/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.team;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.internal.team.RepositoryTeamProvider;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.team.IRepositoryProject;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public class RepositoryProject
extends PlatformObject
implements IRepositoryProject,
IListener {
    private IProject project;
    private CDOView view;

    public RepositoryProject(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public synchronized CDOView getView() {
        if (this.view == null) {
            this.view = this.openView();
            this.view.addListener((IListener)this);
            this.view.getSession().addListener((IListener)this);
        }
        return this.view;
    }

    public void dispose() {
        this.project = null;
        if (this.view != null) {
            this.view.removeListener((IListener)this);
            this.view.getSession().removeListener((IListener)this);
            this.view.getSession().close();
            this.view = null;
        }
    }

    public void notifyEvent(IEvent event) {
    }

    protected CDOView openView() {
        String description = RepositoryTeamProvider.getSessionDescription(this.project);
        CDOSession session = (CDOSession)this.getContainer().getElement("org.eclipse.emf.cdo.sessions", "cdo", description);
        return session.openView();
    }

    protected IPluginContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }
}

