/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.ide;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.cdo.ui.internal.ide.bundle.OM;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PartInitException;

public class CommonNavigatorUtils {
    private static final String ERROR_LOG_ID = "org.eclipse.pde.runtime.LogView";

    public static Object createMessageProvider(final String message, final MessageType type) {
        return new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter.equals(ILabelProvider.class)) {
                    return new LabelProvider(){

                        public String getText(Object element) {
                            return message;
                        }

                        public Image getImage(Object element) {
                            switch (type) {
                                case ERROR: {
                                    return OM.getImageDescriptor("icons/full/elcl16/error.gif").createImage();
                                }
                                case WARNING: {
                                    return OM.getImageDescriptor("icons/full/elcl16/warning.gif").createImage();
                                }
                                case INFO: {
                                    return OM.getImageDescriptor("icons/full/elcl16/info.gif").createImage();
                                }
                            }
                            return super.getImage(element);
                        }
                    };
                }
                if (adapter.equals(Runnable.class)) {
                    return new Runnable(){

                        public void run() {
                            try {
                                UIUtil.getActiveWorkbenchPage().showView(CommonNavigatorUtils.ERROR_LOG_ID);
                            }
                            catch (PartInitException ex) {
                                OM.LOG.error((Throwable)ex);
                            }
                        }
                    };
                }
                return null;
            }

            public String toString() {
                return message;
            }
        };
    }

    public static Object[] createMessageProviderChild(String message, MessageType type) {
        Object[] result = new Object[]{CommonNavigatorUtils.createMessageProvider(message, type)};
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        ERROR,
        WARNING,
        INFO;

    }
}

