/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import java.util.Date;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.ui.SharedIcons;
import org.eclipse.emf.cdo.internal.ui.dialogs.OpenAuditDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class BranchSelectionDialog
extends TitleAreaDialog {
    private CDOView view;
    private CDOBranch targetBranch;
    private CDOBranchPoint targetBranchPoint;
    private TreeViewer viewer;
    private Button headRadio;
    private Button baseRadio;
    private Button timeRadio;
    private Text timeText;
    private long selectedTimeStamp;
    private Button browseTimeButton;

    public BranchSelectionDialog(IWorkbenchPage page, CDOView view) {
        super(page.getWorkbenchWindow().getShell());
        this.view = view;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)UIUtil.createGridData());
        composite.setLayout((Layout)new GridLayout(1, false));
        this.getShell().setText(Messages.getString("BranchSelectionDialog_0"));
        this.setTitle(Messages.getString("BranchSelectionDialog_1"));
        this.setTitleImage(SharedIcons.getImage("wizban/BranchBanner.gif"));
        this.targetBranchPoint = this.view.getBranch().getPoint(this.view.getTimeStamp());
        this.viewer = new TreeViewer(composite, 2048);
        this.viewer.getControl().setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)true));
        this.viewer.setContentProvider((IContentProvider)new BranchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new BranchLabelProvider());
        this.viewer.setInput((Object)this.view.getSession().getBranchManager());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                BranchSelectionDialog.this.checkValidSelection(selection);
            }
        });
        Group pointGroup = new Group(composite, 0);
        pointGroup.setText(Messages.getString("BranchSelectionDialog.0"));
        pointGroup.setLayout((Layout)new GridLayout(3, false));
        pointGroup.setLayoutData((Object)UIUtil.createGridData());
        this.headRadio = new Button((Composite)pointGroup, 16);
        this.headRadio.setText(Messages.getString("BranchSelectionDialog.1"));
        new Label((Composite)pointGroup, 0);
        new Label((Composite)pointGroup, 0);
        this.baseRadio = new Button((Composite)pointGroup, 16);
        this.baseRadio.setText(Messages.getString("BranchSelectionDialog.2"));
        new Label((Composite)pointGroup, 0);
        new Label((Composite)pointGroup, 0);
        this.timeRadio = new Button((Composite)pointGroup, 16);
        this.timeRadio.setText(Messages.getString("BranchSelectionDialog.3"));
        this.timeText = new Text((Composite)pointGroup, 2048);
        this.timeText.setText(new Date(this.view.getSession().getRepositoryInfo().getCreationTime()).toString());
        this.timeText.setEditable(false);
        this.browseTimeButton = new Button((Composite)pointGroup, 0);
        this.browseTimeButton.setImage(SharedIcons.getImage("etool16/clock.png"));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BranchSelectionDialog.this.checkValidSelection((IStructuredSelection)BranchSelectionDialog.this.viewer.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                BranchSelectionDialog.this.checkValidSelection((IStructuredSelection)BranchSelectionDialog.this.viewer.getSelection());
            }
        };
        this.headRadio.addSelectionListener(selectionListener);
        this.baseRadio.addSelectionListener(selectionListener);
        this.timeRadio.addSelectionListener(selectionListener);
        this.timeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BranchSelectionDialog.this.timeRadio.getSelection()) {
                    BranchSelectionDialog.this.updateSelectedPoint();
                }
            }
        });
        this.headRadio.setSelection(true);
        this.browseTimeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OpenAuditDialog dialog = new OpenAuditDialog(UIUtil.getActiveWorkbenchPage());
                if (dialog.open() == 0) {
                    BranchSelectionDialog.this.timeText.setText(new Date(dialog.getTimeStamp()).toString());
                    BranchSelectionDialog.this.selectedTimeStamp = dialog.getTimeStamp();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.expandAll();
        return composite;
    }

    private void checkValidSelection(IStructuredSelection selection) {
        CDOBranch branch = (CDOBranch)selection.getFirstElement();
        if (this.getSelectedPoint(branch).equals(this.targetBranchPoint)) {
            this.setErrorMessage(Messages.getString("BranchSelectionDialog_2"));
            this.getButton(0).setEnabled(false);
        } else if (branch.isMainBranch() && this.baseRadio.getSelection()) {
            this.setErrorMessage(Messages.getString("BranchSelectionDialog.5"));
            this.getButton(0).setEnabled(false);
        } else {
            this.targetBranch = branch;
            this.setErrorMessage(null);
            this.getButton(0).setEnabled(true);
        }
    }

    protected void okPressed() {
        this.updateSelectedPoint();
        super.okPressed();
    }

    protected void updateSelectedPoint() {
        if (this.targetBranch != null) {
            this.targetBranchPoint = this.getSelectedPoint(this.targetBranch);
        }
    }

    protected CDOBranchPoint getSelectedPoint(CDOBranch branch) {
        if (this.headRadio.getSelection()) {
            return branch.getHead();
        }
        if (this.baseRadio.getSelection()) {
            return branch.getBase();
        }
        if (this.timeRadio.getSelection()) {
            return branch.getPoint(this.selectedTimeStamp);
        }
        return branch.getHead();
    }

    public CDOBranchPoint getTargetBranchPoint() {
        return this.targetBranchPoint;
    }

    public static class BranchContentProvider
    implements ITreeContentProvider {
        private static final Object[] NO_ELEMENTS = new Object[0];
        private CDOBranchManager branchManager;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof CDOBranchManager) {
                this.branchManager = (CDOBranchManager)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == this.branchManager) {
                return new Object[]{this.branchManager.getMainBranch()};
            }
            if (inputElement instanceof CDOBranch) {
                return ((CDOBranch)inputElement).getBranches();
            }
            return NO_ELEMENTS;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == this.branchManager) {
                return new Object[]{this.branchManager.getMainBranch()};
            }
            if (parentElement instanceof CDOBranch) {
                return ((CDOBranch)parentElement).getBranches();
            }
            return NO_ELEMENTS;
        }

        public Object getParent(Object element) {
            if (element == this.branchManager) {
                return null;
            }
            if (element instanceof CDOBranch) {
                return ((CDOBranch)element).getBase();
            }
            return NO_ELEMENTS;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }
    }

    public static class BranchLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof CDOBranch) {
                return ((CDOBranch)element).getName();
            }
            return element.toString();
        }
    }
}

