/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.properties;

import java.util.Date;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.internal.ui.properties.CDOPropertySource;
import org.eclipse.emf.cdo.session.CDOSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOSessionPropertySource
extends CDOPropertySource<CDOSession> {
    private static final String CATEGORY_SESSION = "Session";
    private static final String CATEGORY_REPOSITORY = "Repository";
    private static final String SESSION_ID = "sessionID";
    private static final String USER_ID = "userID";
    private static final String PASSIVE_UPDATE_ENABLED = "passiveUpdateEnabled";
    private static final String PASSIVE_UPDATE_MODE = "passiveUpdateMode";
    private static final String REPOSITORY_NAME = "repositoryName";
    private static final String REPOSITORY_UUID = "repositoryUUID";
    private static final String REPOSITORY_TYPE = "repositoryType";
    private static final String REPOSITORY_STATE = "repositoryState";
    private static final String REPOSITORY_CREATION_TIME = "repositoryCreationTime";
    private static final String SUPPORTING_AUDITS = "supportingAudits";
    private static final String SUPPORTING_BRANCHES = "supportingBranches";
    private static final String STORE_TYPE = "storeType";
    private static final String OBJECT_ID_TYPES = "objectIDTypes";

    public CDOSessionPropertySource(CDOSession object) {
        super(object);
        this.addPropertyDescriptor(CATEGORY_SESSION, SESSION_ID, Messages.getString("CDOSessionPropertySource_0"), Messages.getString("CDOSessionPropertySource_3"));
        this.addPropertyDescriptor(CATEGORY_SESSION, USER_ID, Messages.getString("CDOSessionPropertySource_4"), Messages.getString("CDOSessionPropertySource_5"));
        this.addPropertyDescriptor(CATEGORY_SESSION, PASSIVE_UPDATE_ENABLED, Messages.getString("CDOSessionPropertySource_6"), Messages.getString("CDOSessionPropertySource_7"));
        this.addPropertyDescriptor(CATEGORY_SESSION, PASSIVE_UPDATE_MODE, Messages.getString("CDOSessionPropertySource_8"), Messages.getString("CDOSessionPropertySource_9"));
        this.addPropertyDescriptor(CATEGORY_REPOSITORY, REPOSITORY_NAME, Messages.getString("CDOSessionPropertySource_10"), Messages.getString("CDOSessionPropertySource_11"));
        this.addPropertyDescriptor(CATEGORY_REPOSITORY, REPOSITORY_UUID, Messages.getString("CDOSessionPropertySource_12"), Messages.getString("CDOSessionPropertySource_13"));
        this.addPropertyDescriptor(CATEGORY_REPOSITORY, REPOSITORY_TYPE, Messages.getString("CDOSessionPropertySource_14"), Messages.getString("CDOSessionPropertySource_15"));
        this.addPropertyDescriptor(CATEGORY_REPOSITORY, REPOSITORY_STATE, Messages.getString("CDOSessionPropertySource_16"), Messages.getString("CDOSessionPropertySource_17"));
        this.addPropertyDescriptor(CATEGORY_REPOSITORY, REPOSITORY_CREATION_TIME, Messages.getString("CDOSessionPropertySource_18"), Messages.getString("CDOSessionPropertySource_19"));
        this.addPropertyDescriptor(CATEGORY_REPOSITORY, SUPPORTING_AUDITS, Messages.getString("CDOSessionPropertySource_20"), Messages.getString("CDOSessionPropertySource_21"));
        this.addPropertyDescriptor(CATEGORY_REPOSITORY, SUPPORTING_BRANCHES, Messages.getString("CDOSessionPropertySource_22"), Messages.getString("CDOSessionPropertySource_23"));
        this.addPropertyDescriptor(CATEGORY_REPOSITORY, STORE_TYPE, Messages.getString("CDOSessionPropertySource_24"), Messages.getString("CDOSessionPropertySource_25"));
        this.addPropertyDescriptor(CATEGORY_REPOSITORY, OBJECT_ID_TYPES, Messages.getString("CDOSessionPropertySource_26"), Messages.getString("CDOSessionPropertySource_27"));
    }

    public Object getPropertyValue(Object id) {
        CDOSession session = (CDOSession)this.getObject();
        if (SESSION_ID.equals(id)) {
            return session.getSessionID();
        }
        if (USER_ID.equals(id)) {
            return session.getUserID();
        }
        if (PASSIVE_UPDATE_ENABLED.equals(id)) {
            return session.options().isPassiveUpdateEnabled();
        }
        if (PASSIVE_UPDATE_MODE.equals(id)) {
            return session.options().getPassiveUpdateMode().toString();
        }
        if (REPOSITORY_NAME.equals(id)) {
            return session.getRepositoryInfo().getName();
        }
        if (REPOSITORY_UUID.equals(id)) {
            return session.getRepositoryInfo().getUUID();
        }
        if (REPOSITORY_TYPE.equals(id)) {
            return session.getRepositoryInfo().getType().toString();
        }
        if (REPOSITORY_STATE.equals(id)) {
            return session.getRepositoryInfo().getState().toString();
        }
        if (REPOSITORY_CREATION_TIME.equals(id)) {
            return new Date(session.getRepositoryInfo().getCreationTime());
        }
        if (SUPPORTING_AUDITS.equals(id)) {
            return session.getRepositoryInfo().isSupportingAudits();
        }
        if (SUPPORTING_BRANCHES.equals(id)) {
            return session.getRepositoryInfo().isSupportingBranches();
        }
        if (STORE_TYPE.equals(id)) {
            return session.getRepositoryInfo().getStoreType();
        }
        if (OBJECT_ID_TYPES.equals(id)) {
            StringBuilder builder = new StringBuilder();
            for (CDOID.ObjectType objectIDType : session.getRepositoryInfo().getObjectIDTypes()) {
                if (builder.length() != 0) {
                    builder.append(", ");
                }
                builder.append(objectIDType);
            }
            return builder.toString();
        }
        return null;
    }

    @Override
    public void resetPropertyValue(Object id) {
        if (PASSIVE_UPDATE_ENABLED.equals(id)) {
            ((CDOSession)this.getObject()).options().setPassiveUpdateEnabled(true);
        } else if (PASSIVE_UPDATE_MODE.equals(id)) {
            ((CDOSession)this.getObject()).options().setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode.INVALIDATIONS);
        } else {
            super.resetPropertyValue(id);
        }
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PASSIVE_UPDATE_ENABLED.equals(id)) {
            ((CDOSession)this.getObject()).options().setPassiveUpdateEnabled(((Boolean)value).booleanValue());
        } else if (PASSIVE_UPDATE_MODE.equals(id)) {
            ((CDOSession)this.getObject()).options().setPassiveUpdateMode((CDOCommonSession.Options.PassiveUpdateMode)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

