/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;

public class CDOLabelProvider
extends AdapterFactoryLabelProvider
implements IColorProvider,
IFontProvider {
    private static final Color GRAY = UIUtil.getDisplay().getSystemColor(15);
    private static final Color RED = UIUtil.getDisplay().getSystemColor(3);
    private Font bold;
    private CDOView view;
    private TreeViewer viewer;

    public CDOLabelProvider(AdapterFactory adapterFactory, CDOView view, TreeViewer viewer) {
        super(adapterFactory);
        this.view = view;
        this.viewer = viewer;
        this.bold = UIUtil.getBoldFont((Control)viewer.getControl());
    }

    public CDOView getView() {
        return this.view;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        this.bold.dispose();
        super.dispose();
    }

    public void notifyChanged(final Notification notification) {
        super.notifyChanged(notification);
        try {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        CDOLabelProvider.this.viewer.refresh(notification.getNotifier(), true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Color getBackground(Object object) {
        return null;
    }

    public Color getForeground(Object object) {
        try {
            InternalCDOObject cdoObject = FSMUtil.adapt((Object)object, (CDOView)this.view);
            switch (cdoObject.cdoState()) {
                case PROXY: {
                    return GRAY;
                }
                case CONFLICT: {
                    return RED;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public Font getFont(Object object) {
        try {
            InternalCDOObject cdoObject = FSMUtil.adapt((Object)object, (CDOView)this.view);
            switch (cdoObject.cdoState()) {
                case NEW: 
                case DIRTY: 
                case CONFLICT: {
                    return this.bold;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }
}

