/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.eresource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceNodeImpl;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOViewProviderRegistry;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOResourceImpl
extends CDOResourceNodeImpl
implements CDOResource,
Resource.Internal {
    private static final EReference CDO_RESOURCE_CONTENTS = EresourcePackage.eINSTANCE.getCDOResource_Contents();
    private static URIConverter defaultURIConverter;
    private boolean root;
    private URI initialURI;
    private boolean existing;
    private boolean loading;
    private boolean loaded;
    private EList<Resource.Diagnostic> errors;
    private EList<Resource.Diagnostic> warnings;

    public CDOResourceImpl(URI initialURI) {
        this.initialURI = initialURI;
    }

    protected CDOResourceImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return EresourcePackage.Literals.CDO_RESOURCE;
    }

    @Override
    public Resource.Internal eDirectResource() {
        if (this.isRoot()) {
            return this;
        }
        return super.eDirectResource();
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == CDOResource.class) {
            return baseFeatureID;
        }
        if (baseClass == Resource.class) {
            return baseFeatureID + 3;
        }
        return super.eBaseStructuralFeatureID(baseFeatureID, baseClass);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == CDOResource.class) {
            return derivedFeatureID;
        }
        if (baseClass == Resource.class) {
            return derivedFeatureID - 3;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    @Override
    public ResourceSet getResourceSet() {
        return (ResourceSet)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__RESOURCE_SET, true);
    }

    @Override
    public void setResourceSet(ResourceSet newResourceSet) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__RESOURCE_SET, newResourceSet);
    }

    public URI getURIGen() {
        return (URI)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__URI, true);
    }

    @Override
    public URI getURI() {
        if (this.cdoID() == null && this.initialURI != null) {
            return this.initialURI;
        }
        return super.getURI();
    }

    public void setURIGen(URI newURI) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__URI, newURI);
    }

    @Override
    public void setURI(URI newURI) {
        String newPath = CDOURIUtil.extractResourcePath(newURI);
        this.setPath(newPath);
    }

    @Override
    public EList<EObject> getContents() {
        return (EList)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__CONTENTS, true);
    }

    @Override
    public void cdoInternalPostDetach(boolean remote) {
        super.cdoInternalPostDetach(remote);
        if (remote) {
            this.existing = false;
            this.cdoView().getResourceSet().getResources().remove((Object)this);
        } else {
            this.removeFromResourceSet();
        }
    }

    @Override
    public boolean isModified() {
        return (Boolean)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__MODIFIED, true);
    }

    @Override
    public void setModified(boolean newModified) {
        boolean oldIsModified = this.isModified();
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__MODIFIED, newModified);
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsModified, newModified){

                public Object getNotifier() {
                    return CDOResourceImpl.this;
                }

                public int getFeatureID(Class<?> expectedClass) {
                    return 3;
                }
            };
            this.eNotify((Notification)notification);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    private Notification setLoaded(boolean isLoaded) {
        boolean oldIsLoaded = this.loaded;
        this.loaded = isLoaded;
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsLoaded, isLoaded){

                public Object getNotifier() {
                    return CDOResourceImpl.this;
                }

                public int getFeatureID(Class<?> expectedClass) {
                    return 4;
                }
            };
            return notification;
        }
        return null;
    }

    @Override
    public boolean isTrackingModification() {
        return (Boolean)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__TRACKING_MODIFICATION, true);
    }

    @Override
    public void setTrackingModification(boolean newTrackingModification) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__TRACKING_MODIFICATION, newTrackingModification);
    }

    @Override
    public EList<Resource.Diagnostic> getErrors() {
        if (this.errors == null) {
            this.errors = new NotifyingListImpl<Resource.Diagnostic>(){
                private static final long serialVersionUID = 1L;

                protected boolean isNotificationRequired() {
                    return CDOResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return CDOResourceImpl.this;
                }

                public int getFeatureID() {
                    return 9;
                }
            };
        }
        return this.errors;
    }

    @Override
    public EList<Resource.Diagnostic> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new NotifyingListImpl<Resource.Diagnostic>(){
                private static final long serialVersionUID = 1L;

                protected boolean isNotificationRequired() {
                    return CDOResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return CDOResourceImpl.this;
                }

                public int getFeatureID() {
                    return 10;
                }
            };
        }
        return this.warnings;
    }

    @Override
    public long getTimeStamp() {
        return (Long)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__TIME_STAMP, true);
    }

    @Override
    public void setTimeStamp(long newTimeStamp) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__TIME_STAMP, newTimeStamp);
    }

    public TreeIterator<EObject> getAllContents() {
        return new AbstractTreeIterator<EObject>((Object)this, false){
            private static final long serialVersionUID = 1L;

            public Iterator<EObject> getChildren(Object object) {
                return object == CDOResourceImpl.this ? CDOResourceImpl.this.getContents().iterator() : ((EObject)object).eContents().iterator();
            }
        };
    }

    public EObject getEObject(String uriFragment) {
        CDOID cdoID;
        block5: {
            if (uriFragment == null) {
                return null;
            }
            cdoID = CDOIDUtil.read((String)uriFragment);
            if (!CDOIDUtil.isNull((CDOID)cdoID) && (!cdoID.isTemporary() || this.cdoView().isObjectRegistered(cdoID))) break block5;
            return null;
        }
        try {
            if (cdoID.isObject()) {
                CDOObject object = this.cdoView().getObject(cdoID, true);
                return CDOUtil.getEObject(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getURIFragment(EObject object) {
        InternalCDOObject internalCDOObject = FSMUtil.adapt(object, this.cdoView());
        StringBuilder builder = new StringBuilder();
        CDOIDUtil.write((StringBuilder)builder, (CDOID)internalCDOObject.cdoID());
        return builder.toString();
    }

    public void load(InputStream inputStream, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cdoInternalPreLoad() {
        try {
            this.load(null);
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded()) {
            Notification notification;
            if (!FSMUtil.isTransient(this)) {
                InternalCDOView view = this.cdoView();
                CDOID id = this.cdoID();
                if (id == null) {
                    this.registerProxy(view);
                } else if (view instanceof CDOViewImpl) {
                    CDOViewImpl impl = (CDOViewImpl)view;
                    Object object = impl.getObjectsLock();
                    synchronized (object) {
                        if (!view.isObjectRegistered(id)) {
                            this.registerProxy(view);
                        }
                    }
                } else if (!view.isObjectRegistered(id)) {
                    this.registerProxy(view);
                }
            }
            if ((notification = this.setLoaded(true)) != null) {
                this.eNotify(notification);
            }
        }
    }

    private void registerProxy(InternalCDOView view) throws Resource.IOWrappedException {
        try {
            view.registerProxyResource(this);
        }
        catch (Exception ex) {
            this.setExisting(false);
            this.cdoInternalSetState(CDOState.TRANSIENT);
            throw new Resource.IOWrappedException(ex);
        }
    }

    private URIConverter getURIConverter() {
        return this.getResourceSet() == null ? CDOResourceImpl.getDefaultURIConverter() : this.getResourceSet().getURIConverter();
    }

    private static synchronized URIConverter getDefaultURIConverter() {
        if (defaultURIConverter == null) {
            defaultURIConverter = new ExtensibleURIConverterImpl();
        }
        return defaultURIConverter;
    }

    public void save(Map<?, ?> options) throws IOException {
        CDOTransaction transaction = this.getTransaction(options);
        IProgressMonitor progressMonitor = options != null ? (IProgressMonitor)options.get(CDOResource.OPTION_SAVE_PROGRESS_MONITOR) : null;
        try {
            transaction.commit(progressMonitor);
        }
        catch (CommitException ex) {
            throw new TransactionException((Throwable)ex);
        }
        this.setModified(false);
    }

    private CDOTransaction getTransaction(Map<?, ?> options) {
        CDOTransaction transaction;
        CDOTransaction cDOTransaction = transaction = options != null ? (CDOTransaction)options.get(CDOResource.OPTION_SAVE_OVERRIDE_TRANSACTION) : null;
        if (transaction == null) {
            InternalCDOView view = this.cdoView();
            if (view instanceof CDOTransaction) {
                transaction = (CDOTransaction)((Object)view);
            } else {
                throw new IllegalStateException("No transaction available");
            }
        }
        return transaction;
    }

    public void save(OutputStream outputStream, Map<?, ?> options) throws IOException {
    }

    public void unload() {
    }

    @Override
    public void delete(Map<?, ?> options) throws IOException {
        if (FSMUtil.isTransient(this)) {
            this.removeFromResourceSet();
        } else {
            if (this.isRoot()) {
                throw new UnsupportedOperationException();
            }
            if (this.getFolder() == null) {
                InternalCDOView view = this.cdoView();
                view.getRootResource().getContents().remove((Object)this);
            } else {
                this.basicSetFolder(null, false);
            }
        }
    }

    private void removeFromResourceSet() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet != null) {
            resourceSet.getResources().remove((Object)this);
        }
    }

    public void attached(EObject object) {
        if (!FSMUtil.isTransient(this)) {
            InternalCDOObject cdoObject = FSMUtil.adapt(object, this.cdoView());
            this.attached(cdoObject, this.cdoView().toTransaction());
        }
    }

    private void attached(InternalCDOObject cdoObject, InternalCDOTransaction transaction) {
        CDOStateMachine.INSTANCE.attach(cdoObject, transaction);
    }

    public void detached(EObject object) {
        if (!FSMUtil.isTransient(this)) {
            InternalCDOObject cdoObject = FSMUtil.adapt(object, this.cdoView());
            CDOStateMachine.INSTANCE.detach(cdoObject);
        }
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        URI uri;
        InternalCDOView view;
        ResourceSet oldResourceSet = this.getResourceSet();
        if (oldResourceSet != null) {
            notifications = ((InternalEList)oldResourceSet.getResources()).basicRemove((Object)this, notifications);
        }
        this.setResourceSet(resourceSet);
        if (resourceSet != null && (view = this.cdoView()) == null && (view = (InternalCDOView)CDOViewProviderRegistry.INSTANCE.provideView(uri = this.getURI(), resourceSet)) != null) {
            view.attachResource(this);
        }
        if (this.eNotificationRequired()) {
            if (notifications == null) {
                notifications = new NotificationChainImpl(2);
            }
            notifications.add((Notification)new NotificationImpl(1, oldResourceSet, resourceSet){

                public Object getNotifier() {
                    return CDOResourceImpl.this;
                }

                public int getFeatureID(Class<?> expectedClass) {
                    return 0;
                }
            });
        }
        return notifications;
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public boolean isExisting() {
        return this.existing;
    }

    protected void setExisting(boolean existing) {
        this.existing = existing;
    }

    @Override
    protected EList<?> createList(EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature == CDO_RESOURCE_CONTENTS) {
            return new ContentsCDOList((EStructuralFeature)CDO_RESOURCE_CONTENTS);
        }
        return super.createList(eStructuralFeature);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ContentsCDOList
    extends EStoreEObjectImpl.BasicEStoreEList<Object> {
        private static final long serialVersionUID = 1L;

        public ContentsCDOList(EStructuralFeature eStructuralFeature) {
            super((InternalEObject)CDOResourceImpl.this, eStructuralFeature);
        }

        public boolean contains(Object object) {
            if (this.size() <= 4) {
                return super.contains(object);
            }
            return object instanceof InternalEObject && ((InternalEObject)object).eDirectResource() == CDOResourceImpl.this;
        }

        public NotificationChain inverseAdd(Object object, NotificationChain notifications) {
            if (FSMUtil.isTransient(CDOResourceImpl.this)) {
                InternalEObject eObject = (InternalEObject)object;
                notifications = eObject.eSetResource((Resource.Internal)CDOResourceImpl.this, notifications);
            } else {
                InternalCDOTransaction transaction = CDOResourceImpl.this.cdoView().toTransaction();
                InternalCDOObject cdoObject = FSMUtil.adapt(object, transaction);
                notifications = cdoObject.eSetResource(CDOResourceImpl.this, notifications);
                if (FSMUtil.isTransient(cdoObject)) {
                    CDOResourceImpl.this.attached(cdoObject, transaction);
                }
            }
            return notifications;
        }

        public NotificationChain inverseRemove(Object object, NotificationChain notifications) {
            if (FSMUtil.isTransient(CDOResourceImpl.this)) {
                InternalEObject eObject = (InternalEObject)object;
                notifications = eObject.eSetResource(null, notifications);
            } else {
                InternalEObject eObject = (InternalEObject)object;
                CDOResourceImpl.this.detached((EObject)eObject);
                notifications = eObject.eSetResource(null, notifications);
            }
            return notifications;
        }

        protected void loaded() {
            Notification notification = CDOResourceImpl.this.setLoaded(true);
            if (notification != null) {
                CDOResourceImpl.this.eNotify(notification);
            }
        }

        protected void modified() {
            if (CDOResourceImpl.this.isTrackingModification()) {
                CDOResourceImpl.this.setModified(true);
            }
        }

        protected boolean useEquals() {
            return false;
        }

        protected boolean hasInverse() {
            return true;
        }

        protected boolean isUnique() {
            return true;
        }

        protected void didAdd(int index, Object newObject) {
            super.didAdd(index, newObject);
            if (!CDOResourceImpl.this.isExisting() && !CDOResourceImpl.this.isLoaded()) {
                this.loaded();
            }
        }

        protected void didClear(int size, Object[] oldObjects) {
            super.didClear(size, oldObjects);
            if (!CDOResourceImpl.this.isExisting() && !CDOResourceImpl.this.isLoaded()) {
                this.loaded();
            }
        }
    }
}

