/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transaction;

import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;

public class CDOAutoAttacher
extends CDODefaultTransactionHandler {
    private CDOTransaction transaction;

    public CDOAutoAttacher(CDOTransaction transaction) {
        this.transaction = transaction;
        transaction.addTransactionHandler(this);
    }

    public CDOTransaction getTransaction() {
        return this.transaction;
    }

    public void attachingObject(CDOTransaction transaction, CDOObject object) {
        if (object instanceof CDOResource) {
            return;
        }
        EObject obj = CDOUtil.getEObject(object);
        this.handle(obj, obj);
    }

    public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureChange) {
        if (object instanceof CDOResource) {
            return;
        }
        if (featureChange != null) {
            CDOFeatureDeltaVisitorAutoAttach featureChangeVisitor = new CDOFeatureDeltaVisitorAutoAttach(object);
            featureChange.accept((CDOFeatureDeltaVisitor)featureChangeVisitor);
        }
    }

    protected void persist(EObject res, Object object) {
        InternalCDOObject cdoObject;
        if (!(object instanceof CDOResource) && object instanceof InternalCDOObject && FSMUtil.isTransient(cdoObject = (InternalCDOObject)object)) {
            res.eResource().getContents().add((Object)cdoObject);
        }
    }

    private void check(EObject referrer, EReference reference, EObject element) {
        if (element != null && element.eResource() == null) {
            if (reference != null && reference.isContainment()) {
                this.handle(referrer, element);
            } else {
                this.persist(referrer, CDOUtil.getCDOObject(element));
            }
        }
    }

    private void handle(EObject referrer, EObject eObject) {
        for (EReference reference : eObject.eClass().getEAllReferences()) {
            if (reference.isMany()) {
                List list = (List)eObject.eGet((EStructuralFeature)reference);
                for (EObject element : list) {
                    this.check(referrer, reference, element);
                }
                continue;
            }
            this.check(referrer, reference, (EObject)eObject.eGet((EStructuralFeature)reference));
        }
    }

    private class CDOFeatureDeltaVisitorAutoAttach
    implements CDOFeatureDeltaVisitor {
        private EObject referrer;

        public CDOFeatureDeltaVisitorAutoAttach(EObject referrer) {
            this.referrer = referrer;
        }

        public void visit(CDOAddFeatureDelta featureChange) {
            CDOAutoAttacher.this.persist(this.referrer, featureChange.getValue());
        }

        public void visit(CDOClearFeatureDelta featureChange) {
        }

        public void visit(CDOListFeatureDelta featureChange) {
        }

        public void visit(CDOMoveFeatureDelta featureChange) {
        }

        public void visit(CDORemoveFeatureDelta featureChange) {
        }

        public void visit(CDOSetFeatureDelta featureChange) {
            CDOAutoAttacher.this.persist(this.referrer, featureChange.getValue());
        }

        public void visit(CDOUnsetFeatureDelta featureChange) {
        }

        public void visit(CDOContainerFeatureDelta featureChange) {
        }
    }
}

