/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOURIUtil {
    public static final char SEGMENT_SEPARATOR_CHAR = '/';
    public static final String SEGMENT_SEPARATOR = new String(new char[]{'/'});

    public static void validateURI(URI uri) throws InvalidURIException {
        if (!"cdo".equals(uri.scheme())) {
            throw new InvalidURIException(uri);
        }
        if (!uri.isHierarchical()) {
            throw new InvalidURIException(uri);
        }
    }

    public static String extractRepositoryUUID(URI uri) {
        try {
            CDOURIUtil.validateURI(uri);
            if (!uri.hasAuthority()) {
                throw new InvalidURIException(uri);
            }
            return uri.authority();
        }
        catch (InvalidURIException ex) {
            return null;
        }
    }

    public static String[] extractResourceFolderAndName(URI uri) throws InvalidURIException {
        String path = CDOURIUtil.extractResourcePath(uri);
        int lastSeparator = path.lastIndexOf(47);
        if (lastSeparator == -1) {
            String[] stringArray = new String[2];
            stringArray[1] = path;
            return stringArray;
        }
        String folder = path.substring(0, lastSeparator);
        String name = path.substring(lastSeparator + 1);
        return new String[]{folder, name};
    }

    public static String extractResourcePath(URI uri) throws InvalidURIException {
        CDOURIUtil.validateURI(uri);
        String path = uri.path();
        if (path == null) {
            return SEGMENT_SEPARATOR;
        }
        return path;
    }

    public static URI createResourceURI(String repositoryUUID, String path) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("cdo");
        stringBuilder.append(":");
        if (repositoryUUID != null) {
            stringBuilder.append("//");
            stringBuilder.append(repositoryUUID);
        }
        if (!SEGMENT_SEPARATOR.equals(path)) {
            if (path.charAt(0) != '/') {
                stringBuilder.append('/');
            }
            stringBuilder.append(path);
        }
        return URI.createURI((String)stringBuilder.toString());
    }

    public static URI createResourceURI(CDOView view, String path) {
        return CDOURIUtil.createResourceURI(view == null ? null : view.getSession(), path);
    }

    public static URI createResourceURI(CDOSession session, String path) {
        return CDOURIUtil.createResourceURI(session == null ? null : session.getRepositoryInfo().getUUID(), path);
    }

    public static CDOID convertExternalCDOID(URI baseURI, CDOID newCDOID) {
        StringBuilder builder = new StringBuilder();
        CDOIDUtil.write((StringBuilder)builder, (CDOID)newCDOID);
        baseURI = baseURI.trimFragment().appendFragment(builder.toString());
        return CDOIDUtil.createExternal((String)baseURI.toString());
    }

    public static List<String> analyzePath(URI uri) {
        String path = CDOURIUtil.extractResourcePath(uri);
        return CDOURIUtil.analyzePath(path);
    }

    public static List<String> analyzePath(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, SEGMENT_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            if (name == null) continue;
            segments.add(name);
        }
        return segments;
    }
}

