/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.CDOObjectWrapper;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.CDOStore;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.spi.cdo.CDOElementProxy;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOLegacyWrapper
extends CDOObjectWrapper {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOLegacyWrapper.class);
    private static ThreadLocal<Map<CDOID, CDOLegacyWrapper>> wrapperRegistry = new InheritableThreadLocal<Map<CDOID, CDOLegacyWrapper>>(){

        @Override
        protected Map<CDOID, CDOLegacyWrapper> initialValue() {
            return new HashMap<CDOID, CDOLegacyWrapper>();
        }
    };
    private static ThreadLocal<Counter> recursionCounter = new InheritableThreadLocal<Counter>(){

        @Override
        protected Counter initialValue() {
            return new Counter();
        }
    };
    protected CDOState state;
    protected InternalCDORevision revision;
    private boolean underConstruction;

    public CDOLegacyWrapper(InternalEObject instance) {
        this.instance = instance;
        this.state = CDOState.TRANSIENT;
        instance.eAdapters().add((Object)((Adapter)this));
        this.attachAdapterListListener();
    }

    @Override
    public CDOState cdoState() {
        return this.state;
    }

    @Override
    public InternalCDORevision cdoRevision() {
        return this.revision;
    }

    @Override
    public void cdoReload() {
        CDOStateMachine.INSTANCE.reload(this);
    }

    @Override
    public CDOState cdoInternalSetState(CDOState state) {
        if (this.state != state) {
            if (TRACER.isEnabled()) {
                TRACER.format("Setting state {0} for {1}", new Object[]{state, this});
            }
            CDOState oldState = this.state;
            this.state = state;
            this.adjustEProxy();
            if (this.view != null) {
                this.view.handleObjectStateChanged(this, oldState, state);
            }
            return oldState;
        }
        return null;
    }

    @Override
    public void cdoInternalSetRevision(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Setting revision: " + revision);
        }
        this.revision = (InternalCDORevision)revision;
    }

    @Override
    public void cdoInternalPostAttach() {
        this.instanceToRevision();
        for (Adapter adapter : this.eAdapters()) {
            if (adapter instanceof CDOObjectWrapper) continue;
            this.view.handleAddAdapter(this, adapter);
            this.view.subscribe(this, adapter);
        }
    }

    @Override
    public void cdoInternalPostDetach(boolean remote) {
        if (remote) {
            return;
        }
        EClass eClass = this.revision.getEClass();
        CDOStore store = this.view.getStore();
        InternalEObject eContainer = store.getContainer(this);
        if (eContainer != null && this.eContainmentFeature().isResolveProxies()) {
            CDOLegacyWrapper.adjustOppositeReference(this, eContainer, this.eContainmentFeature());
        }
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            EReference oppositeReference = ((EStructuralFeature.Internal)feature).getEOpposite();
            if (oppositeReference != null && !oppositeReference.isContainment()) {
                if (feature.isMany()) {
                    int size = this.revision.size(feature);
                    int i = 0;
                    while (i < size) {
                        EObject object = (EObject)this.getValueFromRevision(feature, i);
                        CDOObjectWrapper wrapper = (CDOObjectWrapper)CDOUtil.getCDOObject(object);
                        this.setOppositeReference(wrapper, oppositeReference);
                        ++i;
                    }
                } else {
                    EObject oppositeObject = (EObject)this.instance.eGet(feature);
                    if (oppositeObject != null) {
                        CDOObjectWrapper wrapper = (CDOObjectWrapper)CDOUtil.getCDOObject(oppositeObject);
                        this.setOppositeReference(wrapper, oppositeReference);
                    }
                }
            }
            ++n2;
        }
    }

    private void setOppositeReference(CDOObjectWrapper wrapper, EReference oppositeReference) {
        CDOStore store;
        InternalCDOView view;
        if (wrapper != null && (view = wrapper.cdoView()) != null && (store = view.getStore()) != null) {
            store.set(wrapper, (EStructuralFeature)oppositeReference, 0, this);
        }
    }

    @Override
    public void cdoInternalPostRollback() {
        InternalCDORevision revision = this.cdoView().getRevision(this.cdoID(), true);
        this.cdoInternalSetRevision((CDORevision)revision);
        this.revisionToInstance();
        this.state = CDOState.CLEAN;
    }

    @Override
    public void cdoInternalPreCommit() {
        this.instanceToRevisionContainment();
        EClass eClass = this.revision.getEClass();
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isUnsettable()) {
                if (!this.instance.eIsSet(feature)) {
                    if (feature.isMany()) {
                        InternalEList list = (InternalEList)this.instance.eGet(feature);
                        this.clearList(feature, (InternalEList<Object>)list);
                    } else {
                        this.revision.set(feature, -1, null);
                    }
                } else if (this.instance.eGet(feature) == null) {
                    this.revision.set(feature, -1, (Object)CDORevisionData.NIL);
                }
            }
            ++n2;
        }
    }

    @Override
    public void cdoInternalPreLoad() {
    }

    @Override
    public void cdoInternalPostLoad() {
        this.revisionToInstance();
    }

    @Override
    public void cdoInternalPostInvalidate() {
        if (this.cdoState() != CDOState.CLEAN) {
            InternalCDORevision revision = this.cdoView().getRevision(this.cdoID(), true);
            this.cdoInternalSetRevision((CDORevision)revision);
        }
        this.revisionToInstance();
        this.cdoInternalSetState(CDOState.CLEAN);
    }

    @Override
    public void cdoInternalCleanup() {
    }

    public boolean equals(Object obj) {
        return obj == this || obj == this.instance;
    }

    public int hashCode() {
        if (this.instance != null) {
            return this.instance.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return "CDOLegacyWrapper[" + this.id + ", " + this.instance.getClass().getName() + "]";
    }

    protected void attachAdapterListListener() {
        ((BasicNotifierImpl.EObservableAdapterList)this.instance.eAdapters()).addListener((BasicNotifierImpl.EObservableAdapterList.Listener)new CDOObjectWrapper.AdapterListListener(this));
    }

    protected void instanceToRevision() {
        if (TRACER.isEnabled()) {
            TRACER.format("Transfering instance to revision: {0} --> {1}", new Object[]{this.instance, this.revision});
        }
        this.instanceToRevisionContainment();
        InternalCDOPackageRegistry packageRegistry = this.cdoView().getSession().getPackageRegistry();
        EClass eClass = this.revision.getEClass();
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            this.instanceToRevisionFeature(feature, (CDOPackageRegistry)packageRegistry);
            ++n2;
        }
    }

    protected void instanceToRevisionContainment() {
        CDOResource resource = (CDOResource)this.getInstanceResource(this.instance);
        this.revision.setResourceID(resource == null ? CDOID.NULL : resource.cdoID());
        InternalEObject eContainer = this.getInstanceContainer(this.instance);
        if (eContainer == null) {
            this.revision.setContainerID((Object)CDOID.NULL);
            this.revision.setContainingFeatureID(0);
        } else {
            InternalCDOObject cdoContainer = FSMUtil.adapt(eContainer, this.view);
            this.revision.setContainerID((Object)cdoContainer);
            this.revision.setContainingFeatureID(this.getInstanceContainerFeatureID(this.instance));
        }
    }

    protected void instanceToRevisionFeature(EStructuralFeature feature, CDOPackageRegistry packageRegistry) {
        Object instanceValue = this.getInstanceValue(this.instance, feature, packageRegistry);
        CDOObjectImpl.instanceToRevisionFeature(this.view, this, feature, instanceValue);
    }

    protected void revisionToInstance() {
        boolean deliver;
        if (this.underConstruction) {
            return;
        }
        this.underConstruction = true;
        if (TRACER.isEnabled()) {
            TRACER.format("Transfering revision to instance: {0} --> {1}", new Object[]{this.revision, this.instance});
        }
        if (deliver = this.instance.eDeliver()) {
            this.instance.eSetDeliver(false);
        }
        Counter counter = recursionCounter.get();
        try {
            try {
                CDOLegacyWrapper.registerWrapper(this);
                counter.increment();
                this.revisionToInstanceContainment();
                EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)this.revision.getEClass());
                int n = eStructuralFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EStructuralFeature feature = eStructuralFeatureArray[n2];
                    this.revisionToInstanceFeature(feature);
                    ++n2;
                }
                this.revisionToInstanceResource();
            }
            catch (RuntimeException ex) {
                OM.LOG.error((Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                throw new CDOException((Throwable)ex);
            }
        }
        finally {
            if (deliver) {
                this.instance.eSetDeliver(true);
            }
            counter.decrement();
            CDOLegacyWrapper.unregisterWrapper(this);
            this.underConstruction = false;
        }
    }

    protected void revisionToInstanceContainment() {
        Object containerID = this.revision.getContainerID();
        InternalEObject container = this.getEObjectFromPotentialID(this.view, null, containerID);
        this.setInstanceContainer(container, this.revision.getContainingFeatureID());
    }

    protected void revisionToInstanceResource() {
        CDOID resourceID = this.revision.getResourceID();
        InternalEObject resource = this.getEObjectFromPotentialID(this.view, null, resourceID);
        this.setInstanceResource((Resource.Internal)resource);
    }

    protected void revisionToInstanceFeature(EStructuralFeature feature) {
        if (feature.isUnsettable() && !this.view.getStore().isSet(this, feature)) {
            this.instance.eUnset(feature);
            return;
        }
        if (feature.isMany()) {
            if (TRACER.isEnabled()) {
                TRACER.format("State of Object (" + this + "/" + this.instance + ") is : " + (Object)((Object)this.state), new Object[0]);
            }
            if (this.state == CDOState.CLEAN || this.state == CDOState.PROXY || this.state == CDOState.NEW || this.state == CDOState.DIRTY) {
                int size = this.revision.size(feature);
                InternalEList list = (InternalEList)this.instance.eGet(feature);
                this.clearList(feature, (InternalEList<Object>)list);
                int i = 0;
                while (i < size) {
                    Object object = this.getValueFromRevision(feature, i);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Adding " + object + " to feature " + feature + "in instance " + this.instance, new Object[0]);
                    }
                    list.basicAdd(object, null);
                    ++i;
                }
            }
        } else {
            Object object = this.getValueFromRevision(feature, 0);
            if (feature instanceof EAttribute) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Setting attribute value " + object + " to feature " + feature + " in instance " + this.instance, new Object[0]);
                }
                if (feature.isUnsettable() && object.equals(CDORevisionData.NIL)) {
                    this.eSet(feature, null);
                } else {
                    this.eSet(feature, object);
                }
            } else {
                if (TRACER.isEnabled()) {
                    TRACER.format("Adding object " + object + " to feature " + feature + " in instance " + this.instance, new Object[0]);
                }
                int featureID = this.instance.eClass().getFeatureID(feature);
                Class<?> baseClass = object == null ? null : object.getClass();
                EStructuralFeature.Internal internalFeature = (EStructuralFeature.Internal)feature;
                EReference oppositeReference = internalFeature.getEOpposite();
                if (oppositeReference != null) {
                    if (object != null) {
                        this.instance.eInverseAdd((InternalEObject)object, featureID, baseClass, null);
                    }
                    if (object != null && !EMFUtil.isPersistent((EStructuralFeature)oppositeReference)) {
                        this.adjustOppositeReference(this.instance, (InternalEObject)object, oppositeReference);
                    }
                } else if (object != CDORevisionData.NIL) {
                    this.instance.eSet(feature, object);
                } else {
                    this.instance.eSet(feature, null);
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Added object " + object + " to feature " + feature + " in instance " + this.instance, new Object[0]);
                }
            }
        }
    }

    private void adjustOppositeReference(InternalEObject instance, InternalEObject object, EReference oppositeReference) {
        boolean wasDeliver = object.eDeliver();
        if (wasDeliver) {
            object.eSetDeliver(false);
        }
        try {
            if (oppositeReference.isMany()) {
                InternalEList list = (InternalEList)object.eGet((EStructuralFeature)oppositeReference);
                list.basicAdd((Object)instance, null);
            } else if (object.eGet((EStructuralFeature)oppositeReference) != instance) {
                object.eInverseAdd(instance, oppositeReference.getFeatureID(), instance.getClass(), null);
            }
        }
        finally {
            if (wasDeliver) {
                object.eSetDeliver(true);
            }
        }
    }

    private void clearList(EStructuralFeature feature, InternalEList<Object> list) {
        int i = list.size() - 1;
        while (i >= 0) {
            InternalEObject obj = (InternalEObject)list.get(i);
            list.basicRemove((Object)obj, null);
            --i;
        }
    }

    private Object getValueFromRevision(EStructuralFeature feature, int index) {
        Object object = this.revision.get(feature, index);
        if (object == null) {
            return null;
        }
        if (object instanceof CDOElementProxy) {
            object = ((CDOElementProxy)object).resolve(this.view.getSession(), (CDORevision)this.revision, feature, index);
        }
        if (object instanceof CDOLegacyWrapper) {
            return ((CDOLegacyWrapper)object).cdoInternalInstance();
        }
        CDOType type = CDOModelUtil.getType((EClassifier)feature.getEType());
        object = type.convertToEMF(feature.getEType(), object);
        if (type == CDOType.OBJECT && object instanceof CDOID) {
            CDOID id = (CDOID)object;
            if (id.isNull()) {
                return null;
            }
            object = CDOLegacyWrapper.getRegisteredWrapper(id);
            if (object != null) {
                return ((CDOLegacyWrapper)object).cdoInternalInstance();
            }
            object = id.isExternal() ? this.view.getResourceSet().getEObject(URI.createURI((String)id.toURIFragment()), true) : this.view.getObject(id);
            if (object instanceof CDOObjectWrapper) {
                return ((CDOObjectWrapper)object).cdoInternalInstance();
            }
        }
        return object;
    }

    protected Resource.Internal getInstanceResource(InternalEObject instance) {
        return instance.eDirectResource();
    }

    protected InternalEObject getInstanceContainer(InternalEObject instance) {
        return instance.eInternalContainer();
    }

    protected int getInstanceContainerFeatureID(InternalEObject instance) {
        return instance.eContainerFeatureID();
    }

    protected Object getInstanceValue(InternalEObject instance, EStructuralFeature feature, CDOPackageRegistry packageRegistry) {
        return instance.eGet(feature);
    }

    protected void setInstanceResource(Resource.Internal resource) {
        Method method = ReflectUtil.getMethod(this.instance.getClass(), (String)"eSetDirectResource", (Class[])new Class[]{Resource.Internal.class});
        ReflectUtil.invokeMethod((Method)method, (Object)this.instance, (Object[])new Object[]{resource});
    }

    protected void setInstanceContainer(InternalEObject container, int containerFeatureID) {
        Method method = ReflectUtil.getMethod(this.instance.getClass(), (String)"eBasicSetContainer", (Class[])new Class[]{InternalEObject.class, Integer.TYPE});
        ReflectUtil.invokeMethod((Method)method, (Object)this.instance, (Object[])new Object[]{container, containerFeatureID});
    }

    protected void setInstanceValue(InternalEObject instance, EStructuralFeature feature, Object value) {
        instance.eSet(feature, value);
    }

    protected InternalEObject getEObjectFromPotentialID(InternalCDOView view, EStructuralFeature feature, Object potentialID) {
        CDOLegacyWrapper wrapper;
        if (potentialID instanceof CDOID && (wrapper = CDOLegacyWrapper.getRegisteredWrapper((CDOID)potentialID)) != null) {
            potentialID = wrapper.instance;
            if (TRACER.isEnabled()) {
                TRACER.format("Getting Object (" + potentialID + ") from localThread instead of the view", new Object[0]);
            }
        } else {
            if (potentialID instanceof CDOID) {
                CDOID id = (CDOID)potentialID;
                if (id.isNull()) {
                    return null;
                }
                if (id.isExternal()) {
                    URI uri = URI.createURI((String)id.toURIFragment());
                    InternalEObject eObject = (InternalEObject)view.getResourceSet().getEObject(uri, true);
                    return eObject;
                }
                boolean loadOnDemand = feature == null;
                potentialID = view.getObject(id, loadOnDemand);
                if (potentialID == null && !loadOnDemand) {
                    return this.createProxy(view, feature, id);
                }
            }
            if (potentialID instanceof InternalCDOObject) {
                return ((InternalCDOObject)potentialID).cdoInternalInstance();
            }
        }
        return (InternalEObject)potentialID;
    }

    protected InternalEObject createProxy(InternalCDOView view, EStructuralFeature feature, CDOID id) {
        EClassifier eType = feature.getEType();
        Class instanceClass = eType.getInstanceClass();
        Class[] interfaces = new Class[]{instanceClass, InternalEObject.class, LegacyProxy.class};
        ClassLoader classLoader = CDOLegacyWrapper.class.getClassLoader();
        LegacyProxyInvocationHandler handler = new LegacyProxyInvocationHandler(this, id);
        return (InternalEObject)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
    }

    protected void clearEList(InternalEList<Object> list) {
        while (!list.isEmpty()) {
            Object toBeRemoved = list.basicGet(0);
            list.basicRemove(toBeRemoved, null);
        }
    }

    protected void resolveAllProxies() {
        InternalCDOPackageRegistry packageRegistry = this.cdoView().getSession().getPackageRegistry();
        EClass eClass = this.revision.getEClass();
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature instanceof EReference) {
                this.resolveProxies(feature, (CDOPackageRegistry)packageRegistry);
            }
            ++n2;
        }
    }

    protected void resolveProxies(EStructuralFeature feature, CDOPackageRegistry packageRegistry) {
        Object value = this.getInstanceValue(this.instance, feature, packageRegistry);
        if (value != null) {
            if (feature.isMany()) {
                InternalEList list = (InternalEList)value;
                int size = list.size();
                boolean deliver = this.instance.eDeliver();
                if (deliver) {
                    this.instance.eSetDeliver(false);
                }
                int i = 0;
                while (i < size) {
                    Object element = list.get(i);
                    if (element instanceof LegacyProxy) {
                        CDOID id = ((LegacyProxy)element).getID();
                        InternalCDOObject resolved = (InternalCDOObject)this.view.getObject(id);
                        InternalEObject instance = resolved.cdoInternalInstance();
                        list.set(i, (Object)instance);
                    }
                    ++i;
                }
                if (deliver) {
                    this.instance.eSetDeliver(true);
                }
            } else if (value instanceof LegacyProxy) {
                CDOID id = ((LegacyProxy)value).getID();
                InternalCDOObject resolved = (InternalCDOObject)this.view.getObject(id);
                InternalEObject instance = resolved.cdoInternalInstance();
                this.setInstanceValue(instance, feature, instance);
            }
        }
    }

    protected void adjustEProxy() {
        if (this.state == CDOState.PROXY) {
            if (!this.instance.eIsProxy()) {
                URI uri = URI.createURI((String)("cdo:proxy#" + this.id));
                if (TRACER.isEnabled()) {
                    TRACER.format("Setting proxyURI {0} for {1}", new Object[]{uri, this.instance});
                }
                this.instance.eSetProxyURI(uri);
            }
        } else if (this.instance.eIsProxy()) {
            if (TRACER.isEnabled()) {
                TRACER.format("Unsetting proxyURI for {0}", new Object[]{this.instance});
            }
            this.instance.eSetProxyURI(null);
        }
    }

    @Override
    public synchronized EList<Adapter> eAdapters() {
        EList adapters = this.instance.eAdapters();
        for (Adapter adapter : adapters) {
            if (FSMUtil.isTransient(this) || adapter instanceof CDOLegacyWrapper) continue;
            this.cdoView().handleAddAdapter(this, adapter);
        }
        return adapters;
    }

    public static boolean isLegacyProxy(Object object) {
        return object instanceof LegacyProxy;
    }

    protected static int getEFlagMask(Class<?> instanceClass, String flagName) {
        Field field = ReflectUtil.getField(instanceClass, (String)flagName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return (Integer)field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    protected static CDOLegacyWrapper getRegisteredWrapper(CDOID id) {
        return wrapperRegistry.get().get(id);
    }

    protected static void registerWrapper(CDOLegacyWrapper wrapper) {
        wrapperRegistry.get().put(wrapper.cdoID(), wrapper);
    }

    protected static void unregisterWrapper(CDOLegacyWrapper wrapper) {
        wrapperRegistry.get().remove(wrapper.cdoID());
    }

    protected static boolean isRegisteredWrapper(CDOLegacyWrapper wrapper) {
        return wrapperRegistry.get().containsKey(wrapper.cdoID());
    }

    private static void adjustOppositeReference(InternalCDOObject instance, InternalEObject object, EReference feature) {
        if (object != null) {
            InternalCDOObject cdoObject = (InternalCDOObject)CDOUtil.getCDOObject((EObject)object);
            if (cdoObject != null && !FSMUtil.isTransient(cdoObject)) {
                InternalEObject.EStore eStore = cdoObject.eStore();
                if (eStore != null) {
                    if (feature.isMany()) {
                        int index = eStore.indexOf((InternalEObject)cdoObject, (EStructuralFeature)feature, (Object)instance.cdoID());
                        if (index != -1) {
                            eStore.set((InternalEObject)cdoObject, (EStructuralFeature)feature, index, (Object)instance);
                        }
                    } else {
                        eStore.set((InternalEObject)cdoObject, (EStructuralFeature)feature, 0, (Object)instance);
                    }
                }
            } else if (feature.isResolveProxies()) {
                if (feature.isMany()) {
                    InternalEList list = (InternalEList)object.eGet((EStructuralFeature)feature);
                    int index = list.indexOf((Object)instance);
                    if (index != -1) {
                        list.set(index, (Object)instance);
                    }
                } else {
                    object.eSet((EStructuralFeature)feature, (Object)instance);
                }
            }
        }
    }

    private static final class Counter {
        private int value;

        public void increment() {
            ++this.value;
        }

        public int decrement() {
            return --this.value;
        }
    }

    private static interface LegacyProxy {
        public CDOID getID();
    }

    private static final class LegacyProxyInvocationHandler
    implements InvocationHandler,
    LegacyProxy {
        private static final Method getIDMethod = ReflectUtil.getMethod(LegacyProxy.class, (String)"getID", (Class[])new Class[0]);
        private static final Method eIsProxyMethod = ReflectUtil.getMethod(EObject.class, (String)"eIsProxy", (Class[])new Class[0]);
        private static final Method eProxyURIMethod = ReflectUtil.getMethod(InternalEObject.class, (String)"eProxyURI", (Class[])new Class[0]);
        private CDOLegacyWrapper wrapper;
        private CDOID id;

        public LegacyProxyInvocationHandler(CDOLegacyWrapper wrapper, CDOID id) {
            this.wrapper = wrapper;
            this.id = id;
        }

        public CDOID getID() {
            return this.id;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(getIDMethod)) {
                return this.id;
            }
            if (method.equals(eIsProxyMethod)) {
                return true;
            }
            if (method.equals(eProxyURIMethod)) {
                Resource resource = this.wrapper.eResource();
                return resource.getURI().appendFragment(this.id.toURIFragment());
            }
            throw new UnsupportedOperationException(method.getName());
        }
    }
}

