/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDeltaUtil;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOInvalidationPolicy;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.internal.cdo.CDOEvent;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.transaction.CDOTransactionImpl;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.fsm.FiniteStateMachine;
import org.eclipse.net4j.util.fsm.ITransition;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOStateMachine
extends FiniteStateMachine<CDOState, CDOEvent, InternalCDOObject> {
    public static final CDOStateMachine INSTANCE = new CDOStateMachine();
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_STATEMACHINE, CDOStateMachine.class);
    private InternalCDOObject lastTracedObject;
    private CDOState lastTracedState;
    private CDOEvent lastTracedEvent;

    private CDOStateMachine() {
        super(CDOState.class, CDOEvent.class);
        this.init(CDOState.TRANSIENT, CDOEvent.PREPARE, new PrepareTransition());
        this.init(CDOState.TRANSIENT, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.TRANSIENT, CDOEvent.DETACH, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.REATTACH, new ReattachTransition());
        this.init(CDOState.TRANSIENT, CDOEvent.READ, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.WRITE, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.INVALIDATE, FAIL);
        this.init(CDOState.TRANSIENT, CDOEvent.DETACH_REMOTE, FAIL);
        this.init(CDOState.TRANSIENT, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.TRANSIENT, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.ATTACH, new AttachTransition());
        this.init(CDOState.PREPARED, CDOEvent.DETACH, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.READ, IGNORE);
        this.init(CDOState.PREPARED, CDOEvent.WRITE, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.INVALIDATE, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.DETACH_REMOTE, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.NEW, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.NEW, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.NEW, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.NEW, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.NEW, CDOEvent.READ, IGNORE);
        this.init(CDOState.NEW, CDOEvent.WRITE, new WriteNewTransition());
        this.init(CDOState.NEW, CDOEvent.INVALIDATE, FAIL);
        this.init(CDOState.NEW, CDOEvent.DETACH_REMOTE, FAIL);
        this.init(CDOState.NEW, CDOEvent.COMMIT, new CommitTransition(false));
        this.init(CDOState.NEW, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.CLEAN, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.READ, IGNORE);
        this.init(CDOState.CLEAN, CDOEvent.WRITE, new WriteTransition());
        this.init(CDOState.CLEAN, CDOEvent.INVALIDATE, new InvalidateTransition(null, null));
        this.init(CDOState.CLEAN, CDOEvent.DETACH_REMOTE, DetachRemoteTransition.INSTANCE);
        this.init(CDOState.CLEAN, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.DIRTY, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.DIRTY, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.DIRTY, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.DIRTY, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.DIRTY, CDOEvent.READ, IGNORE);
        this.init(CDOState.DIRTY, CDOEvent.WRITE, new RewriteTransition());
        this.init(CDOState.DIRTY, CDOEvent.INVALIDATE, new ConflictTransition(null, null));
        this.init(CDOState.DIRTY, CDOEvent.DETACH_REMOTE, new InvalidConflictTransition());
        this.init(CDOState.DIRTY, CDOEvent.COMMIT, new CommitTransition(true));
        this.init(CDOState.DIRTY, CDOEvent.ROLLBACK, new RollbackTransition());
        this.init(CDOState.PROXY, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.PROXY, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.PROXY, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.PROXY, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.PROXY, CDOEvent.READ, new LoadTransition(false));
        this.init(CDOState.PROXY, CDOEvent.WRITE, new LoadTransition(true));
        this.init(CDOState.PROXY, CDOEvent.INVALIDATE, IGNORE);
        this.init(CDOState.PROXY, CDOEvent.DETACH_REMOTE, DetachRemoteTransition.INSTANCE);
        this.init(CDOState.PROXY, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.PROXY, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.CONFLICT, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.CONFLICT, CDOEvent.ATTACH, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.CONFLICT, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.CONFLICT, CDOEvent.READ, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.WRITE, new RewriteTransition());
        this.init(CDOState.CONFLICT, CDOEvent.INVALIDATE, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.DETACH_REMOTE, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.COMMIT, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.ROLLBACK, new RollbackTransition());
        this.init(CDOState.INVALID, CDOEvent.PREPARE, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.ATTACH, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.DETACH, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.INVALID, CDOEvent.READ, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.WRITE, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.INVALIDATE, IGNORE);
        this.init(CDOState.INVALID, CDOEvent.DETACH_REMOTE, IGNORE);
        this.init(CDOState.INVALID, CDOEvent.COMMIT, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.ROLLBACK, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.PREPARE, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.ATTACH, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.DETACH, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.READ, IGNORE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.WRITE, IGNORE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.INVALIDATE, IGNORE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.DETACH_REMOTE, IGNORE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.COMMIT, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.ROLLBACK, DetachRemoteTransition.INSTANCE);
    }

    public void attach(InternalCDOObject object, InternalCDOTransaction transaction) {
        ReentrantLock lock = this.lockView(transaction);
        try {
            ArrayList contents = new ArrayList();
            this.prepare(object, (Pair<InternalCDOTransaction, List<InternalCDOObject>>)new Pair((Object)transaction, contents));
            this.attachOrReattach(object, transaction);
            for (InternalCDOObject content : contents) {
                this.attachOrReattach(content, transaction);
            }
        }
        finally {
            this.unlockView(lock);
        }
    }

    private void attachOrReattach(InternalCDOObject object, InternalCDOTransaction transaction) {
        if (!(transaction instanceof CDOTransactionImpl)) {
            throw new UnsupportedOperationException("Transaction does not support the getFormerRevisionKeys() method");
        }
        if (((CDOTransactionImpl)transaction).getFormerRevisionKeys().containsKey(object)) {
            this.reattachObject(object, transaction);
        } else {
            this.attachObject(object);
        }
    }

    private void prepare(InternalCDOObject object, Pair<InternalCDOTransaction, List<InternalCDOObject>> transactionAndContents) {
        if (TRACER.isEnabled()) {
            TRACER.format("PREPARE: {0} --> {1}", new Object[]{object, transactionAndContents.getElement1()});
        }
        this.process(object, CDOEvent.PREPARE, transactionAndContents);
    }

    private void attachObject(InternalCDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("ATTACH: {0}", new Object[]{object});
        }
        this.process(object, CDOEvent.ATTACH, null);
    }

    private void reattachObject(InternalCDOObject object, InternalCDOTransaction transaction) {
        if (TRACER.isEnabled()) {
            TRACER.format("REATTACH: {0}", new Object[]{object});
        }
        this.process(object, CDOEvent.REATTACH, transaction);
    }

    public void detach(InternalCDOObject object) {
        ReentrantLock lock = this.lockView(object.cdoView());
        try {
            if (TRACER.isEnabled()) {
                this.trace(object, CDOEvent.DETACH);
            }
            ArrayList objectsToDetach = new ArrayList();
            InternalCDOTransaction transaction = (InternalCDOTransaction)object.cdoView();
            this.process(object, CDOEvent.DETACH, objectsToDetach);
            for (InternalCDOObject content : objectsToDetach) {
                CDOState oldState = content.cdoInternalSetState(CDOState.TRANSIENT);
                content.cdoInternalPostDetach(false);
                content.cdoInternalSetState(oldState);
            }
            for (InternalCDOObject content : objectsToDetach) {
                transaction.detachObject(content);
                content.cdoInternalSetState(CDOState.TRANSIENT);
                content.cdoInternalSetView(null);
                content.cdoInternalSetID(null);
                content.cdoInternalSetRevision(null);
            }
        }
        finally {
            this.unlockView(lock);
        }
    }

    public InternalCDORevision read(InternalCDOObject object) {
        ReentrantLock lock = this.lockView(object.cdoView());
        try {
            if (TRACER.isEnabled()) {
                this.trace(object, CDOEvent.READ);
            }
            this.process(object, CDOEvent.READ, null);
            InternalCDORevision internalCDORevision = object.cdoRevision();
            return internalCDORevision;
        }
        finally {
            this.unlockView(lock);
        }
    }

    public InternalCDORevision readNoLoad(InternalCDOObject object) {
        ReentrantLock lock = this.lockView(object.cdoView());
        try {
            switch (object.cdoState()) {
                case TRANSIENT: 
                case NEW: 
                case PROXY: 
                case CONFLICT: 
                case INVALID: 
                case INVALID_CONFLICT: 
                case PREPARED: {
                    return null;
                }
            }
            InternalCDORevision internalCDORevision = object.cdoRevision();
            return internalCDORevision;
        }
        finally {
            this.unlockView(lock);
        }
    }

    public void write(InternalCDOObject object) {
        this.write(object, null);
    }

    public void write(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        ReentrantLock lock = this.lockView(object.cdoView());
        try {
            this.writeWithoutViewLock(object, featureDelta);
        }
        finally {
            this.unlockView(lock);
        }
    }

    private void writeWithoutViewLock(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        if (TRACER.isEnabled()) {
            this.trace(object, CDOEvent.WRITE);
        }
        this.process(object, CDOEvent.WRITE, featureDelta);
    }

    public void reload(InternalCDOObject ... objects) {
        InternalCDOObject[] internalCDOObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOObject object = internalCDOObjectArray[n2];
            CDOState state = object.cdoState();
            if (state == CDOState.CLEAN || state == CDOState.PROXY) {
                this.changeState(object, CDOState.PROXY);
                object.cdoInternalSetRevision(null);
                this.read(object);
            }
            ++n2;
        }
    }

    public void invalidate(InternalCDOObject object, CDORevisionKey key, long lastUpdateTime) {
        ReentrantLock lock = this.lockView(object.cdoView());
        try {
            if (TRACER.isEnabled()) {
                this.trace(object, CDOEvent.INVALIDATE);
            }
            this.process(object, CDOEvent.INVALIDATE, new Pair((Object)key, (Object)lastUpdateTime));
        }
        finally {
            this.unlockView(lock);
        }
    }

    public void detachRemote(InternalCDOObject object) {
        ReentrantLock lock = this.lockView(object.cdoView());
        try {
            if (TRACER.isEnabled()) {
                this.trace(object, CDOEvent.DETACH_REMOTE);
            }
            this.process(object, CDOEvent.DETACH_REMOTE, null);
        }
        finally {
            this.unlockView(lock);
        }
    }

    public void commit(InternalCDOObject object, CDOSessionProtocol.CommitTransactionResult result) {
        ReentrantLock lock = this.lockView(object.cdoView());
        try {
            if (TRACER.isEnabled()) {
                this.trace(object, CDOEvent.COMMIT);
            }
            this.process(object, CDOEvent.COMMIT, result);
        }
        finally {
            this.unlockView(lock);
        }
    }

    public void rollback(InternalCDOObject object) {
        ReentrantLock lock = this.lockView(object.cdoView());
        try {
            if (TRACER.isEnabled()) {
                this.trace(object, CDOEvent.ROLLBACK);
            }
            this.process(object, CDOEvent.ROLLBACK, null);
            object.cdoInternalPostRollback();
        }
        finally {
            this.unlockView(lock);
        }
    }

    protected CDOState getState(InternalCDOObject object) {
        return object.cdoState();
    }

    protected void setState(InternalCDOObject object, CDOState state) {
        object.cdoInternalSetState(state);
    }

    private ReentrantLock lockView(InternalCDOView view) {
        if (view == null) {
            return null;
        }
        ReentrantLock stateLock = view.getStateLock();
        stateLock.lock();
        return stateLock;
    }

    private void unlockView(ReentrantLock stateLock) {
        if (stateLock != null) {
            stateLock.unlock();
        }
    }

    private void trace(InternalCDOObject object, CDOEvent event) {
        CDOState state = object.cdoState();
        if (this.lastTracedObject != object || this.lastTracedState != state || this.lastTracedEvent != event) {
            TRACER.format("{0}: {1}", new Object[]{event, object.getClass().getName()});
            this.lastTracedObject = object;
            this.lastTracedState = state;
            this.lastTracedEvent = event;
        }
    }

    private void testAttach(InternalCDOObject object) {
        this.process(object, CDOEvent.ATTACH, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AttachTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private AttachTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object NULL) {
            object.cdoInternalPostAttach();
            CDOStateMachine.this.changeState(object, CDOState.NEW);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CommitTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, CDOSessionProtocol.CommitTransactionResult> {
        public CommitTransition(boolean useDeltas) {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, CDOSessionProtocol.CommitTransactionResult data) {
            CDOID oldID;
            InternalCDOTransaction transaction = object.cdoView().toTransaction();
            InternalCDORevision revision = object.cdoRevision();
            Map<CDOID, CDOID> idMappings = data.getIDMappings();
            CDOID newID = idMappings.get(oldID = object.cdoID());
            if (newID != null) {
                object.cdoInternalSetID(newID);
                transaction.remapObject(oldID);
                revision.setID(newID);
            }
            revision.adjustForCommit(transaction.getBranch(), data.getTimeStamp());
            revision.adjustReferences(data.getReferenceAdjuster());
            InternalCDORevisionManager revisionManager = transaction.getSession().getRevisionManager();
            if (!revisionManager.addRevision((CDORevision)revision)) {
                throw new IllegalStateException("Revision was not registered: " + revision);
            }
            CDOStateMachine.this.changeState(object, CDOState.CLEAN);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConflictTransition
    extends InvalidateTransition {
        private ConflictTransition() {
        }

        @Override
        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Pair<CDORevisionKey, Long> keyAndTime) {
            CDORevisionKey key = (CDORevisionKey)keyAndTime.getElement1();
            InternalCDORevision oldRevision = object.cdoRevision();
            if (key == null || key.getVersion() >= oldRevision.getVersion() - 1) {
                CDOStateMachine.this.changeState(object, CDOState.CONFLICT);
                InternalCDOTransaction transaction = object.cdoView().toTransaction();
                transaction.setConflict(object);
            }
        }

        /* synthetic */ ConflictTransition(ConflictTransition conflictTransition, ConflictTransition conflictTransition2) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DetachRemoteTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        static final DetachRemoteTransition INSTANCE = new DetachRemoteTransition();

        private DetachRemoteTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object NULL) {
            INSTANCE.changeState(object, CDOState.INVALID);
            InternalCDOView view = object.cdoView();
            view.deregisterObject(object);
            object.cdoInternalPostDetach(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DetachTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, List<InternalCDOObject>> {
        private DetachTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, List<InternalCDOObject> objectsToDetach) {
            InternalCDOTransaction transaction = (InternalCDOTransaction)object.cdoView();
            objectsToDetach.add(object);
            boolean isResource = object instanceof Resource;
            for (InternalEObject eObject : object.eContents()) {
                InternalCDOObject content;
                boolean isDirectlyConnected;
                boolean bl = isDirectlyConnected = isResource && eObject.eDirectResource() == object;
                if (!isDirectlyConnected && eObject.eDirectResource() != null || (content = FSMUtil.adapt(eObject, transaction)) == null) continue;
                INSTANCE.process(content, CDOEvent.DETACH, objectsToDetach);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvalidConflictTransition
    extends ConflictTransition {
        private InvalidConflictTransition() {
        }

        @Override
        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Pair<CDORevisionKey, Long> UNUSED) {
            CDOStateMachine.this.changeState(object, CDOState.INVALID_CONFLICT);
            InternalCDOTransaction transaction = object.cdoView().toTransaction();
            transaction.setConflict(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InvalidTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        public static final InvalidTransition INSTANCE = new InvalidTransition();

        private InvalidTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object NULL) {
            InternalCDOView view = object.cdoView();
            CDOInvalidationPolicy policy = view.options().getInvalidationPolicy();
            policy.handleInvalidObject(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvalidateTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Pair<CDORevisionKey, Long>> {
        private InvalidateTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Pair<CDORevisionKey, Long> keyAndTime) {
            CDORevisionKey key = (CDORevisionKey)keyAndTime.getElement1();
            long lastUpdateTime = (Long)keyAndTime.getElement2();
            InternalCDORevision oldRevision = object.cdoRevision();
            if (key == null || key.getVersion() >= oldRevision.getVersion()) {
                InternalCDOView view = object.cdoView();
                if (key instanceof CDORevisionDelta) {
                    CDORevisionDelta delta = (CDORevisionDelta)key;
                    InternalCDORevision newRevision = oldRevision.copy();
                    CDOBranchVersion target = null;
                    if (delta instanceof CDORevisionDeltaImpl) {
                        CDORevisionDeltaImpl impl = (CDORevisionDeltaImpl)delta;
                        target = impl.getTarget();
                    }
                    if (target != null) {
                        newRevision.setBranchPoint(target.getBranch().getPoint(lastUpdateTime));
                        newRevision.setVersion(target.getVersion());
                        newRevision.setRevised(0L);
                    } else {
                        newRevision.adjustForCommit(view.getBranch(), lastUpdateTime);
                    }
                    delta.apply((CDORevision)newRevision);
                    object.cdoInternalSetRevision((CDORevision)newRevision);
                    CDOStateMachine.this.changeState(object, CDOState.CLEAN);
                    object.cdoInternalPostLoad();
                } else {
                    CDOStateMachine.this.changeState(object, CDOState.PROXY);
                    CDOInvalidationPolicy policy = view.options().getInvalidationPolicy();
                    policy.handleInvalidation(object, key);
                    object.cdoInternalPostInvalidate();
                }
            }
        }

        /* synthetic */ InvalidateTransition(InvalidateTransition invalidateTransition, InvalidateTransition invalidateTransition2) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LoadTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private boolean forWrite;

        public LoadTransition(boolean forWrite) {
            this.forWrite = forWrite;
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object delta) {
            object.cdoInternalPreLoad();
            InternalCDOView view = object.cdoView();
            InternalCDORevision revision = view.getRevision(object.cdoID(), true);
            if (revision == null) {
                INSTANCE.detachRemote(object);
                CDOInvalidationPolicy policy = view.options().getInvalidationPolicy();
                policy.handleInvalidObject(object);
            }
            CDOStateMachine.this.changeState(object, CDOState.CLEAN);
            object.cdoInternalSetRevision((CDORevision)revision);
            object.cdoInternalPostLoad();
            if (this.forWrite) {
                INSTANCE.writeWithoutViewLock(object, (CDOFeatureDelta)delta);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PrepareTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Pair<InternalCDOTransaction, List<InternalCDOObject>>> {
        private PrepareTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Pair<InternalCDOTransaction, List<InternalCDOObject>> transactionAndContents) {
            InternalCDOTransaction transaction = (InternalCDOTransaction)transactionAndContents.getElement1();
            List contents = (List)transactionAndContents.getElement2();
            if (!(transaction instanceof CDOTransactionImpl)) {
                throw new UnsupportedOperationException("Transaction does not support the getFormerRevisionKeys() method");
            }
            boolean reattaching = ((CDOTransactionImpl)transaction).getFormerRevisionKeys().containsKey(object);
            if (!reattaching) {
                CDOIDTemp id = transaction.getNextTemporaryID();
                object.cdoInternalSetID((CDOID)id);
                object.cdoInternalSetView(transaction);
                CDOStateMachine.this.changeState(object, CDOState.PREPARED);
                EClass eClass = object.eClass();
                CDORevisionFactory factory = transaction.getSession().getRevisionManager().getFactory();
                InternalCDORevision revision = (InternalCDORevision)factory.createRevision(eClass);
                revision.setID((CDOID)id);
                revision.setBranchPoint(transaction.getBranch().getHead());
                object.cdoInternalSetRevision((CDORevision)revision);
                transaction.registerObject(object);
                transaction.registerNew(object);
            }
            Iterator<InternalCDOObject> it = this.getProperContents(object, transaction);
            while (it.hasNext()) {
                InternalCDOObject content = it.next();
                contents.add(content);
                INSTANCE.process(content, CDOEvent.PREPARE, transactionAndContents);
            }
        }

        private Iterator<InternalCDOObject> getProperContents(InternalCDOObject object, final CDOTransaction transaction) {
            final boolean isResource = object instanceof Resource;
            final Iterator delegate = object.eContents().iterator();
            return new Iterator<InternalCDOObject>(){
                private Object next;

                @Override
                public boolean hasNext() {
                    while (delegate.hasNext()) {
                        InternalEObject eObject = (InternalEObject)delegate.next();
                        EStructuralFeature eContainingFeature = eObject.eContainingFeature();
                        if (!isResource && (eObject.eDirectResource() != null || eContainingFeature != null && !EMFUtil.isPersistent((EStructuralFeature)eContainingFeature))) continue;
                        this.next = FSMUtil.adapt(eObject, transaction);
                        return true;
                    }
                    return false;
                }

                @Override
                public InternalCDOObject next() {
                    return (InternalCDOObject)this.next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ReattachTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, InternalCDOTransaction> {
        private ReattachTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, InternalCDOTransaction transaction) {
            InternalCDORevisionManager revisionManager = transaction.getSession().getRevisionManager();
            if (!(transaction instanceof CDOTransactionImpl)) {
                throw new UnsupportedOperationException("Transaction does not support the getFormerRevisionKeys() method");
            }
            CDORevisionKey revKey = ((CDOTransactionImpl)transaction).getFormerRevisionKeys().get(object);
            CDOID id = revKey.getID();
            object.cdoInternalSetID(id);
            object.cdoInternalSetView(transaction);
            CDORevisionFactory factory = revisionManager.getFactory();
            InternalCDORevision revision = (InternalCDORevision)factory.createRevision(object.eClass());
            revision.setID(id);
            revision.setBranchPoint(transaction.getBranch().getHead());
            revision.setVersion(revKey.getVersion());
            object.cdoInternalSetRevision((CDORevision)revision);
            object.cdoInternalPostAttach();
            InternalCDORevision cleanRevision = revisionManager.getRevisionByVersion(id, (CDOBranchVersion)revKey, -1, true);
            CDORevisionDelta revisionDelta = CDORevisionDeltaUtil.create((CDORevision)cleanRevision, (CDORevision)revision);
            transaction.registerRevisionDelta(revisionDelta);
            transaction.registerDirty(object, null);
            CDOStateMachine.this.changeState(object, CDOState.DIRTY);
            transaction.getLastSavepoint().getReattachedObjects().put(id, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RewriteTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private RewriteTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object featureDelta) {
            InternalCDOTransaction transaction = object.cdoView().toTransaction();
            transaction.registerFeatureDelta(object, (CDOFeatureDelta)featureDelta);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RollbackTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private RollbackTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object NULL) {
            CDOStateMachine.this.changeState(object, CDOState.PROXY);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WriteNewTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private WriteNewTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object featureDelta) {
            InternalCDOTransaction transaction = object.cdoView().toTransaction();
            transaction.registerFeatureDelta(object, (CDOFeatureDelta)featureDelta);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WriteTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private WriteTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object featureDelta) {
            InternalCDOTransaction transaction = object.cdoView().toTransaction();
            InternalCDORevision revision = object.cdoRevision().copy();
            object.cdoInternalSetRevision((CDORevision)revision);
            transaction.registerDirty(object, (CDOFeatureDelta)featureDelta);
            CDOStateMachine.this.changeState(object, CDOState.DIRTY);
        }
    }
}

