/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.session.CDOCollectionLoadingPolicy;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.spi.cdo.CDOElementProxy;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;

public class CDOCollectionLoadingPolicyImpl
implements CDOCollectionLoadingPolicy {
    private int initialChunkSize;
    private int resolveChunkSize;

    public CDOCollectionLoadingPolicyImpl(int initialChunkSize, int resolveChunkSize) {
        this.resolveChunkSize = resolveChunkSize <= 0 ? -1 : resolveChunkSize;
        this.initialChunkSize = initialChunkSize < 0 ? resolveChunkSize : initialChunkSize;
    }

    public int getInitialChunkSize() {
        return this.initialChunkSize;
    }

    public int getResolveChunkSize() {
        return this.resolveChunkSize;
    }

    public Object resolveProxy(CDOSession session, CDORevision rev, EStructuralFeature feature, int accessIndex, int serverIndex) {
        InternalCDORevision revision = (InternalCDORevision)rev;
        int fetchIndex = serverIndex;
        int chunkSize = this.resolveChunkSize;
        if (chunkSize == -1) {
            chunkSize = Integer.MAX_VALUE;
        }
        CDOList list = revision.getList(feature);
        int size = list.size();
        int fromIndex = accessIndex;
        int toIndex = accessIndex;
        boolean minReached = false;
        boolean maxReached = false;
        boolean alternation = false;
        int i = 0;
        while (i < chunkSize) {
            if (alternation) {
                if (!maxReached && toIndex < size - 1 && list.get(toIndex + 1) instanceof CDOElementProxy) {
                    ++toIndex;
                } else {
                    maxReached = true;
                }
                if (!minReached) {
                    alternation = false;
                }
            } else {
                if (!minReached && fromIndex > 0 && list.get(fromIndex - 1) instanceof CDOElementProxy) {
                    --fromIndex;
                } else {
                    minReached = true;
                }
                if (!maxReached) {
                    alternation = true;
                }
            }
            if (minReached && maxReached) break;
            ++i;
        }
        CDOSessionProtocol protocol = ((InternalCDOSession)session).getSessionProtocol();
        return protocol.loadChunk(revision, feature, accessIndex, fetchIndex, fromIndex, toIndex);
    }
}

