/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticationResult;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticator;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.session.remote.CDORemoteSessionManagerImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOSessionConfiguration;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.SecurityUtil;

public abstract class CDOSessionConfigurationImpl
implements InternalCDOSessionConfiguration {
    private boolean passiveUpdateEnabled = true;
    private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode = CDOCommonSession.Options.PassiveUpdateMode.INVALIDATIONS;
    private CDOAuthenticator authenticator = new AuthenticatorImpl();
    private CDOSession.ExceptionHandler exceptionHandler;
    private boolean activateOnOpen = true;
    private InternalCDOSession session;

    public boolean isPassiveUpdateEnabled() {
        return this.passiveUpdateEnabled;
    }

    public void setPassiveUpdateEnabled(boolean passiveUpdateEnabled) {
        this.checkNotOpen();
        this.passiveUpdateEnabled = passiveUpdateEnabled;
    }

    public CDOCommonSession.Options.PassiveUpdateMode getPassiveUpdateMode() {
        return this.passiveUpdateMode;
    }

    public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode) {
        this.checkNotOpen();
        this.passiveUpdateMode = passiveUpdateMode;
    }

    public CDOAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(CDOAuthenticator authenticator) {
        this.checkNotOpen();
        this.authenticator = authenticator;
    }

    public CDOSession.ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(CDOSession.ExceptionHandler exceptionHandler) {
        this.checkNotOpen();
        this.exceptionHandler = exceptionHandler;
    }

    public boolean isActivateOnOpen() {
        return this.activateOnOpen;
    }

    public void setActivateOnOpen(boolean activateOnOpen) {
        this.checkNotOpen();
        this.activateOnOpen = activateOnOpen;
    }

    public boolean isSessionOpen() {
        if (this.session == null) {
            return false;
        }
        if (!this.session.isClosed()) {
            return true;
        }
        this.session = null;
        return false;
    }

    public CDOSession openSession() {
        if (!this.isSessionOpen()) {
            this.session = this.createSession();
            this.session.setExceptionHandler(this.exceptionHandler);
            if (this.activateOnOpen) {
                this.session.activate();
            }
        }
        return this.session;
    }

    public InternalCDOSession getSession() {
        this.checkOpen();
        return this.session;
    }

    public void activateSession(InternalCDOSession session) throws Exception {
        CDORemoteSessionManagerImpl remoteSessionManager = new CDORemoteSessionManagerImpl();
        remoteSessionManager.setLocalSession(session);
        session.setRemoteSessionManager(remoteSessionManager);
        remoteSessionManager.activate();
    }

    public void deactivateSession(InternalCDOSession session) throws Exception {
        InternalCDORemoteSessionManager remoteSessionManager = session.getRemoteSessionManager();
        session.setRemoteSessionManager(null);
        LifecycleUtil.deactivate((Object)remoteSessionManager);
        CDOSessionProtocol sessionProtocol = session.getSessionProtocol();
        LifecycleUtil.deactivate((Object)sessionProtocol);
        session.setSessionProtocol(null);
        session = null;
    }

    protected void checkOpen() {
        if (!this.isSessionOpen()) {
            throw new IllegalStateException(Messages.getString("CDOSessionConfigurationImpl.1"));
        }
    }

    protected void checkNotOpen() {
        if (this.isSessionOpen()) {
            throw new IllegalStateException(Messages.getString("CDOSessionConfigurationImpl.0"));
        }
    }

    protected class AuthenticatorImpl
    implements CDOAuthenticator {
        private String encryptionAlgorithmName = "PBEWithMD5AndDES";
        private byte[] encryptionSaltBytes = SecurityUtil.DEFAULT_SALT;
        private int encryptionIterationCount = 20;
        private IPasswordCredentialsProvider credentialsProvider;

        public String getEncryptionAlgorithmName() {
            return this.encryptionAlgorithmName;
        }

        public void setEncryptionAlgorithmName(String encryptionAlgorithmName) {
            this.checkSessionNotOpened();
            this.encryptionAlgorithmName = encryptionAlgorithmName;
        }

        public byte[] getEncryptionSaltBytes() {
            return this.encryptionSaltBytes;
        }

        public void setEncryptionSaltBytes(byte[] encryptionSaltBytes) {
            this.checkSessionNotOpened();
            this.encryptionSaltBytes = encryptionSaltBytes;
        }

        public int getEncryptionIterationCount() {
            return this.encryptionIterationCount;
        }

        public void setEncryptionIterationCount(int encryptionIterationCount) {
            this.checkSessionNotOpened();
            this.encryptionIterationCount = encryptionIterationCount;
        }

        public IPasswordCredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        public void setCredentialsProvider(IPasswordCredentialsProvider credentialsProvider) {
            this.checkSessionNotOpened();
            this.credentialsProvider = credentialsProvider;
        }

        public CDOAuthenticationResult authenticate(byte[] randomToken) {
            if (this.credentialsProvider == null) {
                throw new IllegalStateException("No credentials provider configured");
            }
            IPasswordCredentials credentials = this.credentialsProvider.getCredentials();
            String userID = credentials.getUserID();
            byte[] cryptedToken = this.encryptToken(credentials.getPassword(), randomToken);
            return new CDOAuthenticationResult(userID, cryptedToken);
        }

        protected byte[] encryptToken(char[] password, byte[] token) {
            try {
                return SecurityUtil.encrypt((byte[])token, (char[])password, (String)this.encryptionAlgorithmName, (byte[])this.encryptionSaltBytes, (int)this.encryptionIterationCount);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SecurityException(ex);
            }
        }

        private void checkSessionNotOpened() {
            if (CDOSessionConfigurationImpl.this.session != null) {
                throw new IllegalStateException("Not allowed after the session has been opened");
            }
        }
    }
}

