/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOSessionFactory
extends Factory {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.sessions";
    private static final String TRUE = Boolean.TRUE.toString();

    public CDOSessionFactory(String type) {
        super(PRODUCT_GROUP, type);
    }

    public CDOSession create(String description) {
        try {
            URI uri = new URI(description);
            String query = uri.getQuery();
            if (StringUtil.isEmpty((String)query)) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOSessionFactory.1"), description));
            }
            Map<String, String> result = this.getParameters(query);
            String repositoryName = result.get("repositoryName");
            if (repositoryName == null) {
                throw new IllegalArgumentException("Repository name is missing: " + description);
            }
            boolean automaticPackageRegistry = TRUE.equals(result.get("automaticPackageRegistry"));
            return this.createSession(repositoryName, automaticPackageRegistry);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected abstract InternalCDOSession createSession(String var1, boolean var2);

    private Map<String, String> getParameters(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        while (tokenizer.hasMoreTokens()) {
            String key;
            String parameter = tokenizer.nextToken();
            if (StringUtil.isEmpty((String)parameter)) continue;
            int pos = parameter.indexOf(61);
            if (pos == -1) {
                key = parameter.trim();
                result.put(key, "");
                continue;
            }
            key = parameter.substring(0, pos).trim();
            String value = parameter.substring(pos + 1);
            result.put(key, value);
        }
        return result;
    }
}

