/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticator;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.common.util.RepositoryStateChangedEvent;
import org.eclipse.emf.cdo.common.util.RepositoryTypeChangedEvent;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSingleValueFeatureDeltaImpl;
import org.eclipse.emf.cdo.session.CDOCollectionLoadingPolicy;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.CDORawReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureDeltaVisitorImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.internal.cdo.CDOFactoryImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.session.SessionUtil;
import org.eclipse.emf.internal.cdo.transaction.CDOTransactionImpl;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOSessionConfiguration;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.QueueRunner;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.IOptionsContainer;
import org.eclipse.net4j.util.options.OptionsEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOSessionImpl
extends Container<CDOView>
implements InternalCDOSession {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, CDOSessionImpl.class);
    private InternalCDOSessionConfiguration configuration;
    private CDOSession.ExceptionHandler exceptionHandler;
    private CDOSessionProtocol sessionProtocol;
    @ReflectUtil.ExcludeFromDump
    private IListener sessionProtocolListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            CDOSessionImpl.this.deactivate();
        }
    };
    private int sessionID;
    private String userID;
    private long lastUpdateTime;
    @ReflectUtil.ExcludeFromDump
    private Object lastUpdateTimeLock = new Object();
    private CDOSession.Options options = this.createOptions();
    private CDORepositoryInfo repositoryInfo;
    private CDOFetchRuleManager ruleManager = CDOFetchRuleManager.NOOP;
    private IRWLockManager<CDOSessionImpl, Object> lockmanager = new RWLockManager();
    @ReflectUtil.ExcludeFromDump
    private Set<CDOSessionImpl> singletonCollection = Collections.singleton(this);
    private CDOAuthenticator authenticator;
    private InternalCDORemoteSessionManager remoteSessionManager;
    private Set<InternalCDOView> views = new HashSet<InternalCDOView>();
    @ReflectUtil.ExcludeFromDump
    private Object invalidationLock = new Object();
    @ReflectUtil.ExcludeFromDump
    private QueueRunner invalidationRunner;
    @ReflectUtil.ExcludeFromDump
    private Object invalidationRunnerLock = new Object();
    @ReflectUtil.ExcludeFromDump
    private static ThreadLocal<Boolean> invalidationRunnerActive = new InheritableThreadLocal<Boolean>();
    @ReflectUtil.ExcludeFromDump
    private int lastViewID;

    public CDOSessionImpl(InternalCDOSessionConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public InternalCDOSessionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public CDORepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    @Override
    public void setRepositoryInfo(CDORepositoryInfo repositoryInfo) {
        this.repositoryInfo = repositoryInfo;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    @Override
    public void setSessionID(int sessionID) {
        this.sessionID = sessionID;
    }

    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Override
    public CDOSession.ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setExceptionHandler(CDOSession.ExceptionHandler exceptionHandler) {
        this.checkInactive();
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public CDOSession.Options options() {
        return this.options;
    }

    protected CDOSession.Options createOptions() {
        return new OptionsImpl();
    }

    @Override
    public CDOSessionProtocol getSessionProtocol() {
        return this.sessionProtocol;
    }

    @Override
    public void setSessionProtocol(CDOSessionProtocol sessionProtocol) {
        this.sessionProtocol = sessionProtocol;
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    public Object processPackage(Object value) {
        CDOFactoryImpl.prepareDynamicEPackage(value);
        return value;
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        if (packageUnit.getOriginalType().isGenerated() && !this.options().isGeneratedPackageEmulationEnabled()) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOSessionImpl.0"), packageUnit));
        }
        return this.getSessionProtocol().loadPackages(packageUnit);
    }

    public void acquireAtomicRequestLock(Object key) {
        try {
            this.lockmanager.lock(IRWLockManager.LockType.WRITE, key, (Object)this, 0L);
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public void releaseAtomicRequestLock(Object key) {
        this.lockmanager.unlock(IRWLockManager.LockType.WRITE, key, this.singletonCollection);
    }

    @Override
    public CDOFetchRuleManager getFetchRuleManager() {
        return this.ruleManager;
    }

    @Override
    public void setFetchRuleManager(CDOFetchRuleManager fetchRuleManager) {
        this.ruleManager = fetchRuleManager;
    }

    public CDOAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(CDOAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public InternalCDORemoteSessionManager getRemoteSessionManager() {
        return this.remoteSessionManager;
    }

    @Override
    public void setRemoteSessionManager(InternalCDORemoteSessionManager remoteSessionManager) {
        this.remoteSessionManager = remoteSessionManager;
    }

    @Override
    public InternalCDOTransaction openTransaction(CDOBranch branch, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOTransaction transaction = this.createTransaction(branch);
        this.initView(transaction, resourceSet);
        return transaction;
    }

    @Override
    public InternalCDOTransaction openTransaction(ResourceSet resourceSet) {
        return this.openTransaction((CDOBranch)this.getBranchManager().getMainBranch(), resourceSet);
    }

    @Override
    public InternalCDOTransaction openTransaction(CDOBranch branch) {
        return this.openTransaction(branch, this.createResourceSet());
    }

    @Override
    public InternalCDOTransaction openTransaction() {
        return this.openTransaction((CDOBranch)this.getBranchManager().getMainBranch());
    }

    protected InternalCDOTransaction createTransaction(CDOBranch branch) {
        return new CDOTransactionImpl(branch);
    }

    @Override
    public InternalCDOView openView(CDOBranch branch, long timeStamp, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOView view = this.createView(branch, timeStamp);
        this.initView(view, resourceSet);
        return view;
    }

    @Override
    public InternalCDOView openView(CDOBranch branch, long timeStamp) {
        return this.openView(branch, timeStamp, this.createResourceSet());
    }

    @Override
    public InternalCDOView openView(CDOBranch branch) {
        return this.openView(branch, 0L);
    }

    @Override
    public InternalCDOView openView(long timeStamp) {
        return this.openView((CDOBranch)this.getBranchManager().getMainBranch(), timeStamp);
    }

    @Override
    public InternalCDOView openView() {
        return this.openView(0L);
    }

    protected InternalCDOView createView(CDOBranch branch, long timeStamp) {
        return new CDOViewImpl(branch, timeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewDetached(InternalCDOView view) {
        view.getViewSet().remove(view);
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            if (!this.views.remove(view)) {
                return;
            }
        }
        if (this.isActive()) {
            try {
                LifecycleUtil.deactivate((Object)view);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        this.fireElementRemovedEvent(view);
    }

    public CDOView getView(int viewID) {
        this.checkActive();
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            if (view.getViewID() == viewID) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCDOView[] getViews() {
        this.checkActive();
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.views.toArray(new InternalCDOView[this.views.size()]);
        }
    }

    public CDOView[] getElements() {
        return this.getViews();
    }

    public boolean isEmpty() {
        this.checkActive();
        return this.views.isEmpty();
    }

    @Override
    public long refresh() {
        this.checkActive();
        if (this.options().isPassiveUpdateEnabled()) {
            return 0L;
        }
        return this.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long refresh(boolean enablePassiveUpdates) {
        Object object = this.invalidationLock;
        synchronized (object) {
            HashMap<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions;
            HashMap<CDOBranch, List<InternalCDOView>> views;
            block5: {
                views = new HashMap<CDOBranch, List<InternalCDOView>>();
                viewedRevisions = new HashMap<CDOBranch, Map<CDOID, InternalCDORevision>>();
                this.collectViewedRevisions(views, viewedRevisions);
                if (!viewedRevisions.isEmpty()) break block5;
                return 0L;
            }
            CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
            long lastUpdateTime = this.getLastUpdateTime();
            int initialChunkSize = this.options().getCollectionLoadingPolicy().getInitialChunkSize();
            CDOSessionProtocol.RefreshSessionResult result = sessionProtocol.refresh(lastUpdateTime, viewedRevisions, initialChunkSize, enablePassiveUpdates);
            this.registerPackageUnits(result.getPackageUnits());
            for (Map.Entry entry : views.entrySet()) {
                CDOBranch branch = (CDOBranch)entry.getKey();
                List branchViews = (List)entry.getValue();
                this.processRefreshSessionResult(result, branch, branchViews, viewedRevisions);
            }
            this.setLastUpdateTime(result.getLastUpdateTime());
            return result.getLastUpdateTime();
        }
    }

    @Override
    public void processRefreshSessionResult(CDOSessionProtocol.RefreshSessionResult result, CDOBranch branch, List<InternalCDOView> branchViews, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions) {
        Map<CDOID, InternalCDORevision> oldRevisions = viewedRevisions.get(branch);
        HashMap<CDOID, Pair> newRevisions = null;
        ArrayList<CDORevisionKey> changedObjects = new ArrayList<CDORevisionKey>();
        for (InternalCDORevision newRevision : result.getChangedObjects(branch)) {
            this.getRevisionManager().addRevision((CDORevision)newRevision);
            InternalCDORevision oldRevision = oldRevisions.get(newRevision.getID());
            InternalCDORevisionDelta delta = newRevision.compare((CDORevision)oldRevision);
            changedObjects.add((CDORevisionKey)delta);
            if (newRevisions == null) {
                newRevisions = new HashMap<CDOID, Pair>();
            }
            newRevisions.put(delta.getID(), new Pair((Object)oldRevision, (Object)newRevision));
        }
        List<CDOIDAndVersion> detachedObjects = result.getDetachedObjects(branch);
        for (CDOIDAndVersion detachedObject : detachedObjects) {
            this.getRevisionManager().reviseLatest(detachedObject.getID(), branch);
        }
        for (InternalCDOView view : branchViews) {
            view.invalidate(result.getLastUpdateTime(), changedObjects, detachedObjects, oldRevisions);
        }
    }

    private void collectViewedRevisions(Map<CDOBranch, List<InternalCDOView>> views, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions) {
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            if (view.getTimeStamp() == 0L) {
                boolean needNewMap;
                CDOBranch branch = view.getBranch();
                Map<CDOID, InternalCDORevision> revisions = viewedRevisions.get(branch);
                boolean bl = needNewMap = revisions == null;
                if (needNewMap) {
                    revisions = new HashMap<CDOID, InternalCDORevision>();
                }
                view.collectViewedRevisions(revisions);
                if (!revisions.isEmpty()) {
                    List<InternalCDOView> list = views.get(branch);
                    if (list == null) {
                        list = new ArrayList<InternalCDOView>();
                        views.put(branch, list);
                    }
                    list.add(view);
                    if (needNewMap) {
                        viewedRevisions.put(branch, revisions);
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastUpdateTime() {
        Object object = this.lastUpdateTimeLock;
        synchronized (object) {
            return this.lastUpdateTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
        Object object = this.lastUpdateTimeLock;
        synchronized (object) {
            if (this.lastUpdateTime < lastUpdateTime) {
                this.lastUpdateTime = lastUpdateTime;
            }
            this.lastUpdateTimeLock.notifyAll();
        }
    }

    @Override
    public void waitForUpdate(long updateTime) {
        this.waitForUpdate(updateTime, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean waitForUpdate(long updateTime, long timeoutMillis) {
        long end = timeoutMillis == -1L ? Long.MAX_VALUE : System.currentTimeMillis() + timeoutMillis;
        while (true) {
            Object object = this.lastUpdateTimeLock;
            synchronized (object) {
                if (this.lastUpdateTime >= updateTime) {
                    return true;
                }
                long now = System.currentTimeMillis();
                if (now >= end) {
                    return false;
                }
                try {
                    this.lastUpdateTimeLock.wait(end - now);
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        }
    }

    @Override
    public Object resolveElementProxy(CDORevision revision, EStructuralFeature feature, int accessIndex, int serverIndex) {
        CDOCollectionLoadingPolicy policy = this.options().getCollectionLoadingPolicy();
        return policy.resolveProxy(this, revision, feature, accessIndex, serverIndex);
    }

    @Override
    public void handleRepositoryTypeChanged(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        this.fireEvent((IEvent)new RepositoryTypeChangedEvent((INotifier)this, oldType, newType));
    }

    @Override
    public void handleRepositoryStateChanged(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        this.fireEvent((IEvent)new RepositoryStateChangedEvent((INotifier)this, oldState, newState));
    }

    @Override
    public void handleBranchNotification(InternalCDOBranch branch) {
        this.getBranchManager().handleBranchCreated(branch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCommitNotification(CDOCommitInfo commitInfo) {
        try {
            Object object = this.invalidationLock;
            synchronized (object) {
                this.registerPackageUnits(commitInfo.getNewPackageUnits());
                this.invalidate(commitInfo, null);
            }
        }
        catch (RuntimeException ex) {
            if (this.isActive()) {
                OM.LOG.error((Throwable)ex);
            }
            OM.LOG.info(Messages.getString("CDOSessionImpl.2"));
        }
    }

    private void registerPackageUnits(List<CDOPackageUnit> packageUnits) {
        InternalCDOPackageRegistry packageRegistry = this.getPackageRegistry();
        for (CDOPackageUnit newPackageUnit : packageUnits) {
            packageRegistry.putPackageUnit((InternalCDOPackageUnit)newPackageUnit);
        }
    }

    private Map<CDOID, InternalCDORevision> reviseRevisions(CDOCommitInfo commitInfo) {
        CDOID id;
        HashMap<CDOID, InternalCDORevision> oldRevisions = null;
        CDOBranch newBranch = commitInfo.getBranch();
        long timeStamp = commitInfo.getTimeStamp();
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        for (CDOIDAndVersion key : commitInfo.getNewObjects()) {
            if (!(key instanceof InternalCDORevision)) continue;
            InternalCDORevision newRevision = (InternalCDORevision)key;
            revisionManager.addRevision((CDORevision)newRevision);
        }
        for (CDOIDAndVersion key : commitInfo.getChangedObjects()) {
            CDORevisionDelta revisionDelta;
            InternalCDORevision oldRevision;
            if (key instanceof CDORevisionDelta && (oldRevision = revisionManager.getRevisionByVersion((revisionDelta = (CDORevisionDelta)key).getID(), (CDOBranchVersion)revisionDelta, -1, false)) != null) {
                CDOFeatureDeltaVisitorImpl visitor = new CDOFeatureDeltaVisitorImpl((CDORevision)oldRevision){
                    private List<Object> workList;
                    private final /* synthetic */ CDORevision val$oldRevision;
                    {
                        this.val$oldRevision = cDORevision;
                    }

                    public void visit(CDOAddFeatureDelta delta) {
                        this.workList.add(delta.getIndex(), delta.getValue());
                    }

                    public void visit(CDOClearFeatureDelta delta) {
                        this.workList.clear();
                    }

                    public void visit(CDOListFeatureDelta deltas) {
                        List list = (List)((InternalCDORevision)this.val$oldRevision).getValue(deltas.getFeature());
                        if (list != null) {
                            this.workList = new ArrayList<Object>(list);
                            super.visit(deltas);
                        }
                    }

                    public void visit(CDOMoveFeatureDelta delta) {
                        Object value = this.workList.get(delta.getOldPosition());
                        ((CDOMoveFeatureDeltaImpl)delta).setValue(value);
                        ECollections.move(this.workList, (int)delta.getNewPosition(), (int)delta.getOldPosition());
                    }

                    public void visit(CDORemoveFeatureDelta delta) {
                        Object oldValue = this.workList.remove(delta.getIndex());
                        ((CDOSingleValueFeatureDeltaImpl)delta).setValue(oldValue);
                    }
                };
                for (CDOFeatureDelta featureDelta : revisionDelta.getFeatureDeltas()) {
                    featureDelta.accept((CDOFeatureDeltaVisitor)visitor);
                }
            }
            id = key.getID();
            Pair<InternalCDORevision, InternalCDORevision> pair = this.createNewRevision((CDORevisionKey)key, commitInfo);
            if (pair != null) {
                InternalCDORevision newRevision = (InternalCDORevision)pair.getElement2();
                revisionManager.addRevision((CDORevision)newRevision);
                if (oldRevisions == null) {
                    oldRevisions = new HashMap<CDOID, InternalCDORevision>();
                }
                InternalCDORevision oldRevision2 = (InternalCDORevision)pair.getElement1();
                oldRevisions.put(id, oldRevision2);
                continue;
            }
            if (!ObjectUtil.equals((Object)key.getBranch(), (Object)newBranch)) continue;
            revisionManager.reviseVersion(id, (CDOBranchVersion)key, timeStamp);
        }
        for (CDOIDAndVersion key : commitInfo.getDetachedObjects()) {
            id = key.getID();
            int version = key.getVersion();
            if (version == 0) {
                revisionManager.reviseLatest(id, newBranch);
                continue;
            }
            CDOBranchVersion branchVersion = newBranch.getVersion(version);
            revisionManager.reviseVersion(id, branchVersion, timeStamp);
        }
        return oldRevisions;
    }

    private Pair<InternalCDORevision, InternalCDORevision> createNewRevision(CDORevisionKey potentialDelta, CDOCommitInfo commitInfo) {
        if (potentialDelta instanceof CDORevisionDelta) {
            CDORevisionDelta delta = (CDORevisionDelta)potentialDelta;
            CDOID id = delta.getID();
            InternalCDORevisionManager revisionManager = this.getRevisionManager();
            InternalCDORevision oldRevision = revisionManager.getRevisionByVersion(id, (CDOBranchVersion)potentialDelta, -1, false);
            if (oldRevision != null) {
                InternalCDORevision newRevision = oldRevision.copy();
                newRevision.adjustForCommit(commitInfo.getBranch(), commitInfo.getTimeStamp());
                delta.apply((CDORevision)newRevision);
                return new Pair((Object)oldRevision, (Object)newRevision);
            }
        }
        return null;
    }

    @Override
    public void invalidate(CDOCommitInfo commitInfo, InternalCDOTransaction sender) {
        Map<CDOID, InternalCDORevision> oldRevisions = this.reviseRevisions(commitInfo);
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            if (view != sender && ObjectUtil.equals((Object)view.getBranch(), (Object)commitInfo.getBranch())) {
                QueueRunner runner = this.getInvalidationRunner();
                runner.addWork((Object)new InvalidationRunnable(view, commitInfo, oldRevisions));
            }
            ++n2;
        }
        this.fireInvalidationEvent(sender, commitInfo);
        this.setLastUpdateTime(commitInfo.getTimeStamp());
    }

    @Override
    public Object getInvalidationLock() {
        return this.invalidationLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueRunner getInvalidationRunner() {
        Object object = this.invalidationRunnerLock;
        synchronized (object) {
            if (this.invalidationRunner == null) {
                this.invalidationRunner = this.createInvalidationRunner();
                this.invalidationRunner.activate();
            }
        }
        return this.invalidationRunner;
    }

    protected QueueRunner createInvalidationRunner() {
        return new QueueRunner(){

            protected String getThreadName() {
                return "InvalidationRunner";
            }

            public String toString() {
                return this.getThreadName();
            }
        };
    }

    public void fireInvalidationEvent(InternalCDOView excludedView, CDOCommitInfo commitInfo) {
        this.fireEvent(new InvalidationEvent(excludedView, commitInfo));
    }

    public String toString() {
        String name = this.repositoryInfo == null ? "?" : this.repositoryInfo.getName();
        return MessageFormat.format("CDOSession[{0}, {1}]", name, this.sessionID);
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initView(InternalCDOView view, ResourceSet resourceSet) {
        if (TRACER.isEnabled()) {
            Object[] objectArray = new Object[1];
            objectArray[0] = view.isReadOnly() ? (view.getTimeStamp() != 0L ? "historical" : "read-only") : "transactional";
            TRACER.format("Initializing new {0} view", objectArray);
        }
        InternalCDOViewSet viewSet = SessionUtil.prepareResourceSet(resourceSet);
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            view.setSession(this);
            view.setViewID(++this.lastViewID);
            this.views.add(view);
        }
        view.setViewSet(viewSet);
        viewSet.add(view);
        try {
            view.activate();
            this.fireElementAddedEvent(view);
        }
        catch (RuntimeException ex) {
            Set<InternalCDOView> set2 = this.views;
            synchronized (set2) {
                this.views.remove(view);
            }
            viewSet.remove(view);
            throw ex;
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.getConfiguration().activateSession(this);
        this.checkState(this.sessionProtocol, "sessionProtocol");
        this.checkState(this.remoteSessionManager, "remoteSessionManager");
        if (this.exceptionHandler != null) {
            this.sessionProtocol = new DelegatingSessionProtocol(this.sessionProtocol);
        }
        EventUtil.addListener((Object)this.sessionProtocol, (IListener)this.sessionProtocolListener);
    }

    protected void doDeactivate() throws Exception {
        InternalCDOView[] internalCDOViewArray = this.views.toArray(new InternalCDOView[this.views.size()]);
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            try {
                view.close();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ++n2;
        }
        this.views.clear();
        if (this.invalidationRunner != null) {
            LifecycleUtil.deactivate((Object)this.invalidationRunner, (OMLogger.Level)OMLogger.Level.WARN);
            this.invalidationRunner = null;
        }
        EventUtil.removeListener((Object)this.sessionProtocol, (IListener)this.sessionProtocolListener);
        this.getConfiguration().deactivateSession(this);
        super.doDeactivate();
    }

    public static boolean isInvalidationRunnerActive() {
        return invalidationRunnerActive.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DelegatingSessionProtocol
    extends Lifecycle
    implements CDOSessionProtocol {
        private CDOSessionProtocol delegate;
        @ReflectUtil.ExcludeFromDump
        private IListener delegateListener = new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                DelegatingSessionProtocol.this.deactivate();
            }
        };

        public DelegatingSessionProtocol(CDOSessionProtocol delegate) {
            this.delegate = delegate;
            this.activate();
        }

        public CDOSessionProtocol getDelegate() {
            return this.delegate;
        }

        public CDOSession getSession() {
            return (CDOSession)this.delegate.getSession();
        }

        @Override
        public boolean cancelQuery(int queryId) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.cancelQuery(queryId);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void changeSubscription(int viewID, List<CDOID> cdoIDs, boolean subscribeMode, boolean clear) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.changeSubscription(viewID, cdoIDs, subscribeMode, clear);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void openView(int viewID, CDOBranchPoint branchPoint, boolean readOnly) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.openView(viewID, branchPoint, readOnly);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public boolean[] changeView(int viewID, CDOBranchPoint branchPoint, List<InternalCDOObject> invalidObjects) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.changeView(viewID, branchPoint, invalidObjects);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void closeView(int viewID) {
            int attempt = 0;
            while (true) {
                try {
                    if (this.delegate != null) {
                        this.delegate.closeView(viewID);
                    }
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.CommitTransactionResult commitTransaction(int transactionID, String comment, boolean releaseLocks, CDOIDProvider idProvider, CDOCommitData commitData, OMMonitor monitor) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.commitTransaction(transactionID, comment, releaseLocks, idProvider, commitData, monitor);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.CommitTransactionResult commitDelegation(CDOBranch branch, String userID, String comment, CDOCommitData commitData, OMMonitor monitor) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.commitDelegation(branch, userID, comment, commitData, monitor);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.CommitTransactionResult commitXATransactionCancel(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.commitXATransactionCancel(xaContext, monitor);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase1(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.commitXATransactionPhase1(xaContext, monitor);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase2(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.commitXATransactionPhase2(xaContext, monitor);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase3(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.commitXATransactionPhase3(xaContext, monitor);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.RepositoryTimeResult getRepositoryTime() {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.getRepositoryTime();
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public boolean isObjectLocked(CDOView view, CDOObject object, IRWLockManager.LockType lockType, boolean byOthers) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.isObjectLocked(view, object, lockType, byOthers);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadPackages(packageUnit);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        public int createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.createBranch(branchID, branchInfo);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadBranch(branchID);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadSubBranches(branchID);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadBranches(startID, endID, branchHandler);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.loadCommitInfos(branch, startTime, endTime, handler);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        public CDOCommitData loadCommitData(long timeStamp) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadCommitData(timeStamp);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public Object loadChunk(InternalCDORevision revision, EStructuralFeature feature, int accessIndex, int fetchIndex, int fromIndex, int toIndex) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadChunk(revision, feature, accessIndex, fetchIndex, fromIndex, toIndex);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        public List<InternalCDORevision> loadRevisions(List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadRevisions(infos, branchPoint, referenceChunk, prefetchDepth);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        public InternalCDORevision loadRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int referenceChunk) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadRevisionByVersion(id, branchVersion, referenceChunk);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.RefreshSessionResult lockObjects(long lastUpdateTime, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions, int viewID, IRWLockManager.LockType lockType, long timeout) throws InterruptedException {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.lockObjects(lastUpdateTime, viewedRevisions, viewID, lockType, timeout);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void query(int viewID, AbstractQueryIterator<?> queryResult) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.query(viewID, queryResult);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void disablePassiveUpdate() {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.disablePassiveUpdate();
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode mode) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.setPassiveUpdateMode(mode);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOSessionProtocol.RefreshSessionResult refresh(long lastUpdateTime, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions, int initialChunkSize, boolean enablePassiveUpdates) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.refresh(lastUpdateTime, viewedRevisions, initialChunkSize, enablePassiveUpdates);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void unlockObjects(CDOView view, Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.unlockObjects(view, objects, lockType);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public List<CDORemoteSession> getRemoteSessions(InternalCDORemoteSessionManager manager, boolean subscribe) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.getRemoteSessions(manager, subscribe);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public Set<Integer> sendRemoteMessage(CDORemoteSessionMessage message, List<CDORemoteSession> recipients) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.sendRemoteMessage(message, recipients);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public boolean unsubscribeRemoteSessions() {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.unsubscribeRemoteSessions();
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void replicateRepository(CDOReplicationContext context) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.replicateRepository(context);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public void replicateRepositoryRaw(CDORawReplicationContext context) {
            int attempt = 0;
            while (true) {
                try {
                    this.delegate.replicateRepositoryRaw(context);
                    return;
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public CDOChangeSetData[] loadChangeSets(CDOBranchPointRange ... ranges) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadChangeSets(ranges);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        @Override
        public Set<CDOID> loadMergeData(CDORevisionAvailabilityInfo ancestorInfo, CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo) {
            int attempt = 0;
            while (true) {
                try {
                    return this.delegate.loadMergeData(ancestorInfo, targetInfo, sourceInfo);
                }
                catch (Exception ex) {
                    this.handleException(++attempt, ex);
                    continue;
                }
                break;
            }
        }

        protected void doActivate() throws Exception {
            super.doActivate();
            EventUtil.addListener((Object)this.delegate, (IListener)this.delegateListener);
        }

        protected void doDeactivate() throws Exception {
            EventUtil.removeListener((Object)this.delegate, (IListener)this.delegateListener);
            LifecycleUtil.deactivate((Object)this.delegate);
            this.delegate = null;
            super.doDeactivate();
        }

        private void handleException(int attempt, Exception exception) {
            try {
                CDOSessionImpl.this.getExceptionHandler().handleException(CDOSessionImpl.this, attempt, exception);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvalidationEvent
    extends Event
    implements CDOSessionInvalidationEvent {
        private static final long serialVersionUID = 1L;
        private InternalCDOView view;
        private CDOCommitInfo commitInfo;

        public InvalidationEvent(InternalCDOView view, CDOCommitInfo commitInfo) {
            super((INotifier)CDOSessionImpl.this);
            this.view = view;
            this.commitInfo = commitInfo;
        }

        @Override
        public CDOSession getSource() {
            return (CDOSession)super.getSource();
        }

        public CDOCommitInfoManager getCommitInfoManager() {
            return this.commitInfo.getCommitInfoManager();
        }

        @Override
        public InternalCDOView getView() {
            return this.view;
        }

        @Override
        public boolean isRemote() {
            return this.view == null;
        }

        public CDOBranch getBranch() {
            return this.commitInfo.getBranch();
        }

        public long getTimeStamp() {
            return this.commitInfo.getTimeStamp();
        }

        public String getUserID() {
            return this.commitInfo.getUserID();
        }

        public String getComment() {
            return this.commitInfo.getComment();
        }

        public boolean isEmpty() {
            return false;
        }

        public List<CDOPackageUnit> getNewPackageUnits() {
            return this.commitInfo.getNewPackageUnits();
        }

        public List<CDOIDAndVersion> getNewObjects() {
            return this.commitInfo.getNewObjects();
        }

        public List<CDORevisionKey> getChangedObjects() {
            return this.commitInfo.getChangedObjects();
        }

        public List<CDOIDAndVersion> getDetachedObjects() {
            return this.commitInfo.getDetachedObjects();
        }

        public int compareTo(CDOBranchPoint o) {
            return this.commitInfo.compareTo((Object)o);
        }

        public String toString() {
            return "CDOSessionInvalidationEvent[" + this.commitInfo + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InvalidationRunnable
    implements Runnable {
        private InternalCDOView view;
        private CDOCommitInfo commitInfo;
        private Map<CDOID, InternalCDORevision> oldRevisions;

        private InvalidationRunnable(InternalCDOView view, CDOCommitInfo commitInfo, Map<CDOID, InternalCDORevision> oldRevisions) {
            this.view = view;
            this.commitInfo = commitInfo;
            this.oldRevisions = oldRevisions;
        }

        @Override
        public void run() {
            try {
                try {
                    invalidationRunnerActive.set(true);
                    long lastUpdateTime = this.commitInfo.getTimeStamp();
                    List allChangedObjects = this.commitInfo.getChangedObjects();
                    List allDetachedObjects = this.commitInfo.getDetachedObjects();
                    this.view.invalidate(lastUpdateTime, allChangedObjects, allDetachedObjects, this.oldRevisions);
                }
                catch (RuntimeException ex) {
                    if (this.view.isActive()) {
                        OM.LOG.error((Throwable)ex);
                    } else {
                        OM.LOG.info(Messages.getString("CDOSessionImpl.1"));
                    }
                    invalidationRunnerActive.set(false);
                }
            }
            finally {
                invalidationRunnerActive.set(false);
            }
        }
    }

    protected class OptionsImpl
    extends Notifier
    implements CDOSession.Options {
        private boolean generatedPackageEmulationEnabled;
        private boolean passiveUpdateEnabled = true;
        private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode = CDOCommonSession.Options.PassiveUpdateMode.INVALIDATIONS;
        private CDOCollectionLoadingPolicy collectionLoadingPolicy = CDOCollectionLoadingPolicy.DEFAULT;

        public IOptionsContainer getContainer() {
            return CDOSessionImpl.this;
        }

        public boolean isGeneratedPackageEmulationEnabled() {
            return this.generatedPackageEmulationEnabled;
        }

        public synchronized void setGeneratedPackageEmulationEnabled(boolean generatedPackageEmulationEnabled) {
            this.generatedPackageEmulationEnabled = generatedPackageEmulationEnabled;
            if (this.generatedPackageEmulationEnabled != generatedPackageEmulationEnabled) {
                this.generatedPackageEmulationEnabled = generatedPackageEmulationEnabled;
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new GeneratedPackageEmulationEventImpl(), listeners);
                }
            }
        }

        public boolean isPassiveUpdateEnabled() {
            return this.passiveUpdateEnabled;
        }

        public synchronized void setPassiveUpdateEnabled(boolean passiveUpdateEnabled) {
            if (this.passiveUpdateEnabled != passiveUpdateEnabled) {
                this.passiveUpdateEnabled = passiveUpdateEnabled;
                if (passiveUpdateEnabled) {
                    CDOSessionImpl.this.refresh(true);
                } else {
                    CDOSessionImpl.this.getSessionProtocol().disablePassiveUpdate();
                }
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new PassiveUpdateEventImpl(!passiveUpdateEnabled, passiveUpdateEnabled, this.passiveUpdateMode, this.passiveUpdateMode), listeners);
                }
            }
        }

        public CDOCommonSession.Options.PassiveUpdateMode getPassiveUpdateMode() {
            return this.passiveUpdateMode;
        }

        public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode) {
            CDOSessionImpl.this.checkArg(passiveUpdateMode, "passiveUpdateMode");
            if (this.passiveUpdateMode != passiveUpdateMode) {
                CDOCommonSession.Options.PassiveUpdateMode oldMode = this.passiveUpdateMode;
                this.passiveUpdateMode = passiveUpdateMode;
                CDOSessionImpl.this.getSessionProtocol().setPassiveUpdateMode(passiveUpdateMode);
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new PassiveUpdateEventImpl(this.passiveUpdateEnabled, this.passiveUpdateEnabled, oldMode, passiveUpdateMode), listeners);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOCollectionLoadingPolicy getCollectionLoadingPolicy() {
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                return this.collectionLoadingPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCollectionLoadingPolicy(CDOCollectionLoadingPolicy policy) {
            if (policy == null) {
                policy = CDOCollectionLoadingPolicy.DEFAULT;
            }
            IListener[] listeners = this.getListeners();
            CollectionLoadingPolicyEventImpl event = null;
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                if (this.collectionLoadingPolicy != policy) {
                    this.collectionLoadingPolicy = policy;
                    if (listeners != null) {
                        event = new CollectionLoadingPolicyEventImpl();
                    }
                }
            }
            if (event != null) {
                this.fireEvent((IEvent)event, listeners);
            }
        }

        private final class CollectionLoadingPolicyEventImpl
        extends OptionsEvent
        implements CDOSession.Options.CollectionLoadingPolicyEvent {
            private static final long serialVersionUID = 1L;

            public CollectionLoadingPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class GeneratedPackageEmulationEventImpl
        extends OptionsEvent
        implements CDOSession.Options.GeneratedPackageEmulationEvent {
            private static final long serialVersionUID = 1L;

            public GeneratedPackageEmulationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class PassiveUpdateEventImpl
        extends OptionsEvent
        implements CDOCommonSession.Options.PassiveUpdateEvent {
            private static final long serialVersionUID = 1L;
            private boolean oldEnabled;
            private boolean newEnabled;
            private CDOCommonSession.Options.PassiveUpdateMode oldMode;
            private CDOCommonSession.Options.PassiveUpdateMode newMode;

            public PassiveUpdateEventImpl(boolean oldEnabled, boolean newEnabled, CDOCommonSession.Options.PassiveUpdateMode oldMode, CDOCommonSession.Options.PassiveUpdateMode newMode) {
                super((IOptions)OptionsImpl.this);
                this.oldEnabled = oldEnabled;
                this.newEnabled = newEnabled;
                this.oldMode = oldMode;
                this.newMode = newMode;
            }

            public boolean getOldEnabled() {
                return this.oldEnabled;
            }

            public boolean getNewEnabled() {
                return this.newEnabled;
            }

            public CDOCommonSession.Options.PassiveUpdateMode getOldMode() {
                return this.oldMode;
            }

            public CDOCommonSession.Options.PassiveUpdateMode getNewMode() {
                return this.newMode;
            }
        }
    }
}

