/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionMerger;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.transaction.CDOConflictResolver2;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.net4j.util.collection.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectConflictResolver2
implements CDOConflictResolver2 {
    private CDOTransaction transaction;

    @Override
    public CDOTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void setTransaction(CDOTransaction transaction) {
        if (this.transaction != transaction) {
            if (this.transaction != null) {
                this.unhookTransaction(this.transaction);
            }
            this.transaction = transaction;
            if (this.transaction != null) {
                this.hookTransaction(this.transaction);
            }
        }
    }

    @Override
    public void resolveConflicts(Set<CDOObject> conflicts) {
    }

    @Override
    public void resolveConflicts(Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts, List<CDORevisionDelta> deltas) {
        Map<CDOID, CDORevisionDelta> localDeltas = this.transaction.getRevisionDeltas();
        for (Map.Entry<CDOObject, Pair<CDORevision, CDORevisionDelta>> entry : conflicts.entrySet()) {
            CDOObject conflict = entry.getKey();
            CDORevision oldRevision = (CDORevision)entry.getValue().getElement1();
            CDORevisionDelta remoteDelta = (CDORevisionDelta)entry.getValue().getElement2();
            CDORevisionDelta localDelta = localDeltas.get(conflict.cdoID());
            this.resolveConflict(conflict, oldRevision, localDelta, remoteDelta, deltas);
        }
    }

    protected abstract void resolveConflict(CDOObject var1, CDORevision var2, CDORevisionDelta var3, CDORevisionDelta var4, List<CDORevisionDelta> var5);

    protected void hookTransaction(CDOTransaction transaction) {
    }

    protected void unhookTransaction(CDOTransaction transaction) {
    }

    public static void rollbackObject(CDOObject object) {
        CDOStateMachine.INSTANCE.rollback((InternalCDOObject)object);
    }

    public static void readObject(CDOObject object) {
        CDOStateMachine.INSTANCE.read((InternalCDOObject)object);
    }

    public static void changeObject(CDOObject object, CDORevisionDelta revisionDelta) {
        AbstractObjectConflictResolver2.readObject(object);
        InternalCDORevision revision = (InternalCDORevision)object.cdoRevision().copy();
        ((InternalCDORevisionDelta)revisionDelta).setVersion(revision.getVersion());
        CDORevisionMerger merger = new CDORevisionMerger();
        merger.merge(revision, revisionDelta);
        ((InternalCDOObject)object).cdoInternalSetRevision((CDORevision)revision);
        ((InternalCDOObject)object).cdoInternalSetState(CDOState.DIRTY);
        ((InternalCDOObject)object).cdoInternalPostLoad();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MergeLocalChangesPerFeature
    extends ThreeWayMerge {
        @Override
        protected void resolveConflict(CDOObject conflict, CDORevisionDelta localDelta, List<CDORevisionDelta> remoteDeltas) {
            if (this.hasFeatureConflicts(localDelta, remoteDeltas)) {
                throw new CDOException(Messages.getString("AbstractObjectConflictResolver.0"));
            }
            MergeLocalChangesPerFeature.rollbackObject(conflict);
            for (CDORevisionDelta remoteDelta : remoteDeltas) {
                for (CDOFeatureDelta remoteFeatureDelta : remoteDelta.getFeatureDeltas()) {
                    ((InternalCDORevisionDelta)localDelta).addFeatureDelta(remoteFeatureDelta);
                }
            }
            MergeLocalChangesPerFeature.changeObject(conflict, localDelta);
        }

        protected boolean hasFeatureConflicts(CDORevisionDelta localDelta, List<CDORevisionDelta> remoteDeltas) {
            HashSet<EStructuralFeature> features = new HashSet<EStructuralFeature>();
            for (CDOFeatureDelta localFeatureDelta : localDelta.getFeatureDeltas()) {
                features.add(localFeatureDelta.getFeature());
            }
            for (CDORevisionDelta remoteDelta : remoteDeltas) {
                for (CDOFeatureDelta remoteFeatureDelta : remoteDelta.getFeatureDeltas()) {
                    EStructuralFeature feature = remoteFeatureDelta.getFeature();
                    if (!features.contains(feature)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TakeRemoteChangesThenApplyLocalChanges
    extends AbstractObjectConflictResolver2 {
        @Override
        protected void resolveConflict(CDOObject conflict, CDORevision oldRevision, CDORevisionDelta localDelta, CDORevisionDelta remoteDelta, List<CDORevisionDelta> deltas) {
            TakeRemoteChangesThenApplyLocalChanges.rollbackObject(conflict);
            TakeRemoteChangesThenApplyLocalChanges.changeObject(conflict, localDelta);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ThreeWayMerge
    extends AbstractObjectConflictResolver2 {
        @Override
        protected void resolveConflict(CDOObject conflict, CDORevision oldRevision, CDORevisionDelta localDelta, CDORevisionDelta remoteDelta, List<CDORevisionDelta> deltas) {
            this.resolveConflict(conflict, localDelta, Collections.singletonList(remoteDelta));
        }

        protected abstract void resolveConflict(CDOObject var1, CDORevisionDelta var2, List<CDORevisionDelta> var3);
    }
}

