/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDeltaUtil;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.internal.cdo.transaction.CDOUserSavepointImpl;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOUserSavepoint;
import org.eclipse.net4j.util.collection.MultiMap;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOSavepointImpl
extends CDOUserSavepointImpl
implements InternalCDOSavepoint {
    private Map<CDOID, CDORevision> baseNewObjects = new HashMap<CDOID, CDORevision>();
    private Map<CDOID, CDOObject> newObjects = new HashMap<CDOID, CDOObject>();
    private Map<CDOID, CDOObject> dirtyObjects = new HashMap<CDOID, CDOObject>();
    private ConcurrentMap<CDOID, CDORevisionDelta> revisionDeltas = new ConcurrentHashMap<CDOID, CDORevisionDelta>();
    private Map<CDOID, CDOObject> detachedObjects = new HashMap<CDOID, CDOObject>(){
        private static final long serialVersionUID = 1L;

        @Override
        public CDOObject put(CDOID key, CDOObject object) {
            CDOSavepointImpl.this.sharedDetachedObjects.add(key);
            CDOSavepointImpl.this.dirtyObjects.remove(key);
            CDOSavepointImpl.this.baseNewObjects.remove(key);
            CDOSavepointImpl.this.newObjects.remove(key);
            CDOSavepointImpl.this.revisionDeltas.remove(key);
            return super.put(key, object);
        }
    };
    private Map<CDOID, CDOObject> reattachedObjects = new HashMap<CDOID, CDOObject>();
    private Set<CDOID> sharedDetachedObjects;
    private boolean wasDirty;

    public CDOSavepointImpl(InternalCDOTransaction transaction, InternalCDOSavepoint lastSavepoint) {
        super(transaction, lastSavepoint);
        this.wasDirty = transaction.isDirty();
        this.sharedDetachedObjects = lastSavepoint == null ? new HashSet<CDOID>() : lastSavepoint.getSharedDetachedObjects();
    }

    @Override
    public InternalCDOTransaction getTransaction() {
        return (InternalCDOTransaction)super.getTransaction();
    }

    @Override
    public InternalCDOSavepoint getFirstSavePoint() {
        return (InternalCDOSavepoint)super.getFirstSavePoint();
    }

    @Override
    public InternalCDOSavepoint getPreviousSavepoint() {
        return (InternalCDOSavepoint)super.getPreviousSavepoint();
    }

    @Override
    public InternalCDOSavepoint getNextSavepoint() {
        return (InternalCDOSavepoint)super.getNextSavepoint();
    }

    @Override
    public void setPreviousSavepoint(InternalCDOUserSavepoint previousSavepoint) {
        super.setPreviousSavepoint(previousSavepoint);
    }

    @Override
    public void setNextSavepoint(InternalCDOUserSavepoint nextSavepoint) {
        super.setNextSavepoint(nextSavepoint);
    }

    @Override
    public void clear() {
        this.newObjects.clear();
        this.dirtyObjects.clear();
        this.revisionDeltas.clear();
        this.baseNewObjects.clear();
        this.detachedObjects.clear();
        this.reattachedObjects.clear();
    }

    @Override
    public boolean wasDirty() {
        return this.wasDirty;
    }

    @Override
    public Map<CDOID, CDOObject> getNewObjects() {
        return this.newObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getDetachedObjects() {
        return this.detachedObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getReattachedObjects() {
        return this.reattachedObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getDirtyObjects() {
        return this.dirtyObjects;
    }

    @Override
    public Set<CDOID> getSharedDetachedObjects() {
        return this.sharedDetachedObjects;
    }

    @Override
    public ConcurrentMap<CDOID, CDORevisionDelta> getRevisionDeltas() {
        return this.revisionDeltas;
    }

    @Override
    public Map<CDOID, CDORevision> getBaseNewObjects() {
        return this.baseNewObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getAllDirtyObjects() {
        if (this.getPreviousSavepoint() == null) {
            return Collections.unmodifiableMap(this.getDirtyObjects());
        }
        MultiMap.ListBased dirtyObjects = new MultiMap.ListBased();
        InternalCDOSavepoint savepoint = this;
        while (savepoint != null) {
            dirtyObjects.getDelegates().add(savepoint.getDirtyObjects());
            savepoint = savepoint.getPreviousSavepoint();
        }
        return dirtyObjects;
    }

    @Override
    public Map<CDOID, CDOObject> getAllNewObjects() {
        if (this.getPreviousSavepoint() == null) {
            return Collections.unmodifiableMap(this.getNewObjects());
        }
        if (this.getSharedDetachedObjects().size() == 0) {
            MultiMap.ListBased newObjects = new MultiMap.ListBased();
            InternalCDOSavepoint savepoint = this;
            while (savepoint != null) {
                newObjects.getDelegates().add(savepoint.getNewObjects());
                savepoint = savepoint.getPreviousSavepoint();
            }
            return newObjects;
        }
        HashMap<CDOID, CDOObject> newObjects = new HashMap<CDOID, CDOObject>();
        InternalCDOSavepoint savepoint = this;
        while (savepoint != null) {
            for (Map.Entry<CDOID, CDOObject> entry : savepoint.getNewObjects().entrySet()) {
                if (this.getSharedDetachedObjects().contains(entry.getKey())) continue;
                newObjects.put(entry.getKey(), entry.getValue());
            }
            savepoint = savepoint.getPreviousSavepoint();
        }
        return newObjects;
    }

    @Override
    public Map<CDOID, CDORevision> getAllBaseNewObjects() {
        if (this.getPreviousSavepoint() == null) {
            return Collections.unmodifiableMap(this.getBaseNewObjects());
        }
        MultiMap.ListBased newObjects = new MultiMap.ListBased();
        InternalCDOSavepoint savepoint = this;
        while (savepoint != null) {
            newObjects.getDelegates().add(savepoint.getBaseNewObjects());
            savepoint = savepoint.getPreviousSavepoint();
        }
        return newObjects;
    }

    @Override
    public Map<CDOID, CDORevisionDelta> getAllRevisionDeltas() {
        if (this.getPreviousSavepoint() == null) {
            return Collections.unmodifiableMap(this.getRevisionDeltas());
        }
        HashMap<CDOID, CDORevisionDelta> revisionDeltas = new HashMap<CDOID, CDORevisionDelta>();
        InternalCDOSavepoint savepoint = this.getFirstSavePoint();
        while (savepoint != null) {
            for (Map.Entry entry : savepoint.getRevisionDeltas().entrySet()) {
                if (((CDOID)entry.getKey()).isTemporary() || this.getSharedDetachedObjects().contains(entry.getKey())) continue;
                CDORevisionDeltaImpl revisionDelta = (CDORevisionDeltaImpl)revisionDeltas.get(entry.getKey());
                if (revisionDelta == null) {
                    revisionDeltas.put((CDOID)entry.getKey(), CDORevisionDeltaUtil.copy((CDORevisionDelta)((CDORevisionDelta)entry.getValue())));
                    continue;
                }
                for (CDOFeatureDelta delta : ((CDORevisionDelta)entry.getValue()).getFeatureDeltas()) {
                    revisionDelta.addFeatureDelta(((InternalCDOFeatureDelta)delta).copy());
                }
            }
            savepoint = savepoint.getNextSavepoint();
        }
        return Collections.unmodifiableMap(revisionDeltas);
    }

    @Override
    public Map<CDOID, CDOObject> getAllDetachedObjects() {
        if (this.getPreviousSavepoint() == null && this.reattachedObjects.isEmpty()) {
            return Collections.unmodifiableMap(this.getDetachedObjects());
        }
        HashMap<CDOID, CDOObject> detachedObjects = new HashMap<CDOID, CDOObject>();
        HashSet<CDOID> reattachedObjectIDs = new HashSet<CDOID>();
        InternalCDOSavepoint savepoint = this;
        while (savepoint != null) {
            reattachedObjectIDs.addAll(savepoint.getReattachedObjects().keySet());
            for (Map.Entry<CDOID, CDOObject> entry : savepoint.getDetachedObjects().entrySet()) {
                if (entry.getKey().isTemporary() || reattachedObjectIDs.contains(entry.getKey())) continue;
                detachedObjects.put(entry.getKey(), entry.getValue());
            }
            savepoint = savepoint.getPreviousSavepoint();
        }
        return detachedObjects;
    }

    @Override
    public void recalculateSharedDetachedObjects() {
        this.sharedDetachedObjects.clear();
        InternalCDOSavepoint savepoint = this;
        while (savepoint != null) {
            for (CDOID id : savepoint.getDetachedObjects().keySet()) {
                this.sharedDetachedObjects.add(id);
            }
            savepoint = savepoint.getPreviousSavepoint();
        }
    }

    @Override
    public void rollback() {
        InternalCDOTransaction transaction = this.getTransaction();
        LifecycleUtil.checkActive((Object)transaction);
        transaction.getTransactionStrategy().rollback(transaction, this);
    }
}

