/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDeltaUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourceFactory;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceNodeImpl;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetDataImpl;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetImpl;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitDataImpl;
import org.eclipse.emf.cdo.internal.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.internal.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOSavepoint;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransactionStartedEvent;
import org.eclipse.emf.cdo.transaction.CDOUserSavepoint;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.LegacyModeNotEnabledException;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.CDOObjectMerger;
import org.eclipse.emf.internal.cdo.CDOObjectWrapper;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.revision.CDOListWithElementProxiesImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOConflictResolver2;
import org.eclipse.emf.internal.cdo.transaction.CDOSavepointImpl;
import org.eclipse.emf.internal.cdo.util.CompletePackageClosure;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOUserSavepoint;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.FastList;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.OptionsEvent;
import org.eclipse.net4j.util.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOTransactionImpl
extends CDOViewImpl
implements InternalCDOTransaction {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSACTION, CDOTransactionImpl.class);
    private FastList<CDOTransactionHandler> transactionHandlers = new FastList<CDOTransactionHandler>(){

        protected CDOTransactionHandler[] newArray(int length) {
            return new CDOTransactionHandler[length];
        }
    };
    private InternalCDOSavepoint lastSavepoint;
    private InternalCDOSavepoint firstSavepoint = this.lastSavepoint = this.createSavepoint(null);
    private boolean dirty;
    private int conflict;
    private CDOTransactionStrategy transactionStrategy;
    private AtomicInteger lastTemporaryID = new AtomicInteger();
    private long lastCommitTime = 0L;
    private String commitComment;
    private Map<InternalCDOObject, CDORevisionKey> formerRevisionKeys = new HashMap<InternalCDOObject, CDORevisionKey>();
    private final ThreadLocal<Boolean> providingCDOID = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public CDOTransactionImpl(CDOBranch branch) {
        super(branch, 0L);
    }

    @Override
    public OptionsImpl options() {
        return (OptionsImpl)super.options();
    }

    @Override
    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean setBranchPoint(CDOBranchPoint branchPoint) {
        if (branchPoint.getTimeStamp() != 0L) {
            throw new IllegalArgumentException("Changing the target time is not supported by transactions");
        }
        if (this.isDirty() && !this.getBranch().equals(branchPoint.getBranch())) {
            throw new IllegalStateException("Changing the target branch is impossible while transaction is dirty");
        }
        return super.setBranchPoint(branchPoint);
    }

    @Override
    public void addTransactionHandler(CDOTransactionHandler handler) {
        this.transactionHandlers.add((Object)handler);
    }

    @Override
    public void removeTransactionHandler(CDOTransactionHandler handler) {
        this.transactionHandlers.remove((Object)handler);
    }

    @Override
    public CDOTransactionHandler[] getTransactionHandlers() {
        return (CDOTransactionHandler[])this.transactionHandlers.get();
    }

    @Override
    public boolean isDirty() {
        if (this.isClosed()) {
            return false;
        }
        return this.dirty;
    }

    @Override
    public boolean hasConflict() {
        this.checkActive();
        return this.conflict != 0;
    }

    @Override
    public void setConflict(InternalCDOObject object) {
        ConflictEvent event = new ConflictEvent(object, this.conflict == 0);
        ++this.conflict;
        IListener[] listeners = this.getListeners();
        if (listeners != null) {
            this.fireEvent(event, listeners);
        }
    }

    @Override
    public Set<CDOObject> getConflicts() {
        HashSet<CDOObject> conflicts = new HashSet<CDOObject>();
        for (CDOObject object : this.getDirtyObjects().values()) {
            if (!object.cdoConflict()) continue;
            conflicts.add(object);
        }
        for (CDOObject object : this.getDetachedObjects().values()) {
            if (!object.cdoConflict()) continue;
            conflicts.add(object);
        }
        return conflicts;
    }

    @Override
    public void resolveConflicts(CDOConflictResolver ... resolvers) {
        Set<CDOObject> conflicts = this.getConflicts();
        this.handleConflicts(conflicts, resolvers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOChangeSetData merge(CDOBranchPoint source, CDOMerger merger) {
        InternalCDOSession session = this.getSession();
        Object object = session.getInvalidationLock();
        synchronized (object) {
            CDOChangeSetData result;
            CDORevisionAvailabilityInfo sourceInfo;
            CDORevisionAvailabilityInfo targetInfo;
            CDORevisionAvailabilityInfo ancestorInfo;
            CDOBranch sourceBranch;
            block7: {
                if (this.isDirty()) {
                    throw new IllegalStateException("Merging into dirty transactions not yet supported");
                }
                long now = this.getLastUpdateTime();
                CDOBranchPoint target = this.getBranch().getPoint(now);
                sourceBranch = source.getBranch();
                if (source.getTimeStamp() == 0L) {
                    source = sourceBranch.getPoint(now);
                }
                if (CDOBranchUtil.isContainedBy((CDOBranchPoint)source, (CDOBranchPoint)target)) {
                    throw new IllegalArgumentException("Source is already contained in " + target);
                }
                CDOBranchPoint ancestor = CDOBranchUtil.getAncestor((CDOBranchPoint)target, (CDOBranchPoint)source);
                ancestorInfo = this.createRevisionAvailabilityInfo(ancestor);
                targetInfo = this.createRevisionAvailabilityInfo(target);
                sourceInfo = this.createRevisionAvailabilityInfo(source);
                CDOSessionProtocol sessionProtocol = session.getSessionProtocol();
                Set<CDOID> ids = sessionProtocol.loadMergeData(ancestorInfo, targetInfo, sourceInfo);
                this.cacheRevisions(ancestorInfo);
                this.cacheRevisions(targetInfo);
                this.cacheRevisions(sourceInfo);
                CDOChangeSet targetChanges = this.createChangeSet(ids, ancestorInfo, targetInfo);
                CDOChangeSet sourceChanges = this.createChangeSet(ids, ancestorInfo, sourceInfo);
                result = merger.merge(targetChanges, sourceChanges);
                if (result != null) break block7;
                return null;
            }
            sourceBranch.isLocal();
            return this.applyChangeSetData(result, ancestorInfo, targetInfo, sourceInfo);
        }
    }

    private CDORevisionAvailabilityInfo createRevisionAvailabilityInfo(CDOBranchPoint branchPoint) {
        CDORevisionAvailabilityInfo info = new CDORevisionAvailabilityInfo(branchPoint);
        InternalCDORevisionManager revisionManager = this.getSession().getRevisionManager();
        InternalCDORevisionCache cache = revisionManager.getCache();
        List revisions = cache.getRevisions(branchPoint);
        for (CDORevision revision : revisions) {
            if (revision instanceof PointerCDORevision) {
                PointerCDORevision pointer = (PointerCDORevision)revision;
                CDOBranchVersion target = pointer.getTarget();
                if (target != null) {
                    revision = cache.getRevisionByVersion(pointer.getID(), target);
                }
            } else if (revision instanceof DetachedCDORevision) {
                revision = null;
            }
            if (revision == null) continue;
            info.addRevision((CDORevisionKey)revision);
        }
        return info;
    }

    private void cacheRevisions(CDORevisionAvailabilityInfo info) {
        InternalCDORevisionManager revisionManager = this.getSession().getRevisionManager();
        CDOBranch branch = info.getBranchPoint().getBranch();
        for (CDORevisionKey key : info.getAvailableRevisions().values()) {
            CDORevision revision = (CDORevision)key;
            revisionManager.addRevision(revision);
            if (ObjectUtil.equals((Object)revision.getBranch(), (Object)branch)) continue;
            CDOID id = revision.getID();
            CDORevision firstRevision = revisionManager.getCache().getRevisionByVersion(id, branch.getVersion(1));
            if (firstRevision == null) continue;
            long revised = firstRevision.getTimeStamp() - 1L;
            CDOBranchVersion target = CDOBranchUtil.copyBranchVersion((CDOBranchVersion)revision);
            PointerCDORevision pointer = new PointerCDORevision(revision.getEClass(), id, branch, revised, target);
            revisionManager.addRevision((CDORevision)pointer);
        }
    }

    private CDOChangeSet createChangeSet(Set<CDOID> ids, CDORevisionAvailabilityInfo startInfo, CDORevisionAvailabilityInfo endInfo) {
        CDOChangeSetData data = CDORevisionDeltaUtil.createChangeSetData(ids, (CDORevisionProvider)startInfo, (CDORevisionProvider)endInfo);
        return new CDOChangeSetImpl(startInfo.getBranchPoint(), endInfo.getBranchPoint(), data);
    }

    @Override
    public CDOChangeSetData applyChangeSetData(CDOChangeSetData changeSetData, CDORevisionAvailabilityInfo ancestorInfo, CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo) {
        CDOID id;
        CDOChangeSetDataImpl result = new CDOChangeSetDataImpl();
        if (sourceInfo.getBranchPoint().getBranch().isLocal()) {
            this.mapLocalIDs(changeSetData);
        }
        for (CDOIDAndVersion key : changeSetData.getNewObjects()) {
            InternalCDORevision revision = (InternalCDORevision)key;
            CDOID id2 = revision.getID();
            if (this.getObjectIfExists(id2) != null) continue;
            InternalCDOObject object = this.newInstance(revision.getEClass());
            object.cdoInternalSetView(this);
            object.cdoInternalSetRevision((CDORevision)revision);
            object.cdoInternalSetID(id2);
            object.cdoInternalSetState(CDOState.NEW);
            object.cdoInternalPostLoad();
            this.registerObject(object);
            this.registerNew(object);
            result.getNewObjects().add(revision);
            this.dirty = true;
        }
        Map<CDOID, CDOObject> dirtyObjects = this.lastSavepoint.getDirtyObjects();
        ConcurrentMap<CDOID, CDORevisionDelta> revisionDeltas = this.lastSavepoint.getRevisionDeltas();
        HashMap<CDOID, InternalCDORevision> oldRevisions = new HashMap<CDOID, InternalCDORevision>();
        for (CDORevisionKey key : changeSetData.getChangedObjects()) {
            InternalCDORevisionDelta ancestorGoalDelta = (InternalCDORevisionDelta)key;
            id = ancestorGoalDelta.getID();
            InternalCDORevision ancestorRevision = (InternalCDORevision)ancestorInfo.getRevision(id);
            InternalCDOObject object = this.getObject(id);
            boolean revisionChanged = false;
            InternalCDORevision targetRevision = object.cdoRevision();
            if (targetRevision == null) {
                targetRevision = (InternalCDORevision)targetInfo.getRevision(id);
                object.cdoInternalSetRevision((CDORevision)targetRevision);
                revisionChanged = true;
            }
            oldRevisions.put(id, targetRevision);
            InternalCDORevision goalRevision = ancestorRevision.copy();
            goalRevision.setBranchPoint((CDOBranchPoint)this);
            goalRevision.setVersion(targetRevision.getVersion());
            goalRevision.setRevised(0L);
            ancestorGoalDelta.apply((CDORevision)goalRevision);
            InternalCDORevisionDelta targetGoalDelta = goalRevision.compare((CDORevision)targetRevision);
            if (!targetGoalDelta.isEmpty()) {
                revisionDeltas.put(id, (CDORevisionDelta)targetGoalDelta);
                result.getChangedObjects().add(targetGoalDelta);
                object.cdoInternalSetState(CDOState.DIRTY);
                object.cdoInternalSetRevision((CDORevision)goalRevision);
                revisionChanged = true;
                dirtyObjects.put(id, object);
                this.dirty = true;
            }
            if (!revisionChanged) continue;
            object.cdoInternalPostLoad();
        }
        HashSet<CDOObject> detachedObjects = new HashSet<CDOObject>();
        for (CDOIDAndVersion key : changeSetData.getDetachedObjects()) {
            id = key.getID();
            InternalCDOObject object = this.getObjectIfExists(id);
            if (object == null) continue;
            result.getDetachedObjects().add(CDOIDUtil.createIDAndVersion((CDOID)id, (int)0));
            CDOStateMachine.INSTANCE.detach(object);
            detachedObjects.add(object);
            this.dirty = true;
        }
        ArrayList<CDORevisionDelta> deltas = new ArrayList<CDORevisionDelta>(revisionDeltas.values());
        if (!deltas.isEmpty() || !detachedObjects.isEmpty()) {
            this.sendDeltaNotifications(deltas, detachedObjects, oldRevisions);
        }
        return result;
    }

    private void mapLocalIDs(CDOChangeSetData changeSetData) {
        HashMap<CDOID, CDOIDTemp> idMappings = new HashMap<CDOID, CDOIDTemp>();
        for (CDOIDAndVersion key : changeSetData.getNewObjects()) {
            InternalCDORevision revision = (InternalCDORevision)key;
            if (!revision.getBranch().isLocal()) continue;
            CDOID oldID = revision.getID();
            CDOIDTemp newID = this.getNextTemporaryID();
            idMappings.put(oldID, newID);
            revision.setID((CDOID)newID);
        }
        if (!idMappings.isEmpty()) {
            CDOIDMapper idMapper = new CDOIDMapper(idMappings);
            idMapper.setAllowUnmappedTempIDs(true);
            for (CDOIDAndVersion key : changeSetData.getNewObjects()) {
                InternalCDORevision revision = (InternalCDORevision)key;
                revision.adjustReferences((CDOReferenceAdjuster)idMapper);
            }
            for (CDOIDAndVersion key : changeSetData.getChangedObjects()) {
                InternalCDORevisionDelta revisionDelta = (InternalCDORevisionDelta)key;
                revisionDelta.adjustReferences((CDOReferenceAdjuster)idMapper);
            }
        }
    }

    private InternalCDOObject getObjectIfExists(CDOID id) {
        try {
            return this.getObject(id);
        }
        catch (ObjectNotFoundException ex) {
            return null;
        }
    }

    @Override
    public void handleConflicts(Set<CDOObject> conflicts) {
        this.handleConflicts(conflicts, this.options().getConflictResolvers());
    }

    /*
     * Unable to fully structure code
     */
    private void handleConflicts(Set<CDOObject> conflicts, CDOConflictResolver[] resolvers) {
        block7: {
            if (resolvers.length == 0) {
                return;
            }
            states = new ArrayList<CDOState>(conflicts.size());
            revisions = new ArrayList<CDORevision>(conflicts.size());
            for (CDOObject conflict : conflicts) {
                states.add(conflict.cdoState());
                revisions.add(conflict.cdoRevision());
            }
            resolved = 0;
            try {
                remaining = new HashSet<CDOObject>(conflicts);
                var10_9 = resolvers;
                var9_11 = resolvers.length;
                var8_13 = 0;
                while (var8_13 < var9_11) {
                    resolver = var10_9[var8_13];
                    resolver.resolveConflicts(Collections.unmodifiableSet(remaining));
                    it = remaining.iterator();
                    while (it.hasNext()) {
                        object = (CDOObject)it.next();
                        if (object.cdoConflict()) continue;
                        ++resolved;
                        it.remove();
                    }
                    ++var8_13;
                }
                break block7;
            }
            catch (Exception ex) {
                state = states.iterator();
                revision = revisions.iterator();
                ** for (object : conflicts)
            }
lbl-1000:
            // 1 sources

            {
                ((InternalCDOObject)object).cdoInternalSetState((CDOState)state.next());
                ((InternalCDOObject)object).cdoInternalSetRevision((CDORevision)revision.next());
                continue;
            }
lbl38:
            // 1 sources

            throw WrappedException.wrap((Exception)ex);
        }
        this.conflict -= resolved;
    }

    public void handleConflicts(Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts, List<CDORevisionDelta> deltas) {
        this.handleConflicts(conflicts, this.options().getConflictResolvers(), deltas);
    }

    /*
     * Unable to fully structure code
     */
    private void handleConflicts(Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts, CDOConflictResolver[] resolvers, List<CDORevisionDelta> deltas) {
        block9: {
            if (resolvers.length == 0) {
                return;
            }
            states = new ArrayList<CDOState>(conflicts.size());
            revisions = new ArrayList<CDORevision>(conflicts.size());
            for (CDOObject conflict : conflicts.keySet()) {
                states.add(conflict.cdoState());
                revisions.add(conflict.cdoRevision());
            }
            resolved = 0;
            try {
                remaining = new HashMap<CDOObject, Pair<CDORevision, CDORevisionDelta>>(conflicts);
                var11_10 = resolvers;
                var10_12 = resolvers.length;
                var9_14 = 0;
                while (var9_14 < var10_12) {
                    resolver = var11_10[var9_14];
                    if (resolver instanceof CDOConflictResolver2) {
                        resolver2 = (CDOConflictResolver2)resolver;
                        resolver2.resolveConflicts(Collections.unmodifiableMap(remaining), deltas);
                    } else {
                        resolver.resolveConflicts(Collections.unmodifiableSet(remaining.keySet()));
                    }
                    it = remaining.keySet().iterator();
                    while (it.hasNext()) {
                        object = (CDOObject)it.next();
                        if (object.cdoConflict()) continue;
                        ++resolved;
                        it.remove();
                    }
                    ++var9_14;
                }
                break block9;
            }
            catch (Exception ex) {
                state = states.iterator();
                revision = revisions.iterator();
                ** for (object : conflicts.keySet())
            }
lbl-1000:
            // 1 sources

            {
                ((InternalCDOObject)object).cdoInternalSetState((CDOState)state.next());
                ((InternalCDOObject)object).cdoInternalSetRevision((CDORevision)revision.next());
                continue;
            }
lbl42:
            // 1 sources

            throw WrappedException.wrap((Exception)ex);
        }
        this.conflict -= resolved;
    }

    @Override
    public CDOIDTemp getNextTemporaryID() {
        return CDOIDUtil.createTempObject((int)this.lastTemporaryID.incrementAndGet());
    }

    @Override
    public CDOResource createResource(String path) {
        this.checkActive();
        URI uri = CDOURIUtil.createResourceURI(this, path);
        return (CDOResource)this.getResourceSet().createResource(uri);
    }

    @Override
    public CDOResource getOrCreateResource(String path) {
        this.checkActive();
        try {
            CDOID id = this.getResourceNodeID(path);
            if (!CDOIDUtil.isNull((CDOID)id)) {
                return (CDOResource)((Object)this.getObject(id));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createResource(path);
    }

    @Override
    public void attachResource(CDOResourceImpl resource) {
        if (resource.isExisting()) {
            super.attachResource(resource);
        } else {
            this.attachNewResource(resource);
        }
    }

    private void attachNewResource(CDOResourceImpl resource) {
        URI uri = resource.getURI();
        List<String> names = CDOURIUtil.analyzePath(uri);
        String resourceName = names.isEmpty() ? null : names.remove(names.size() - 1);
        CDOResourceFolder folder = this.getOrCreateResourceFolder(names);
        this.attachNewResourceNode(folder, resourceName, resource);
    }

    @Override
    public CDOResourceFolder getOrCreateResourceFolder(List<String> names) {
        CDOObject folder = null;
        for (String name : names) {
            CDOResourceNode node;
            try {
                CDOID folderID = folder == null ? null : folder.cdoID();
                node = this.getResourceNode(folderID, name);
            }
            catch (CDOException ex) {
                node = EresourceFactory.eINSTANCE.createCDOResourceFolder();
                this.attachNewResourceNode((CDOResourceFolder)folder, name, node);
            }
            if (node instanceof CDOResourceFolder) {
                folder = node;
                continue;
            }
            throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.0"), node));
        }
        return folder;
    }

    private void attachNewResourceNode(CDOResourceFolder folder, String name, CDOResourceNode newNode) {
        CDOResourceNodeImpl node = (CDOResourceNodeImpl)newNode;
        node.basicSetName(name, false);
        if (folder == null) {
            if (node.isRoot()) {
                CDOStateMachine.INSTANCE.attach(node, this);
            } else {
                this.getRootResource().getContents().add((Object)node);
            }
        } else {
            node.basicSetFolder(folder, false);
        }
    }

    public void detach(CDOResourceImpl cdoResource) {
        CDOStateMachine.INSTANCE.detach(cdoResource);
    }

    @Override
    public InternalCDOSavepoint getLastSavepoint() {
        this.checkActive();
        return this.lastSavepoint;
    }

    @Override
    public CDOTransactionStrategy getTransactionStrategy() {
        if (this.transactionStrategy == null) {
            this.transactionStrategy = CDOTransactionStrategy.DEFAULT;
            this.transactionStrategy.setTarget(this);
        }
        return this.transactionStrategy;
    }

    @Override
    public void setTransactionStrategy(CDOTransactionStrategy transactionStrategy) {
        if (this.transactionStrategy != null) {
            this.transactionStrategy.unsetTarget(this);
        }
        this.transactionStrategy = transactionStrategy;
        if (this.transactionStrategy != null) {
            this.transactionStrategy.setTarget(this);
        }
    }

    @Override
    protected CDOID getRootOrTopLevelResourceNodeID(String name) {
        if (this.dirty) {
            CDOResourceNode node = this.getRootResourceNode(name, this.getDirtyObjects().values());
            if (node != null) {
                return node.cdoID();
            }
            node = this.getRootResourceNode(name, this.getNewObjects().values());
            if (node != null) {
                return node.cdoID();
            }
        }
        CDOID id = super.getRootOrTopLevelResourceNodeID(name);
        if (this.getLastSavepoint().getAllDetachedObjects().containsKey(id) || this.getDirtyObjects().containsKey(id)) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.1"), name));
        }
        return id;
    }

    private CDOResourceNode getRootResourceNode(String name, Collection<? extends CDOObject> objects) {
        for (CDOObject cDOObject : objects) {
            CDOResourceNode node;
            if (!(cDOObject instanceof CDOResourceNode) || (node = (CDOResourceNode)cDOObject).getFolder() != null || !ObjectUtil.equals((Object)name, (Object)node.getName())) continue;
            return node;
        }
        return null;
    }

    @Override
    public InternalCDOObject getObject(CDOID id, boolean loadOnDemand) {
        this.checkActive();
        if (CDOIDUtil.isNull((CDOID)id)) {
            return null;
        }
        if (id.isTemporary() && this.isDetached(id)) {
            throw new ObjectNotFoundException(id, (CDOBranchPoint)this);
        }
        return super.getObject(id, loadOnDemand);
    }

    private boolean isDetached(CDOID id) {
        return this.lastSavepoint.getSharedDetachedObjects().contains(id);
    }

    @Override
    public InternalCDOTransaction.InternalCDOCommitContext createCommitContext() {
        return new CDOCommitContextImpl(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CDOCommitInfo commit(IProgressMonitor progressMonitor) throws CommitException {
        this.checkActive();
        Object object = this.getSession().getInvalidationLock();
        synchronized (object) {
            this.getLock().lock();
            try {
                CDOTransactionStrategy transactionStrategy;
                CDOCommitInfo info;
                if (this.hasConflict()) {
                    throw new CommitException(Messages.getString("CDOTransactionImpl.2"));
                }
                if (progressMonitor == null) {
                    progressMonitor = new NullProgressMonitor();
                }
                if ((info = (transactionStrategy = this.getTransactionStrategy()).commit(this, progressMonitor)) != null) {
                    this.lastCommitTime = info.getTimeStamp();
                }
                CDOCommitInfo cDOCommitInfo = info;
                return cDOCommitInfo;
            }
            catch (CommitException ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw new CommitException(t);
            }
            finally {
                this.getLock().unlock();
            }
        }
    }

    @Override
    public CDOCommitInfo commit() throws CommitException {
        return this.commit(null);
    }

    @Override
    public void rollback() {
        this.checkActive();
        this.rollback(this.firstSavepoint);
        this.cleanUp();
    }

    private void removeObject(CDOID id, CDOObject object) {
        ((InternalCDOObject)object).cdoInternalSetState(CDOState.TRANSIENT);
        this.removeObject(id);
        if (object instanceof CDOResource) {
            this.getResourceSet().getResources().remove((Object)object);
        }
        ((InternalCDOObject)object).cdoInternalSetID(null);
        ((InternalCDOObject)object).cdoInternalSetRevision(null);
        ((InternalCDOObject)object).cdoInternalSetView(null);
    }

    private Set<CDOID> rollbackCompletely(CDOUserSavepoint savepoint) {
        HashSet<CDOID> idsOfNewObjectWithDeltas = new HashSet<CDOID>();
        InternalCDOSavepoint itrSavepoint = this.lastSavepoint;
        while (itrSavepoint != null) {
            InternalCDOObject internalDirtyObject;
            Map<CDOID, CDOObject> detachedObjectsMap;
            Map<CDOID, CDOObject> newObjects = itrSavepoint.getNewObjects();
            for (CDOID id : newObjects.keySet()) {
                CDOObject object = newObjects.get(id);
                this.removeObject(id, object);
            }
            Set<CDOID> detachedIDs = itrSavepoint.getDetachedObjects().keySet();
            for (CDOObject reattachedObject : itrSavepoint.getReattachedObjects().values()) {
                CDOID cdoID = reattachedObject.cdoID();
                if (detachedIDs.contains(cdoID)) continue;
                this.removeObject(cdoID, reattachedObject);
            }
            ConcurrentMap<CDOID, CDORevisionDelta> revisionDeltas = itrSavepoint.getRevisionDeltas();
            if (!revisionDeltas.isEmpty()) {
                for (CDORevisionDelta dirtyObject : revisionDeltas.values()) {
                    if (!dirtyObject.getID().isTemporary()) continue;
                    idsOfNewObjectWithDeltas.add(dirtyObject.getID());
                }
            }
            if (!(detachedObjectsMap = itrSavepoint.getDetachedObjects()).isEmpty()) {
                for (Map.Entry<CDOID, CDOObject> entryDirty : detachedObjectsMap.entrySet()) {
                    if (entryDirty.getKey().isTemporary()) {
                        idsOfNewObjectWithDeltas.add(entryDirty.getKey());
                        continue;
                    }
                    internalDirtyObject = (InternalCDOObject)entryDirty.getValue();
                    this.cleanObject(internalDirtyObject, this.getRevision(entryDirty.getKey(), true));
                }
            }
            for (Map.Entry<CDOID, CDOObject> entryDirtyObject : itrSavepoint.getDirtyObjects().entrySet()) {
                if (entryDirtyObject.getKey().isTemporary()) continue;
                internalDirtyObject = (InternalCDOObject)entryDirtyObject.getValue();
                if (itrSavepoint.getReattachedObjects().values().contains(internalDirtyObject)) continue;
                CDOStateMachine.INSTANCE.rollback(internalDirtyObject);
            }
            if (savepoint == itrSavepoint) break;
            itrSavepoint = itrSavepoint.getPreviousSavepoint();
        }
        return idsOfNewObjectWithDeltas;
    }

    /*
     * WARNING - void declaration
     */
    private void loadSavepoint(CDOSavepoint savepoint, Set<CDOID> idsOfNewObjectWithDeltas) {
        void var7_14;
        InternalCDOObject object;
        this.lastSavepoint.recalculateSharedDetachedObjects();
        Map<CDOID, CDOObject> dirtyObjects = this.getDirtyObjects();
        Map<CDOID, CDOObject> newObjMaps = this.getNewObjects();
        Map<CDOID, CDORevision> newBaseRevision = this.getBaseNewObjects();
        Map<CDOID, CDOObject> detachedObjects = this.getDetachedObjects();
        for (CDOID cDOID : idsOfNewObjectWithDeltas) {
            if (detachedObjects.containsKey(cDOID)) continue;
            object = (InternalCDOObject)newObjMaps.get(cDOID);
            CDORevision revision = newBaseRevision.get(cDOID);
            if (revision == null) continue;
            object.cdoInternalSetRevision(revision.copy());
            object.cdoInternalSetView(this);
            object.cdoInternalSetID(revision.getID());
            object.cdoInternalSetState(CDOState.NEW);
            object.cdoInternalPostLoad();
            if (super.getObject(object.cdoID(), false) != null) continue;
            this.registerObject(object);
        }
        for (Map.Entry entry : newObjMaps.entrySet()) {
            object = (InternalCDOObject)entry.getValue();
            this.cleanObject(object, object.cdoRevision());
            object.cdoInternalSetState(CDOState.NEW);
        }
        for (Map.Entry entry : dirtyObjects.entrySet()) {
            if (detachedObjects.containsKey(entry.getKey())) continue;
            InternalCDOObject internalDirtyObject = (InternalCDOObject)entry.getValue();
            this.cleanObject(internalDirtyObject, this.getRevision((CDOID)entry.getKey(), true));
        }
        InternalCDOSavepoint internalCDOSavepoint = this.firstSavepoint;
        while (var7_14 != savepoint) {
            CDOObjectMerger merger = new CDOObjectMerger();
            for (CDORevisionDelta delta : var7_14.getRevisionDeltas().values()) {
                if (delta.getID().isTemporary() && !idsOfNewObjectWithDeltas.contains(delta.getID()) || detachedObjects.containsKey(delta.getID())) continue;
                Map<CDOID, CDOObject> map = delta.getID().isTemporary() ? newObjMaps : dirtyObjects;
                InternalCDOObject object2 = (InternalCDOObject)map.get(delta.getID());
                merger.merge(object2, delta);
                object2.cdoInternalPostLoad();
            }
            InternalCDOSavepoint internalCDOSavepoint2 = var7_14.getNextSavepoint();
        }
        this.dirty = savepoint.wasDirty();
    }

    @Override
    public void detachObject(InternalCDOObject object) {
        CDOTransactionHandler[] handlers = this.getTransactionHandlers();
        if (handlers != null) {
            int i = 0;
            while (i < handlers.length) {
                CDOTransactionHandler handler = handlers[i];
                handler.detachingObject(this, object);
                ++i;
            }
        }
        CDOID id = object.cdoID();
        if (object.cdoState() == CDOState.NEW) {
            Map<CDOID, CDOObject> map = this.getLastSavepoint().getNewObjects();
            if (map.containsKey(id)) {
                map.remove(id);
            } else {
                this.getLastSavepoint().getDetachedObjects().put(id, object);
            }
            this.deregisterObject(object);
        } else {
            this.getLastSavepoint().getDetachedObjects().put(id, object);
            if (!this.formerRevisionKeys.containsKey(object)) {
                CDORevisionKey revKey = CDORevisionUtil.createRevisionKey((CDORevisionKey)object.cdoRevision());
                this.formerRevisionKeys.put(object, revKey);
            }
            this.lastSavepoint.getReattachedObjects().remove(id);
        }
        if (!this.dirty) {
            this.dirty = true;
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent(new StartedEvent(), listeners);
            }
        }
    }

    public void rollback(CDOUserSavepoint savepoint) {
        this.checkActive();
        this.getTransactionStrategy().rollback(this, (InternalCDOUserSavepoint)savepoint);
    }

    @Override
    public void handleRollback(InternalCDOSavepoint savepoint) {
        block16: {
            if (savepoint == null) {
                throw new IllegalArgumentException(Messages.getString("CDOTransactionImpl.3"));
            }
            if (savepoint.getTransaction() != this) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOTransactionImpl.4"), savepoint));
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("handleRollback()");
            }
            try {
                CDOTransactionHandler[] handlers;
                if (!savepoint.isValid()) {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOTransactionImpl.6"), savepoint));
                }
                ReentrantLock viewLock = this.getStateLock();
                viewLock.lock();
                try {
                    Set<CDOID> idsOfNewObjectWithDeltas = this.rollbackCompletely(savepoint);
                    this.lastSavepoint = savepoint;
                    this.lastSavepoint.setNextSavepoint(null);
                    this.lastSavepoint.clear();
                    this.loadSavepoint(this.lastSavepoint, idsOfNewObjectWithDeltas);
                    if (this.lastSavepoint == this.firstSavepoint && this.options().isAutoReleaseLocksEnabled()) {
                        this.unlockObjects(null, null);
                    }
                }
                finally {
                    viewLock.unlock();
                }
                Map idMappings = Collections.emptyMap();
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent(new FinishedEvent(CDOTransactionFinishedEvent.Type.ROLLED_BACK, idMappings), listeners);
                }
                if ((handlers = this.getTransactionHandlers()) == null) break block16;
                int i = 0;
                while (i < handlers.length) {
                    CDOTransactionHandler handler = handlers[i];
                    try {
                        handler.rolledBackTransaction(this);
                    }
                    catch (RuntimeException ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                    ++i;
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new TransactionException((Throwable)ex);
            }
        }
    }

    @Override
    public InternalCDOSavepoint handleSetSavepoint() {
        this.addToBase(this.lastSavepoint.getNewObjects());
        this.lastSavepoint = this.createSavepoint(this.lastSavepoint);
        return this.lastSavepoint;
    }

    protected CDOSavepointImpl createSavepoint(InternalCDOSavepoint lastSavepoint) {
        return new CDOSavepointImpl(this, lastSavepoint);
    }

    @Override
    public InternalCDOSavepoint setSavepoint() {
        this.checkActive();
        return (InternalCDOSavepoint)this.getTransactionStrategy().setSavepoint(this);
    }

    private void addToBase(Map<CDOID, CDOObject> objects) {
        for (CDOObject object : objects.values()) {
            ((InternalCDOObject)object).cdoInternalPreCommit();
            this.lastSavepoint.getBaseNewObjects().put(object.cdoID(), object.cdoRevision().copy());
        }
    }

    @Override
    protected String getClassName() {
        return "CDOTransaction";
    }

    @Override
    public void registerNew(InternalCDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering new object {0}", new Object[]{object});
        }
        this.registerNewPackage(object.eClass().getEPackage());
        CDOTransactionHandler[] handlers = this.getTransactionHandlers();
        if (handlers != null) {
            int i = 0;
            while (i < handlers.length) {
                CDOTransactionHandler handler = handlers[i];
                handler.attachingObject(this, object);
                ++i;
            }
        }
        this.registerNew(this.lastSavepoint.getNewObjects(), object);
    }

    private void registerNewPackage(EPackage ePackage) {
        InternalCDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
        if (!packageRegistry.containsKey((Object)ePackage.getNsURI())) {
            packageRegistry.putEPackage(ePackage);
        }
    }

    @Override
    public void registerFeatureDelta(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        CDOTransactionHandler[] handlers;
        CDOID id = object.cdoID();
        boolean needToSaveFeatureDelta = true;
        if (object.cdoState() == CDOState.NEW) {
            if (this.getLastSavepoint().getPreviousSavepoint() == null || featureDelta == null) {
                needToSaveFeatureDelta = false;
            } else {
                Map<CDOID, CDOObject> map = this.getLastSavepoint().getNewObjects();
                boolean bl = needToSaveFeatureDelta = !map.containsKey(id);
            }
        }
        if (needToSaveFeatureDelta) {
            CDORevisionDelta revisionDelta = (CDORevisionDelta)this.lastSavepoint.getRevisionDeltas().get(id);
            if (revisionDelta == null) {
                revisionDelta = CDORevisionDeltaUtil.create((CDORevision)object.cdoRevision());
                this.lastSavepoint.getRevisionDeltas().put(id, revisionDelta);
            }
            ((InternalCDORevisionDelta)revisionDelta).addFeatureDelta(featureDelta);
        }
        if ((handlers = this.getTransactionHandlers()) != null) {
            int i = 0;
            while (i < handlers.length) {
                CDOTransactionHandler handler = handlers[i];
                handler.modifyingObject(this, object, featureDelta);
                ++i;
            }
        }
    }

    @Override
    public void registerRevisionDelta(CDORevisionDelta revisionDelta) {
        this.lastSavepoint.getRevisionDeltas().putIfAbsent(revisionDelta.getID(), revisionDelta);
    }

    @Override
    public void registerDirty(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering dirty object {0}", new Object[]{object});
        }
        if (featureDelta != null) {
            this.registerFeatureDelta(object, featureDelta);
        }
        this.registerNew(this.lastSavepoint.getDirtyObjects(), object);
    }

    private void registerNew(Map map, InternalCDOObject object) {
        InternalCDOObject old = map.put(object.cdoID(), object);
        if (old != null) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOTransactionImpl.10"), object));
        }
        if (!this.dirty) {
            this.dirty = true;
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent(new StartedEvent(), listeners);
            }
        }
    }

    public List<CDOPackageUnit> analyzeNewPackages() {
        InternalCDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
        HashSet<EPackage> usedPackages = new HashSet<EPackage>();
        HashSet<EPackage> usedNewPackages = new HashSet<EPackage>();
        for (CDOObject object : this.getNewObjects().values()) {
            CDOPackageUnit packageUnit;
            EPackage topLevelPackage;
            EPackage ePackage = object.eClass().getEPackage();
            if (!usedPackages.add(ePackage) || ePackage != (topLevelPackage = EMFUtil.getTopLevelPackage((EPackage)ePackage)) && !usedPackages.add(topLevelPackage) || CDOModelUtil.isSystemPackage((EPackage)topLevelPackage) || (packageUnit = packageRegistry.getPackageUnit(topLevelPackage)).getState() != CDOPackageUnit.State.NEW) continue;
            usedNewPackages.add(topLevelPackage);
        }
        if (usedNewPackages.size() > 0) {
            HashSet<CDOPackageUnit> result = new HashSet<CDOPackageUnit>();
            for (EPackage usedNewPackage : CDOTransactionImpl.analyzeNewPackages(usedNewPackages, (CDOPackageRegistry)packageRegistry)) {
                CDOPackageUnit packageUnit = packageRegistry.getPackageUnit(usedNewPackage);
                result.add(packageUnit);
            }
            return new ArrayList<CDOPackageUnit>(result);
        }
        return Collections.emptyList();
    }

    private static List<EPackage> analyzeNewPackages(Collection<EPackage> usedTopLevelPackages, CDOPackageRegistry packageRegistry) {
        ArrayList<EPackage> newPackages = new ArrayList<EPackage>();
        CompletePackageClosure closure = new CompletePackageClosure();
        usedTopLevelPackages = closure.calculate(usedTopLevelPackages);
        for (EPackage usedPackage : usedTopLevelPackages) {
            if (CDOModelUtil.isSystemPackage((EPackage)usedPackage)) continue;
            CDOPackageUnit packageUnit = packageRegistry.getPackageUnit(usedPackage);
            if (packageUnit == null) {
                throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.11"), usedPackage));
            }
            if (packageUnit.getState() != CDOPackageUnit.State.NEW) continue;
            newPackages.add(usedPackage);
        }
        return newPackages;
    }

    private void cleanUp() {
        this.lastSavepoint = this.firstSavepoint;
        this.firstSavepoint.clear();
        this.firstSavepoint.setNextSavepoint(null);
        this.firstSavepoint.getSharedDetachedObjects().clear();
        this.formerRevisionKeys.clear();
        this.dirty = false;
        this.conflict = 0;
        this.lastTemporaryID.set(0);
    }

    @Override
    public CDOSavepoint[] exportChanges(OutputStream stream) throws IOException {
        CDODataOutputImpl out = new CDODataOutputImpl((ExtendedDataOutput)new ExtendedDataOutputStream(stream)){

            public CDOIDProvider getIDProvider() {
                return CDOTransactionImpl.this;
            }

            public CDOPackageRegistry getPackageRegistry() {
                return CDOTransactionImpl.this.getSession().getPackageRegistry();
            }
        };
        ArrayList<InternalCDOSavepoint> savepoints = new ArrayList<InternalCDOSavepoint>();
        InternalCDOSavepoint savepoint = this.firstSavepoint;
        while (savepoint != null) {
            Collection<CDOObject> newObjects = savepoint.getNewObjects().values();
            Collection revisionDeltas = savepoint.getRevisionDeltas().values();
            if (newObjects.isEmpty() && revisionDeltas.isEmpty()) {
                savepoint = savepoint.getNextSavepoint();
                continue;
            }
            savepoints.add(savepoint);
            out.writeBoolean(true);
            out.writeInt(newObjects.size());
            for (CDOObject newObject : newObjects) {
                out.writeCDORevision(newObject.cdoRevision(), -1);
            }
            out.writeInt(revisionDeltas.size());
            for (CDORevisionDelta revisionDelta : revisionDeltas) {
                out.writeCDORevisionDelta(revisionDelta);
            }
            savepoint = savepoint.getNextSavepoint();
        }
        out.writeBoolean(false);
        return savepoints.toArray(new CDOSavepoint[savepoints.size()]);
    }

    @Override
    public CDOSavepoint[] importChanges(InputStream stream, boolean reconstructSavepoints) throws IOException {
        ArrayList<InternalCDOSavepoint> savepoints = new ArrayList<InternalCDOSavepoint>();
        if (stream.available() > 0) {
            CDODataInputImpl in = new CDODataInputImpl((ExtendedDataInput)new ExtendedDataInputStream(stream)){

                protected CDOPackageRegistry getPackageRegistry() {
                    return CDOTransactionImpl.this.getSession().getPackageRegistry();
                }

                protected CDOBranchManager getBranchManager() {
                    return CDOTransactionImpl.this.getSession().getBranchManager();
                }

                protected CDOCommitInfoManager getCommitInfoManager() {
                    return CDOTransactionImpl.this.getSession().getCommitInfoManager();
                }

                protected CDORevisionFactory getRevisionFactory() {
                    return CDOTransactionImpl.this.getSession().getRevisionManager().getFactory();
                }

                protected CDOListFactory getListFactory() {
                    return CDOListWithElementProxiesImpl.FACTORY;
                }
            };
            HashMap<CDOID, CDOID> idMappings = new HashMap<CDOID, CDOID>();
            while (in.readBoolean()) {
                if (reconstructSavepoints) {
                    InternalCDOSavepoint savepoint = this.setSavepoint();
                    savepoints.add(savepoint);
                }
                ArrayList<InternalCDORevision> revisions = new ArrayList<InternalCDORevision>();
                this.importNewRevisions((CDODataInput)in, revisions, idMappings);
                List<InternalCDORevisionDelta> revisionDeltas = this.importRevisionDeltas((CDODataInput)in);
                CDOIDMapper idMapper = new CDOIDMapper(idMappings);
                for (InternalCDORevision revision : revisions) {
                    revision.adjustReferences((CDOReferenceAdjuster)idMapper);
                }
                for (InternalCDORevisionDelta delta : revisionDeltas) {
                    delta.adjustReferences((CDOReferenceAdjuster)idMapper);
                }
                for (InternalCDORevision revision : revisions) {
                    InternalCDOObject object = this.newInstance(revision);
                    this.registerObject(object);
                    this.registerNew(object);
                }
                CDOObjectMerger merger = new CDOObjectMerger();
                for (InternalCDORevisionDelta delta : revisionDeltas) {
                    InternalCDOObject object = this.getObject(delta.getID());
                    InternalCDORevision revision = object.cdoRevision().copy();
                    merger.merge(object, (CDORevisionDelta)delta);
                    this.registerRevisionDelta((CDORevisionDelta)delta);
                    this.registerDirty(object, null);
                    if (delta.getVersion() >= revision.getVersion()) continue;
                    this.setConflict(object);
                }
            }
        }
        return savepoints.toArray(new CDOSavepoint[savepoints.size()]);
    }

    private void importNewRevisions(CDODataInput in, List<InternalCDORevision> revisions, Map<CDOID, CDOID> idMappings) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            InternalCDORevision revision = (InternalCDORevision)in.readCDORevision();
            CDOID oldID = revision.getID();
            CDOIDTemp newID = this.getNextTemporaryID();
            idMappings.put(oldID, (CDOID)newID);
            revision.setID((CDOID)newID);
            revisions.add(revision);
            ++i;
        }
    }

    private List<InternalCDORevisionDelta> importRevisionDeltas(CDODataInput in) throws IOException {
        int size = in.readInt();
        ArrayList<InternalCDORevisionDelta> deltas = new ArrayList<InternalCDORevisionDelta>(size);
        int i = 0;
        while (i < size) {
            InternalCDORevisionDelta delta = (InternalCDORevisionDelta)in.readCDORevisionDelta();
            deltas.add(delta);
            ++i;
        }
        return deltas;
    }

    private InternalCDOObject newInstance(InternalCDORevision revision) {
        InternalCDOObject object = this.newInstance(revision.getEClass());
        object.cdoInternalSetID(revision.getID());
        object.cdoInternalSetRevision((CDORevision)revision);
        object.cdoInternalSetState(CDOState.NEW);
        object.cdoInternalSetView(this);
        return object;
    }

    @Override
    public Map<CDOID, CDOObject> getDirtyObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllDirtyObjects();
    }

    @Override
    public Map<CDOID, CDOObject> getNewObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllNewObjects();
    }

    @Override
    public Map<CDOID, CDORevision> getBaseNewObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllBaseNewObjects();
    }

    @Override
    public Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
        this.checkActive();
        return this.lastSavepoint.getAllRevisionDeltas();
    }

    @Override
    public Map<CDOID, CDOObject> getDetachedObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllDetachedObjects();
    }

    public Map<InternalCDOObject, CDORevisionKey> getFormerRevisionKeys() {
        return this.formerRevisionKeys;
    }

    @Override
    public Map<InternalCDOObject, InternalCDORevision> getFormerRevisions() {
        throw new UnsupportedOperationException("This method is no longer supported. Call getFormerRevisionKeys() instead.");
    }

    @Override
    protected CDOID getID(InternalCDOObject object, boolean onlyPersistedID) {
        CDORevisionKey revKey;
        CDOID id = super.getID(object, onlyPersistedID);
        if (!this.providingCDOID.get().booleanValue() && id == null && (revKey = this.formerRevisionKeys.get(object)) != null) {
            id = revKey.getID();
        }
        return id;
    }

    @Override
    public CDOID provideCDOID(Object idOrObject) {
        try {
            this.providingCDOID.set(true);
            CDOID cDOID = super.provideCDOID(idOrObject);
            return cDOID;
        }
        finally {
            this.providingCDOID.set(false);
        }
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.options().disposeConflictResolvers();
        this.lastSavepoint = null;
        this.firstSavepoint = null;
        this.transactionStrategy = null;
        super.doDeactivate();
    }

    @Override
    protected Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> invalidate(long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, List<CDORevisionDelta> deltas, Set<InternalCDOObject> changedObjects, Set<CDOObject> detachedObjects) {
        if (!allDetachedObjects.isEmpty()) {
            HashSet<CDOID> referencedOIDs = new HashSet<CDOID>();
            for (CDOIDAndVersion key : allDetachedObjects) {
                referencedOIDs.add(key.getID());
            }
            Collection<CDOObject> cachedDirtyObjects = this.getDirtyObjects().values();
            this.removeCrossReferences(cachedDirtyObjects, referencedOIDs);
            Collection<CDOObject> cachedNewObjects = this.getNewObjects().values();
            this.removeCrossReferences(cachedNewObjects, referencedOIDs);
        }
        return super.invalidate(lastUpdateTime, allChangedObjects, allDetachedObjects, deltas, changedObjects, detachedObjects);
    }

    private void removeCrossReferences(Collection<CDOObject> referencers, Set<CDOID> referencedOIDs) {
        for (CDOObject referencer : referencers) {
            EContentsEList.FeatureIterator it = (EContentsEList.FeatureIterator)referencer.eCrossReferences().iterator();
            while (it.hasNext()) {
                InternalCDORevision cleanRevision;
                Object value;
                EObject referencedObject = (EObject)it.next();
                CDOID referencedOID = CDOUtil.getCDOObject(referencedObject).cdoID();
                if (!referencedOIDs.contains(referencedOID)) continue;
                EReference reference = (EReference)it.feature();
                if (referencer.cdoState() == CDOState.DIRTY && ((value = (cleanRevision = this.getSession().getRevisionManager().getRevisionByVersion(referencer.cdoID(), (CDOBranchVersion)referencer.cdoRevision(), -1, true)).get((EStructuralFeature)reference, -1)) instanceof CDOObject && value == referencedObject || value instanceof CDOID && value.equals(referencedOID) || value instanceof CDOList && ((CDOList)value).contains((Object)referencedOID))) continue;
                EStructuralFeature.Setting setting = ((InternalEObject)referencer).eSetting((EStructuralFeature)reference);
                EcoreUtil.remove((EStructuralFeature.Setting)setting, (Object)referencedObject);
            }
        }
    }

    @Override
    public long getLastCommitTime() {
        return this.lastCommitTime;
    }

    @Override
    public String getCommitComment() {
        return this.commitComment;
    }

    @Override
    public void setCommitComment(String comment) {
        this.commitComment = comment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CDOCommitContextImpl
    implements InternalCDOTransaction.InternalCDOCommitContext {
        private InternalCDOTransaction transaction;
        private CDOCommitData commitData;

        public CDOCommitContextImpl(InternalCDOTransaction transaction) {
            this.transaction = transaction;
            this.calculateCommitData();
        }

        private void calculateCommitData() {
            List<CDOPackageUnit> newPackageUnits = CDOTransactionImpl.this.analyzeNewPackages();
            ArrayList<CDORevision> revisions = new ArrayList<CDORevision>(this.getNewObjects().size());
            for (CDOObject newObject : this.getNewObjects().values()) {
                revisions.add(newObject.cdoRevision());
            }
            ArrayList<CDORevisionDelta> deltas = new ArrayList<CDORevisionDelta>(this.getRevisionDeltas().size());
            for (CDORevisionDelta delta : this.getRevisionDeltas().values()) {
                deltas.add(delta);
            }
            ArrayList<CDOIDAndVersion> detached = new ArrayList<CDOIDAndVersion>(this.getDetachedObjects().size());
            for (CDOID id : this.getDetachedObjects().keySet()) {
                detached.add(CDOIDUtil.createIDAndVersion((CDOID)id, (int)0));
            }
            this.commitData = new CDOCommitDataImpl(newPackageUnits, revisions, deltas, detached);
        }

        @Override
        public InternalCDOTransaction getTransaction() {
            return this.transaction;
        }

        @Override
        public CDOCommitData getCommitData() {
            return this.commitData;
        }

        @Override
        public Map<CDOID, CDOObject> getDirtyObjects() {
            return this.transaction.getDirtyObjects();
        }

        @Override
        public Map<CDOID, CDOObject> getNewObjects() {
            return this.transaction.getNewObjects();
        }

        @Override
        public List<CDOPackageUnit> getNewPackageUnits() {
            return this.commitData.getNewPackageUnits();
        }

        @Override
        public Map<CDOID, CDOObject> getDetachedObjects() {
            return this.transaction.getDetachedObjects();
        }

        @Override
        public Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
            return this.transaction.getRevisionDeltas();
        }

        @Override
        public void preCommit() {
            if (CDOTransactionImpl.this.isDirty()) {
                CDOTransactionHandler[] handlers;
                if (TRACER.isEnabled()) {
                    TRACER.trace("commit()");
                }
                if ((handlers = CDOTransactionImpl.this.getTransactionHandlers()) != null) {
                    final boolean[] modifiedAgain = new boolean[1];
                    CDODefaultTransactionHandler modifiedAgainHandler = new CDODefaultTransactionHandler(){

                        public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureChange) {
                            modifiedAgain[0] = true;
                        }
                    };
                    CDOTransactionImpl.this.addTransactionHandler(modifiedAgainHandler);
                    try {
                        int i = 0;
                        while (i < handlers.length) {
                            modifiedAgain[0] = false;
                            CDOTransactionHandler handler = handlers[i];
                            handler.committingTransaction(this.getTransaction(), this);
                            if (modifiedAgain[0]) {
                                this.calculateCommitData();
                            }
                            ++i;
                        }
                    }
                    finally {
                        CDOTransactionImpl.this.removeTransactionHandler(modifiedAgainHandler);
                    }
                }
                try {
                    this.preCommit(this.getNewObjects());
                    this.preCommit(this.getDirtyObjects());
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new TransactionException((Throwable)ex);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void postCommit(CDOSessionProtocol.CommitTransactionResult result) {
            if (CDOTransactionImpl.this.isDirty()) {
                try {
                    boolean branchChanged;
                    long timeStamp = result.getTimeStamp();
                    CDOBranch branch = result.getBranch();
                    boolean bl = branchChanged = !ObjectUtil.equals((Object)branch, (Object)CDOTransactionImpl.this.getBranch());
                    if (branchChanged) {
                        CDOTransactionImpl.this.basicSetBranchPoint(branch.getHead());
                    }
                    for (CDOPackageUnit newPackageUnit : this.getNewPackageUnits()) {
                        ((InternalCDOPackageUnit)newPackageUnit).setState(CDOPackageUnit.State.LOADED);
                    }
                    this.postCommit(this.getNewObjects(), result);
                    this.postCommit(this.getDirtyObjects(), result);
                    for (CDORevisionDelta delta : this.getRevisionDeltas().values()) {
                        ((InternalCDORevisionDelta)delta).adjustReferences(result.getReferenceAdjuster());
                    }
                    for (CDOID id : this.getDetachedObjects().keySet()) {
                        CDOTransactionImpl.this.removeObject(id);
                    }
                    CDOCommitInfo commitInfo = this.makeCommitInfo(timeStamp);
                    InternalCDOSession session = CDOTransactionImpl.this.getSession();
                    session.invalidate(commitInfo, this.transaction);
                    CDOTransactionHandler[] handlers = CDOTransactionImpl.this.getTransactionHandlers();
                    if (handlers != null) {
                        int i = 0;
                        while (i < handlers.length) {
                            CDOTransactionHandler handler = handlers[i];
                            handler.committedTransaction(this.transaction, this);
                            ++i;
                        }
                    }
                    CDOTransactionImpl.this.getChangeSubscriptionManager().committedTransaction(this.transaction, this);
                    CDOTransactionImpl.this.getAdapterManager().committedTransaction(this.transaction, this);
                    CDOTransactionImpl.this.cleanUp();
                    Map<CDOID, CDOID> idMappings = result.getIDMappings();
                    IListener[] listeners = CDOTransactionImpl.this.getListeners();
                    if (listeners == null) return;
                    if (branchChanged) {
                        CDOTransactionImpl.this.fireViewTargetChangedEvent(listeners);
                    }
                    CDOTransactionImpl.this.fireEvent(new FinishedEvent(CDOTransactionFinishedEvent.Type.COMMITTED, idMappings), listeners);
                    return;
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new TransactionException((Throwable)ex);
                }
            } else {
                if (!CDOTransactionImpl.this.options().isAutoReleaseLocksEnabled()) return;
                CDOTransactionImpl.this.unlockObjects(null, null);
            }
        }

        private CDOCommitInfo makeCommitInfo(long timeStamp) {
            InternalCDOSession session = CDOTransactionImpl.this.getSession();
            CDOBranch branch = CDOTransactionImpl.this.getBranch();
            String userID = session.getUserID();
            String comment = CDOTransactionImpl.this.getCommitComment();
            InternalCDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
            return commitInfoManager.createCommitInfo(branch, timeStamp, userID, comment, this.commitData);
        }

        private void preCommit(Map<CDOID, CDOObject> objects) {
            if (!objects.isEmpty()) {
                boolean noLegacy = !CDOTransactionImpl.this.isLegacyModeEnabled();
                for (CDOObject object : objects.values()) {
                    if (noLegacy && object instanceof CDOObjectWrapper) {
                        throw new LegacyModeNotEnabledException();
                    }
                    ((InternalCDOObject)object).cdoInternalPreCommit();
                }
            }
        }

        private void postCommit(Map<CDOID, CDOObject> objects, CDOSessionProtocol.CommitTransactionResult result) {
            if (!objects.isEmpty()) {
                for (CDOObject object : objects.values()) {
                    CDOStateMachine.INSTANCE.commit((InternalCDOObject)object, result);
                }
            }
        }
    }

    private final class ConflictEvent
    extends CDOViewImpl.Event
    implements CDOTransactionConflictEvent {
        private static final long serialVersionUID = 1L;
        private InternalCDOObject conflictingObject;
        private boolean firstConflict;

        public ConflictEvent(InternalCDOObject conflictingObject, boolean firstConflict) {
            super(CDOTransactionImpl.this);
            this.conflictingObject = conflictingObject;
            this.firstConflict = firstConflict;
        }

        public InternalCDOObject getConflictingObject() {
            return this.conflictingObject;
        }

        public boolean isFirstConflict() {
            return this.firstConflict;
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionConflictEvent[source={0}, conflictingObject={1}, firstConflict={2}]", this.getSource(), this.getConflictingObject(), this.isFirstConflict());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FinishedEvent
    extends CDOViewImpl.Event
    implements CDOTransactionFinishedEvent {
        private static final long serialVersionUID = 1L;
        private CDOTransactionFinishedEvent.Type type;
        private Map<CDOID, CDOID> idMappings;

        private FinishedEvent(CDOTransactionFinishedEvent.Type type, Map<CDOID, CDOID> idMappings) {
            super(CDOTransactionImpl.this);
            this.type = type;
            this.idMappings = idMappings;
        }

        @Override
        public CDOTransactionFinishedEvent.Type getType() {
            return this.type;
        }

        @Override
        public Map<CDOID, CDOID> getIDMappings() {
            return this.idMappings;
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionFinishedEvent[source={0}, type={1}, idMappings={2}]", new Object[]{this.getSource(), this.getType(), this.idMappings == null ? 0 : this.idMappings.size()});
        }
    }

    protected final class OptionsImpl
    extends CDOViewImpl.OptionsImpl
    implements CDOTransaction.Options {
        private List<CDOConflictResolver> conflictResolvers;
        private boolean autoReleaseLocksEnabled;

        public OptionsImpl() {
            super(CDOTransactionImpl.this);
            this.conflictResolvers = new ArrayList<CDOConflictResolver>();
            this.autoReleaseLocksEnabled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOConflictResolver[] getConflictResolvers() {
            List<CDOConflictResolver> list = this.conflictResolvers;
            synchronized (list) {
                return this.conflictResolvers.toArray(new CDOConflictResolver[this.conflictResolvers.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setConflictResolvers(CDOConflictResolver[] resolvers) {
            List<CDOConflictResolver> list = this.conflictResolvers;
            synchronized (list) {
                for (CDOConflictResolver resolver : this.conflictResolvers) {
                    resolver.setTransaction(null);
                }
                this.conflictResolvers.clear();
                CDOConflictResolver[] cDOConflictResolverArray = resolvers;
                int n = resolvers.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOConflictResolver resolver;
                    resolver = cDOConflictResolverArray[n2];
                    this.validateResolver(resolver);
                    this.conflictResolvers.add(resolver);
                    ++n2;
                }
            }
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent((IEvent)new ConflictResolversEventImpl(), listeners);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addConflictResolver(CDOConflictResolver resolver) {
            IListener[] listeners;
            boolean changed = false;
            List<CDOConflictResolver> list = this.conflictResolvers;
            synchronized (list) {
                if (!this.conflictResolvers.contains(resolver)) {
                    this.validateResolver(resolver);
                    this.conflictResolvers.add(resolver);
                    changed = true;
                }
            }
            if (changed && (listeners = this.getListeners()) != null) {
                this.fireEvent((IEvent)new ConflictResolversEventImpl(), listeners);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeConflictResolver(CDOConflictResolver resolver) {
            boolean changed = false;
            List<CDOConflictResolver> list = this.conflictResolvers;
            synchronized (list) {
                changed = this.conflictResolvers.remove(resolver);
            }
            if (changed) {
                resolver.setTransaction(null);
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new ConflictResolversEventImpl(), listeners);
                }
            }
        }

        public void disposeConflictResolvers() {
            try {
                CDOConflictResolver[] cDOConflictResolverArray = CDOTransactionImpl.this.options().getConflictResolvers();
                int n = cDOConflictResolverArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOConflictResolver resolver = cDOConflictResolverArray[n2];
                    try {
                        resolver.setTransaction(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void validateResolver(CDOConflictResolver resolver) {
            if (resolver.getTransaction() != null) {
                throw new IllegalArgumentException(Messages.getString("CDOTransactionImpl.17"));
            }
            resolver.setTransaction(CDOTransactionImpl.this);
        }

        public boolean isAutoReleaseLocksEnabled() {
            return this.autoReleaseLocksEnabled;
        }

        public void setAutoReleaseLocksEnabled(boolean on) {
            if (this.autoReleaseLocksEnabled != on) {
                this.autoReleaseLocksEnabled = on;
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new AutoReleaseLocksEventImpl(), listeners);
                }
            }
        }

        private final class AutoReleaseLocksEventImpl
        extends OptionsEvent
        implements CDOTransaction.Options.AutoReleaseLocksEvent {
            private static final long serialVersionUID = 1L;

            public AutoReleaseLocksEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ConflictResolversEventImpl
        extends OptionsEvent
        implements CDOTransaction.Options.ConflictResolversEvent {
            private static final long serialVersionUID = 1L;

            public ConflictResolversEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }
    }

    private final class StartedEvent
    extends CDOViewImpl.Event
    implements CDOTransactionStartedEvent {
        private static final long serialVersionUID = 1L;

        private StartedEvent() {
            super(CDOTransactionImpl.this);
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionStartedEvent[source={0}]", this.getSource());
        }
    }
}

