/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDODetachedRevisionDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.DanglingReferenceException;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOFeatureAnalyzer;
import org.eclipse.emf.cdo.view.CDOInvalidationPolicy;
import org.eclipse.emf.cdo.view.CDOObjectHandler;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDORevisionPrefetchingPolicy;
import org.eclipse.emf.cdo.view.CDOStaleReferencePolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewAdaptersNotifiedEvent;
import org.eclipse.emf.cdo.view.CDOViewEvent;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.CDODeltaNotificationImpl;
import org.eclipse.emf.internal.cdo.CDOInvalidationNotificationImpl;
import org.eclipse.emf.internal.cdo.CDOLegacyAdapter;
import org.eclipse.emf.internal.cdo.CDOMetaWrapper;
import org.eclipse.emf.internal.cdo.CDONotificationBuilder;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.CDOStore;
import org.eclipse.emf.internal.cdo.CDOURIHandler;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.query.CDOQueryImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOTransactionImpl;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.collection.FastList;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.OptionsEvent;
import org.eclipse.net4j.util.ref.ReferenceType;
import org.eclipse.net4j.util.ref.ReferenceValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOViewImpl
extends Lifecycle
implements InternalCDOView {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_VIEW, CDOViewImpl.class);
    private final boolean legacyModeEnabled;
    private int viewID;
    private InternalCDOSession session;
    private InternalCDOViewSet viewSet;
    private CDOBranchPoint branchPoint;
    private CDOURIHandler uriHandler = new CDOURIHandler(this);
    private CDOFeatureAnalyzer featureAnalyzer = CDOFeatureAnalyzer.NOOP;
    private ConcurrentMap<CDOID, InternalCDOObject> objects;
    private CDOStore store = new CDOStore(this);
    private ReentrantLock lock = new ReentrantLock(true);
    private ReentrantLock stateLock = new ReentrantLock(true);
    private CDOResourceImpl rootResource;
    private ChangeSubscriptionManager changeSubscriptionManager = this.createChangeSubscriptionManager();
    private AdapterManager adapterPolicyManager = this.createAdapterManager();
    private FastList<CDOObjectHandler> objectHandlers = new FastList<CDOObjectHandler>(){

        protected CDOObjectHandler[] newArray(int length) {
            return new CDOObjectHandler[length];
        }
    };
    private OptionsImpl options;
    @ReflectUtil.ExcludeFromDump
    private transient CDOID lastLookupID;
    @ReflectUtil.ExcludeFromDump
    private transient InternalCDOObject lastLookupObject;
    private long lastUpdateTime;
    @ReflectUtil.ExcludeFromDump
    private Object lastUpdateTimeLock = new Object();

    public CDOViewImpl(CDOBranch branch, long timeStamp) {
        this.branchPoint = branch.getPoint(timeStamp);
        this.legacyModeEnabled = CDOUtil.isLegacyModeDefault();
        this.options = this.createOptions();
    }

    @Override
    public OptionsImpl options() {
        return this.options;
    }

    public int getViewID() {
        return this.viewID;
    }

    @Override
    public void setViewID(int viewId) {
        this.viewID = viewId;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isLegacyModeEnabled() {
        return this.legacyModeEnabled;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.viewSet.getResourceSet();
    }

    @Override
    public InternalCDOViewSet getViewSet() {
        return this.viewSet;
    }

    @Override
    public void setViewSet(InternalCDOViewSet viewSet) {
        this.viewSet = viewSet;
        if (viewSet != null) {
            viewSet.getResourceSet().getURIConverter().getURIHandlers().add(0, (Object)this.getURIHandler());
        }
    }

    @Override
    public InternalCDOSession getSession() {
        return this.session;
    }

    @Override
    public void setSession(InternalCDOSession session) {
        this.session = session;
    }

    @Override
    public CDOStore getStore() {
        this.checkActive();
        return this.store;
    }

    @Override
    public CDOResourceImpl getRootResource() {
        this.checkActive();
        if (this.rootResource == null) {
            CDOID rootResourceID = this.session.getRepositoryInfo().getRootResourceID();
            this.rootResource = (CDOResourceImpl)this.getObject(rootResourceID);
            this.rootResource.setRoot(true);
            this.registerObject(this.rootResource);
            this.getResourceSet().getResources().add((Object)this.rootResource);
        }
        return this.rootResource;
    }

    private void clearRootResource() {
        if (this.rootResource != null) {
            this.getResourceSet().getResources().remove((Object)this.rootResource);
            this.deregisterObject(this.rootResource);
            this.rootResource = null;
        }
    }

    @Override
    public CDOURIHandler getURIHandler() {
        return this.uriHandler;
    }

    public CDOBranch getBranch() {
        return this.branchPoint.getBranch();
    }

    public long getTimeStamp() {
        return this.branchPoint.getTimeStamp();
    }

    @Override
    public boolean setBranch(CDOBranch branch) {
        return this.setBranchPoint(branch, this.getTimeStamp());
    }

    @Override
    public boolean setTimeStamp(long timeStamp) {
        return this.setBranchPoint(this.getBranch(), timeStamp);
    }

    @Override
    public boolean setBranchPoint(CDOBranch branch, long timeStamp) {
        this.checkActive();
        return this.setBranchPoint(branch.getPoint(timeStamp));
    }

    @Override
    public boolean setBranchPoint(CDOBranchPoint branchPoint) {
        long timeStamp = branchPoint.getTimeStamp();
        long creationTimeStamp = this.getSession().getRepositoryInfo().getCreationTime();
        if (timeStamp != 0L && timeStamp < creationTimeStamp) {
            throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) < repository creation time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)creationTimeStamp)));
        }
        if (branchPoint.equals(this.branchPoint)) {
            return false;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Changing view target to {0}", new Object[]{branchPoint});
        }
        List<InternalCDOObject> invalidObjects = this.getInvalidObjects(timeStamp);
        CDOSessionProtocol sessionProtocol = this.getSession().getSessionProtocol();
        boolean[] existanceFlags = sessionProtocol.changeView(this.viewID, branchPoint, invalidObjects);
        this.basicSetBranchPoint(branchPoint);
        int i = 0;
        for (InternalCDOObject invalidObject : invalidObjects) {
            boolean existanceFlag;
            if (existanceFlag = existanceFlags[i++]) {
                CDOStateMachine.INSTANCE.invalidate(invalidObject, null, 0L);
                continue;
            }
            CDOStateMachine.INSTANCE.detachRemote(invalidObject);
        }
        this.clearRootResource();
        IListener[] listeners = this.getListeners();
        if (listeners != null) {
            this.fireViewTargetChangedEvent(listeners);
        }
        return true;
    }

    protected void basicSetBranchPoint(CDOBranchPoint branchPoint) {
        this.branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)branchPoint);
    }

    protected void fireViewTargetChangedEvent(IListener[] listeners) {
        this.fireEvent(new ViewTargetChangedEvent(this.branchPoint), listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InternalCDOObject> getInvalidObjects(long timeStamp) {
        ArrayList<InternalCDOObject> result = new ArrayList<InternalCDOObject>();
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            for (InternalCDOObject object : this.objects.values()) {
                InternalCDORevision revision = object.cdoRevision();
                if (revision == null) {
                    revision = this.getRevision(object.cdoID(), false);
                }
                if (revision != null && revision.isValid(timeStamp)) continue;
                result.add(object);
            }
        }
        return result;
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public ReentrantLock getStateLock() {
        return this.stateLock;
    }

    public Object getObjectsLock() {
        return this.objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, long timeout) throws InterruptedException {
        this.checkActive();
        this.checkState(this.getTimeStamp() == 0L, "Locking not supported for historial views");
        Object object = this.session.getInvalidationLock();
        synchronized (object) {
            this.getLock().lock();
            try {
                HashMap<CDOID, InternalCDORevision> revisions = new HashMap<CDOID, InternalCDORevision>();
                for (CDOObject cDOObject : objects) {
                    if (FSMUtil.isNew(cDOObject)) continue;
                    InternalCDORevision revision = (InternalCDORevision)cDOObject.cdoRevision();
                    if (revision == null) {
                        revision = CDOStateMachine.INSTANCE.read((InternalCDOObject)cDOObject);
                    }
                    revisions.put(revision.getID(), revision);
                }
                HashMap<CDOBranch, Map<CDOID, InternalCDORevision>> hashMap = new HashMap<CDOBranch, Map<CDOID, InternalCDORevision>>();
                hashMap.put(this.getBranch(), revisions);
                CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                long lastUpdateTime = this.session.getLastUpdateTime();
                CDOSessionProtocol.RefreshSessionResult result = sessionProtocol.lockObjects(lastUpdateTime, hashMap, this.viewID, lockType, timeout);
                this.registerPackageUnits(result.getPackageUnits());
                CDOViewImpl view = this;
                List<InternalCDOView> views = Collections.singletonList(view);
                this.session.processRefreshSessionResult(result, this.getBranch(), views, hashMap);
            }
            finally {
                this.getLock().unlock();
            }
        }
    }

    private void registerPackageUnits(List<CDOPackageUnit> packageUnits) {
        InternalCDOPackageRegistry packageRegistry = this.session.getPackageRegistry();
        for (CDOPackageUnit newPackageUnit : packageUnits) {
            packageRegistry.putPackageUnit((InternalCDOPackageUnit)newPackageUnit);
        }
    }

    @Override
    public void unlockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType) {
        this.checkActive();
        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
        sessionProtocol.unlockObjects(this, objects, lockType);
    }

    @Override
    public void unlockObjects() {
        this.unlockObjects(null, null);
    }

    @Override
    public boolean isObjectLocked(CDOObject object, IRWLockManager.LockType lockType, boolean byOthers) {
        this.checkActive();
        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
        return sessionProtocol.isObjectLocked(this, object, lockType, byOthers);
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean hasConflict() {
        return false;
    }

    @Override
    public CDOFeatureAnalyzer getFeatureAnalyzer() {
        return this.featureAnalyzer;
    }

    @Override
    public void setFeatureAnalyzer(CDOFeatureAnalyzer featureAnalyzer) {
        this.featureAnalyzer = featureAnalyzer == null ? CDOFeatureAnalyzer.NOOP : featureAnalyzer;
    }

    @Override
    public InternalCDOTransaction toTransaction() {
        this.checkActive();
        if (this instanceof InternalCDOTransaction) {
            return (InternalCDOTransaction)((Object)this);
        }
        throw new ReadOnlyException(MessageFormat.format(Messages.getString("CDOViewImpl.0"), this));
    }

    @Override
    public boolean hasResource(String path) {
        this.checkActive();
        try {
            this.getResourceNodeID(path);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public CDOQuery createQuery(String language, String queryString) {
        this.checkActive();
        return new CDOQueryImpl(this, language, queryString);
    }

    @Override
    public CDOResourceNode getResourceNode(String path) {
        CDOID id = this.getResourceNodeID(path);
        if (id == null) {
            return null;
        }
        InternalCDOObject object = this.getObject(id);
        if (object instanceof CDOResourceNode) {
            return (CDOResourceNode)((Object)object);
        }
        return null;
    }

    @Override
    public CDOID getResourceNodeID(String path) {
        if (StringUtil.isEmpty((String)path)) {
            throw new IllegalArgumentException(Messages.getString("CDOViewImpl.1"));
        }
        CDOID folderID = null;
        if (CDOURIUtil.SEGMENT_SEPARATOR.equals(path)) {
            folderID = this.getResourceNodeIDChecked(null, null);
        } else {
            List<String> names = CDOURIUtil.analyzePath(path);
            for (String name : names) {
                folderID = this.getResourceNodeIDChecked(folderID, name);
            }
        }
        return folderID;
    }

    private CDOID getResourceNodeIDChecked(CDOID folderID, String name) {
        if ((folderID = this.getResourceNodeID(folderID, name)) == null) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.2"), name));
        }
        return folderID;
    }

    protected CDOResourceNode getResourceNode(CDOID folderID, String name) {
        try {
            CDOID id = this.getResourceNodeID(folderID, name);
            return (CDOResourceNode)((Object)this.getObject(id));
        }
        catch (CDOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CDOException((Throwable)ex);
        }
    }

    protected CDOID getResourceNodeID(CDOID folderID, String name) {
        if (folderID == null) {
            return this.getRootOrTopLevelResourceNodeID(name);
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.getString("CDOViewImpl.3"));
        }
        InternalCDORevision folderRevision = this.getLocalRevision(folderID);
        EClass resourceFolderClass = EresourcePackage.eINSTANCE.getCDOResourceFolder();
        if (folderRevision.getEClass() != resourceFolderClass) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.4"), folderID));
        }
        EReference nodesFeature = EresourcePackage.eINSTANCE.getCDOResourceFolder_Nodes();
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        int size = folderRevision.data().size((EStructuralFeature)nodesFeature);
        int i = 0;
        while (i < size) {
            Object value = folderRevision.data().get((EStructuralFeature)nodesFeature, i);
            value = this.getStore().resolveProxy(folderRevision, (EStructuralFeature)nodesFeature, i, value);
            InternalCDORevision childRevision = this.getLocalRevision((CDOID)this.convertObjectToID(value));
            if (name.equals(childRevision.data().get((EStructuralFeature)nameFeature, 0))) {
                return childRevision.getID();
            }
            ++i;
        }
        throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.5"), name));
    }

    protected CDOID getRootOrTopLevelResourceNodeID(String name) {
        CDOQuery resourceQuery = this.createResourcesQuery(null, name, true);
        resourceQuery.setMaxResults(1);
        List<CDOID> ids = resourceQuery.getResult(CDOID.class);
        if (ids.isEmpty()) {
            if (name == null) {
                throw new CDOException(Messages.getString("CDOViewImpl.6"));
            }
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.7"), name));
        }
        if (ids.size() > 1) {
            throw new ImplementationError(Messages.getString("CDOViewImpl.8"));
        }
        return ids.get(0);
    }

    protected InternalCDORevision getLocalRevision(CDOID id) {
        InternalCDORevision revision = null;
        InternalCDOObject object = this.getObject(id, false);
        if (object != null && object.cdoState() != CDOState.PROXY) {
            revision = object.cdoRevision();
        }
        if (revision == null) {
            revision = this.getRevision(id, true);
        }
        if (revision == null) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.9"), id));
        }
        return revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCDOObject[] getObjectsArray() {
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            return this.objects.values().toArray(new InternalCDOObject[this.objects.size()]);
        }
    }

    @Override
    public CDOResource getResource(String path) {
        return this.getResource(path, true);
    }

    @Override
    public CDOResource getResource(String path, boolean loadInDemand) {
        this.checkActive();
        URI uri = CDOURIUtil.createResourceURI(this, path);
        return (CDOResource)this.getResourceSet().getResource(uri, loadInDemand);
    }

    @Override
    public List<CDOResourceNode> queryResources(CDOResourceFolder folder, String name, boolean exactMatch) {
        CDOQuery resourceQuery = this.createResourcesQuery(folder, name, exactMatch);
        return resourceQuery.getResult(CDOResourceNode.class);
    }

    @Override
    public CloseableIterator<CDOResourceNode> queryResourcesAsync(CDOResourceFolder folder, String name, boolean exactMatch) {
        CDOQuery resourceQuery = this.createResourcesQuery(folder, name, exactMatch);
        return resourceQuery.getResultAsync(CDOResourceNode.class);
    }

    private CDOQuery createResourcesQuery(CDOResourceFolder folder, String name, boolean exactMatch) {
        this.checkActive();
        CDOQuery query = this.createQuery("resources", name);
        query.setParameter("folder", folder == null ? null : folder.cdoID());
        query.setParameter("exactMatch", exactMatch);
        return query;
    }

    @Override
    public List<CDOObjectReference> queryXRefs(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        CDOQuery xrefsQuery = this.createXRefsQuery(targetObjects, sourceReferences);
        return xrefsQuery.getResult(CDOObjectReference.class);
    }

    @Override
    public CloseableIterator<CDOObjectReference> queryXRefsAsync(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        CDOQuery xrefsQuery = this.createXRefsQuery(targetObjects, sourceReferences);
        return xrefsQuery.getResultAsync(CDOObjectReference.class);
    }

    private CDOQuery createXRefsQuery(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        this.checkActive();
        String string = this.createXRefsQueryString(targetObjects);
        CDOQuery query = this.createQuery("xrefs", string);
        if (sourceReferences.length != 0) {
            string = this.createXRefsQueryParameter(sourceReferences);
            query.setParameter("sourceReferences", string);
        }
        return query;
    }

    private String createXRefsQueryString(Set<CDOObject> targetObjects) {
        StringBuilder builder = new StringBuilder();
        for (CDOObject target : targetObjects) {
            if (FSMUtil.isTransient(target)) {
                throw new IllegalArgumentException("Cross referencing for transient objects not supported " + target);
            }
            CDOID id = target.cdoID();
            if (id.isTemporary()) {
                throw new IllegalArgumentException("Cross referencing for uncommitted new objects not supported " + target);
            }
            if (builder.length() != 0) {
                builder.append("|");
            }
            builder.append(id.toURIFragment());
            if (id instanceof CDOClassifierRef.Provider) continue;
            builder.append("|");
            CDOClassifierRef classifierRef = new CDOClassifierRef((EClassifier)target.eClass());
            builder.append(classifierRef.getURI());
        }
        return builder.toString();
    }

    private String createXRefsQueryParameter(EReference[] sourceReferences) {
        StringBuilder builder = new StringBuilder();
        EReference[] eReferenceArray = sourceReferences;
        int n = sourceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            EReference sourceReference = eReferenceArray[n2];
            if (builder.length() != 0) {
                builder.append("|");
            }
            CDOClassifierRef classifierRef = new CDOClassifierRef((EClassifier)sourceReference.eClass());
            builder.append(classifierRef.getURI());
            builder.append("|");
            builder.append(sourceReference.getName());
            ++n2;
        }
        return builder.toString();
    }

    public CDOResourceImpl getResource(CDOID resourceID) {
        if (CDOIDUtil.isNull((CDOID)resourceID)) {
            throw new IllegalArgumentException("resourceID: " + resourceID);
        }
        return (CDOResourceImpl)this.getObject(resourceID);
    }

    public InternalCDOObject newInstance(EClass eClass) {
        EObject eObject = EcoreUtil.create((EClass)eClass);
        return FSMUtil.adapt(eObject, this);
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, boolean loadOnDemand) {
        InternalCDORevisionManager revisionManager = this.session.getRevisionManager();
        int initialChunkSize = this.session.options().getCollectionLoadingPolicy().getInitialChunkSize();
        return (InternalCDORevision)revisionManager.getRevision(id, (CDOBranchPoint)this, initialChunkSize, 0, loadOnDemand);
    }

    @Override
    public void prefetchRevisions(CDOID id, int depth) {
        this.checkArg(depth != 0, "Prefetch depth must not be zero");
        int initialChunkSize = this.session.options().getCollectionLoadingPolicy().getInitialChunkSize();
        this.prefetchRevisions(id, depth, initialChunkSize);
    }

    protected void prefetchRevisions(CDOID id, int depth, int initialChunkSize) {
        InternalCDORevisionManager revisionManager = this.session.getRevisionManager();
        revisionManager.getRevision(id, (CDOBranchPoint)this, initialChunkSize, depth, true);
    }

    @Override
    public InternalCDOObject getObject(CDOID id) {
        return this.getObject(id, true);
    }

    /*
     * Exception decompiling
     */
    @Override
    public InternalCDOObject getObject(CDOID id, boolean loadOnDemand) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <T extends EObject> T getObject(T objectFromDifferentView) {
        this.checkActive();
        CDOObject object = CDOUtil.getCDOObject(objectFromDifferentView);
        CDOView view = object.cdoView();
        if (view != this) {
            if (!view.getSession().getRepositoryInfo().getUUID().equals(this.session.getRepositoryInfo().getUUID())) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewImpl.11"), objectFromDifferentView));
            }
            CDOID id = object.cdoID();
            InternalCDOObject contextified = this.getObject(id, true);
            EObject cast = CDOUtil.getEObject(contextified);
            return (T)cast;
        }
        return objectFromDifferentView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isObjectRegistered(CDOID id) {
        this.checkActive();
        if (CDOIDUtil.isNull((CDOID)id)) {
            return false;
        }
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            return this.objects.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOObject removeObject(CDOID id) {
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            if (id.equals(this.lastLookupID)) {
                this.lastLookupID = null;
                this.lastLookupObject = null;
            }
            return (InternalCDOObject)this.objects.remove(id);
        }
    }

    private InternalCDOObject createMetaObject(CDOIDMeta id) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating meta object for " + id);
        }
        InternalCDOPackageRegistry packageRegistry = this.session.getPackageRegistry();
        InternalEObject metaInstance = packageRegistry.getMetaInstanceMapper().lookupMetaInstance((CDOID)id);
        return new CDOMetaWrapper(this, metaInstance, (CDOID)id);
    }

    private InternalCDOObject createObject(CDOID id) {
        InternalCDORevision revision;
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating object for " + id);
        }
        if ((revision = this.getRevision(id, true)) == null) {
            throw new ObjectNotFoundException(id, (CDOBranchPoint)this);
        }
        EClass eClass = revision.getEClass();
        InternalCDOObject object = CDOModelUtil.isResource((EClass)eClass) && !id.equals(this.session.getRepositoryInfo().getRootResourceID()) ? (InternalCDOObject)((Object)this.newResourceInstance(revision)) : this.newInstance(eClass);
        this.cleanObject(object, revision);
        return object;
    }

    private CDOResource newResourceInstance(InternalCDORevision revision) {
        String path = this.getResourcePath(revision);
        return this.getResource(path, true);
    }

    private String getResourcePath(InternalCDORevision revision) {
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        CDOID folderID = (CDOID)revision.data().getContainerID();
        String name = (String)revision.data().get((EStructuralFeature)nameFeature, 0);
        if (CDOIDUtil.isNull((CDOID)folderID)) {
            if (name == null) {
                return CDOURIUtil.SEGMENT_SEPARATOR;
            }
            return name;
        }
        InternalCDOObject object = this.getObject(folderID, true);
        if (object instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)((Object)object);
            String path = folder.getPath();
            return String.valueOf(path) + CDOURIUtil.SEGMENT_SEPARATOR + name;
        }
        throw new ImplementationError(MessageFormat.format(Messages.getString("CDOViewImpl.14"), object));
    }

    protected void cleanObject(InternalCDOObject object, InternalCDORevision revision) {
        object.cdoInternalCleanup();
        object.cdoInternalSetView(this);
        object.cdoInternalSetRevision((CDORevision)revision);
        object.cdoInternalSetID(revision.getID());
        object.cdoInternalSetState(CDOState.CLEAN);
        object.cdoInternalPostLoad();
    }

    public CDOID provideCDOID(Object idOrObject) {
        Object shouldBeCDOID = this.convertObjectToID(idOrObject);
        if (shouldBeCDOID instanceof CDOID) {
            CDOID id = (CDOID)shouldBeCDOID;
            if (TRACER.isEnabled() && id != idOrObject) {
                TRACER.format("Converted object to CDOID: {0} --> {1}", new Object[]{idOrObject, id});
            }
            return id;
        }
        if (idOrObject instanceof InternalEObject) {
            InternalCDOObject object;
            InternalEObject eObject = (InternalEObject)idOrObject;
            if (eObject instanceof InternalCDOObject && (object = (InternalCDOObject)idOrObject).cdoView() != null && FSMUtil.isNew(object)) {
                String uri = EcoreUtil.getURI((EObject)eObject).toString();
                return CDOIDUtil.createTempObjectExternal((String)uri);
            }
            Resource eResource = eObject.eResource();
            if (!(eResource == null || eResource instanceof CDOResource && ((CDOResource)eResource).cdoState() == CDOState.TRANSIENT)) {
                String uri = EcoreUtil.getURI((EObject)eObject).toString();
                return CDOIDUtil.createExternal((String)uri);
            }
            throw new DanglingReferenceException((EObject)eObject);
        }
        throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOViewImpl.16"), idOrObject.getClass().getName()));
    }

    @Override
    public Object convertObjectToID(Object potentialObject) {
        return this.convertObjectToID(potentialObject, false);
    }

    @Override
    public Object convertObjectToID(Object potentialObject, boolean onlyPersistedID) {
        if (potentialObject instanceof CDOID) {
            return potentialObject;
        }
        if (potentialObject instanceof InternalEObject) {
            if (potentialObject instanceof InternalCDOObject) {
                InternalCDOObject object = (InternalCDOObject)potentialObject;
                CDOID id = this.getID(object, onlyPersistedID);
                if (id != null) {
                    return id;
                }
            } else {
                try {
                    CDOLegacyAdapter object = FSMUtil.getLegacyAdapter((EList<Adapter>)((InternalEObject)potentialObject).eAdapters());
                    if (object != null) {
                        CDOID id = this.getID(object, onlyPersistedID);
                        if (id != null) {
                            return id;
                        }
                        potentialObject = object;
                    }
                }
                catch (Throwable ex) {
                    OM.LOG.warn(ex);
                }
            }
        }
        return potentialObject;
    }

    protected CDOID getID(InternalCDOObject object, boolean onlyPersistedID) {
        if (onlyPersistedID && (FSMUtil.isTransient(object) || FSMUtil.isNew(object))) {
            return null;
        }
        InternalCDOView view = object.cdoView();
        if (view == this) {
            return object.cdoID();
        }
        if (view != null && view.getSession() == this.getSession()) {
            return object.cdoID();
        }
        return null;
    }

    @Override
    public Object convertIDToObject(Object potentialID) {
        if (potentialID instanceof CDOID) {
            if (potentialID == CDOID.NULL) {
                return null;
            }
            CDOID id = (CDOID)potentialID;
            if (id.isExternal()) {
                return this.getResourceSet().getEObject(URI.createURI((String)id.toURIFragment()), true);
            }
            InternalCDOObject result = this.getObject(id, true);
            if (result == null) {
                throw new ImplementationError(MessageFormat.format(Messages.getString("CDOViewImpl.17"), id));
            }
            return result.cdoInternalInstance();
        }
        return potentialID;
    }

    @Override
    public void attachResource(CDOResourceImpl resource) {
        if (!resource.isExisting()) {
            throw new ReadOnlyException(MessageFormat.format(Messages.getString("CDOViewImpl.18"), this));
        }
        resource.cdoInternalSetView(this);
        resource.cdoInternalSetState(CDOState.PROXY);
    }

    @Override
    public void registerProxyResource(CDOResourceImpl resource) {
        URI uri = resource.getURI();
        String path = CDOURIUtil.extractResourcePath(uri);
        boolean isRoot = CDOURIUtil.SEGMENT_SEPARATOR.equals(path);
        try {
            CDOID id = isRoot ? this.session.getRepositoryInfo().getRootResourceID() : this.getResourceNodeID(path);
            resource.cdoInternalSetID(id);
            this.registerObject(resource);
            if (isRoot) {
                resource.setRoot(true);
                this.rootResource = resource;
            }
        }
        catch (Exception ex) {
            throw new InvalidURIException(uri, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObject(InternalCDOObject object) {
        InternalCDOObject old;
        if (TRACER.isEnabled()) {
            TRACER.format("Registering {0}", new Object[]{object});
        }
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            old = this.objects.put(object.cdoID(), object);
        }
        if (old != null) {
            if (old != object) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOViewImpl.20"), object));
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Object was already registered: {0}", new Object[]{object});
            }
        }
    }

    @Override
    public void deregisterObject(InternalCDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("Deregistering {0}", new Object[]{object});
        }
        this.removeObject(object.cdoID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remapObject(CDOID oldID) {
        CDOID newID;
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            InternalCDOObject object = (InternalCDOObject)this.objects.remove(oldID);
            newID = object.cdoID();
            this.objects.put(newID, object);
            if (this.lastLookupID == oldID) {
                this.lastLookupID = null;
                this.lastLookupObject = null;
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Remapping {0} --> {1}", new Object[]{oldID, newID});
        }
    }

    @Override
    public void addObjectHandler(CDOObjectHandler handler) {
        this.objectHandlers.add((Object)handler);
    }

    @Override
    public void removeObjectHandler(CDOObjectHandler handler) {
        this.objectHandlers.remove((Object)handler);
    }

    @Override
    public CDOObjectHandler[] getObjectHandlers() {
        return (CDOObjectHandler[])this.objectHandlers.get();
    }

    @Override
    public void handleObjectStateChanged(InternalCDOObject object, CDOState oldState, CDOState newState) {
        CDOObjectHandler[] handlers = this.getObjectHandlers();
        if (handlers != null) {
            int i = 0;
            while (i < handlers.length) {
                CDOObjectHandler handler = handlers[i];
                handler.objectStateChanged(this, object, oldState, newState);
                ++i;
            }
        }
    }

    @Override
    public void invalidate(long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, Map<CDOID, InternalCDORevision> oldRevisions) {
        Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts = null;
        ArrayList<CDORevisionDelta> deltas = new ArrayList<CDORevisionDelta>();
        HashSet<InternalCDOObject> changedObjects = new HashSet<InternalCDOObject>();
        HashSet<CDOObject> detachedObjects = new HashSet<CDOObject>();
        try {
            this.lock.lock();
            conflicts = this.invalidate(lastUpdateTime, allChangedObjects, allDetachedObjects, deltas, changedObjects, detachedObjects);
        }
        finally {
            this.lock.unlock();
        }
        this.sendInvalidationNotifications(changedObjects, detachedObjects);
        this.fireInvalidationEvent(lastUpdateTime, Collections.unmodifiableSet(changedObjects), Collections.unmodifiableSet(detachedObjects));
        if (conflicts != null) {
            if (this instanceof CDOTransactionImpl) {
                CDOTransactionImpl transaction = (CDOTransactionImpl)this;
                transaction.handleConflicts(conflicts, deltas);
            } else {
                InternalCDOTransaction transaction = (InternalCDOTransaction)((Object)this);
                transaction.handleConflicts(conflicts.keySet());
            }
        }
        if (!deltas.isEmpty() || !detachedObjects.isEmpty()) {
            this.sendDeltaNotifications(deltas, detachedObjects, oldRevisions);
        }
        this.fireAdaptersNotifiedEvent(lastUpdateTime);
        this.setLastUpdateTime(lastUpdateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> invalidate(long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, List<CDORevisionDelta> deltas, Set<InternalCDOObject> changedObjects, Set<CDOObject> detachedObjects) {
        HashMap<InternalCDOObject, Pair> conflicts = null;
        for (CDORevisionKey cDORevisionKey : allChangedObjects) {
            CDORevisionDelta delta = null;
            if (cDORevisionKey instanceof CDORevisionDelta) {
                delta = (CDORevisionDelta)cDORevisionKey;
                if (this instanceof CDOTransaction) {
                    delta = new CDORevisionDeltaImpl(delta, true);
                }
                deltas.add(delta);
            }
            InternalCDOObject changedObject = null;
            ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
            synchronized (concurrentMap) {
                changedObject = (InternalCDOObject)this.objects.get(cDORevisionKey.getID());
            }
            if (changedObject == null) continue;
            Pair oldInfo = new Pair((Object)changedObject.cdoRevision(), (Object)delta);
            CDOStateMachine.INSTANCE.invalidate(changedObject, cDORevisionKey, lastUpdateTime);
            changedObjects.add(changedObject);
            if (!changedObject.cdoConflict()) continue;
            if (conflicts == null) {
                conflicts = new HashMap();
            }
            conflicts.put(changedObject, oldInfo);
        }
        for (CDOIDAndVersion cDOIDAndVersion : allDetachedObjects) {
            InternalCDOObject detachedObject = this.removeObject(cDOIDAndVersion.getID());
            if (detachedObject == null) continue;
            Pair oldInfo = new Pair((Object)detachedObject.cdoRevision(), (Object)CDODetachedRevisionDeltaImpl.DETACHED);
            CDOStateMachine.INSTANCE.detachRemote(detachedObject);
            detachedObjects.add(detachedObject);
            if (!detachedObject.cdoConflict()) continue;
            if (conflicts == null) {
                conflicts = new HashMap<InternalCDOObject, Pair>();
            }
            conflicts.put(detachedObject, oldInfo);
        }
        return conflicts;
    }

    private void sendInvalidationNotifications(Set<InternalCDOObject> dirtyObjects, Set<CDOObject> detachedObjects) {
        if (this.options().isInvalidationNotificationEnabled()) {
            CDOInvalidationNotificationImpl notification;
            for (InternalCDOObject dirtyObject : dirtyObjects) {
                if (!dirtyObject.eNotificationRequired()) continue;
                notification = new CDOInvalidationNotificationImpl(dirtyObject);
                dirtyObject.eNotify(notification);
            }
            for (CDOObject detachedObject : detachedObjects) {
                if (!((InternalCDOObject)detachedObject).eNotificationRequired()) continue;
                notification = new CDOInvalidationNotificationImpl(detachedObject);
                detachedObject.eNotify(notification);
            }
        }
    }

    private void fireInvalidationEvent(long timeStamp, Set<? extends CDOObject> dirtyObjects, Set<? extends CDOObject> detachedObjects) {
        IListener[] listeners;
        if (!(dirtyObjects.isEmpty() && detachedObjects.isEmpty() || (listeners = this.getListeners()) == null)) {
            this.fireEvent(new InvalidationEvent(timeStamp, dirtyObjects, detachedObjects), listeners);
        }
    }

    @Override
    public void fireAdaptersNotifiedEvent(long timeStamp) {
        this.fireEvent(new AdaptersNotifiedEvent(timeStamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDeltaNotifications(List<CDORevisionDelta> deltas, Set<CDOObject> detachedObjects, Map<CDOID, InternalCDORevision> oldRevisions) {
        if (deltas != null) {
            CDONotificationBuilder builder = new CDONotificationBuilder(this);
            for (CDORevisionDelta delta : deltas) {
                NotificationChain notification;
                InternalCDOObject object;
                CDOID id = delta.getID();
                ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
                synchronized (concurrentMap) {
                    object = (InternalCDOObject)this.objects.get(id);
                }
                if (object == null || !object.eNotificationRequired()) continue;
                InternalCDORevision oldRevision = null;
                if (oldRevisions != null) {
                    oldRevision = oldRevisions.get(id);
                }
                if ((notification = builder.buildNotification(object, oldRevision, delta, detachedObjects)) == null) continue;
                notification.dispatch();
            }
        }
        if (detachedObjects != null) {
            for (CDOObject detachedObject : detachedObjects) {
                InternalCDOObject object = (InternalCDOObject)detachedObject;
                if (!object.eNotificationRequired()) continue;
                CDODeltaNotificationImpl notification = new CDODeltaNotificationImpl((InternalEObject)object, 111, -1, null, null);
                notification.dispatch();
            }
            this.getChangeSubscriptionManager().handleDetachedObjects(detachedObjects);
        }
    }

    private boolean isLocked(InternalCDOObject object) {
        if (object.cdoWriteLock().isLocked()) {
            return true;
        }
        return object.cdoReadLock().isLocked();
    }

    protected ChangeSubscriptionManager createChangeSubscriptionManager() {
        return new ChangeSubscriptionManager(this);
    }

    public AdapterManager getAdapterManager() {
        return this.adapterPolicyManager;
    }

    protected AdapterManager createAdapterManager() {
        return new AdapterManager();
    }

    @Override
    public void handleAddAdapter(InternalCDOObject eObject, Adapter adapter) {
        if (!FSMUtil.isNew(eObject)) {
            this.subscribe(eObject, adapter);
        }
        this.adapterPolicyManager.attachAdapter(eObject, adapter);
    }

    @Override
    public void handleRemoveAdapter(InternalCDOObject eObject, Adapter adapter) {
        if (!FSMUtil.isNew(eObject)) {
            this.unsubscribe(eObject, adapter);
        }
        this.adapterPolicyManager.detachAdapter(eObject, adapter);
    }

    @Override
    public void subscribe(EObject eObject, Adapter adapter) {
        this.changeSubscriptionManager.subscribe(eObject, adapter);
    }

    @Override
    public void unsubscribe(EObject eObject, Adapter adapter) {
        this.changeSubscriptionManager.unsubscribe(eObject, adapter);
    }

    @Override
    public boolean hasSubscription(CDOID id) {
        return this.changeSubscriptionManager.getSubcribeObject(id) != null;
    }

    protected ChangeSubscriptionManager getChangeSubscriptionManager() {
        return this.changeSubscriptionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reload(CDOObject ... objects) {
        Object object;
        ArrayList<Object> internalObjects;
        if (objects != null && objects.length != 0) {
            internalObjects = new ArrayList(objects.length);
            CDOObject[] cDOObjectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                object = cDOObjectArray[n2];
                if (object instanceof InternalCDOObject) {
                    internalObjects.add((InternalCDOObject)object);
                }
                ++n2;
            }
        } else {
            object = this.objects;
            synchronized (object) {
                internalObjects = new ArrayList(this.objects.values());
            }
        }
        int result = internalObjects.size();
        if (result != 0) {
            CDOStateMachine.INSTANCE.reload(internalObjects.toArray(new InternalCDOObject[result]));
        }
        return result;
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    public int compareTo(CDOBranchPoint o) {
        return this.branchPoint.compareTo((Object)o);
    }

    public String toString() {
        int sessionID = this.session == null ? 0 : this.session.getSessionID();
        return MessageFormat.format("{0}[{1}:{2}]", this.getClassName(), sessionID, this.viewID);
    }

    protected String getClassName() {
        return "CDOView";
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof ResourceSet;
    }

    public Notifier getTarget() {
        return this.getResourceSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectViewedRevisions(Map<CDOID, InternalCDORevision> revisions) {
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            for (InternalCDOObject object : this.objects.values()) {
                InternalCDORevision revision;
                CDOID id;
                CDOState state = object.cdoState();
                if (state != CDOState.CLEAN && state != CDOState.DIRTY && state != CDOState.CONFLICT || revisions.containsKey(id = object.cdoID()) || (revision = CDOStateMachine.INSTANCE.readNoLoad(object)) == null) continue;
                revisions.put(id, revision);
            }
        }
    }

    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.session, "session");
        this.checkState(this.viewID > 0, "viewID");
    }

    protected void doActivate() throws Exception {
        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
        sessionProtocol.openView(this.viewID, (CDOBranchPoint)this, this.isReadOnly());
    }

    protected void doDeactivate() throws Exception {
        try {
            CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
            if (LifecycleUtil.isActive((Object)sessionProtocol)) {
                sessionProtocol.closeView(this.viewID);
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        try {
            this.session.viewDetached(this);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        this.objects = null;
        this.store = null;
        this.viewSet = null;
        this.changeSubscriptionManager = null;
        this.featureAnalyzer = null;
        this.lastLookupID = null;
        this.lastLookupObject = null;
        this.options = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastUpdateTime() {
        Object object = this.lastUpdateTimeLock;
        synchronized (object) {
            return this.lastUpdateTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
        Object object = this.lastUpdateTimeLock;
        synchronized (object) {
            if (this.lastUpdateTime < lastUpdateTime) {
                this.lastUpdateTime = lastUpdateTime;
            }
            this.lastUpdateTimeLock.notifyAll();
        }
    }

    @Override
    public void waitForUpdate(long updateTime) {
        this.waitForUpdate(updateTime, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean waitForUpdate(long updateTime, long timeoutMillis) {
        long end = timeoutMillis == -1L ? Long.MAX_VALUE : System.currentTimeMillis() + timeoutMillis;
        while (true) {
            Object object = this.lastUpdateTimeLock;
            synchronized (object) {
                if (this.lastUpdateTime >= updateTime) {
                    return true;
                }
                long now = System.currentTimeMillis();
                if (now >= end) {
                    return false;
                }
                try {
                    this.lastUpdateTimeLock.wait(end - now);
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        }
    }

    protected class AdapterManager {
        private Set<CDOObject> objects = new HashBag();

        protected AdapterManager() {
        }

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy() != CDOAdapterPolicy.NONE) {
                for (CDOObject object : commitContext.getNewObjects().values()) {
                    this.attachObject(object);
                }
                for (CDOObject object : commitContext.getDetachedObjects().values()) {
                    this.detachObject(object);
                }
            }
        }

        protected synchronized void attachObject(CDOObject object) {
            if (((InternalEObject)object).eNotificationRequired()) {
                CDOAdapterPolicy strongReferencePolicy = CDOViewImpl.this.options().getStrongReferencePolicy();
                int count = 0;
                for (Adapter adapter : object.eAdapters()) {
                    if (!strongReferencePolicy.isValid(object, adapter)) continue;
                    ++count;
                }
                int i = 0;
                while (i < count) {
                    this.objects.add(object);
                    ++i;
                }
            }
        }

        protected synchronized void detachObject(CDOObject object) {
            while (this.objects.remove(object)) {
            }
        }

        protected synchronized void attachAdapter(CDOObject object, Adapter adapter) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy().isValid(object, adapter)) {
                this.objects.add(object);
            }
        }

        protected synchronized void detachAdapter(CDOObject object, Adapter adapter) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy().isValid(object, adapter)) {
                this.objects.remove(object);
            }
        }

        public synchronized void reset() {
            Set<CDOObject> oldObject = this.objects;
            this.objects = new HashBag();
            if (CDOViewImpl.this.options().getStrongReferencePolicy() != CDOAdapterPolicy.NONE) {
                InternalCDOObject[] objects = CDOViewImpl.this.getObjectsArray();
                int i = 0;
                while (i < objects.length) {
                    InternalCDOObject object = objects[i];
                    this.attachObject(object);
                    ++i;
                }
            }
            oldObject.clear();
        }
    }

    private final class AdaptersNotifiedEvent
    extends Event
    implements CDOViewAdaptersNotifiedEvent {
        private static final long serialVersionUID = 1L;
        private long timeStamp;

        public AdaptersNotifiedEvent(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public String toString() {
            return "CDOViewAdaptersNotifiedEvent: " + this.timeStamp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ChangeSubscriptionManager {
        private CDOViewImpl view;
        private Map<CDOID, SubscribeEntry> subscriptions = new HashMap<CDOID, SubscribeEntry>();

        public ChangeSubscriptionManager(CDOViewImpl view) {
            this.view = view;
        }

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            this.handleNewObjects(commitContext.getNewObjects().values());
            this.handleDetachedObjects(commitContext.getDetachedObjects().values());
        }

        public void subscribe(EObject eObject, Adapter adapter) {
            this.subscribe(eObject, adapter, 1);
        }

        public void unsubscribe(EObject eObject, Adapter adapter) {
            this.subscribe(eObject, adapter, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyChangeSubcriptionPolicy() {
            boolean policiesPresent = this.view.options().hasChangeSubscriptionPolicies();
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                this.subscriptions.clear();
                ArrayList<CDOID> cdoIDs = new ArrayList<CDOID>();
                if (policiesPresent) {
                    InternalCDOObject[] internalCDOObjectArray = this.view.getObjectsArray();
                    int n = internalCDOObjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InternalCDOObject cdoObject = internalCDOObjectArray[n2];
                        int count = this.getNumberOfValidAdapter(cdoObject);
                        if (count > 0) {
                            cdoIDs.add(cdoObject.cdoID());
                            this.addEntry(cdoObject.cdoID(), cdoObject, count);
                        }
                        ++n2;
                    }
                }
                this.request(cdoIDs, true, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleDetachedObjects(Collection<CDOObject> detachedObjects) {
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                for (CDOObject detachedObject : detachedObjects) {
                    CDOID id = detachedObject.cdoID();
                    SubscribeEntry entry = this.subscriptions.get(id);
                    if (entry == null) continue;
                    this.detachObject(id);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleNewObjects(Collection<? extends CDOObject> newObjects) {
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                for (CDOObject cDOObject : newObjects) {
                    int count;
                    InternalCDOObject cdoDetachedObject = (InternalCDOObject)cDOObject;
                    if (cdoDetachedObject == null || (count = this.getNumberOfValidAdapter(cdoDetachedObject)) <= 0) continue;
                    this.subscribe(cdoDetachedObject.cdoID(), cdoDetachedObject, count);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected InternalCDOObject getSubcribeObject(CDOID id) {
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                SubscribeEntry entry = this.subscriptions.get(id);
                if (entry != null) {
                    return entry.getObject();
                }
            }
            return null;
        }

        protected void request(List<CDOID> ids, boolean clear, boolean subscribeMode) {
            CDOSessionProtocol sessionProtocol = this.view.session.getSessionProtocol();
            int viewID = this.view.getViewID();
            sessionProtocol.changeSubscription(viewID, ids, subscribeMode, clear);
        }

        protected int getNumberOfValidAdapter(InternalCDOObject object) {
            int count = 0;
            if (!FSMUtil.isTransient(object) && !FSMUtil.isNew(object) && object.eNotificationRequired()) {
                for (Adapter adapter : object.eAdapters()) {
                    if (!this.shouldSubscribe(object, adapter)) continue;
                    ++count;
                }
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void subscribe(EObject eObject, Adapter adapter, int adjust) {
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                if (this.shouldSubscribe(eObject, adapter)) {
                    InternalCDOObject internalCDOObject = FSMUtil.adapt(eObject, this.view);
                    if (internalCDOObject.cdoView() != this.view) {
                        throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.27"), internalCDOObject));
                    }
                    this.subscribe(internalCDOObject.cdoID(), internalCDOObject, adjust);
                }
            }
        }

        private boolean shouldSubscribe(EObject eObject, Adapter adapter) {
            CDOAdapterPolicy[] cDOAdapterPolicyArray = this.view.options().getChangeSubscriptionPolicies();
            int n = cDOAdapterPolicyArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOAdapterPolicy policy = cDOAdapterPolicyArray[n2];
                if (policy.isValid(eObject, adapter)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void subscribe(CDOID id, InternalCDOObject cdoObject, int adjust) {
            boolean policiesPresent = this.view.options().hasChangeSubscriptionPolicies();
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                int count = 0;
                SubscribeEntry entry = this.subscriptions.get(id);
                if (entry == null) {
                    if (adjust < 0) {
                        return;
                    }
                    if (policiesPresent) {
                        this.request(Collections.singletonList(id), false, true);
                    }
                } else {
                    count = entry.getCount();
                }
                if ((count += adjust) <= 0) {
                    this.subscriptions.remove(id);
                    if (policiesPresent) {
                        this.request(Collections.singletonList(id), false, false);
                    }
                } else if (entry == null) {
                    this.addEntry(id, cdoObject, count);
                } else {
                    entry.setCount(count);
                }
            }
        }

        private void detachObject(CDOID id) {
            this.subscribe(id, null, Integer.MIN_VALUE);
        }

        private void addEntry(CDOID key, InternalCDOObject object, int count) {
            this.subscriptions.put(key, new SubscribeEntry(object, count));
        }

        protected static final class SubscribeEntry {
            private int count;
            private InternalCDOObject object;

            public SubscribeEntry(InternalCDOObject object, int count) {
                this.count = count;
                this.object = object;
            }

            public InternalCDOObject getObject() {
                return this.object;
            }

            public int getCount() {
                return this.count;
            }

            public void setCount(int count) {
                this.count = count;
            }
        }
    }

    protected abstract class Event
    extends org.eclipse.net4j.util.event.Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;

        public Event() {
            super((INotifier)CDOViewImpl.this);
        }

        public CDOViewImpl getSource() {
            return (CDOViewImpl)super.getSource();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvalidationEvent
    extends Event
    implements CDOViewInvalidationEvent {
        private static final long serialVersionUID = 1L;
        private long timeStamp;
        private Set<? extends CDOObject> dirtyObjects;
        private Set<? extends CDOObject> detachedObjects;

        public InvalidationEvent(long timeStamp, Set<? extends CDOObject> dirtyOIDs, Set<? extends CDOObject> detachedObjects) {
            this.timeStamp = timeStamp;
            this.dirtyObjects = dirtyOIDs;
            this.detachedObjects = detachedObjects;
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public Set<? extends CDOObject> getDirtyObjects() {
            return this.dirtyObjects;
        }

        @Override
        public Set<? extends CDOObject> getDetachedObjects() {
            return this.detachedObjects;
        }

        public String toString() {
            return "CDOViewInvalidationEvent: " + this.dirtyObjects;
        }
    }

    protected class OptionsImpl
    extends org.eclipse.net4j.util.event.Notifier
    implements CDOView.Options {
        private boolean invalidationNotificationEnabled;
        private CDOInvalidationPolicy invalidationPolicy = CDOInvalidationPolicy.DEFAULT;
        private CDORevisionPrefetchingPolicy revisionPrefetchingPolicy = CDOUtil.createRevisionPrefetchingPolicy(1);
        private CDOStaleReferencePolicy staleReferencePolicy = CDOStaleReferencePolicy.EXCEPTION;
        private HashBag<CDOAdapterPolicy> changeSubscriptionPolicies = new HashBag();
        private CDOAdapterPolicy strongReferencePolicy = CDOAdapterPolicy.ALL;

        public OptionsImpl() {
            this.setCacheReferenceType(null);
        }

        public CDOViewImpl getContainer() {
            return CDOViewImpl.this;
        }

        public CDOInvalidationPolicy getInvalidationPolicy() {
            return this.invalidationPolicy;
        }

        public void setInvalidationPolicy(CDOInvalidationPolicy policy) {
            if (this.invalidationPolicy != policy) {
                this.invalidationPolicy = policy;
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new InvalidationPolicyEventImpl(), listeners);
                }
            }
        }

        public boolean isInvalidationNotificationEnabled() {
            return this.invalidationNotificationEnabled;
        }

        public void setInvalidationNotificationEnabled(boolean enabled) {
            if (this.invalidationNotificationEnabled != enabled) {
                this.invalidationNotificationEnabled = enabled;
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new InvalidationNotificationEventImpl(), listeners);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasChangeSubscriptionPolicies() {
            HashBag<CDOAdapterPolicy> hashBag = this.changeSubscriptionPolicies;
            synchronized (hashBag) {
                return !this.changeSubscriptionPolicies.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOAdapterPolicy[] getChangeSubscriptionPolicies() {
            HashBag<CDOAdapterPolicy> hashBag = this.changeSubscriptionPolicies;
            synchronized (hashBag) {
                return (CDOAdapterPolicy[])this.changeSubscriptionPolicies.toArray((Object[])new CDOAdapterPolicy[this.changeSubscriptionPolicies.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeSubscriptionPolicy(CDOAdapterPolicy policy) {
            IListener[] listeners;
            boolean changed = false;
            HashBag<CDOAdapterPolicy> hashBag = this.changeSubscriptionPolicies;
            synchronized (hashBag) {
                if (this.changeSubscriptionPolicies.add((Object)policy)) {
                    CDOViewImpl.this.changeSubscriptionManager.notifyChangeSubcriptionPolicy();
                    changed = true;
                }
            }
            if (changed && (listeners = this.getListeners()) != null) {
                this.fireEvent((IEvent)new ChangeSubscriptionPoliciesEventImpl(), listeners);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeSubscriptionPolicy(CDOAdapterPolicy policy) {
            IListener[] listeners;
            boolean changed = false;
            HashBag<CDOAdapterPolicy> hashBag = this.changeSubscriptionPolicies;
            synchronized (hashBag) {
                if (this.changeSubscriptionPolicies.remove((Object)policy) && !this.changeSubscriptionPolicies.contains((Object)policy)) {
                    CDOViewImpl.this.changeSubscriptionManager.notifyChangeSubcriptionPolicy();
                    changed = true;
                }
            }
            if (changed && (listeners = this.getListeners()) != null) {
                this.fireEvent((IEvent)new ChangeSubscriptionPoliciesEventImpl(), listeners);
            }
        }

        public CDOAdapterPolicy getStrongReferencePolicy() {
            return this.strongReferencePolicy;
        }

        public void setStrongReferencePolicy(CDOAdapterPolicy adapterPolicy) {
            if (adapterPolicy == null) {
                adapterPolicy = CDOAdapterPolicy.ALL;
            }
            if (this.strongReferencePolicy != adapterPolicy) {
                this.strongReferencePolicy = adapterPolicy;
                CDOViewImpl.this.adapterPolicyManager.reset();
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new ReferencePolicyEventImpl(), listeners);
                }
            }
        }

        public CDORevisionPrefetchingPolicy getRevisionPrefetchingPolicy() {
            return this.revisionPrefetchingPolicy;
        }

        public void setRevisionPrefetchingPolicy(CDORevisionPrefetchingPolicy prefetchingPolicy) {
            if (prefetchingPolicy == null) {
                prefetchingPolicy = CDORevisionPrefetchingPolicy.NO_PREFETCHING;
            }
            if (this.revisionPrefetchingPolicy != prefetchingPolicy) {
                this.revisionPrefetchingPolicy = prefetchingPolicy;
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new RevisionPrefetchingPolicyEventImpl(), listeners);
                }
            }
        }

        public CDOStaleReferencePolicy getStaleReferenceBehaviour() {
            return this.staleReferencePolicy;
        }

        public void setStaleReferenceBehaviour(CDOStaleReferencePolicy policy) {
            if (policy == null) {
                policy = CDOStaleReferencePolicy.EXCEPTION;
            }
            if (this.staleReferencePolicy != policy) {
                this.staleReferencePolicy = policy;
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new StaleReferencePolicyEventImpl(), listeners);
                }
            }
        }

        public ReferenceType getCacheReferenceType() {
            if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Strong) {
                return ReferenceType.STRONG;
            }
            if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Soft) {
                return ReferenceType.SOFT;
            }
            if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Weak) {
                return ReferenceType.WEAK;
            }
            throw new IllegalStateException(Messages.getString("CDOViewImpl.29"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setCacheReferenceType(ReferenceType referenceType) {
            ReferenceValueMap.Strong newObjects;
            if (referenceType == null) {
                referenceType = ReferenceType.SOFT;
            }
            switch (referenceType) {
                case STRONG: {
                    if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Strong) {
                        return false;
                    }
                    newObjects = new ReferenceValueMap.Strong();
                    break;
                }
                case SOFT: {
                    if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Soft) {
                        return false;
                    }
                    newObjects = new ReferenceValueMap.Soft();
                    break;
                }
                case WEAK: {
                    if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Weak) {
                        return false;
                    }
                    newObjects = new ReferenceValueMap.Weak();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Messages.getString("CDOViewImpl.29"));
                }
            }
            if (CDOViewImpl.this.objects == null) {
                CDOViewImpl.this.objects = (ConcurrentMap)newObjects;
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new CacheReferenceTypeEventImpl(), listeners);
                }
                return true;
            }
            for (Map.Entry entry : CDOViewImpl.this.objects.entrySet()) {
                InternalCDOObject object = (InternalCDOObject)entry.getValue();
                if (object == null) continue;
                newObjects.put((Object)((CDOID)entry.getKey()), (Object)object);
            }
            ConcurrentMap oldObjects = CDOViewImpl.this.objects;
            ConcurrentMap concurrentMap = CDOViewImpl.this.objects;
            synchronized (concurrentMap) {
                CDOViewImpl.this.objects = (ConcurrentMap)newObjects;
            }
            oldObjects.clear();
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent((IEvent)new CacheReferenceTypeEventImpl(), listeners);
            }
            return true;
        }

        private final class CacheReferenceTypeEventImpl
        extends OptionsEvent
        implements CDOView.Options.CacheReferenceTypeEvent {
            private static final long serialVersionUID = 1L;

            public CacheReferenceTypeEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ChangeSubscriptionPoliciesEventImpl
        extends OptionsEvent
        implements CDOView.Options.ChangeSubscriptionPoliciesEvent {
            private static final long serialVersionUID = 1L;

            public ChangeSubscriptionPoliciesEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class InvalidationNotificationEventImpl
        extends OptionsEvent
        implements CDOView.Options.InvalidationNotificationEvent {
            private static final long serialVersionUID = 1L;

            public InvalidationNotificationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class InvalidationPolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.InvalidationPolicyEvent {
            private static final long serialVersionUID = 1L;

            public InvalidationPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ReferencePolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.ReferencePolicyEvent {
            private static final long serialVersionUID = 1L;

            public ReferencePolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class RevisionPrefetchingPolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.RevisionPrefetchingPolicyEvent {
            private static final long serialVersionUID = 1L;

            public RevisionPrefetchingPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class StaleReferencePolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.StaleReferencePolicyEvent {
            private static final long serialVersionUID = 1L;

            public StaleReferencePolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }
    }

    private final class ViewTargetChangedEvent
    extends Event
    implements CDOViewTargetChangedEvent {
        private static final long serialVersionUID = 1L;
        private CDOBranchPoint branchPoint;

        public ViewTargetChangedEvent(CDOBranchPoint branchPoint) {
            this.branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)branchPoint);
        }

        public String toString() {
            return MessageFormat.format("CDOViewTargetChangedEvent: {0}", this.branchPoint);
        }

        public CDOBranchPoint getBranchPoint() {
            return this.branchPoint;
        }
    }
}

