/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDODeltaNotification;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionMerger;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.spi.cdo.InternalCDOObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectConflictResolver
implements CDOConflictResolver {
    private CDOTransaction transaction;

    @Override
    public CDOTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void setTransaction(CDOTransaction transaction) {
        if (this.transaction != transaction) {
            if (this.transaction != null) {
                this.unhookTransaction(this.transaction);
            }
            this.transaction = transaction;
            if (this.transaction != null) {
                this.hookTransaction(this.transaction);
            }
        }
    }

    @Override
    public void resolveConflicts(Set<CDOObject> conflicts) {
        Map<CDOID, CDORevisionDelta> localDeltas = this.transaction.getRevisionDeltas();
        for (CDOObject conflict : conflicts) {
            CDORevisionDelta localDelta = localDeltas.get(conflict.cdoID());
            this.resolveConflict(conflict, localDelta);
        }
    }

    protected abstract void resolveConflict(CDOObject var1, CDORevisionDelta var2);

    protected void hookTransaction(CDOTransaction transaction) {
    }

    protected void unhookTransaction(CDOTransaction transaction) {
    }

    public static void rollbackObject(CDOObject object) {
        CDOStateMachine.INSTANCE.rollback((InternalCDOObject)object);
    }

    public static void readObject(CDOObject object) {
        CDOStateMachine.INSTANCE.read((InternalCDOObject)object);
    }

    public static void changeObject(CDOObject object, CDORevisionDelta revisionDelta) {
        AbstractObjectConflictResolver.readObject(object);
        InternalCDORevision revision = (InternalCDORevision)object.cdoRevision().copy();
        ((InternalCDORevisionDelta)revisionDelta).setVersion(revision.getVersion());
        CDORevisionMerger merger = new CDORevisionMerger();
        merger.merge(revision, revisionDelta);
        ((InternalCDOObject)object).cdoInternalSetRevision((CDORevision)revision);
        ((InternalCDOObject)object).cdoInternalSetState(CDOState.DIRTY);
        ((InternalCDOObject)object).cdoInternalPostLoad();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MergeLocalChangesPerFeature
    extends ThreeWayMerge {
        @Override
        protected void resolveConflict(CDOObject conflict, CDORevisionDelta localDelta, List<CDORevisionDelta> remoteDeltas) {
            if (this.hasFeatureConflicts(localDelta, remoteDeltas)) {
                throw new CDOException(Messages.getString("AbstractObjectConflictResolver.0"));
            }
            MergeLocalChangesPerFeature.rollbackObject(conflict);
            for (CDORevisionDelta remoteDelta : remoteDeltas) {
                for (CDOFeatureDelta remoteFeatureDelta : remoteDelta.getFeatureDeltas()) {
                    ((InternalCDORevisionDelta)localDelta).addFeatureDelta(remoteFeatureDelta);
                }
            }
            MergeLocalChangesPerFeature.changeObject(conflict, localDelta);
        }

        protected boolean hasFeatureConflicts(CDORevisionDelta localDelta, List<CDORevisionDelta> remoteDeltas) {
            HashSet<EStructuralFeature> features = new HashSet<EStructuralFeature>();
            for (CDOFeatureDelta localFeatureDelta : localDelta.getFeatureDeltas()) {
                features.add(localFeatureDelta.getFeature());
            }
            for (CDORevisionDelta remoteDelta : remoteDeltas) {
                for (CDOFeatureDelta remoteFeatureDelta : remoteDelta.getFeatureDeltas()) {
                    EStructuralFeature feature = remoteFeatureDelta.getFeature();
                    if (!features.contains(feature)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class TakeRemoteChangesThenApplyLocalChanges
    extends AbstractObjectConflictResolver {
        protected void resolveConflict(CDOObject conflict, CDORevisionDelta revisionDelta) {
            TakeRemoteChangesThenApplyLocalChanges.rollbackObject(conflict);
            TakeRemoteChangesThenApplyLocalChanges.changeObject(conflict, revisionDelta);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ThreeWayMerge
    extends AbstractObjectConflictResolver
    implements CDOAdapterPolicy {
        private ChangeSubscriptionAdapter adapter = new ChangeSubscriptionAdapter();
        private CDOTransactionHandler handler = new CDODefaultTransactionHandler(){

            public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta ignored) {
                if (ThreeWayMerge.this.getTransaction() == transaction) {
                    ThreeWayMerge.this.adapter.attach(object);
                }
            }

            public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
                if (ThreeWayMerge.this.getTransaction() == transaction) {
                    ThreeWayMerge.this.adapter.reset();
                }
            }

            public void rolledBackTransaction(CDOTransaction transaction) {
                if (ThreeWayMerge.this.getTransaction() == transaction && transaction.getLastSavepoint().getPreviousSavepoint() == null) {
                    ThreeWayMerge.this.adapter.reset();
                }
            }
        };

        @Override
        public boolean isValid(EObject object, Adapter adapter) {
            return adapter instanceof ChangeSubscriptionAdapter;
        }

        @Override
        protected void hookTransaction(CDOTransaction transaction) {
            transaction.options().addChangeSubscriptionPolicy(this);
            transaction.addTransactionHandler(this.handler);
        }

        @Override
        protected void unhookTransaction(CDOTransaction transaction) {
            transaction.removeTransactionHandler(this.handler);
            transaction.options().removeChangeSubscriptionPolicy(this);
        }

        @Override
        protected void resolveConflict(CDOObject conflict, CDORevisionDelta revisionDelta) {
            this.resolveConflict(conflict, revisionDelta, this.adapter.getRevisionDeltas(conflict));
        }

        protected abstract void resolveConflict(CDOObject var1, CDORevisionDelta var2, List<CDORevisionDelta> var3);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ChangeSubscriptionAdapter
        extends AdapterImpl {
            private Set<CDOObject> notifiers = new HashSet<CDOObject>();
            private Map<CDOObject, List<CDORevisionDelta>> deltas = new HashMap<CDOObject, List<CDORevisionDelta>>();

            public List<CDORevisionDelta> getRevisionDeltas(CDOObject notifier) {
                List<CDORevisionDelta> list = this.deltas.get(CDOUtil.getEObject(notifier));
                if (list == null) {
                    return Collections.emptyList();
                }
                return list;
            }

            public Set<CDOObject> getNotifiers() {
                return this.notifiers;
            }

            public Map<CDOObject, List<CDORevisionDelta>> getDeltas() {
                return this.deltas;
            }

            public void attach(CDOObject notifier) {
                if (this.notifiers.add(notifier)) {
                    notifier.eAdapters().add((Object)this);
                }
            }

            public void reset() {
                for (CDOObject notifier : this.notifiers) {
                    notifier.eAdapters().remove((Object)this);
                }
                this.notifiers.clear();
                this.deltas.clear();
            }

            public void notifyChanged(Notification msg) {
                try {
                    if (msg instanceof CDODeltaNotification) {
                        CDODeltaNotification deltaNotification = (CDODeltaNotification)msg;
                        Object notifier = deltaNotification.getNotifier();
                        if (!deltaNotification.hasNext() && this.notifiers.contains(notifier)) {
                            CDORevisionDelta revisionDelta = deltaNotification.getRevisionDelta();
                            List<CDORevisionDelta> list = this.deltas.get(notifier);
                            if (list == null) {
                                list = new ArrayList<CDORevisionDelta>(1);
                                this.deltas.put(CDOUtil.getCDOObject((EObject)notifier), list);
                            }
                            list.add(revisionDelta);
                        }
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
    }
}

