/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.CDORawReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CDOSessionProtocol
extends CDOProtocol,
InternalCDOPackageRegistry.PackageLoader,
InternalCDOBranchManager.BranchLoader,
InternalCDORevisionManager.RevisionLoader,
InternalCDOCommitInfoManager.CommitInfoLoader {
    public RepositoryTimeResult getRepositoryTime();

    public void disablePassiveUpdate();

    public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode var1);

    public RefreshSessionResult refresh(long var1, Map<CDOBranch, Map<CDOID, InternalCDORevision>> var3, int var4, boolean var5);

    public Object loadChunk(InternalCDORevision var1, EStructuralFeature var2, int var3, int var4, int var5, int var6);

    public void openView(int var1, CDOBranchPoint var2, boolean var3);

    public boolean[] changeView(int var1, CDOBranchPoint var2, List<InternalCDOObject> var3);

    public void closeView(int var1);

    public void changeSubscription(int var1, List<CDOID> var2, boolean var3, boolean var4);

    public void query(int var1, AbstractQueryIterator<?> var2);

    public boolean cancelQuery(int var1);

    public RefreshSessionResult lockObjects(long var1, Map<CDOBranch, Map<CDOID, InternalCDORevision>> var3, int var4, IRWLockManager.LockType var5, long var6) throws InterruptedException;

    public void unlockObjects(CDOView var1, Collection<? extends CDOObject> var2, IRWLockManager.LockType var3);

    public boolean isObjectLocked(CDOView var1, CDOObject var2, IRWLockManager.LockType var3, boolean var4);

    public CommitTransactionResult commitTransaction(int var1, String var2, boolean var3, CDOIDProvider var4, CDOCommitData var5, OMMonitor var6);

    public CommitTransactionResult commitDelegation(CDOBranch var1, String var2, String var3, CDOCommitData var4, OMMonitor var5);

    public CommitTransactionResult commitXATransactionPhase1(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitXATransactionPhase2(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitXATransactionPhase3(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitXATransactionCancel(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public List<CDORemoteSession> getRemoteSessions(InternalCDORemoteSessionManager var1, boolean var2);

    public Set<Integer> sendRemoteMessage(CDORemoteSessionMessage var1, List<CDORemoteSession> var2);

    public boolean unsubscribeRemoteSessions();

    public void replicateRepository(CDOReplicationContext var1);

    public void replicateRepositoryRaw(CDORawReplicationContext var1);

    public CDOChangeSetData[] loadChangeSets(CDOBranchPointRange ... var1);

    public Set<CDOID> loadMergeData(CDORevisionAvailabilityInfo var1, CDORevisionAvailabilityInfo var2, CDORevisionAvailabilityInfo var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CommitTransactionResult
    implements CDOBranchPoint {
        private CDOIDProvider idProvider;
        private String rollbackMessage;
        private CDOBranchPoint branchPoint;
        private Map<CDOID, CDOID> idMappings = new HashMap<CDOID, CDOID>();
        private CDOReferenceAdjuster referenceAdjuster;

        public CommitTransactionResult(CDOIDProvider idProvider, String rollbackMessage) {
            this.idProvider = idProvider;
            this.rollbackMessage = rollbackMessage;
        }

        public CommitTransactionResult(CDOIDProvider idProvider, CDOBranchPoint branchPoint) {
            this.idProvider = idProvider;
            this.branchPoint = branchPoint;
        }

        public CDOReferenceAdjuster getReferenceAdjuster() {
            if (this.referenceAdjuster == null) {
                this.referenceAdjuster = this.createReferenceAdjuster();
            }
            return this.referenceAdjuster;
        }

        public void setReferenceAdjuster(CDOReferenceAdjuster referenceAdjuster) {
            this.referenceAdjuster = referenceAdjuster;
        }

        public String getRollbackMessage() {
            return this.rollbackMessage;
        }

        public CDOBranch getBranch() {
            return this.branchPoint.getBranch();
        }

        public long getTimeStamp() {
            return this.branchPoint.getTimeStamp();
        }

        public int compareTo(CDOBranchPoint o) {
            return this.branchPoint.compareTo((Object)o);
        }

        public Map<CDOID, CDOID> getIDMappings() {
            return this.idMappings;
        }

        public void addIDMapping(CDOID oldID, CDOID newID) {
            this.idMappings.put(oldID, newID);
        }

        protected PostCommitReferenceAdjuster createReferenceAdjuster() {
            return new PostCommitReferenceAdjuster(this.idProvider, new CDOIDMapper(this.idMappings));
        }

        protected static class PostCommitReferenceAdjuster
        implements CDOReferenceAdjuster {
            private CDOIDProvider idProvider;
            private CDOIDMapper idMapper;

            public PostCommitReferenceAdjuster(CDOIDProvider idProvider, CDOIDMapper idMapper) {
                this.idProvider = idProvider;
                this.idMapper = idMapper;
            }

            public Object adjustReference(Object id) {
                if (id == null || id == CDOID.NULL) {
                    return id;
                }
                if (this.idProvider != null && (id instanceof CDOID || id instanceof InternalEObject)) {
                    id = this.idProvider.provideCDOID(id);
                }
                return this.idMapper.adjustReference(id);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OpenSessionResult {
        private int sessionID;
        private String userID;
        private String repositoryUUID;
        private CDOCommonRepository.Type repositoryType;
        private CDOCommonRepository.State repositoryState;
        private String storeType;
        private Set<CDOID.ObjectType> objectIDTypes;
        private long repositoryCreationTime;
        private long lastUpdateTime;
        private RepositoryTimeResult repositoryTimeResult;
        private CDOID rootResourceID;
        private boolean repositorySupportingAudits;
        private boolean repositorySupportingBranches;
        private boolean repositoryEnsuringReferentialIntegrity;
        private List<InternalCDOPackageUnit> packageUnits = new ArrayList<InternalCDOPackageUnit>();

        public OpenSessionResult(int sessionID, String userID, String repositoryUUID, CDOCommonRepository.Type repositoryType, CDOCommonRepository.State repositoryState, String storeType, Set<CDOID.ObjectType> objectIDTypes, long repositoryCreationTime, long lastUpdateTime, CDOID rootResourceID, boolean repositorySupportingAudits, boolean repositorySupportingBranches) {
            this.sessionID = sessionID;
            this.userID = userID;
            this.repositoryUUID = repositoryUUID;
            this.repositoryType = repositoryType;
            this.repositoryState = repositoryState;
            this.storeType = storeType;
            this.objectIDTypes = objectIDTypes;
            this.repositoryCreationTime = repositoryCreationTime;
            this.lastUpdateTime = lastUpdateTime;
            this.rootResourceID = rootResourceID;
            this.repositorySupportingAudits = repositorySupportingAudits;
            this.repositorySupportingBranches = repositorySupportingBranches;
        }

        public int getSessionID() {
            return this.sessionID;
        }

        public String getUserID() {
            return this.userID;
        }

        public String getRepositoryUUID() {
            return this.repositoryUUID;
        }

        public CDOCommonRepository.Type getRepositoryType() {
            return this.repositoryType;
        }

        public CDOCommonRepository.State getRepositoryState() {
            return this.repositoryState;
        }

        public String getStoreType() {
            return this.storeType;
        }

        public Set<CDOID.ObjectType> getObjectIDTypes() {
            return this.objectIDTypes;
        }

        public CDOID getRootResourceID() {
            return this.rootResourceID;
        }

        public long getRepositoryCreationTime() {
            return this.repositoryCreationTime;
        }

        public boolean isRepositorySupportingAudits() {
            return this.repositorySupportingAudits;
        }

        public boolean isRepositorySupportingBranches() {
            return this.repositorySupportingBranches;
        }

        public boolean isRepositoryEnsuringReferentialIntegrity() {
            return this.repositoryEnsuringReferentialIntegrity;
        }

        public void setRepositoryEnsuringReferentialIntegrity(boolean repositoryEnsuringReferentialIntegrity) {
            this.repositoryEnsuringReferentialIntegrity = repositoryEnsuringReferentialIntegrity;
        }

        public RepositoryTimeResult getRepositoryTimeResult() {
            return this.repositoryTimeResult;
        }

        public void setRepositoryTimeResult(RepositoryTimeResult repositoryTimeResult) {
            this.repositoryTimeResult = repositoryTimeResult;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public List<InternalCDOPackageUnit> getPackageUnits() {
            return this.packageUnits;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RefreshSessionResult {
        private long lastUpdateTime;
        private List<CDOPackageUnit> packageUnits = new ArrayList<CDOPackageUnit>();
        private Map<CDOBranch, List<InternalCDORevision>> changedObjects = new HashMap<CDOBranch, List<InternalCDORevision>>();
        private Map<CDOBranch, List<CDOIDAndVersion>> detachedObjects = new HashMap<CDOBranch, List<CDOIDAndVersion>>();

        public RefreshSessionResult(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public List<CDOPackageUnit> getPackageUnits() {
            return this.packageUnits;
        }

        public List<InternalCDORevision> getChangedObjects(CDOBranch branch) {
            List<InternalCDORevision> list = this.changedObjects.get(branch);
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        public List<CDOIDAndVersion> getDetachedObjects(CDOBranch branch) {
            List<CDOIDAndVersion> list = this.detachedObjects.get(branch);
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        public void addPackageUnit(CDOPackageUnit packageUnit) {
            this.packageUnits.add(packageUnit);
        }

        public void addChangedObject(InternalCDORevision revision) {
            CDOBranch branch = revision.getBranch();
            List<InternalCDORevision> list = this.changedObjects.get(branch);
            if (list == null) {
                list = new ArrayList<InternalCDORevision>();
                this.changedObjects.put(branch, list);
            }
            list.add(revision);
        }

        public void addDetachedObject(CDORevisionKey revision) {
            CDOBranch branch = revision.getBranch();
            List<CDOIDAndVersion> list = this.detachedObjects.get(branch);
            if (list == null) {
                list = new ArrayList<CDOIDAndVersion>();
                this.detachedObjects.put(branch, list);
            }
            list.add((CDOIDAndVersion)revision);
        }
    }

    public static final class RepositoryTimeResult {
        private long requested;
        private long indicated;
        private long responded;
        private long confirmed;

        public long getRequested() {
            return this.requested;
        }

        public void setRequested(long requested) {
            this.requested = requested;
        }

        public long getIndicated() {
            return this.indicated;
        }

        public void setIndicated(long indicated) {
            this.indicated = indicated;
        }

        public long getResponded() {
            return this.responded;
        }

        public void setResponded(long responded) {
            this.responded = responded;
        }

        public long getConfirmed() {
            return this.confirmed;
        }

        public void setConfirmed(long confirmed) {
            this.confirmed = confirmed;
        }

        public long getAproximateRepositoryOffset() {
            long latency = this.confirmed - this.requested >> 1;
            long shift = this.confirmed - this.responded;
            return shift - latency;
        }

        public long getAproximateRepositoryTime() {
            long offset = this.getAproximateRepositoryOffset();
            return System.currentTimeMillis() + offset;
        }

        public String toString() {
            return MessageFormat.format("RepositoryTime[requested={0}, indicated={1}, responded={2}, confirmed={3}]", CDOCommonUtil.formatTimeStamp((long)this.requested), CDOCommonUtil.formatTimeStamp((long)this.indicated), CDOCommonUtil.formatTimeStamp((long)this.responded), CDOCommonUtil.formatTimeStamp((long)this.confirmed));
        }
    }
}

