/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.views.components;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.providers.IPropertiesEditionPartProvider;
import org.eclipse.emf.eef.runtime.impl.components.StandardPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.impl.notify.PropertiesValidationEditionEvent;
import org.eclipse.emf.eef.runtime.impl.services.PropertiesEditionPartProviderService;
import org.eclipse.emf.eef.views.DocumentedElement;
import org.eclipse.emf.eef.views.ViewsPackage;
import org.eclipse.emf.eef.views.parts.DocumentationPropertiesEditionPart;
import org.eclipse.emf.eef.views.parts.ViewsViewsRepository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DocumentedElementPropertiesEditionComponent
extends StandardPropertiesEditionComponent {
    public static String DOCUMENTATION_PART = "Documentation";
    private String[] parts = new String[]{DOCUMENTATION_PART};
    private DocumentedElement documentedElement;
    protected DocumentationPropertiesEditionPart documentationPart;

    public DocumentedElementPropertiesEditionComponent(EObject documentedElement, String editing_mode) {
        if (documentedElement instanceof DocumentedElement) {
            this.documentedElement = (DocumentedElement)documentedElement;
            if ("Live".equals(editing_mode)) {
                this.semanticAdapter = this.initializeSemanticAdapter();
                this.documentedElement.eAdapters().add((Object)this.semanticAdapter);
            }
        }
        this.editing_mode = editing_mode;
    }

    private AdapterImpl initializeSemanticAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(final Notification msg) {
                if (DocumentedElementPropertiesEditionComponent.this.documentationPart == null) {
                    DocumentedElementPropertiesEditionComponent.this.dispose();
                } else {
                    Runnable updateRunnable = new Runnable(){

                        public void run() {
                            DocumentedElementPropertiesEditionComponent.this.runUpdateRunnable(msg);
                        }
                    };
                    if (Display.getCurrent() == null) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(updateRunnable);
                    } else {
                        updateRunnable.run();
                    }
                }
            }
        };
    }

    protected void runUpdateRunnable(Notification msg) {
        if (ViewsPackage.eINSTANCE.getDocumentedElement_Documentation().equals(msg.getFeature()) && this.documentationPart != null) {
            if (msg.getNewValue() != null) {
                this.documentationPart.setDocumentation(EcoreUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)msg.getNewValue()));
            } else {
                this.documentationPart.setDocumentation("");
            }
        }
    }

    public Class translatePart(String key) {
        if (DOCUMENTATION_PART.equals(key)) {
            return ViewsViewsRepository.Documentation.class;
        }
        return super.translatePart(key);
    }

    public String[] partsList() {
        return this.parts;
    }

    public IPropertiesEditionPart getPropertiesEditionPart(int kind, String key) {
        if (this.documentedElement != null && DOCUMENTATION_PART.equals(key)) {
            IPropertiesEditionPartProvider provider;
            if (this.documentationPart == null && (provider = PropertiesEditionPartProviderService.getInstance().getProvider(ViewsViewsRepository.class)) != null) {
                this.documentationPart = (DocumentationPropertiesEditionPart)provider.getPropertiesEditionPart(ViewsViewsRepository.Documentation.class, kind, (IPropertiesEditionComponent)this);
                this.addListener((IPropertiesEditionListener)this.documentationPart);
            }
            return (IPropertiesEditionPart)this.documentationPart;
        }
        return null;
    }

    public void setPropertiesEditionPart(Class key, int kind, IPropertiesEditionPart propertiesEditionPart) {
        if (key == ViewsViewsRepository.Documentation.class) {
            this.documentationPart = (DocumentationPropertiesEditionPart)propertiesEditionPart;
        }
    }

    public void initPart(Class key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.documentationPart != null && key == ViewsViewsRepository.Documentation.class) {
            ((IPropertiesEditionPart)this.documentationPart).setContext(elt, allResource);
            DocumentedElement documentedElement = (DocumentedElement)elt;
            if (documentedElement.getDocumentation() != null) {
                this.documentationPart.setDocumentation(EcoreUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)documentedElement.getDocumentation()));
            }
        }
        this.setInitializing(false);
    }

    public CompoundCommand getPropertiesEditionCommand(EditingDomain editingDomain) {
        CompoundCommand cc = new CompoundCommand();
        if (this.documentedElement != null && this.documentationPart != null) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.documentedElement, (Object)ViewsPackage.eINSTANCE.getDocumentedElement_Documentation(), (Object)EcoreUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)this.documentationPart.getDocumentation())));
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        cc.append((Command)IdentityCommand.INSTANCE);
        return cc;
    }

    public EObject getPropertiesEditionObject(EObject source) {
        if (source instanceof DocumentedElement) {
            DocumentedElement documentedElementToUpdate = (DocumentedElement)source;
            documentedElementToUpdate.setDocumentation((String)EcoreUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)this.documentationPart.getDocumentation()));
            return documentedElementToUpdate;
        }
        return null;
    }

    public void firePropertiesChanged(IPropertiesEditionEvent event) {
        if (!this.isInitializing()) {
            Diagnostic valueDiagnostic = this.validateValue(event);
            if (1 == event.getState() && "Live".equals(this.editing_mode) && valueDiagnostic.getSeverity() == 0) {
                CompoundCommand command = new CompoundCommand();
                if (ViewsViewsRepository.Documentation.documentation == event.getAffectedEditor()) {
                    command.append(SetCommand.create((EditingDomain)this.liveEditingDomain, (Object)this.documentedElement, (Object)ViewsPackage.eINSTANCE.getDocumentedElement_Documentation(), (Object)EcoreUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)((String)event.getNewValue()))));
                }
                if (!command.isEmpty() && !command.canExecute()) {
                    EEFRuntimePlugin.getDefault().logError("Cannot perform model change command.", null);
                } else {
                    this.liveEditingDomain.getCommandStack().execute((Command)command);
                }
            }
            if (valueDiagnostic.getSeverity() != 0 && valueDiagnostic instanceof BasicDiagnostic) {
                super.firePropertiesChanged((IPropertiesEditionEvent)new PropertiesValidationEditionEvent(event, valueDiagnostic));
            } else {
                Diagnostic validate = this.validate();
                super.firePropertiesChanged((IPropertiesEditionEvent)new PropertiesValidationEditionEvent(event, validate));
            }
            super.firePropertiesChanged(event);
        }
    }

    public String getHelpContent(String key, int kind) {
        if (key == ViewsViewsRepository.Documentation.documentation) {
            return "The documentation of the element";
        }
        return super.getHelpContent(key, kind);
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            String newStringValue = event.getNewValue().toString();
            try {
                if (ViewsViewsRepository.Documentation.documentation == event.getAffectedEditor()) {
                    Object newValue = EcoreUtil.createFromString((EDataType)ViewsPackage.eINSTANCE.getDocumentedElement_Documentation().getEAttributeType(), (String)newStringValue);
                    ret = Diagnostician.INSTANCE.validate(ViewsPackage.eINSTANCE.getDocumentedElement_Documentation().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }

    public Diagnostic validate() {
        Diagnostic validate = Diagnostic.OK_INSTANCE;
        if ("Batch".equals(this.editing_mode)) {
            EObject copy = EcoreUtil.copy((EObject)this.documentedElement);
            copy = this.getPropertiesEditionObject(copy);
            validate = EEFRuntimePlugin.getEEFValidator().validate(copy);
        } else if ("Live".equals(this.editing_mode)) {
            validate = EEFRuntimePlugin.getEEFValidator().validate((EObject)this.documentedElement);
        }
        return validate;
    }

    public void dispose() {
        if (this.semanticAdapter != null) {
            this.documentedElement.eAdapters().remove((Object)this.semanticAdapter);
        }
    }

    public String getTabText(String p_key) {
        return this.documentationPart.getTitle();
    }
}

