/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBasedScope
implements IScope {
    private Map<String, ? extends EObject> entries;

    public MapBasedScope(Map<String, ? extends EObject> entries) {
        this.entries = entries;
    }

    public IScope getOuterScope() {
        return IScope.NULLSCOPE;
    }

    public Iterable<IEObjectDescription> getAllContents() {
        return Iterables.transform(this.entries.entrySet(), (Function)new Function<Map.Entry<String, ? extends EObject>, IEObjectDescription>(){

            public IEObjectDescription apply(Map.Entry<String, ? extends EObject> from) {
                return new MapEntry(from);
            }
        });
    }

    public Iterable<IEObjectDescription> getContents() {
        return this.getAllContents();
    }

    public IEObjectDescription getContentByName(String name) {
        EObject element = this.entries.get(name);
        if (element != null) {
            return EObjectDescription.create((String)name, (EObject)element);
        }
        return null;
    }

    public IEObjectDescription getContentByEObject(EObject object) {
        URI uri = EcoreUtil.getURI((EObject)object);
        for (Map.Entry<String, ? extends EObject> entry : this.entries.entrySet()) {
            if (!uri.equals((Object)EcoreUtil.getURI((EObject)entry.getValue()))) continue;
            return new MapEntry(entry);
        }
        return null;
    }

    public Iterable<IEObjectDescription> getAllContentsByEObject(EObject object) {
        ArrayList result = Lists.newArrayList();
        URI uri = EcoreUtil.getURI((EObject)object);
        for (Map.Entry<String, ? extends EObject> entry : this.entries.entrySet()) {
            if (!uri.equals((Object)EcoreUtil.getURI((EObject)entry.getValue()))) continue;
            result.add(new MapEntry(entry));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapEntry
    implements IEObjectDescription {
        private final Map.Entry<String, ? extends EObject> entry;

        public MapEntry(Map.Entry<String, ? extends EObject> entry) {
            this.entry = entry;
        }

        public String getName() {
            return this.entry.getKey();
        }

        public String getQualifiedName() {
            return this.entry.getKey();
        }

        public EObject getEObjectOrProxy() {
            return this.entry.getValue();
        }

        public URI getEObjectURI() {
            return EcoreUtil.getURI((EObject)this.entry.getValue());
        }

        public EClass getEClass() {
            return this.entry.getValue().eClass();
        }

        public String getUserData(String name) {
            return null;
        }

        public String[] getUserDataKeys() {
            return new String[0];
        }
    }
}

