/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.identifier;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierCacheHandler {
    private static Log log = LogFactory.getLog(IdentifierCacheHandler.class);
    public static final int PURGE_TRESHOLD = 100;
    private static IdentifierCacheHandler instance = new IdentifierCacheHandler();
    private Map<Key, Object> idMap = new ConcurrentHashMap<Key, Object>();
    private int idModCount = 0;
    private Map<Key, Object> versionMap = new ConcurrentHashMap<Key, Object>();
    private int versionModCount = 0;

    public static IdentifierCacheHandler getInstance() {
        return instance;
    }

    public static void setInstance(IdentifierCacheHandler identifierCacheHandler) {
        instance = identifierCacheHandler;
    }

    public void clear() {
        this.idMap.clear();
        this.idModCount = 0;
        this.versionMap.clear();
        this.versionModCount = 0;
    }

    public Map<Key, Object> getIdMap() {
        return this.idMap;
    }

    public Map<Key, Object> getVersionMap() {
        return this.versionMap;
    }

    public void purgeMaps() {
        this.purgeIDMap();
        this.purgeVersionMap();
    }

    public Object getID(Object obj) {
        Object id = this.idMap.get(new Key(obj));
        if (id == null) {
            log.debug((Object)("ID for object " + obj.getClass().getName() + " not found in id cache"));
            return null;
        }
        if (id instanceof WeakReference) {
            return ((WeakReference)id).get();
        }
        return id;
    }

    public void setID(Object obj, Object id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting id: " + id + " for object " + obj.getClass().getName() + " in idcache "));
        }
        if (id == null) {
            this.idMap.remove(new Key(obj));
        } else if (this.useWeakReference(id)) {
            this.idMap.put(new Key(obj), new WeakReference<Object>(id));
        } else {
            this.idMap.put(new Key(obj), id);
        }
        ++this.idModCount;
        if (this.idModCount > this.getPurgeTreshold()) {
            this.purgeIDMap();
        }
    }

    public Object getVersion(Object obj) {
        Object version = this.versionMap.get(new Key(obj));
        if (version == null) {
            return version;
        }
        return version;
    }

    private boolean useWeakReference(Object id) {
        if (Number.class.isAssignableFrom(id.getClass())) {
            return false;
        }
        return !String.class.isAssignableFrom(id.getClass());
    }

    protected int getPurgeTreshold() {
        return 100;
    }

    public void setVersion(Object obj, Object version) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting version: " + version + " for object " + obj.getClass().getName() + " in idcache "));
        }
        if (version == null) {
            this.versionMap.remove(new Key(obj));
        } else {
            this.versionMap.put(new Key(obj), version);
        }
        ++this.versionModCount;
        if (this.versionModCount > this.getPurgeTreshold()) {
            this.purgeVersionMap();
        }
    }

    private void purgeIDMap() {
        this.purgeMap(this.idMap);
        this.idModCount = 0;
    }

    protected void purgeVersionMap() {
        this.purgeMap(this.versionMap);
        this.versionModCount = 0;
    }

    protected void purgeMap(Map<Key, Object> map) {
        Iterator<Key> it = map.keySet().iterator();
        while (it.hasNext()) {
            Key key = it.next();
            if (key.isValid()) continue;
            it.remove();
        }
    }

    public void dumpID() {
        this.dumpContents(this.idMap);
    }

    private void dumpContents(Map<Key, Object> map) {
        for (Key key : map.keySet()) {
            key.weakRef.get();
        }
    }

    protected static class Key {
        private final WeakReference<Object> weakRef;
        private final int hashcode;

        Key(Object keyObject) {
            this.weakRef = new WeakReference<Object>(keyObject);
            this.hashcode = keyObject.hashCode();
        }

        public boolean equals(Object arg0) {
            assert (arg0 != null);
            assert (arg0 instanceof Key);
            Key key0 = (Key)arg0;
            Object obj0 = key0.weakRef.get();
            Object obj1 = this.weakRef.get();
            if (obj0 == null || obj1 == null) {
                return this == key0;
            }
            return obj0 == obj1;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean isValid() {
            return this.weakRef.get() != null;
        }
    }
}

