/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.browser.uicore;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class CustomizableModelContentProvider implements ITreeContentProvider {

	private final AppearanceConfiguration appearanceConfiguration;

	public CustomizableModelContentProvider(final CustomizationManager customizationManager) {
		this.appearanceConfiguration = customizationManager.getAppearanceConfiguration();
	}

	public Object[] getElements(final Object inputElement) {
		EObject[] rootElements = getRootElements(inputElement);
		if (rootElements == null) {
			return null;
		}
		List<Object> result = new ArrayList<Object>();
		for (EObject eObject : rootElements) {
			result.add(new ModelElementItem(eObject, null, this.appearanceConfiguration));
		}
		return result.toArray();
	}

	public EObject[] getRootElements(final Object inputElement) {
		if (inputElement instanceof IFile) {
			IFile file = (IFile) inputElement;
			ResourceSet resourceSet = new ResourceSetImpl();
			URI uri = URI.createFileURI(file.getLocation().toString());
			Resource resource = resourceSet.getResource(uri, true);
			if (resource != null) {
				EList<EObject> contents = resource.getContents();
				return contents.toArray(new EObject[contents.size()]);
			}
		}
		return null;
	}

	public void dispose() {
		// nothing
	}

	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		// nothing
	}

	public Object[] getChildren(final Object parentElement) {
		if (parentElement instanceof ITreeElement) {
			final ITreeElement treeElement = (ITreeElement) parentElement;
			return treeElement.getChildren().toArray();
		}
		return null;
	}

	public Object getParent(final Object element) {
		if (element instanceof ITreeElement) {
			final ITreeElement treeElement = (ITreeElement) element;
			return treeElement.getTreeParent();
		}
		return null;
	}

	public boolean hasChildren(final Object element) {
		if (element instanceof ITreeElement) {
			final ITreeElement treeElement = (ITreeElement) element;
			return treeElement.hasChildren();
		}
		return false;
	}

}
