/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.editors.MetaclassViewer;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MetaclassViewToolBar {
    private final ToolBar toolBar;
    private ToolItem btnShowMenu;
    private MetaclassViewer metaclassViewer;
    private final BrowserConfiguration browserConfiguration;
    private final Composite fParentComposite;
    private final Action actionDisplayInstancesOfSubclasses = new Action(Messages.MetaclassViewToolBar_displayInstancesOfSubclasses, 2){
        {
            this.setToolTipText(Messages.MetaclassViewToolBar_displayInstancesOfSubclasses);
            this.setImageDescriptor(ImageProvider.getInstance().getDerivedInstancesImageDescriptor());
        }

        public void run() {
            MetaclassViewToolBar.this.metaclassViewer.setDisplayInstancesOfSubclasses(this.isChecked());
        }
    };
    private final Action actionSortByName = new Action(Messages.MetaclassViewToolBar_sortByName, 8){
        {
            this.setToolTipText(Messages.MetaclassViewToolBar_sortByName);
            this.setImageDescriptor(ImageProvider.getInstance().getSortInstancesIcon());
        }

        public void run() {
            MetaclassViewToolBar.this.metaclassViewer.setSortMode(AppearanceConfiguration.MetaclassesSortMode.ByName);
        }
    };
    private final Action actionSortByCount = new Action(Messages.MetaclassViewToolBar_sortByCount, 8){
        {
            this.setToolTipText(Messages.MetaclassViewToolBar_sortByCount);
            this.setImageDescriptor(ImageProvider.getInstance().getSortNumericallyIcon());
        }

        public void run() {
            MetaclassViewToolBar.this.metaclassViewer.setSortMode(AppearanceConfiguration.MetaclassesSortMode.ByCount);
        }
    };
    private final Action actionShowMetaclassesFullQualifiedName = new Action(Messages.MetaclassViewToolBar_showFullQualifiedNames, 32){
        {
            this.setToolTipText(Messages.MetaclassViewToolBar_showFullQualifiedNames);
            this.setImageDescriptor(ImageProvider.getInstance().getShowFullQualifiedNamesImageDescriptor());
        }

        public void run() {
            MetaclassViewToolBar.this.metaclassViewer.setShowMetaclassesFullQualifiedNames(this.isChecked());
        }
    };
    private final Action actionShowEmptyMetaclasses = new Action(Messages.MetaclassViewToolBar_showEmptyMetaclasses, 2){
        {
            this.setToolTipText(Messages.MetaclassViewToolBar_showEmptyMetaclasses);
            this.setImageDescriptor(ImageProvider.getInstance().getShowEmptyMetaclassesIcon());
        }

        public void run() {
            MetaclassViewToolBar.this.metaclassViewer.setShowEmptyMetaclasses(this.isChecked());
        }
    };
    private final Action actionGroupByPackage = new Action(Messages.MetaclassViewToolBar_groupByPackage, 2){
        {
            this.setToolTipText(Messages.MetaclassViewToolBar_groupByPackage);
            this.setImageDescriptor(ImageProvider.getInstance().getPackageImageDescriptor());
        }

        public void run() {
            MetaclassViewToolBar.this.metaclassViewer.setGroupByPackage(this.isChecked());
        }
    };
    private final Action actionDerivationTree = new Action(Messages.MetaclassViewToolBar_showDerivationTree, 2){
        {
            this.setToolTipText(Messages.MetaclassViewToolBar_showDerivationTree);
            this.setImageDescriptor(ImageProvider.getInstance().getDerivationTreeIcon());
        }

        public void run() {
            MetaclassViewToolBar.this.metaclassViewer.setShowDerivationTree(this.isChecked());
            MetaclassViewToolBar.this.actionGroupByPackage.setEnabled(!this.isChecked());
        }
    };

    public MetaclassViewToolBar(Composite parent, BrowserConfiguration browserConfiguration) {
        this.fParentComposite = parent;
        this.browserConfiguration = browserConfiguration;
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        parent.setLayout((Layout)layout);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        toolBarManager.add((IAction)this.actionShowEmptyMetaclasses);
        toolBarManager.add((IAction)this.actionDisplayInstancesOfSubclasses);
        toolBarManager.add((IAction)this.actionDerivationTree);
        this.toolBar = toolBarManager.createControl(parent);
        this.initialize();
        this.createShowMenuAction();
    }

    private void createShowMenuAction() {
        this.btnShowMenu = new ToolItem(this.toolBar, 8);
        this.btnShowMenu.setToolTipText(Messages.MetaclassViewToolBar_showViewMenu);
        this.btnShowMenu.setImage(ImageProvider.getInstance().getViewMenuIcon());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type != 3 || MetaclassViewToolBar.this.toolBar.getItem(new Point(event.x, event.y)) == MetaclassViewToolBar.this.btnShowMenu) {
                    MetaclassViewToolBar.this.openViewMenu();
                }
            }
        };
        this.toolBar.addListener(3, listener);
        this.btnShowMenu.addListener(13, listener);
    }

    public Menu openViewMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)this.actionShowEmptyMetaclasses);
        menuManager.add((IAction)this.actionDisplayInstancesOfSubclasses);
        menuManager.add((IAction)this.actionDerivationTree);
        menuManager.add((IAction)this.actionSortByName);
        menuManager.add((IAction)this.actionSortByCount);
        menuManager.add((IAction)this.actionShowMetaclassesFullQualifiedName);
        menuManager.add((IAction)this.actionGroupByPackage);
        Menu contextMenu = menuManager.createContextMenu((Control)this.fParentComposite);
        Rectangle bounds = Display.getCurrent().map((Control)this.toolBar, null, this.btnShowMenu.getBounds());
        contextMenu.setLocation(bounds.x, bounds.y + bounds.height);
        contextMenu.setVisible(true);
        return contextMenu;
    }

    public void setMetaclassViewer(MetaclassViewer metaclassViewer) {
        this.metaclassViewer = metaclassViewer;
    }

    private void initialize() {
        AppearanceConfiguration.MetaclassesSortMode metaclassesSortMode = this.browserConfiguration.getAppearanceConfiguration().getMetaclassesSortMode();
        this.actionSortByName.setChecked(metaclassesSortMode == AppearanceConfiguration.MetaclassesSortMode.ByName);
        this.actionSortByCount.setChecked(metaclassesSortMode == AppearanceConfiguration.MetaclassesSortMode.ByCount);
        this.actionShowMetaclassesFullQualifiedName.setChecked(this.browserConfiguration.getAppearanceConfiguration().isShowMetaclassesFullQualifiedNames());
        this.actionShowEmptyMetaclasses.setChecked(this.browserConfiguration.getAppearanceConfiguration().isShowEmptyMetaclasses());
        this.actionGroupByPackage.setChecked(this.browserConfiguration.getAppearanceConfiguration().isGroupByPackage());
        this.actionDisplayInstancesOfSubclasses.setChecked(this.browserConfiguration.getAppearanceConfiguration().isDisplayInstancesOfSubclasses());
        this.actionDerivationTree.setChecked(this.browserConfiguration.getAppearanceConfiguration().isShowDerivationTree());
        this.actionGroupByPackage.setEnabled(!this.browserConfiguration.getAppearanceConfiguration().isShowDerivationTree());
    }
}

