/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.builder;

import java.util.LinkedList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.AbstractMoDiscoCatalog;

public final class CatalogJob
extends Job {
    private static final long DELAY = 0L;
    private static CatalogJob instance;
    private final LinkedList<Runnable> actionQueue = new LinkedList();

    private CatalogJob(String name) {
        super(name);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public static synchronized CatalogJob getInstance() {
        if (instance == null) {
            instance = new CatalogJob("Catalog Notifications");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        while (true) {
            Runnable runnable;
            LinkedList<Runnable> linkedList = this.actionQueue;
            synchronized (linkedList) {
                if (this.actionQueue.isEmpty()) {
                    break;
                }
                runnable = this.actionQueue.removeFirst();
            }
            if (AbstractMoDiscoCatalog.SCHEDULING_DEBUG) {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": begin run: " + runnable);
            }
            runnable.run();
            if (!AbstractMoDiscoCatalog.SCHEDULING_DEBUG) continue;
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": end run: " + runnable);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addAction(Runnable runnable) {
        LinkedList<Runnable> linkedList = this.actionQueue;
        synchronized (linkedList) {
            this.actionQueue.addLast(runnable);
        }
        this.cancel();
        this.setPriority(40);
        this.schedule(0L);
    }

    public boolean belongsTo(Object family) {
        return AbstractMoDiscoCatalog.belongsTo(family);
    }
}

