/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.discoverymanager.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryManager;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.handlers.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscovererHandler
implements Discoverer {
    private final Discoverer delegate;
    private String name;
    private String[] paths;
    private Image imageIcon;

    public DiscovererHandler(Discoverer delegateParemeter) {
        this.delegate = delegateParemeter;
    }

    @Override
    public boolean isApplicableTo(Object source) {
        boolean result = false;
        try {
            result = this.delegate.isApplicableTo(source);
        }
        catch (Throwable e) {
            MoDiscoLogger.logError((Throwable)e, (String)NLS.bind((String)Messages.DiscovererHandler_discovererCompliance, (Object[])new Object[]{this.getName()}), (Plugin)DiscoveryManager.getDefault());
            result = false;
        }
        return result;
    }

    @Override
    @Deprecated
    public Resource discoverElement(Object source, URI target) {
        throw new RuntimeException(Messages.DiscovererHandler_deprecatedDiscoveryProcess);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPaths(String[] paths) {
        this.paths = paths;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public void setImageIcon(Image imageIcon) {
        this.imageIcon = imageIcon;
    }

    public Image getImageIcon() {
        return this.imageIcon;
    }

    public String toString() {
        String result = this.getName();
        if (result == null || result.length() == 0) {
            result = this.delegate.toString();
        }
        return result;
    }

    @Override
    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        this.delegate.discoverElement(source, parameters);
    }

    @Override
    public List<DiscoveryParameter> getDiscovererParameters() {
        List<DiscoveryParameter> result = this.delegate.getDiscovererParameters();
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }
}

