/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.parametersdisplay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.data.DiscoveryParameterDisplay;
import org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.parametersdisplay.Messages;
import org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.parametersdisplay.ParametersTableComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscovererParametersComposite
extends Composite {
    private Group discovererParametersGroup = null;
    private InnerParametersGroup inGroup = null;
    private ParametersTableComposite inoutParametersGroup = null;
    private ParametersTableComposite outParametersGroup = null;
    private ExpandBar parametersBar = null;
    private ExpandItem inoutParametersItem = null;
    private ExpandItem outParametersItem = null;
    private List<DiscoveryParameterDisplay> discoveryParameters = Collections.emptyList();

    public DiscovererParametersComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private final void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        this.setLayout((Layout)gridLayout);
        this.createDiscovererParametersGroup();
    }

    private final void createDiscovererParametersGroup() {
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessVerticalSpace = true;
        this.discovererParametersGroup = new Group((Composite)this, 0);
        this.discovererParametersGroup.setText(Messages.DiscovererParametersComposite_2);
        this.discovererParametersGroup.setLayoutData((Object)gridData1);
        this.parametersBar = new ExpandBar((Composite)this.discovererParametersGroup, 512);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.parametersBar.setLayoutData((Object)gridData);
        this.createInParametersGroup();
        this.createInoutParametersGroup();
        this.createOutParametersGroup();
        this.discovererParametersGroup.setLayout((Layout)new GridLayout());
    }

    private final void createInParametersGroup() {
        this.inGroup = new InnerParametersGroup();
        this.inGroup.createInParametersGroup(this.parametersBar, this.getInDiscoveryParameters(), Messages.DiscovererParametersComposite_0);
    }

    private final List<DiscoveryParameterDisplay> getInDiscoveryParameters() {
        ArrayList<DiscoveryParameterDisplay> inParameters = new ArrayList<DiscoveryParameterDisplay>();
        for (DiscoveryParameterDisplay parameter : this.discoveryParameters) {
            if (parameter.getParameterDirectionKind() != DiscoveryParameterDirectionKind.in) continue;
            inParameters.add(parameter);
        }
        return inParameters;
    }

    private final void createInoutParametersGroup() {
        this.inoutParametersGroup = new ParametersTableComposite((Composite)this.parametersBar, 0, this.getInOutDiscoveryParameters());
        this.inoutParametersItem = new ExpandItem(this.parametersBar, 0, 1);
        this.inoutParametersItem.setText(Messages.DiscovererParametersComposite_1);
        this.inoutParametersItem.setHeight(this.inoutParametersGroup.computeSize((int)-1, (int)-1).y);
        this.inoutParametersItem.setControl((Control)this.inoutParametersGroup);
        this.inoutParametersItem.setExpanded(!this.getInOutDiscoveryParameters().isEmpty());
    }

    private final List<DiscoveryParameterDisplay> getInOutDiscoveryParameters() {
        ArrayList<DiscoveryParameterDisplay> inoutParameters = new ArrayList<DiscoveryParameterDisplay>();
        for (DiscoveryParameterDisplay parameter : this.discoveryParameters) {
            if (parameter.getParameterDirectionKind() != DiscoveryParameterDirectionKind.inout) continue;
            inoutParameters.add(parameter);
        }
        return inoutParameters;
    }

    private final void createOutParametersGroup() {
        this.outParametersGroup = new ParametersTableComposite((Composite)this.parametersBar, 0, this.getOutDiscoveryParameters());
        this.outParametersItem = new ExpandItem(this.parametersBar, 0, 2);
        this.outParametersItem.setText(Messages.DiscovererParametersComposite_3);
        this.outParametersItem.setHeight(this.outParametersGroup.computeSize((int)-1, (int)-1).y);
        this.outParametersItem.setControl((Control)this.outParametersGroup);
        this.outParametersItem.setExpanded(!this.getOutDiscoveryParameters().isEmpty());
    }

    private final List<DiscoveryParameterDisplay> getOutDiscoveryParameters() {
        ArrayList<DiscoveryParameterDisplay> outParameters = new ArrayList<DiscoveryParameterDisplay>();
        for (DiscoveryParameterDisplay parameter : this.discoveryParameters) {
            if (parameter.getParameterDirectionKind() != DiscoveryParameterDirectionKind.out) continue;
            outParameters.add(parameter);
        }
        return outParameters;
    }

    public void updateDiscoveryParameters(List<DiscoveryParameterDisplay> displayParameters) {
        this.discoveryParameters = displayParameters;
        this.inGroup.updateDisplayParameters(this.getInDiscoveryParameters());
        this.inoutParametersGroup.updateDisplayParameters(this.getInOutDiscoveryParameters());
        this.outParametersGroup.updateDisplayParameters(this.getOutDiscoveryParameters());
        this.updateParametersItems();
    }

    private final void updateParametersItems() {
        int size = this.getInOutDiscoveryParameters().size();
        this.inoutParametersItem.setExpanded(size != 0);
        if (this.inoutParametersItem.getExpanded()) {
            this.inoutParametersItem.setHeight(this.inoutParametersGroup.getBounds().height);
        }
        this.outParametersItem.setExpanded((size = this.getOutDiscoveryParameters().size()) != 0);
        if (this.outParametersItem.getExpanded()) {
            this.outParametersItem.setHeight(this.outParametersGroup.getBounds().height);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InnerParametersGroup {
        private ParametersTableComposite parametersGroup = null;
        private ExpandItem parametersItem = null;

        InnerParametersGroup() {
        }

        void createInParametersGroup(ExpandBar parametersBar, List<DiscoveryParameterDisplay> discoveryParameters, String message) {
            this.parametersGroup = new ParametersTableComposite((Composite)parametersBar, 0, discoveryParameters);
            this.parametersItem = new ExpandItem(parametersBar, 0, 0);
            this.parametersItem.setText(message);
            this.parametersItem.setHeight(this.parametersGroup.computeSize((int)-1, (int)-1).y);
            this.parametersItem.setControl((Control)this.parametersGroup);
            this.parametersItem.setExpanded(!discoveryParameters.isEmpty());
        }

        void updateDisplayParameters(List<DiscoveryParameterDisplay> discoveryParameters) {
            this.parametersGroup.updateDisplayParameters(discoveryParameters);
        }
    }
}

