/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.facet.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.AbstractMoDiscoCatalog;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.common.ui.internal.views.AbstractCatalogView;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetPackage;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.gmt.modisco.infra.facet.core.FacetSetCatalog;
import org.eclipse.gmt.modisco.infra.facet.editor.presentation.FacetEditor;
import org.eclipse.gmt.modisco.infra.facet.ui.Activator;
import org.eclipse.gmt.modisco.infra.facet.ui.Messages;
import org.eclipse.gmt.modisco.infra.facet.ui.views.FacetSetContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class FacetView
extends AbstractCatalogView
implements AbstractMoDiscoCatalog.ModiscoCatalogChangeListener {
    private static final String NAME_COLUMN = "FacetView_NameColumn";
    private static final String LOCATION_COLUMN = "FacetView_LocationColumn";
    private static final String DEFAULT_COLUMN = "FacetView_DefaultColumn";
    private static final String EXTENDS_COLUMN = "FacetView_ExtendsColumn";
    private static final int COLUMN_WIDTH = 200;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    protected void createColumns() {
        this.createNameColumn();
        this.createExtendsColumn();
        this.createLocationColumn();
        this.createDefaultColumn();
    }

    private void createLocationColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof FacetSet)) {
                    return "";
                }
                FacetSet facetSet = (FacetSet)element;
                URI uri = FacetSetCatalog.getSingleton().getURI(facetSet.getName());
                if (uri == null) {
                    return "null";
                }
                return uri.toString();
            }
        };
        this.createColumn(Messages.FacetView_location, LOCATION_COLUMN, 400, columnLabelProvider);
    }

    private void createNameColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FacetSet) {
                    FacetSet facetSet = (FacetSet)element;
                    return facetSet.getName();
                }
                if (element instanceof Facet) {
                    Facet facet = (Facet)element;
                    return facet.getName();
                }
                if (element instanceof EStructuralFeature) {
                    EStructuralFeature feature = (EStructuralFeature)element;
                    return feature.getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        };
        this.createColumn(Messages.FacetView_name, NAME_COLUMN, 200, columnLabelProvider);
    }

    private void createDefaultColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                FacetSet facetSet;
                EAnnotation annotation;
                if (element instanceof FacetSet && (annotation = (facetSet = (FacetSet)element).getEAnnotation("default")) != null && annotation.getReferences().size() == 1 && annotation.getReferences().get(0) instanceof EPackage) {
                    EPackage ePackage = (EPackage)annotation.getReferences().get(0);
                    return String.valueOf(ePackage.getName()) + " " + ePackage.getNsURI();
                }
                return "";
            }
        };
        this.createColumn(Messages.FacetView_1, DEFAULT_COLUMN, 200, columnLabelProvider);
    }

    private void createExtendsColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FacetSet) {
                    FacetSet facetSet = (FacetSet)element;
                    return String.valueOf(facetSet.getExtendedPackage().getName()) + " " + facetSet.getExtendedPackage().getNsURI();
                }
                return "";
            }
        };
        this.createColumn(Messages.FacetView_3, EXTENDS_COLUMN, 200, columnLabelProvider);
    }

    public void dispose() {
        super.dispose();
        FacetSetCatalog.getSingleton().removeChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    public void changed(EObject changedFacetSet, IFile file) {
        this.refresh(true);
    }

    public void added(EObject addedFacetSet, IFile file) {
        this.refresh(true);
    }

    public void removed(IFile facetSetFile) {
        this.refresh(true);
    }

    protected IContentProvider getContentProvider() {
        return new FacetSetContentProvider(FacetPackage.eINSTANCE.getFacetStructuralFeature());
    }

    protected void openElement(Object element) {
        EObject modelElement = (EObject)element;
        FacetSet facetSet = null;
        if (modelElement instanceof FacetSet) {
            facetSet = (FacetSet)modelElement;
        } else if (modelElement instanceof Facet) {
            Facet facet = (Facet)modelElement;
            facetSet = facet.getEPackage();
        }
        if (facetSet != null) {
            java.net.URI uri = null;
            try {
                String uriString = FacetSetCatalog.getSingleton().getURI(facetSet.getName()).toString();
                uri = java.net.URI.create(uriString);
                IEditorPart editor = null;
                if ("file".equals(uri.getScheme())) {
                    editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (java.net.URI)new java.net.URI(facetSet.eResource().getURI().toString()), (String)"org.eclipse.gmt.modisco.infra.facet.editor.presentation.FacetEditorID", (boolean)true);
                } else {
                    URIEditorInput uriEditorInput = new URIEditorInput(URI.createURI((String)uri.toString()));
                    editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)uriEditorInput, (String)"org.eclipse.gmt.modisco.infra.facet.editor.presentation.FacetEditorID", (boolean)true);
                }
                if (editor instanceof FacetEditor) {
                    FacetEditor facetEditor = (FacetEditor)editor;
                    facetEditor.setSelectionToViewer(modelElement);
                }
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (String)("Failed to open: " + uri), (Plugin)Activator.getDefault());
            }
        }
    }

    protected String getRefreshMessage() {
        return Messages.FacetView_JobName_refreshingFacetSetsView;
    }

    protected Object getInput() {
        FacetSetCatalog.getSingleton().addChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
        return FacetSetCatalog.getSingleton().getAllFacetSets().toArray();
    }
}

