/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.kdm.browser.extension.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.gmt.modisco.kdm.browser.extension.Activator;
import org.eclipse.gmt.modisco.omg.kdm.action.*;

/**
 * @generated
 */
public class IconProvider implements org.eclipse.gmt.modisco.infra.browser.uicore.extensions.icons.IconProvider {
//	Start of user code Image attribute for TryUnit		
	private Image TryUnitImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for CatchUnit		
	private Image CatchUnitImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for FinallyUnit		
	private Image FinallyUnitImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ExceptionUnit		
	private Image ExceptionUnitImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for BlockUnit		
	private Image BlockUnitImage = this.createImage("block.gif");
//	End of user code
//	Start of user code Image attribute for Flow		
	private Image FlowImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for TrueFlow		
	private Image TrueFlowImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for FalseFlow		
	private Image FalseFlowImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for GuardedFlow		
	private Image GuardedFlowImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ActionElement		
	private Image ActionElementImage = this.createImage("StartClassifierBehaviorAction.gif");
//	End of user code
//	Start of user code Image attribute for ControlFlow		
	private Image ControlFlowImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for EntryFlow		
	private Image EntryFlowImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Calls		
	private Image CallsImage = this.createImage("ch_callees.gif");
//	End of user code
//	Start of user code Image attribute for Dispatches		
	private Image DispatchesImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Reads		
	private Image ReadsImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Writes		
	private Image WritesImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Addresses		
	private Image AddressesImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Creates		
	private Image CreatesImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ExitFlow		
	private Image ExitFlowImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ExceptionFlow		
	private Image ExceptionFlowImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Throws		
	private Image ThrowsImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for CompliesTo		
	private Image CompliesToImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for UsesType		
	private Image UsesTypeImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ActionRelationship		
	private Image ActionRelationshipImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for AbstractActionRelationship		
	private Image AbstractActionRelationshipImage = this.createImage("");
//	End of user code
	

	/**
	 * @generated
	 */	
	public IconProvider() {
	}

	/**
	 * @return the icon that must be displayed for the given {@link EObject}, or <code>null</code>
	 *         to keep the default icon, which can be empty, or let another {@link IconProvider}
	 *         provide the icon
	 * @generated
	 */
	public Image getIcon(EObject eObject) {
    Image result = null;
    if (eObject instanceof TryUnit) {
      result = this.TryUnitImage;
    } else
    if (eObject instanceof CatchUnit) {
      result = this.CatchUnitImage;
    } else
    if (eObject instanceof FinallyUnit) {
      result = this.FinallyUnitImage;
    } else
    if (eObject instanceof ExceptionUnit) {
      result = this.ExceptionUnitImage;
    } else
    if (eObject instanceof BlockUnit) {
      result = this.BlockUnitImage;
    } else
    if (eObject instanceof Flow) {
      result = this.FlowImage;
    } else
    if (eObject instanceof TrueFlow) {
      result = this.TrueFlowImage;
    } else
    if (eObject instanceof FalseFlow) {
      result = this.FalseFlowImage;
    } else
    if (eObject instanceof GuardedFlow) {
      result = this.GuardedFlowImage;
    } else
    if (eObject instanceof ActionElement) {
      result = this.ActionElementImage;
    } else
    if (eObject instanceof ControlFlow) {
      result = this.ControlFlowImage;
    } else
    if (eObject instanceof EntryFlow) {
      result = this.EntryFlowImage;
    } else
    if (eObject instanceof Calls) {
      result = this.CallsImage;
    } else
    if (eObject instanceof Dispatches) {
      result = this.DispatchesImage;
    } else
    if (eObject instanceof Reads) {
      result = this.ReadsImage;
    } else
    if (eObject instanceof Writes) {
      result = this.WritesImage;
    } else
    if (eObject instanceof Addresses) {
      result = this.AddressesImage;
    } else
    if (eObject instanceof Creates) {
      result = this.CreatesImage;
    } else
    if (eObject instanceof ExitFlow) {
      result = this.ExitFlowImage;
    } else
    if (eObject instanceof ExceptionFlow) {
      result = this.ExceptionFlowImage;
    } else
    if (eObject instanceof Throws) {
      result = this.ThrowsImage;
    } else
    if (eObject instanceof CompliesTo) {
      result = this.CompliesToImage;
    } else
    if (eObject instanceof UsesType) {
      result = this.UsesTypeImage;
    } else
    if (eObject instanceof ActionRelationship) {
      result = this.ActionRelationshipImage;
    } else
    if (eObject instanceof AbstractActionRelationship) {
      result = this.AbstractActionRelationshipImage;
    } 

    return result;

  }

	/**
	 * Create an image from a resource in the bundle (plugin)
	 * 
	 * @param resourcePath
	 *            the path of the resource (in the bundle)
	 * @return the image
	 * @generated
	 */
	private Image createImage(String resourcePath) {
    Image result = null;
    if ((resourcePath != null) && (resourcePath.length() > 0)) {
      ImageDescriptor descriptor = Activator.getImageDescriptor("icons/kdm/action/" + resourcePath);
      if (descriptor != null) {
        result = descriptor.createImage();
      }
    }
    return result;
  }

}

