/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.kdm.browser.extension.event;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.gmt.modisco.kdm.browser.extension.Activator;
import org.eclipse.gmt.modisco.omg.kdm.event.*;

/**
 * @generated
 */
public class IconProvider implements org.eclipse.gmt.modisco.infra.browser.uicore.extensions.icons.IconProvider {
//	Start of user code Image attribute for OnEntry		
	private Image OnEntryImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for OnExit		
	private Image OnExitImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for InitialState		
	private Image InitialStateImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for State		
	private Image StateImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Transition		
	private Image TransitionImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for EventModel		
	private Image EventModelImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Event		
	private Image EventImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for EventRelationship		
	private Image EventRelationshipImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for EventResource		
	private Image EventResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for EventAction		
	private Image EventActionImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ReadsState		
	private Image ReadsStateImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ProducesEvent		
	private Image ProducesEventImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ConsumesEvent		
	private Image ConsumesEventImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for NextState		
	private Image NextStateImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for EventElement		
	private Image EventElementImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for HasState		
	private Image HasStateImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for AbstractEventElement		
	private Image AbstractEventElementImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for AbstractEventRelationship		
	private Image AbstractEventRelationshipImage = this.createImage("");
//	End of user code
	

	/**
	 * @generated
	 */	
	public IconProvider() {
	}

	/**
	 * @return the icon that must be displayed for the given {@link EObject}, or <code>null</code>
	 *         to keep the default icon, which can be empty, or let another {@link IconProvider}
	 *         provide the icon
	 * @generated
	 */
	public Image getIcon(EObject eObject) {
    Image result = null;
    if (eObject instanceof OnEntry) {
      result = this.OnEntryImage;
    } else
    if (eObject instanceof OnExit) {
      result = this.OnExitImage;
    } else
    if (eObject instanceof InitialState) {
      result = this.InitialStateImage;
    } else
    if (eObject instanceof State) {
      result = this.StateImage;
    } else
    if (eObject instanceof Transition) {
      result = this.TransitionImage;
    } else
    if (eObject instanceof EventModel) {
      result = this.EventModelImage;
    } else
    if (eObject instanceof Event) {
      result = this.EventImage;
    } else
    if (eObject instanceof EventRelationship) {
      result = this.EventRelationshipImage;
    } else
    if (eObject instanceof EventResource) {
      result = this.EventResourceImage;
    } else
    if (eObject instanceof EventAction) {
      result = this.EventActionImage;
    } else
    if (eObject instanceof ReadsState) {
      result = this.ReadsStateImage;
    } else
    if (eObject instanceof ProducesEvent) {
      result = this.ProducesEventImage;
    } else
    if (eObject instanceof ConsumesEvent) {
      result = this.ConsumesEventImage;
    } else
    if (eObject instanceof NextState) {
      result = this.NextStateImage;
    } else
    if (eObject instanceof EventElement) {
      result = this.EventElementImage;
    } else
    if (eObject instanceof HasState) {
      result = this.HasStateImage;
    } else
    if (eObject instanceof AbstractEventElement) {
      result = this.AbstractEventElementImage;
    } else
    if (eObject instanceof AbstractEventRelationship) {
      result = this.AbstractEventRelationshipImage;
    } 

    return result;

  }

	/**
	 * Create an image from a resource in the bundle (plugin)
	 * 
	 * @param resourcePath
	 *            the path of the resource (in the bundle)
	 * @return the image
	 * @generated
	 */
	private Image createImage(String resourcePath) {
    Image result = null;
    if ((resourcePath != null) && (resourcePath.length() > 0)) {
      ImageDescriptor descriptor = Activator.getImageDescriptor("icons/kdm/event/" + resourcePath);
      if (descriptor != null) {
        result = descriptor.createImage();
      }
    }
    return result;
  }

}

