/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.kdm.source.discoverer;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.omg.kdm.kdm.KdmFactory;
import org.eclipse.gmt.modisco.omg.kdm.kdm.Segment;
import org.eclipse.gmt.modisco.omg.kdm.source.Directory;
import org.eclipse.gmt.modisco.omg.kdm.source.InventoryContainer;
import org.eclipse.gmt.modisco.omg.kdm.source.InventoryItem;
import org.eclipse.gmt.modisco.omg.kdm.source.InventoryModel;
import org.eclipse.gmt.modisco.omg.kdm.source.SourceFactory;
import org.eclipse.gmt.modisco.omg.kdm.source.SourceFile;
import org.eclipse.jdt.core.IJavaProject;

public class KDMSourceDiscoverer {
    private boolean rootIsProject = false;
    private InventoryContainer rootContainer = null;
    private IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
    private IContentType textContentType = this.contentTypeManager.getContentType("org.eclipse.gmt.modisco.kdm.source.discoverer.textFile");
    private IContentType configContentType = this.contentTypeManager.getContentType("org.eclipse.gmt.modisco.kdm.source.discoverer.confFile");
    private IContentType srcContentType = this.contentTypeManager.getContentType("org.eclipse.gmt.modisco.kdm.source.discoverer.srcFile");
    private IContentType binaryContentType = this.contentTypeManager.getContentType("org.eclipse.gmt.modisco.kdm.source.discoverer.binaryFile");
    private IContentType imageContentType = this.contentTypeManager.getContentType("org.eclipse.gmt.modisco.kdm.source.discoverer.imageFile");
    private IContentType executableContentType = this.contentTypeManager.getContentType("org.eclipse.gmt.modisco.kdm.source.discoverer.executableFile");

    public final Resource getKDMModelFromDirectory(File aFile) {
        if (!aFile.isDirectory()) {
            return null;
        }
        this.rootIsProject = false;
        this.rootContainer = null;
        return this.createKDMModelFromFile(aFile, aFile.getName());
    }

    public final Resource getKDMModelFromJavaProject(IJavaProject aProject) {
        this.rootIsProject = true;
        this.rootContainer = null;
        return this.createKDMModelFromFile(aProject.getResource().getLocation().toFile(), aProject.getElementName());
    }

    public final Resource getKDMModelFromContainer(IContainer aContainer) {
        this.rootIsProject = aContainer == aContainer.getProject();
        this.rootContainer = null;
        return this.createKDMModelFromFile(aContainer.getLocation().toFile(), aContainer.getName());
    }

    private Resource createKDMModelFromFile(File directoryFile, String name) {
        XMIResourceImpl resultModel = new XMIResourceImpl();
        Segment segment = KdmFactory.eINSTANCE.createSegment();
        InventoryModel inventoryModel = SourceFactory.eINSTANCE.createInventoryModel();
        inventoryModel.setName(name);
        segment.getModel().add((Object)inventoryModel);
        resultModel.getContents().add((Object)segment);
        InventoryContainer project = this.createFileSystemTree(directoryFile);
        inventoryModel.getInventoryElement().add((Object)project);
        return resultModel;
    }

    private InventoryContainer createFileSystemTree(File directory) {
        File[] children;
        Directory resultDirectory;
        if (this.rootContainer == null && this.rootIsProject) {
            resultDirectory = SourceFactory.eINSTANCE.createProject();
            this.rootContainer = resultDirectory;
        } else {
            resultDirectory = SourceFactory.eINSTANCE.createDirectory();
            resultDirectory.setPath(directory.getAbsolutePath());
            if (this.rootContainer == null) {
                this.rootContainer = resultDirectory;
            }
        }
        resultDirectory.setName(directory.getName());
        File[] fileArray = children = directory.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isFile()) {
                InventoryItem childItem = this.getElement(child);
                childItem.setPath(child.getAbsolutePath());
                childItem.setName(child.getName());
                resultDirectory.getInventoryElement().add((Object)childItem);
            } else {
                Directory childDirectory = (Directory)this.createFileSystemTree(child);
                resultDirectory.getInventoryElement().add((Object)childDirectory);
            }
            ++n2;
        }
        return resultDirectory;
    }

    private IContentType findBestContentTypeFor(String fileName) {
        IContentType[] ct = this.contentTypeManager.findContentTypesFor(fileName);
        if (ct.length == 0) {
            return null;
        }
        IContentType bestCT = null;
        int i = 0;
        while (i < ct.length) {
            if (ct[i].getId().startsWith("org.eclipse.gmt.modisco.kdm.source.discoverer") && (bestCT == null || ct[i].isKindOf(bestCT))) {
                bestCT = ct[i];
            }
            ++i;
        }
        return bestCT;
    }

    private InventoryItem getElement(File child) {
        SourceFile item = null;
        IContentType ct = this.findBestContentTypeFor(child.getName());
        if (ct != null) {
            if (ct.isKindOf(this.binaryContentType)) {
                if (ct.isKindOf(this.imageContentType)) {
                    item = SourceFactory.eINSTANCE.createImage();
                    return item;
                }
                if (ct.isKindOf(this.executableContentType)) {
                    item = SourceFactory.eINSTANCE.createExecutableFile();
                    return item;
                }
                item = SourceFactory.eINSTANCE.createBinaryFile();
            } else if (ct.isKindOf(this.textContentType)) {
                if (ct.isKindOf(this.configContentType)) {
                    item = SourceFactory.eINSTANCE.createConfiguration();
                } else if (ct.isKindOf(this.srcContentType)) {
                    item = SourceFactory.eINSTANCE.createSourceFile();
                }
            }
        }
        if (item == null) {
            item = SourceFactory.eINSTANCE.createSourceFile();
        }
        return item;
    }
}

