/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.kdm.uml2converter.popup.actions;

import java.util.logging.Handler;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.kdm.uml2converter.KdmToUml2Activator;
import org.eclipse.gmt.modisco.kdm.uml2converter.popup.actions.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class Convert
implements IObjectActionDelegate {
    private final Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private IFile kdmFile;
    private IWorkbenchPart workbench;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbench = targetPart;
    }

    public void run(IAction action) {
        final String kdmModelPath = this.kdmFile.getLocation().toString();
        final IPath umlModelPath = this.kdmFile.getLocation().removeFileExtension().addFileExtension("uml");
        Job job = new Job(String.valueOf(Messages.Convert_0) + umlModelPath.lastSegment()){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = null;
                AtlLogHandler logHandler = new AtlLogHandler(String.valueOf(umlModelPath.toString()) + ".log");
                Convert.this.logger.addHandler((Handler)logHandler);
                try {
                    try {
                        KDMtoUML2Converter transfo = new KDMtoUML2Converter();
                        XMIResourceImpl kdmModel = new XMIResourceImpl();
                        kdmModel.setURI(URI.createFileURI((String)kdmModelPath));
                        URI outputURI = URI.createFileURI((String)umlModelPath.toString());
                        transfo.getUML2ModelFromKDMModel((Resource)kdmModel, false, outputURI);
                        result = Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        result = Status.CANCEL_STATUS;
                        Convert.this.logger.removeHandler((Handler)logHandler);
                        logHandler.close();
                        try {
                            Convert.this.kdmFile.getParent().refreshLocal(1, null);
                        }
                        catch (Exception e1) {
                            MoDiscoLogger.logError((Throwable)e1, (Plugin)KdmToUml2Activator.getDefault());
                        }
                    }
                }
                finally {
                    Convert.this.logger.removeHandler((Handler)logHandler);
                    logHandler.close();
                    try {
                        Convert.this.kdmFile.getParent().refreshLocal(1, null);
                    }
                    catch (Exception e1) {
                        MoDiscoLogger.logError((Throwable)e1, (Plugin)KdmToUml2Activator.getDefault());
                    }
                }
                return result;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                            IFile ifile = root.getFileForLocation(umlModelPath);
                            if (ifile.exists()) {
                                IWorkbenchPage page = Convert.this.workbench.getSite().getPage();
                                IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                            }
                        }
                        catch (PartInitException e) {
                            MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
                        }
                    }
                });
            }
        });
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.kdmFile = (IFile)((IStructuredSelection)selection).getFirstElement();
    }
}

