/**
 * *******************************************************************************
 * Copyright (c) 2008 Hatha Systems.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nikolai Mansourov (Hatha Systems) - initial API and implementation
 * *******************************************************************************
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.omg.kdm.core;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>KDM Relationship</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A KDM relationship is a model element that represents semantic association between two entities.
 * In the meta-model, KDMRelationship is a subclass of ModelElement. Each KDM package defines some specific KDM
 * relations that are either direct or indirect subclasses of KDMRelationship. Specific subclasses of KDMRelationship are
 * typed associations between some specific subclasses of KDMEntity.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.core.KDMRelationship#getGenericFrom <em>Generic From</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.core.KDMRelationship#getGenericTo <em>Generic To</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.gmt.modisco.omg.kdm.core.CorePackage#getKDMRelationship()
 * @model abstract="true"
 * @generated
 */
public interface KDMRelationship extends ModelElement {
	/**
	 * Returns the value of the '<em><b>Generic From</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.gmt.modisco.omg.kdm.core.KDMEntity#getOutbound <em>Outbound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The origin entity (also referred to as the from-endpoint of the relationship). This property
	 * determines a meta-level interface to KDM relationships. This property is a derived union. Every
	 * specific KDM relationship redefines the from-endpoint to a particular subtype of KDMEntity. In
	 * KDM this is represented by the CMOF redefines mechanism. Concrete properties redefine the
	 * union properties of the parent classes, defined in the Core package.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Generic From</em>' reference.
	 * @see org.eclipse.gmt.modisco.omg.kdm.core.CorePackage#getKDMRelationship_GenericFrom()
	 * @see org.eclipse.gmt.modisco.omg.kdm.core.KDMEntity#getOutbound
	 * @model opposite="outbound" required="true" changeable="false" derived="true"
	 * @generated
	 */
	KDMEntity getGenericFrom();

	/**
	 * Returns the value of the '<em><b>Generic To</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.gmt.modisco.omg.kdm.core.KDMEntity#getInbound <em>Inbound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The target entity (also referred to as the to-endpoint of the relationship). This property determines
	 * a meta-level interface to KDM relationships. This property is a derived union. Every specific
	 * KDM relationship redefines the to-endpoint to a particular subtype of KDMEntity. In KDM this is
	 * represented by the CMOF redefines mechanism. Concrete properties redefine the union
	 * properties of the parent classes, defined in the Core package.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Generic To</em>' reference.
	 * @see org.eclipse.gmt.modisco.omg.kdm.core.CorePackage#getKDMRelationship_GenericTo()
	 * @see org.eclipse.gmt.modisco.omg.kdm.core.KDMEntity#getInbound
	 * @model opposite="inbound" required="true" changeable="false" derived="true"
	 * @generated
	 */
	KDMEntity getGenericTo();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This operation returns the KDM entity that is the to-endpoint (the target) of the current
	 * relationship
	 * <!-- end-model-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	KDMEntity getTo();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This operation returns the KDM entity that is the from-endpoint (the origin) of the
	 * current relationship.
	 * <!-- end-model-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	KDMEntity getFrom();

} // KDMRelationship
