/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui.common;

import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/**
 * This class defines remove dialog box
 * 
 * @author Nicolas Payneau
 */
public class RemoveDialog extends Dialog {
	private Constants mode = Constants.Cancel;
	private String transformationName = null;

	/**
	 * Class constructor
	 */
	public RemoveDialog(final Shell shell, final String transformationName) {
		super(shell);
		Window.setDefaultImage(Activator.getImageDescriptor(
				Constants.pathLittleImage).createImage());
		this.transformationName = transformationName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.dialogs.Dialog#createContents(org.eclipse.swt.widgets
	 * .Composite)
	 */
	@Override
	protected Control createContents(final Composite parent) {
		GridData gridDataLabel = new GridData();
		gridDataLabel.verticalSpan = 10;
		gridDataLabel.horizontalAlignment = SWT.CENTER;
		gridDataLabel.verticalAlignment = SWT.CENTER;

		GridLayout dialogLayout = new GridLayout();
		dialogLayout.numColumns = 1;
		dialogLayout.horizontalSpacing = 9;
		parent.setLayout(dialogLayout);

		Label labelInformation = new Label(parent, SWT.NONE);
		labelInformation.setText(Messages.RemoveDialog_0
				+ this.transformationName + Messages.RemoveDialog_1);
		labelInformation.setLayoutData(gridDataLabel);

		GridData dataButtons = new GridData();
		dataButtons.horizontalAlignment = SWT.CENTER;
		Composite compositeButton = new Composite(parent, SWT.NULL);
		compositeButton.setLayoutData(dataButtons);
		GridLayout layoutButton = new GridLayout();
		layoutButton.numColumns = 3;
		layoutButton.horizontalSpacing = 9;
		compositeButton.setLayout(layoutButton);
		Button deleteFromLauncher = new Button(compositeButton, SWT.NONE);
		deleteFromLauncher.setText(Messages.RemoveDialog_2);
		Button deleteFromWorkflow = new Button(compositeButton, SWT.NONE);
		deleteFromWorkflow.setText(Messages.RemoveDialog_3);
		Button cancel = new Button(compositeButton, SWT.NONE);
		cancel.setText(Messages.RemoveDialog_4);
		cancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(final SelectionEvent e) {
				RemoveDialog.this.close();
			}
		});
		deleteFromWorkflow.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(final SelectionEvent e) {
				RemoveDialog.this.setMode(Constants.deleteFromWorkflowMode);
				RemoveDialog.this.close();
			}
		});
		deleteFromLauncher.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(final SelectionEvent e) {
				RemoveDialog.this.setMode(Constants.deleteFromLauncherMode);
				RemoveDialog.this.close();
			}
		});
		this.getShell().setText(Messages.RemoveDialog_5);
		return labelInformation;
	}

	/**
	 * Allows to retrieve the delete mode (deleteFromWorkflow or
	 * deleteFromLauncher)
	 * 
	 * @return Return the delete mode
	 */
	public Constants getMode() {
		return this.mode;
	}

	public void setMode(final Constants mode) {
		this.mode = mode;
	}

}
