/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.defaultengine;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.WorkflowModelInterface;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.ModiscoworkflowFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowModelImpl
implements WorkflowModelInterface {
    private List<Element> moDiscoElementList;

    @Override
    public void addComponentWorkflow(EObject eModiscowork) {
        Element moDiscoWork = (Element)eModiscowork;
        this.moDiscoElementList.add(moDiscoWork);
    }

    @Override
    public List<EObject> getAllComponents() {
        List<EObject> listComponents = this.moDiscoElementList;
        return listComponents;
    }

    @Override
    public EObject getComponent(int index) {
        return this.moDiscoElementList.get(index);
    }

    @Override
    public void initialization(ILaunchConfiguration configuration, String path) {
        try {
            this.moDiscoElementList = this.stringListToElementList(configuration.getAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist, new ArrayList()));
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private List<Element> stringListToElementList(List<String> stringList) {
        ArrayList<Element> moDiscoList = new ArrayList<Element>();
        int i = 0;
        while (i < stringList.size()) {
            Element modisco = null;
            modisco = stringList.get(i + 2).equals(MoDiscoWorkflowLaunchConstants.launchTypeMoDiscoWorkflow) ? ModiscoworkflowFactory.eINSTANCE.createWorkflow() : ModiscoworkflowFactory.eINSTANCE.createWork();
            modisco.setName(stringList.get(i));
            modisco.setIndex(Integer.parseInt(stringList.get(i + 1)));
            modisco.setType(stringList.get(i + 2));
            moDiscoList.add(modisco);
            i += 3;
        }
        return moDiscoList;
    }

    @Override
    public void moveResource(String path) {
    }

    @Override
    public void removeComponent(int index) {
        this.moDiscoElementList.remove(index);
    }

    @Override
    public void removeResource(String resourcePath) {
    }

    @Override
    public void save(ILaunchConfigurationWorkingCopy configuration, boolean onlyLaunch) {
        ArrayList<String> listString = new ArrayList<String>();
        for (Element modisco : this.moDiscoElementList) {
            listString.add(modisco.getName());
            listString.add(Integer.toString(modisco.getIndex()));
            listString.add(modisco.getType());
        }
        configuration.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist, listString);
    }

    public void saveLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration) {
        ArrayList<String> listString = new ArrayList<String>();
        for (Element modisco : this.moDiscoElementList) {
            listString.add(modisco.getName());
            listString.add(Integer.toString(modisco.getIndex()));
            listString.add(modisco.getType());
        }
        configuration.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist, listString);
    }

    @Override
    public void setComponent(int index, EObject moDiscoWork) {
        Element modisco = (Element)moDiscoWork;
        this.moDiscoElementList.set(index, modisco);
    }

    @Override
    public void exportWorkflow(ILaunchConfiguration configuration, String outputPath) {
        HashSet<File> files = new HashSet<File>();
        File fileRoot = null;
        if (!configuration.isLocal()) {
            IPath path = configuration.getFile().getLocation();
            fileRoot = path.toFile();
        } else {
            fileRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".metadata").append(".plugins").append("org.eclipse.debug.core").append(".launches").append(configuration.getName()).addFileExtension("launch").toFile();
        }
        files.add(fileRoot);
        Path pathOut = new Path(outputPath);
        String nameFile = fileRoot.getName().substring(0, fileRoot.getName().lastIndexOf(".")).concat(".zip");
        pathOut = pathOut.append(nameFile);
        this.createListLaunchConfig(configuration, files);
        this.createZip(files, pathOut.toFile());
    }

    private void createZip(Set<File> files, File outputFile) {
        int bufferZip = 2048;
        byte[] data = new byte[bufferZip];
        try {
            FileOutputStream dest = new FileOutputStream(outputFile);
            BufferedOutputStream buff = new BufferedOutputStream(dest);
            ZipOutputStream out = new ZipOutputStream(buff);
            out.setMethod(8);
            out.setLevel(9);
            for (File file : files) {
                int count;
                FileInputStream fi = new FileInputStream(file);
                BufferedInputStream buffi = new BufferedInputStream(fi, bufferZip);
                ZipEntry entry = new ZipEntry(file.getName());
                out.putNextEntry(entry);
                while ((count = buffi.read(data, 0, bufferZip)) != -1) {
                    out.write(data, 0, count);
                }
                out.closeEntry();
                buffi.close();
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private ILaunchConfiguration getLaunchConfigurationFromName(String configName) {
        ILaunchConfiguration configuration = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getName().equals(configName)) {
                    configuration = config;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return configuration;
    }

    private void createListLaunchConfig(ILaunchConfiguration configuration, Set<File> files) {
        try {
            List moDiscoList = configuration.getAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist, null);
            int i = 0;
            while (i < moDiscoList.size()) {
                ILaunchConfiguration config = this.getLaunchConfigurationFromName((String)moDiscoList.get(i));
                if (!config.isLocal()) {
                    IPath path = config.getFile().getLocation();
                    files.add(path.toFile());
                } else {
                    files.add(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".metadata").append(".plugins").append("org.eclipse.debug.core").append(".launches").append(config.getName()).addFileExtension("launch").toFile());
                }
                i += 3;
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    @Override
    public void downMoDiscoWork(int indexSelected) {
        Element modisco = this.moDiscoElementList.get(indexSelected);
        modisco.setIndex(indexSelected + 1);
        Element modisco2 = this.moDiscoElementList.get(indexSelected + 1);
        modisco2.setIndex(indexSelected);
        this.moDiscoElementList.set(indexSelected + 1, modisco);
        this.moDiscoElementList.set(indexSelected, modisco2);
    }

    @Override
    public void upMoDisoWork(int indexSelected) {
        Element modisco = this.moDiscoElementList.get(indexSelected);
        modisco.setIndex(indexSelected - 1);
        Element modisco2 = this.moDiscoElementList.get(indexSelected - 1);
        modisco2.setIndex(indexSelected);
        this.moDiscoElementList.set(indexSelected - 1, modisco);
        this.moDiscoElementList.set(indexSelected, modisco2);
    }

    @Override
    public void synchronization(List<Element> allMoDiscoWork) {
    }
}

