/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui.common;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.gmt.modisco.workflow.ui.common.Common;
import org.eclipse.gmt.modisco.workflow.ui.common.Messages;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportDialog
extends Dialog {
    private Text baseNameText;
    private Text projectNameText;
    private Text symbolicNameText;
    private boolean export;
    private Composite compositeButton = null;
    private Button exportButton = null;
    private String baseName;
    private String projectName;
    private String symbolicName;
    private String defaultName;

    public ExportDialog(String defaultName, Shell parentShell) {
        super(parentShell);
        this.defaultName = defaultName;
    }

    protected Control createContents(Composite parent) {
        parent.getShell().setSize(400, 150);
        parent.getShell().setLocation(Common.getInstance().centerShell(parent.getShell().getDisplay(), parent.getShell()));
        GridLayout layoutParent = new GridLayout();
        parent.setLayout((Layout)layoutParent);
        layoutParent.numColumns = 3;
        layoutParent.makeColumnsEqualWidth = false;
        GridData gdText = new GridData();
        gdText.horizontalAlignment = 4;
        gdText.horizontalSpan = 2;
        gdText.grabExcessHorizontalSpace = true;
        gdText.verticalAlignment = 2;
        Label labelProjectName = new Label(parent, 0);
        labelProjectName.setText(Messages.ExportDialog_0);
        this.projectNameText = new Text(parent, 2048);
        this.projectNameText.setLayoutData((Object)gdText);
        this.projectNameText.setText(this.defaultName.toLowerCase());
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog.this.updateButton();
            }
        });
        Label labelSymbolicName = new Label(parent, 0);
        labelSymbolicName.setText(Messages.ExportDialog_1);
        this.symbolicNameText = new Text(parent, 2048);
        this.symbolicNameText.setLayoutData((Object)gdText);
        this.symbolicNameText.setText(this.defaultName.toLowerCase());
        this.symbolicNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog.this.updateButton();
            }
        });
        Label labelBase = new Label(parent, 0);
        labelBase.setText(Messages.ExportDialog_2);
        this.baseNameText = new Text(parent, 2048);
        this.baseNameText.setLayoutData((Object)gdText);
        this.baseNameText.setText("org.eclipse." + this.defaultName.toLowerCase());
        this.baseNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog.this.updateButton();
            }
        });
        this.createCompositeButton(parent);
        this.getShell().setText(Messages.ExportDialog_4);
        return parent;
    }

    private void createCompositeButton(Composite parent) {
        GridData gdButtonExport = new GridData();
        gdButtonExport.grabExcessHorizontalSpace = true;
        gdButtonExport.verticalAlignment = 2;
        gdButtonExport.horizontalAlignment = 3;
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 1;
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.verticalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData4 = new GridData();
        gridData4.horizontalSpan = 3;
        gridData4.verticalAlignment = 4;
        gridData4.grabExcessVerticalSpace = true;
        gridData4.horizontalAlignment = 4;
        this.compositeButton = new Composite(parent, 0);
        this.compositeButton.setLayoutData((Object)gridData4);
        this.compositeButton.setLayout((Layout)gridLayout);
        this.exportButton = new Button(this.compositeButton, 0);
        this.exportButton.setText(Messages.ExportDialog_5);
        this.exportButton.setLayoutData((Object)gdButtonExport);
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                IStatus status = ExportDialog.this.verifyAllName();
                if (status.isOK()) {
                    ExportDialog.this.setExport(true);
                    ExportDialog.this.setProjectName(ExportDialog.this.getProjectNameText().getText().trim());
                    ExportDialog.this.setBaseName(ExportDialog.this.getBaseNameText().getText().trim());
                    ExportDialog.this.setSymbolicName(ExportDialog.this.getSymbolicNameText().getText().trim());
                    ExportDialog.this.close();
                } else {
                    MessageDialog.openError((Shell)ExportDialog.this.getShell(), (String)Messages.ExportDialog_6, (String)status.getMessage());
                }
            }
        });
        Button buttonCancel = new Button(this.compositeButton, 0);
        buttonCancel.setText(Messages.ExportDialog_7);
        buttonCancel.setLayoutData((Object)gridData5);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExportDialog.this.setExport(false);
                ExportDialog.this.close();
            }
        });
        this.updateButton();
    }

    void updateButton() {
        if (this.projectNameText.getText().trim().length() > 0 && this.baseNameText.getText().trim().length() > 0) {
            this.exportButton.setEnabled(true);
        } else {
            this.exportButton.setEnabled(false);
        }
    }

    IStatus verifyAllName() {
        IStatus status = null;
        status = JavaConventions.validatePackageName((String)this.symbolicNameText.getText(), (String)"1.6", (String)"1.6");
        if (status.isOK()) {
            status = JavaConventions.validatePackageName((String)this.baseNameText.getText(), (String)"1.6", (String)"1.6");
        }
        return status;
    }

    public boolean isExport() {
        return this.export;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setExport(boolean export) {
        this.export = export;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public Text getProjectNameText() {
        return this.projectNameText;
    }

    protected void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    protected Text getBaseNameText() {
        return this.baseNameText;
    }

    protected Text getSymbolicNameText() {
        return this.symbolicNameText;
    }
}

