/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.correlation;

import java.util.Comparator;
import org.eclipse.hyades.collection.correlation.BaseCorrelatorDataImpl;
import org.eclipse.hyades.collection.correlation.CorrelatorAssociation;
import org.eclipse.hyades.collection.correlation.CorrelatorStack;
import org.eclipse.hyades.collection.correlation.IApplication;
import org.eclipse.hyades.collection.correlation.IContextHandler;
import org.eclipse.hyades.collection.correlation.ICorrelatorData;
import org.eclipse.hyades.collection.correlation.Stack;

public abstract class BaseApplicationImpl
implements IApplication {
    private static final int CORRELATOR_POOL_SIZE = 20;
    private static final int CORRELATOR_POOL_INCREMENT = 10;
    private static final int CORRELATOR_STACK_SIZE = 10;
    private static final int CORRELATOR_STACK_INCREMENT = 10;
    private static final int CORRELATOR_STACKS_SIZE = 10;
    private static final int CORRELATOR_STACKS_INCREMENT = 10;
    private static final int CORRELATOR_ASSOCIATION_POOL_SIZE = 20;
    private static final int CORRELATOR_ASSOCIATION_POOL_INCREMENT = 10;
    private long applicationCounter;
    private Stack correlatorPool;
    private Stack correlatorStacks;
    protected IContextHandler handler;
    private Stack correlatorAssocationPool;

    public abstract BaseCorrelatorDataImpl instantiateCorrelator();

    public void initialize() {
        this.applicationCounter = 0L;
        this.correlatorPool = new Stack(20, 10);
        this.correlatorStacks = new Stack(10, 10);
        this.correlatorAssocationPool = new Stack(20, 10);
        this.handler = null;
    }

    public ICorrelatorData createCorrelatorData() {
        BaseCorrelatorDataImpl correlator = (BaseCorrelatorDataImpl)this.correlatorPool.pop();
        if (correlator == null) {
            correlator = this.instantiateCorrelator();
        } else {
            correlator.invalidate();
        }
        correlator.setApplication(this);
        return correlator;
    }

    public void returnCorrelatorData(ICorrelatorData correlator) {
        this.correlatorPool.push(correlator);
    }

    protected CorrelatorAssociation createCorrelatorAssociation() {
        CorrelatorAssociation association = (CorrelatorAssociation)this.correlatorAssocationPool.pop();
        return association == null ? new CorrelatorAssociation() : association;
    }

    public CorrelatorAssociation handleCall(Comparator key, ICorrelatorData parent) {
        CorrelatorStack stack = this.findCorrelatorStack(key);
        if (stack == null) {
            stack = this.createCorrelatorStack(key);
        }
        if (parent == null) {
            parent = (ICorrelatorData)stack.peek();
        } else {
            ((BaseCorrelatorDataImpl)parent).setApplicationCounter(this.incrementCounter());
            ((BaseCorrelatorDataImpl)parent).setOperationCounter(stack.getOperationCounter());
        }
        CorrelatorAssociation association = this.createCorrelatorAssociation();
        association.setParent(parent);
        association.setChild(null);
        if (this.handler != null) {
            this.handler.handleSend(association);
        }
        return association;
    }

    public CorrelatorAssociation handleCall(Comparator key) {
        return this.handleCall(key, null);
    }

    public CorrelatorAssociation handleReturn(Comparator key, ICorrelatorData parent, ICorrelatorData child) {
        CorrelatorStack stack = this.findCorrelatorStack(key);
        if (child == null) {
            parent = (ICorrelatorData)stack.peek();
        } else {
            ((BaseCorrelatorDataImpl)child).setApplicationCounter(this.incrementCounter());
            ((BaseCorrelatorDataImpl)child).setOperationCounter(stack.getOperationCounter());
        }
        CorrelatorAssociation association = this.createCorrelatorAssociation();
        association.setParent(parent);
        association.setChild(child);
        if (this.handler != null) {
            this.handler.handleReturn(association);
        }
        return association;
    }

    public CorrelatorAssociation handleReturn(Comparator key, ICorrelatorData parent) {
        return this.handleReturn(key, parent, null);
    }

    public CorrelatorAssociation pushChild(Comparator key, ICorrelatorData child) {
        CorrelatorStack stack = this.findCorrelatorStack(key);
        if (stack == null) {
            stack = this.createCorrelatorStack(key);
        }
        ICorrelatorData parent = (ICorrelatorData)stack.peek();
        ((BaseCorrelatorDataImpl)child).setApplicationCounter(this.incrementCounter());
        ((BaseCorrelatorDataImpl)child).setOperationCounter(stack.incrementOperationCounter());
        stack.push(child);
        CorrelatorAssociation association = this.createCorrelatorAssociation();
        association.setParent(parent);
        association.setChild(child);
        if (this.handler != null) {
            this.handler.handleEntry(association);
        }
        return association;
    }

    public CorrelatorAssociation popChild(Comparator key) {
        CorrelatorStack stack = this.findCorrelatorStack(key);
        BaseCorrelatorDataImpl child = (BaseCorrelatorDataImpl)stack.pop();
        child.setApplicationCounter(this.incrementCounter());
        CorrelatorAssociation association = this.createCorrelatorAssociation();
        association.setParent((ICorrelatorData)stack.peek());
        association.setChild(child);
        if (this.handler != null) {
            this.handler.handleExit(association);
        }
        return association;
    }

    public CorrelatorAssociation pushParent(Comparator key, ICorrelatorData parent, ICorrelatorData child) {
        CorrelatorStack stack = this.findCorrelatorStack(key);
        if (stack == null) {
            stack = this.createCorrelatorStack(key);
        }
        if (child == null) {
            stack.push(parent);
        } else {
            ((BaseCorrelatorDataImpl)child).setApplicationCounter(this.incrementCounter());
            ((BaseCorrelatorDataImpl)child).setOperationCounter(stack.incrementOperationCounter());
            stack.push(child);
        }
        CorrelatorAssociation association = this.createCorrelatorAssociation();
        association.setParent(parent);
        association.setChild(child);
        if (this.handler != null) {
            this.handler.handleReceive(association);
        }
        return association;
    }

    public CorrelatorAssociation pushParent(Comparator key, ICorrelatorData parent) {
        return this.pushParent(key, parent, null);
    }

    public CorrelatorAssociation popParent(Comparator key, ICorrelatorData parent) {
        ICorrelatorData newParent;
        CorrelatorStack stack = this.findCorrelatorStack(key);
        if (stack == null) {
            stack = this.createCorrelatorStack(key);
        }
        if (parent == null) {
            newParent = (ICorrelatorData)stack.pop();
        } else {
            newParent = parent;
            ((BaseCorrelatorDataImpl)parent).setApplicationCounter(this.incrementCounter());
            ((BaseCorrelatorDataImpl)parent).setOperationCounter(stack.getOperationCounter());
        }
        CorrelatorAssociation association = this.createCorrelatorAssociation();
        association.setParent(newParent);
        association.setChild(null);
        if (this.handler != null) {
            this.handler.handleReply(association);
        }
        return association;
    }

    public CorrelatorAssociation popParent(Comparator key) {
        return this.popParent(key, null);
    }

    protected synchronized long incrementCounter() {
        return ++this.applicationCounter;
    }

    public ICorrelatorData getActiveCorrelatorByKey(Comparator key) {
        CorrelatorStack stack = this.findCorrelatorStack(key);
        return stack == null ? null : (ICorrelatorData)stack.peek();
    }

    protected CorrelatorStack createCorrelatorStack(Comparator key) {
        CorrelatorStack newStack = new CorrelatorStack(key, 10, 10);
        this.correlatorStacks.push(newStack);
        return newStack;
    }

    protected synchronized void destroyCorrelatorStack(Comparator key) {
        int i = 0;
        while (i <= this.correlatorStacks.top) {
            if (((CorrelatorStack)this.correlatorStacks.stack[i]).getKey().equals(key)) {
                this.correlatorStacks.stack[i] = this.correlatorStacks.stack[this.correlatorStacks.top];
                this.correlatorStacks.stack[this.correlatorStacks.top--] = null;
                return;
            }
            ++i;
        }
    }

    protected synchronized CorrelatorStack findCorrelatorStack(Comparator key) {
        int i = 0;
        while (i <= this.correlatorStacks.top) {
            if (((CorrelatorStack)this.correlatorStacks.stack[i]).getKey().equals(key)) {
                return (CorrelatorStack)this.correlatorStacks.stack[i];
            }
            ++i;
        }
        return null;
    }

    public void releaseAssociation(CorrelatorAssociation association) {
        this.correlatorAssocationPool.push(association);
    }

    public void registerHandler(IContextHandler handler) {
        this.handler = handler;
    }

    public void deregisterHandler() {
        this.handler = null;
    }
}

