/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.trace.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Utilities {
    public static String getCurrentTimeStamp() {
        String timeStamp = Long.toString(System.currentTimeMillis());
        int splitPoint = timeStamp.length() - 3;
        return String.valueOf(timeStamp.substring(0, splitPoint)) + "." + timeStamp.substring(splitPoint);
    }

    public static String getJniNotation(Class clazz) {
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Void.TYPE) {
            return "V";
        }
        if (clazz.isArray()) {
            return clazz.getName();
        }
        return "L" + clazz.getName() + ";";
    }

    public static byte[] serializeObject(Object object) {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outObject = new ObjectOutputStream(outBytes);
            outObject.writeObject(object);
            outObject.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outBytes.toByteArray();
    }

    public static Object deserializeObject(byte[] buffer, int offset, int length) {
        ByteArrayInputStream inBytes = new ByteArrayInputStream(buffer, offset, length);
        Object object = null;
        try {
            ObjectInputStream inObject = new ObjectInputStream(inBytes);
            object = inObject.readObject();
            inObject.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    public static String stringifyPrimitivesStrings(Class clazz, Object object) {
        return clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == Character.TYPE || clazz == Character.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == String.class ? object.toString() : null;
    }

    public static String getInvokedMethodSignature(Class[] parmClasses, String returnType) {
        if (parmClasses == null) {
            return null;
        }
        StringBuffer sigBuffer = new StringBuffer();
        int i = 0;
        while (i < parmClasses.length) {
            sigBuffer.append(Utilities.getJniNotation(parmClasses[i]));
            ++i;
        }
        return "(" + sigBuffer.toString() + ")" + (returnType == null ? "" : returnType);
    }
}

