/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.core.instrument;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.probekit.CompilerFactory;
import org.eclipse.hyades.probekit.IProbeCompiler;
import org.eclipse.hyades.probekit.ProbekitException;
import org.eclipse.hyades.probekit.editor.internal.core.util.JavaUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.JavaModelException;

public class GenerateOperation
implements IWorkspaceRunnable {
    private IFile _probeFile;

    public GenerateOperation(IFile probeFile) {
        this._probeFile = probeFile;
    }

    private IFile getProbeFile() {
        return this._probeFile;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            IFile file = this.getProbeFile();
            IContainer fileContainer = file.getParent();
            file.deleteMarkers("org.eclipse.hyades.probekit.probekitProblem", true, 0);
            IProbeCompiler c = CompilerFactory.INSTANCE.createCompiler();
            String basename = ResourceUtil.getBaseName(file);
            basename = c.makeValidJavaIdentifier(basename);
            c.setClassPrefix(basename);
            c.addIFile(file);
            String generatedSource = c.getGeneratedSource();
            String suffix = c.getClassSuffix();
            IFile javaSourceIFile = fileContainer.getFile((IPath)new Path(String.valueOf(basename) + suffix + ".java"));
            ByteArrayInputStream newJavaContents = new ByteArrayInputStream(generatedSource.getBytes());
            if (javaSourceIFile.exists()) {
                javaSourceIFile.setContents((InputStream)newJavaContents, true, false, monitor);
            } else {
                javaSourceIFile.create((InputStream)newJavaContents, true, monitor);
            }
            String engineScript = c.getEngineScript();
            IFile engineScriptIFile = fileContainer.getFile((IPath)new Path(String.valueOf(basename) + ".probescript"));
            ByteArrayInputStream newScriptContents = new ByteArrayInputStream(engineScript.getBytes());
            if (engineScriptIFile.exists()) {
                engineScriptIFile.setContents((InputStream)newScriptContents, true, false, monitor);
            } else {
                engineScriptIFile.create((InputStream)newScriptContents, true, monitor);
            }
        }
        catch (ProbekitException exc) {
            IStatus status = ResourceUtil.createInitialStatus(4, exc);
            throw new CoreException(status);
        }
    }

    public static final class GenerateOperationUtil {
        private static final String SCRIPT_EXTENSION = "script";
        private static final String GEN_JAVA_EXTENSION = "_probe.java";
        public static final String DOT_PROBESCRIPT_EXTENSION = ".probescript";

        public static IFile[] getProbekitGeneratedFiles(IFile probeFile) {
            return new IFile[]{GenerateOperationUtil.getProbeScriptFile(probeFile), GenerateOperationUtil.getProbeJavaFile(probeFile)};
        }

        public static IClassFile[] getProbekitGeneratedClassFiles(IFile probeFile) throws JavaModelException {
            return JavaUtil.getClassFiles(GenerateOperationUtil.getProbeJavaFile(probeFile));
        }

        public static boolean needToGenerateProbe(IFile probeFile) {
            IFile[] generatedFiles = GenerateOperationUtil.getProbekitGeneratedFiles(probeFile);
            return GenerateOperationUtil.isOlderThan(probeFile, generatedFiles);
        }

        private static boolean isOlderThan(IFile probeFile, IFile[] generatedFiles) {
            int i = 0;
            while (i < generatedFiles.length) {
                IFile file = generatedFiles[i];
                if (!file.isAccessible()) {
                    return true;
                }
                if (GenerateOperationUtil.isOlderThan(file, probeFile)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean isOlderThan(IFile isNewer, IFile isOlder) {
            long newerTime = isNewer.getLocalTimeStamp();
            long olderTime = isOlder.getLocalTimeStamp();
            return olderTime > newerTime;
        }

        private static IFile getProbeScriptFile(IFile probeFile) {
            String probeScriptFileName = String.valueOf(probeFile.getName()) + SCRIPT_EXTENSION;
            Path scriptPath = new Path(probeScriptFileName);
            IContainer probeDir = probeFile.getParent();
            return probeDir.getFile((IPath)scriptPath);
        }

        public static IFile getProbeJavaFile(IFile probeFile) {
            String fileName = String.valueOf(ResourceUtil.getBaseName(probeFile)) + GEN_JAVA_EXTENSION;
            Path filePath = new Path(fileName);
            IContainer probeDir = probeFile.getParent();
            return probeDir.getFile((IPath)filePath);
        }

        public static IMarker[] getGenerateErrors(IFile[] files) throws CoreException {
            HashSet markers = new HashSet();
            int i = 0;
            while (i < files.length) {
                IFile file = files[i];
                Set compileErrors = GenerateOperationUtil.getGenerateErrors(file);
                markers.addAll(compileErrors);
                ++i;
            }
            return markers.toArray(new IMarker[markers.size()]);
        }

        private static Set getGenerateErrors(IFile file) throws CoreException {
            IMarker[] markers = file.findMarkers("org.eclipse.hyades.probekit.probekitProblem", true, 2);
            return ResourceUtil.getErrors(markers);
        }
    }
}

