/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.core.instrument;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;

public class JavacOperation
implements IWorkspaceRunnable {
    private IProject _project;

    public JavacOperation(IProject project) {
        this._project = project;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = this._project.getDescription();
        ICommand javaBuilder = JavacOperationUtil.getJavaCommand(description);
        if (javaBuilder != null) {
            this._project.build(10, "org.eclipse.jdt.core.javabuilder", javaBuilder.getArguments(), monitor);
        }
    }

    public static class JavacOperationUtil {
        public static IMarker[] getCompileErrors(IFile[] files) throws CoreException {
            HashSet markers = new HashSet();
            int i = 0;
            while (i < files.length) {
                IFile file = files[i];
                Set compileErrors = JavacOperationUtil.getCompileErrors((IResource)file);
                markers.addAll(compileErrors);
                ++i;
            }
            return markers.toArray(new IMarker[markers.size()]);
        }

        public static boolean hasCompileErrors(IFile[] files) throws CoreException {
            int i = 0;
            while (i < files.length) {
                IFile file = files[i];
                if (JavacOperationUtil.hasCompileErrors((IResource)file)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public static boolean hasCompileErrors(IResource resource) throws CoreException {
            return JavacOperationUtil.getCompileErrors(resource).size() > 0;
        }

        private static Set getCompileErrors(IResource resource) throws CoreException {
            IMarker[] markers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
            return ResourceUtil.getErrors(markers);
        }

        public static ICommand getJavaCommand(IProjectDescription description) {
            if (description == null) {
                return null;
            }
            ICommand[] commands = description.getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                if ("org.eclipse.jdt.core.javabuilder".equals(commands[i].getBuilderName())) {
                    return commands[i];
                }
                ++i;
            }
            return null;
        }
    }
}

