/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.core.newFile;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.DataType;
import org.eclipse.hyades.models.internal.probekit.FragmentType;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;

public final class ProbekitTypesSingleton {
    private static final String DATA_ITEM_DEFAULT_NAME_PREFIX = "a";
    private static ProbekitTypesSingleton _singleton = null;
    private Map _availableFragmentTypes = new TreeMap(new Sorter());
    private Map _availableDataTypes = new HashMap();

    public static ProbekitTypesSingleton singleton() {
        if (_singleton == null) {
            _singleton = new ProbekitTypesSingleton();
        }
        return _singleton;
    }

    public String getFragmentTypeExplanation(FragmentType type) {
        FragmentTypeMetaData typeMd = (FragmentTypeMetaData)this._availableFragmentTypes.get(type);
        if (typeMd == null) {
            return "";
        }
        return typeMd.getFragmentTypeExplanation();
    }

    public DataType[] getDataTypes(FragmentType type) {
        FragmentTypeMetaData typeMd = (FragmentTypeMetaData)this._availableFragmentTypes.get(type);
        if (typeMd == null) {
            return new DataType[0];
        }
        return typeMd.getValidDataTypes();
    }

    public String getDataTypeExplanation(DataType type) {
        String explanation = (String)this._availableDataTypes.get(type);
        return ResourceUtil.getString(explanation);
    }

    public String[] getDataTypeNames(FragmentType type) {
        DataType[] dataTypes = this.getDataTypes(type);
        String[] dataTypeNames = new String[dataTypes.length];
        int i = 0;
        while (i < dataTypes.length) {
            DataType dtype = dataTypes[i];
            dataTypeNames[i] = dtype.getName();
            ++i;
        }
        return dataTypeNames;
    }

    public boolean isValidDataItemNames(DataItem[] items) {
        HashSet<String> namesSoFar = new HashSet<String>(items.length);
        int i = 0;
        while (i < items.length) {
            DataItem item = items[i];
            String name = item.getName();
            if (name != null) {
                namesSoFar.add(name);
            }
            ++i;
        }
        return namesSoFar.size() >= items.length;
    }

    public boolean isValidDataItemTypes(DataItem[] items) {
        HashSet<DataType> typesSoFar = new HashSet<DataType>(items.length);
        int i = 0;
        while (i < items.length) {
            DataItem item = items[i];
            DataType dataType = item.getType();
            if (dataType != null) {
                typesSoFar.add(dataType);
            }
            ++i;
        }
        return typesSoFar.size() >= items.length;
    }

    public String getInitialDataItemName(DataType arbitraryType, int count) {
        StringBuffer buffer = new StringBuffer(DATA_ITEM_DEFAULT_NAME_PREFIX);
        buffer.append(arbitraryType.getName());
        buffer.append(count);
        return buffer.toString();
    }

    public DataItem createDataItem(DataType[] availableTypes, int count) {
        DataType arbitraryType = availableTypes[0];
        String initialName = ProbekitTypesSingleton.singleton().getInitialDataItemName(arbitraryType, count);
        DataItem item = ProbekitPackage.eINSTANCE.getProbekitFactory().createDataItem();
        item.setType(arbitraryType);
        item.setName(initialName);
        return item;
    }

    private ProbekitTypesSingleton() {
        this.initialize();
    }

    private void initialize() {
        this.initializeFragmentTypes();
        this.initializeDataTypes();
    }

    private void initializeFragmentTypes() {
        this._availableFragmentTypes.put(FragmentType.BEFORE_CALL_LITERAL, new FragmentTypeMetaData(ProbekitMessages._67, new DataType[]{DataType.CLASS_NAME_LITERAL, DataType.METHOD_NAME_LITERAL, DataType.METHOD_SIG_LITERAL, DataType.THIS_OBJECT_LITERAL, DataType.ARGS_LITERAL}));
        this._availableFragmentTypes.put(FragmentType.AFTER_CALL_LITERAL, new FragmentTypeMetaData(ProbekitMessages._68, new DataType[]{DataType.CLASS_NAME_LITERAL, DataType.METHOD_NAME_LITERAL, DataType.METHOD_SIG_LITERAL, DataType.THIS_OBJECT_LITERAL, DataType.EXCEPTION_OBJECT_LITERAL, DataType.ARGS_LITERAL, DataType.RETURNED_OBJECT_LITERAL}));
        this._availableFragmentTypes.put(FragmentType.CATCH_LITERAL, new FragmentTypeMetaData(ProbekitMessages._69, new DataType[]{DataType.CLASS_NAME_LITERAL, DataType.METHOD_NAME_LITERAL, DataType.METHOD_SIG_LITERAL, DataType.THIS_OBJECT_LITERAL, DataType.ARGS_LITERAL, DataType.EXCEPTION_OBJECT_LITERAL, DataType.IS_FINALLY_LITERAL, DataType.CLASS_SOURCE_FILE_LITERAL, DataType.METHOD_NAMES_LITERAL, DataType.METHOD_LINE_TABLES_LITERAL, DataType.METHOD_NUMBER_LITERAL, DataType.EXECUTABLE_UNIT_NUMBER_LITERAL, DataType.STATIC_FIELD_LITERAL}));
        this._availableFragmentTypes.put(FragmentType.ENTRY_LITERAL, new FragmentTypeMetaData(ProbekitMessages._70, new DataType[]{DataType.CLASS_NAME_LITERAL, DataType.METHOD_NAME_LITERAL, DataType.METHOD_SIG_LITERAL, DataType.THIS_OBJECT_LITERAL, DataType.ARGS_LITERAL, DataType.CLASS_SOURCE_FILE_LITERAL, DataType.METHOD_NAMES_LITERAL, DataType.METHOD_LINE_TABLES_LITERAL, DataType.METHOD_NUMBER_LITERAL, DataType.STATIC_FIELD_LITERAL}));
        this._availableFragmentTypes.put(FragmentType.EXECUTABLE_UNIT_LITERAL, new FragmentTypeMetaData(ProbekitMessages._71, new DataType[]{DataType.CLASS_NAME_LITERAL, DataType.METHOD_NAME_LITERAL, DataType.METHOD_SIG_LITERAL, DataType.ARGS_LITERAL, DataType.CLASS_SOURCE_FILE_LITERAL, DataType.METHOD_NAMES_LITERAL, DataType.METHOD_LINE_TABLES_LITERAL, DataType.METHOD_NUMBER_LITERAL, DataType.EXECUTABLE_UNIT_NUMBER_LITERAL, DataType.STATIC_FIELD_LITERAL, DataType.PREVIOUS_UNIT_NUMBER_LITERAL}));
        this._availableFragmentTypes.put(FragmentType.EXIT_LITERAL, new FragmentTypeMetaData(ProbekitMessages._72, new DataType[]{DataType.CLASS_NAME_LITERAL, DataType.METHOD_NAME_LITERAL, DataType.METHOD_SIG_LITERAL, DataType.THIS_OBJECT_LITERAL, DataType.ARGS_LITERAL, DataType.EXCEPTION_OBJECT_LITERAL, DataType.RETURNED_OBJECT_LITERAL, DataType.CLASS_SOURCE_FILE_LITERAL, DataType.METHOD_NAMES_LITERAL, DataType.METHOD_LINE_TABLES_LITERAL, DataType.METHOD_NUMBER_LITERAL, DataType.STATIC_FIELD_LITERAL}));
        this._availableFragmentTypes.put(FragmentType.STATIC_INITIALIZER_LITERAL, new FragmentTypeMetaData(ProbekitMessages._73, new DataType[]{DataType.CLASS_NAME_LITERAL, DataType.CLASS_SOURCE_FILE_LITERAL, DataType.METHOD_NAMES_LITERAL, DataType.METHOD_LINE_TABLES_LITERAL, DataType.METHOD_NUMBER_LITERAL, DataType.STATIC_FIELD_LITERAL}));
    }

    private void initializeDataTypes() {
        this._availableDataTypes.put(DataType.CLASS_NAME_LITERAL, ProbekitMessages._74);
        this._availableDataTypes.put(DataType.METHOD_NAME_LITERAL, ProbekitMessages._75);
        this._availableDataTypes.put(DataType.METHOD_SIG_LITERAL, ProbekitMessages._76);
        this._availableDataTypes.put(DataType.THIS_OBJECT_LITERAL, ProbekitMessages._77);
        this._availableDataTypes.put(DataType.ARGS_LITERAL, ProbekitMessages._78);
        this._availableDataTypes.put(DataType.RETURNED_OBJECT_LITERAL, ProbekitMessages._79);
        this._availableDataTypes.put(DataType.EXCEPTION_OBJECT_LITERAL, ProbekitMessages._80);
        this._availableDataTypes.put(DataType.IS_FINALLY_LITERAL, ProbekitMessages._81);
        this._availableDataTypes.put(DataType.CLASS_SOURCE_FILE_LITERAL, ProbekitMessages._82);
        this._availableDataTypes.put(DataType.METHOD_NAMES_LITERAL, ProbekitMessages._83);
        this._availableDataTypes.put(DataType.METHOD_LINE_TABLES_LITERAL, ProbekitMessages._84);
        this._availableDataTypes.put(DataType.METHOD_NUMBER_LITERAL, ProbekitMessages._85);
        this._availableDataTypes.put(DataType.EXECUTABLE_UNIT_NUMBER_LITERAL, ProbekitMessages._86);
    }

    private static class FragmentTypeMetaData {
        private final String _fragmentTypeExplanation;
        private final DataType[] _dataTypes;

        public FragmentTypeMetaData(String explanation, DataType[] validDataTypes) {
            this._fragmentTypeExplanation = explanation;
            this._dataTypes = validDataTypes;
        }

        public String getFragmentTypeExplanation() {
            return this._fragmentTypeExplanation;
        }

        public DataType[] getValidDataTypes() {
            return this._dataTypes;
        }
    }

    private static class Sorter
    implements Comparator {
        private Sorter() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            FragmentType aType = (FragmentType)a;
            FragmentType bType = (FragmentType)b;
            return aType.getValue() - bType.getValue();
        }
    }
}

