/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.DocumentRoot;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.hyades.models.internal.probekit.ProbekitFactory;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.probekit.ProbekitCompileProblemException;
import org.eclipse.hyades.probekit.ProbekitException;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.presentation.EObjectListAdapterFactory;
import org.eclipse.hyades.probekit.editor.internal.presentation.EObjectListAdapterFactoryEditingDomain;
import org.eclipse.hyades.probekit.editor.internal.presentation.GeneralTab;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitActionBarContributor;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitContentProvider;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitDetailsViewer;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.presentation.codeassist.JavaSnippet;
import org.eclipse.hyades.probekit.editor.internal.presentation.codeassist.SyntaxAdapter;
import org.eclipse.hyades.probekit.editor.internal.provider.EObjectListSwitch;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.hyades.probekit.editor.internal.ui.DialogUtil;
import org.eclipse.hyades.probekit.ui.internal.ContextIds;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.hyades.ui.internal.editor.action.ActionHandlerListener;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.xml.sax.SAXParseException;

public class ProbekitEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    private GeneralTab _generalTab = null;
    private Composite _probesTab = null;
    private int _generalTabIndex;
    private int _probesTabIndex;
    private boolean _hasSyntaxBeenChecked = false;
    private Composite _errorComposite = null;
    private TableViewer _syntaxErrors = null;
    private TableColumn _iconColumn = null;
    private TableColumn _descriptionColumn = null;
    private TableColumn _resourceColumn = null;
    private SyntaxViewerSorter _syntaxErrorSorter = null;
    private Label _syntaxErrorTitle = null;
    protected final String[] COLUMNS = new String[]{"", ProbekitMessages._135, ProbekitMessages._136};
    protected List _jdtProblems = null;
    protected JavaSnippet _snippet = null;
    IFile file;
    private boolean isActivating;
    protected ProbekitWidgetFactory widgetFactory;
    protected ProbekitItemProviderAdapterFactory itemProviderFactory;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected TreeViewer selectionViewer;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected ProbekitDetailsViewer detailsViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection editorSelection;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == ProbekitEditor.this.propertySheetPage) {
                    ProbekitEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)ProbekitEditor.this);
                    ProbekitEditor.this.handleActivate();
                }
            } else if (p == ProbekitEditor.this) {
                ProbekitEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    Collection removedResources = new ArrayList();
    Collection changedResources = new ArrayList();
    Collection savedResources = new ArrayList();
    private MyActionHandlerListener actionHandlerListener;

    protected void handleActivate() {
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            this.editingDomain.getCommandStack().flush();
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    ProbekitUIPlugin.INSTANCE.log(exception);
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)ProbekitMessages._10, (String)ProbekitMessages._9);
    }

    public ProbekitEditor() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        this.itemProviderFactory = new ProbekitItemProviderAdapterFactory();
        factories.add((Object)this.itemProviderFactory);
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new EObjectListAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener((CommandStackListener)new MyCommandStackListener());
        this.editingDomain = new EObjectListAdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack);
        this.actionHandlerListener = new MyActionHandlerListener();
        this._jdtProblems = new ArrayList();
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public ResourceLocator getResourceLocator() {
        return ProbekitUIPlugin.INSTANCE;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createPages() {
        this.initializeFactories();
        Probekit probekit = this.getProbekit();
        List probes = this.getProbes();
        this._snippet = new JavaSnippet(((IFileEditorInput)this.getEditorInput()).getFile(), probekit);
        this._generalTabIndex = this.createGeneralPage(probekit);
        this._probesTabIndex = this.createProbesPage(probes);
        this.setActivePage(this._probesTabIndex);
    }

    private void initializeFactories() {
        this.widgetFactory = new ProbekitWidgetFactory();
        IFileEditorInput modelFile = (IFileEditorInput)this.getEditorInput();
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(URI.createPlatformResourceURI((String)modelFile.getFile().getFullPath().toString()), true);
        }
        catch (Exception exception) {
            if (exception instanceof WrappedException && ((WrappedException)exception).exception() instanceof SAXParseException && modelFile.exists() && modelFile.getFile().getLocation().toFile().length() == 0L) {
                resource = this.editingDomain.getResourceSet().getResource(URI.createPlatformResourceURI((String)modelFile.getFile().getFullPath().toString()), false);
                if (resource == null) {
                    resource = this.editingDomain.getResourceSet().createResource(URI.createPlatformResourceURI((String)modelFile.getFile().getFullPath().toString()));
                } else {
                    resource.getErrors().clear();
                }
                this.addProbekitElement(resource);
            }
            ProbekitUIPlugin.INSTANCE.log(exception);
        }
    }

    private int createGeneralPage(Probekit probekit) {
        this._generalTab = new GeneralTab((EditingDomain)this.editingDomain, this.getContainer(), 0, probekit);
        this.addSelectionChangedListener(this._generalTab.GENERAL_TAB_SELECTION_LISTENER);
        int index = this.addPage((Control)this._generalTab);
        this.setPageText(index, ProbekitMessages._128);
        return index;
    }

    private int createProbesPage(List probes) {
        this._probesTab = this.createProbeTab(probes);
        int index = this.addPage((Control)this._probesTab);
        this.setPageText(index, ProbekitMessages._129);
        this.checkSyntax();
        return index;
    }

    protected Composite createProbeTab(List probes) {
        Composite parent = new Composite(this.getContainer(), 0);
        parent.setLayoutData((Object)GridUtil.createFill());
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 2;
        parent.setLayout((Layout)pageLayout);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridUtil.createFill());
        composite.setLayout((Layout)new GridLayout());
        SashForm errorForm = new SashForm(composite, 512);
        errorForm.setLayout((Layout)new GridLayout());
        errorForm.setLayoutData((Object)GridUtil.createFill());
        SashForm sf = new SashForm((Composite)errorForm, 256){

            public boolean setFocus() {
                return ProbekitEditor.this.currentViewer.getControl().setFocus();
            }
        };
        sf.setLayout((Layout)new GridLayout());
        sf.setLayoutData((Object)GridUtil.createFill());
        this.createProbeTree(sf, probes);
        this.createDetails(sf);
        sf.setWeights(new int[]{30, 70});
        this.createErrorSection((Composite)errorForm);
        errorForm.setWeights(new int[]{70, 30});
        return parent;
    }

    protected void createErrorSection(Composite parent) {
        SyntaxHeaderListener headerListener = new SyntaxHeaderListener();
        this._errorComposite = new Composite(parent, 0);
        GridData errorData = GridUtil.createFill();
        this._errorComposite.setLayoutData((Object)errorData);
        GridLayout layout = new GridLayout();
        this._errorComposite.setLayout((Layout)layout);
        this._errorComposite.setFont(parent.getFont());
        this._errorComposite.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(1));
        this._syntaxErrorTitle = new Label(this._errorComposite, 0);
        this._syntaxErrorTitle.setLayoutData((Object)new GridData());
        this._syntaxErrorTitle.setBackground(this._errorComposite.getBackground());
        this._syntaxErrorTitle.setFont(this._errorComposite.getFont());
        this._syntaxErrors = new TableViewer(this._errorComposite, 68100);
        TableLayout tableLayout = new TableLayout();
        Table table = this._syntaxErrors.getTable();
        this._iconColumn = new TableColumn(table, 16384);
        this._iconColumn.setText(this.COLUMNS[0]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        this._iconColumn.addSelectionListener((SelectionListener)headerListener);
        this._descriptionColumn = new TableColumn(table, 16384);
        this._descriptionColumn.setText(this.COLUMNS[1]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(80));
        this._descriptionColumn.addSelectionListener((SelectionListener)headerListener);
        this._resourceColumn = new TableColumn(table, 16384);
        this._resourceColumn.setText(this.COLUMNS[2]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(18));
        this._resourceColumn.addSelectionListener((SelectionListener)headerListener);
        this._syntaxErrors.setContentProvider((IContentProvider)new SyntaxContentProvider());
        this._syntaxErrors.setLabelProvider((IBaseLabelProvider)new SyntaxColumnLabelProvider());
        this._syntaxErrors.setInput((Object)this.getJDTProblems());
        this._syntaxErrors.setColumnProperties(this.COLUMNS);
        this._syntaxErrors.setSorter((ViewerSorter)this.getSyntaxErrorSorter());
        GridData tableData = new GridData(1808);
        table.setLayoutData((Object)tableData);
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(this._errorComposite.getFont());
        table.addMouseListener((MouseListener)new SyntaxMouseClickListener());
        table.addSelectionListener((SelectionListener)new SyntaxSelectionListener());
    }

    protected SyntaxViewerSorter getSyntaxErrorSorter() {
        if (this._syntaxErrorSorter == null) {
            this._syntaxErrorSorter = new SyntaxViewerSorter();
        }
        return this._syntaxErrorSorter;
    }

    protected void refreshSyntaxErrorMessage() {
        String warningCountMessage;
        String errorCountMessage;
        if (this._hasSyntaxBeenChecked) {
            Resource resource = this.getProbekit().eResource();
            TreeIterator resourceIterator = resource.getAllContents();
            this.getJDTProblems().clear();
            int errorCount = 0;
            int warningCount = 0;
            while (resourceIterator.hasNext()) {
                EObject eObject = (EObject)resourceIterator.next();
                SyntaxAdapter adapter = JavaSnippet.getSyntaxAdapter(eObject);
                errorCount += adapter.errorCount();
                warningCount += adapter.warningCount();
                this.getJDTProblems().addAll(Arrays.asList(adapter.getKnownProblems()));
            }
            errorCountMessage = String.valueOf(errorCount);
            warningCountMessage = String.valueOf(warningCount);
        } else {
            errorCountMessage = "?";
            warningCountMessage = "?";
        }
        this._syntaxErrorTitle.setText(NLS.bind((String)ProbekitMessages._131, (Object[])new Object[]{errorCountMessage, warningCountMessage}));
        this._syntaxErrorTitle.pack(true);
        this._syntaxErrors.setInput((Object)this.getJDTProblems());
        this._syntaxErrors.refresh();
    }

    private void checkSyntax() {
        try {
            this._snippet.compile();
            this._hasSyntaxBeenChecked = true;
            this.refreshSyntaxErrorMessage();
        }
        catch (ProbekitCompileProblemException probekitCompileProblemException) {
        }
        catch (ProbekitException exc) {
            this.reportCheckSyntaxfailure((Exception)((Object)exc));
        }
        catch (CoreException exc) {
            this.reportCheckSyntaxfailure((Exception)((Object)exc));
        }
        this.selectionViewer.refresh();
        this.detailsViewer.refresh();
    }

    private void reportCheckSyntaxfailure(Exception exc) {
        this._hasSyntaxBeenChecked = false;
        ProbekitUIPlugin.getPlugin().log(exc);
        try {
            IMarker marker = this._snippet.getProbeFile().createMarker("org.eclipse.hyades.probekit.probekitProblem");
            String msg = exc.getLocalizedMessage();
            marker.setAttribute("message", (Object)msg);
            marker.setAttribute("severity", 2);
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)ProbekitMessages._132, (String)NLS.bind((String)ProbekitMessages._133, (Object)exc.getLocalizedMessage()));
        }
    }

    protected void createProbeTree(SashForm sf, List probes) {
        ViewerPane sashPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = ProbekitEditor.this.widgetFactory.createTree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, ContextIds.PROBEKIT_TREEVIEW);
                return newTreeViewer;
            }

            public void requestActivation() {
                if (ProbekitEditor.this.isActivating) {
                    return;
                }
                ProbekitEditor.this.isActivating = true;
                ProbekitEditor.this.setCurrentViewerPane(this);
                ((ProbekitActionBarContributor)((IEditorSite)ProbekitEditor.this.getSite()).getActionBarContributor()).resetGlobalActions(ProbekitEditor.this.getActionBars());
                this.setFocus();
                ProbekitEditor.this.isActivating = false;
            }
        };
        sashPane.createControl((Composite)sf);
        this.selectionViewer = (TreeViewer)sashPane.getViewer();
        this.selectionViewer.setContentProvider((IContentProvider)new ProbekitContentProvider(new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory)));
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.selectionViewer.setInput((Object)this.getProbekit());
        Image image = ExtendedImageRegistry.getInstance().getImage(this.getResourceLocator().getImage("full/obj16/Probekit"));
        sashPane.setTitle(ProbekitUIPlugin.getPlugin().getString("4"), image);
        new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
        this.createContextMenuFor((StructuredViewer)this.selectionViewer);
        this.setCurrentViewerPane(sashPane);
    }

    protected void createDetails(SashForm sf) {
        ViewerPane detailsPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                ProbekitDetailsViewer detViewer = new ProbekitDetailsViewer(composite, ProbekitEditor.this.itemProviderFactory, ProbekitEditor.this.widgetFactory);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, ContextIds.PROBEKIT_DETAILVIEW);
                return detViewer;
            }

            public void requestActivation() {
                if (ProbekitEditor.this.isActivating) {
                    return;
                }
                ProbekitEditor.this.isActivating = true;
                ProbekitEditor.this.setCurrentViewerPane(this);
                ((ProbekitActionBarContributor)ProbekitEditor.this.getActionBarContributor()).replaceGlobalActions(ProbekitEditor.this.getActionBars(), ProbekitEditor.this.actionHandlerListener);
                ProbekitEditor.this.isActivating = false;
            }
        };
        detailsPane.createControl((Composite)sf);
        this.detailsViewer = (ProbekitDetailsViewer)detailsPane.getViewer();
        this.addSelectionChangedListener(this.detailsViewer);
        this.selectionViewer.getControl().setRedraw(false);
        this.selectionViewer.expandToLevel(-1);
        if (this.selectionViewer.getExpandedElements().length > 0) {
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.selectionViewer.getExpandedElements()[0]), true);
        }
        this.selectionViewer.getControl().setRedraw(true);
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
            this.currentViewerPane.showFocus(true);
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setActivePage(Composite composite) {
        if (composite == this._generalTab) {
            this.setActivePage(this._generalTabIndex);
        } else if (composite == this._probesTab) {
            this.setActivePage(this._probesTabIndex);
        }
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        ProbekitEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    public void setSelectionToViewer(Collection collection) {
        final Collection theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (ProbekitEditor.this.currentViewer != null) {
                        ProbekitEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    private void select(IProblem problem) {
        EObject eObject = this._snippet.getEObject(problem);
        if (eObject != null) {
            Object eTreeObject = eObject;
            if (eObject instanceof DataItem) {
                eTreeObject = ((DataItem)eObject).eContainer();
            } else if (EObjectListSwitch.isSwitchForFeature(eObject.eContainingFeature())) {
                Probe probe = (Probe)eObject.eContainer();
                eTreeObject = probe.eGet(eObject.eContainingFeature());
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(eTreeObject));
            this.setSelection((ISelection)new StructuredSelection((Object)eObject));
        }
    }

    private Object getInput() {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        if (resourceSet != null && resourceSet.getResources().size() > 0) {
            EList resources = resourceSet.getResources();
            Object selected = null;
            for (Resource element : resources) {
                if (!element.getURI().fileExtension().equals("probe")) continue;
                try {
                    EObject rootObject;
                    selected = rootObject = (EObject)element.getContents().get(0);
                    break;
                }
                catch (Throwable e) {
                    if (e instanceof SAXParseException) {
                        selected = this.addProbekitElement(element);
                        continue;
                    }
                    ProbekitUIPlugin.INSTANCE.log(e);
                }
            }
            return selected;
        }
        return resourceSet;
    }

    private Probekit getProbekit() {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        if (resourceSet != null && resourceSet.getResources().size() > 0) {
            TreeIterator iterator = resourceSet.getAllContents();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof Probekit)) continue;
                return (Probekit)next;
            }
        }
        return null;
    }

    private List getProbes() {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        ArrayList probes = new ArrayList();
        if (resourceSet != null && resourceSet.getResources().size() > 0) {
            TreeIterator iterator = resourceSet.getAllContents();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof Probe)) continue;
                probes.add(next);
            }
        }
        return probes;
    }

    private List getJDTProblems() {
        return this._jdtProblems;
    }

    private Object addProbekitElement(Resource element) {
        DocumentRoot documentRoot = ProbekitFactory.eINSTANCE.createDocumentRoot();
        Probekit probekit = ProbekitFactory.eINSTANCE.createProbekit();
        documentRoot.setProbekit(probekit);
        element.getContents().add((Object)documentRoot);
        DocumentRoot selected = documentRoot;
        return selected;
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        Control control = this.getControl(pageIndex);
        if (control != null) {
            control.setVisible(true);
            control.setFocus();
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    ProbekitEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.currentViewerPane != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            if (this._generalTab.isPageFor(selectedElement)) {
                this.setActivePage(this._generalTab);
            } else {
                this.setActivePage(this._probesTab);
            }
            if (this.currentViewerPane.getViewer() == this.selectionViewer) {
                ArrayList selectionList = new ArrayList();
                selectionList.add(selectedElement);
                while (selectedElements.hasNext()) {
                    selectionList.add(selectedElements.next());
                }
                this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
            } else if (this.currentViewerPane.getViewer().getInput() != selectedElement) {
                this.currentViewerPane.getViewer().setInput(selectedElement);
                this.currentViewerPane.setTitle(selectedElement);
            }
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    Resource savedResource = (Resource)ProbekitEditor.this.editingDomain.getResourceSet().getResources().get(0);
                    ProbekitEditor.this.savedResources.add(savedResource);
                    savedResource.save(Collections.EMPTY_MAP);
                }
                catch (Exception exception) {
                    ProbekitUIPlugin.INSTANCE.log(exception);
                }
                ProbekitEditor.this.checkSyntax();
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            ProbekitUIPlugin.INSTANCE.log(exception);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(URI.createPlatformResourceURI((String)file.getFullPath().toString()));
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInput((IEditorInput)modelFile);
            this.setPartName(file.getFullPath().toString());
            this.doSave(this.getActionBars().getStatusLineManager().getProgressMonitor());
        }
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput.");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        IFileEditorInput fe = (IFileEditorInput)editorInput;
        this.setPartName(fe.getFile().getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.file = ((IFileEditorInput)editorInput).getFile();
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        Collection collection = this.selectionChangedListeners;
        synchronized (collection) {
            this.selectionChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        Collection collection = this.selectionChangedListeners;
        synchronized (collection) {
            this.selectionChangedListeners.remove(listener);
        }
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        if (selection == null) {
            return;
        }
        ConcurrentModificationException e1 = null;
        try {
            Collection collection = this.selectionChangedListeners;
            synchronized (collection) {
                ISelectionChangedListener[] changedListeners = this.selectionChangedListeners.toArray(new ISelectionChangedListener[this.selectionChangedListeners.size()]);
                int i = 0;
                while (i < changedListeners.length) {
                    ISelectionChangedListener listener = changedListeners[i];
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                    ++i;
                }
            }
        }
        catch (ConcurrentModificationException e) {
            e1 = e;
        }
        if (e1 != null) {
            ProbekitUIPlugin.getPlugin().log(e1);
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = this.getActionBars().getStatusLineManager();
        if (this.currentViewer == this.contentOutlineViewer) {
            statusLineManager = this.contentOutlineStatusLineManager;
        }
        if (selection instanceof IStructuredSelection) {
            List collection = ((IStructuredSelection)selection).toList();
            switch (collection.size()) {
                case 0: {
                    statusLineManager.setMessage(ProbekitMessages._6);
                    break;
                }
                case 1: {
                    String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                    statusLineManager.setMessage(NLS.bind((String)ProbekitMessages._5, (Object)text));
                    break;
                }
                default: {
                    statusLineManager.setMessage(NLS.bind((String)ProbekitMessages._7, (Object)Integer.toString(collection.size())));
                    break;
                }
            }
        } else {
            statusLineManager.setMessage("");
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        this.getActionBarContributor().setActiveEditor(null);
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.detailsViewer != null) {
            this.detailsViewer.dispose();
        }
        this._generalTab.dispose();
        try {
            this._snippet.release();
        }
        catch (JavaModelException exc) {
            ProbekitUIPlugin.getPlugin().log((Object)exc);
        }
        this.file = null;
        super.dispose();
    }

    public ProbekitItemProviderAdapterFactory getItemProviderFactory() {
        return this.itemProviderFactory;
    }

    public boolean visit(IResourceDelta delta) {
        if (delta.getKind() == 2 && delta.getResource().equals((Object)this.file)) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ProbekitEditor.this.getSite().getPage().closeEditor((IEditorPart)ProbekitEditor.this, false);
                    ProbekitEditor.this.dispose();
                }
            });
        }
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            IResourceDelta iFile_delta;
            if (delta != null && (iFile_delta = delta.findMember(this.file.getFullPath())) != null) {
                iFile_delta.accept((IResourceDeltaVisitor)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addProbe() {
        Probekit probekit = this.getProbekit();
        Probe probe = ProbekitFactory.eINSTANCE.createProbe();
        CreateChildCommand command = new CreateChildCommand((EditingDomain)this.editingDomain, (EObject)probekit, (EStructuralFeature)ProbekitPackage.eINSTANCE.getProbekit_Probe(), (Object)probe, (Collection)Collections.EMPTY_LIST);
        this.editingDomain.getCommandStack().execute((Command)command);
        this.setSelection((ISelection)new StructuredSelection((Object)probe));
        if (this.selectionViewer != null) {
            this.selectionViewer.setExpandedState((Object)probe, true);
        }
    }

    public class MyActionHandlerListener
    extends ActionHandlerListener {
        public void connectCutCopyPasteActions(IActionBars actionBars) {
            super.connectCutCopyPasteActions(actionBars);
        }
    }

    private class MyCommandStackListener
    implements CommandStackListener {
        private MyCommandStackListener() {
        }

        public void commandStackChanged(final EventObject event) {
            ProbekitEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ProbekitEditor.this.firePropertyChange(257);
                    Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                    if (mostRecentCommand != null) {
                        ProbekitEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                    }
                    if (((MyCommandStackListener)MyCommandStackListener.this).ProbekitEditor.this.propertySheetPage != null && !((MyCommandStackListener)MyCommandStackListener.this).ProbekitEditor.this.propertySheetPage.getControl().isDisposed()) {
                        ((MyCommandStackListener)MyCommandStackListener.this).ProbekitEditor.this.propertySheetPage.refresh();
                    }
                }
            });
        }
    }

    private class SyntaxColumnLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SyntaxColumnLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IProblem problem = (IProblem)element;
            if (columnIndex == 0) {
                return DialogUtil.getImage(JavaSnippet.getIconURL(problem));
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IProblem problem = (IProblem)element;
            if (columnIndex == 0) {
                return "";
            }
            if (columnIndex == 1) {
                return problem.getMessage();
            }
            EObject eObject = ProbekitEditor.this._snippet.getEObject(problem);
            if (eObject == null) {
                return "";
            }
            IItemLabelProvider labelProvider = (IItemLabelProvider)ProbekitEditor.this.itemProviderFactory.adapt((Notifier)eObject, (Object)IItemLabelProvider.class);
            if (labelProvider == null) {
                return "";
            }
            return labelProvider.getText((Object)eObject);
        }
    }

    private class SyntaxContentProvider
    implements IStructuredContentProvider {
        private SyntaxContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }
    }

    private class SyntaxHeaderListener
    implements SelectionListener {
        private SyntaxHeaderListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent event) {
            SyntaxViewerSorter sorter = (SyntaxViewerSorter)ProbekitEditor.this._syntaxErrors.getSorter();
            if (event.widget == ProbekitEditor.this._iconColumn) {
                sorter.setSortBy(ProbekitEditor.this.COLUMNS[0]);
            } else if (event.widget == ProbekitEditor.this._descriptionColumn) {
                sorter.setSortBy(ProbekitEditor.this.COLUMNS[1]);
            } else if (event.widget == ProbekitEditor.this._resourceColumn) {
                sorter.setSortBy(ProbekitEditor.this.COLUMNS[2]);
            }
            ProbekitEditor.this._syntaxErrors.setSorter((ViewerSorter)sorter);
            ProbekitEditor.this._syntaxErrors.refresh();
        }
    }

    private class SyntaxMouseClickListener
    implements MouseListener {
        private SyntaxMouseClickListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            Table table = (Table)e.widget;
            int index = table.getSelectionIndex();
            TableItem item = table.getItem(index);
            IProblem problem = (IProblem)item.getData();
            ProbekitEditor.this.select(problem);
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    private class SyntaxSelectionListener
    implements SelectionListener {
        private SyntaxSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent event) {
            TableItem item = (TableItem)event.item;
            IProblem problem = (IProblem)item.getData();
            ProbekitEditor.this.select(problem);
        }
    }

    private class SyntaxViewerSorter
    extends ViewerSorter {
        private Comparator _iconAscendingComparator = new Comparator(){

            public int compare(Object a, Object b) {
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
                IProblem aProblem = (IProblem)a;
                IProblem bProblem = (IProblem)b;
                if (aProblem.isError() && bProblem.isError()) {
                    return 0;
                }
                if (bProblem.isError()) {
                    return 1;
                }
                return -1;
            }
        };
        private Comparator _iconDescendingComparator = new Comparator(){

            public int compare(Object a, Object b) {
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
                IProblem aProblem = (IProblem)a;
                IProblem bProblem = (IProblem)b;
                if (aProblem.isWarning() && bProblem.isWarning()) {
                    return 0;
                }
                if (bProblem.isWarning()) {
                    return 1;
                }
                return -1;
            }
        };
        private Comparator _descriptionAscendingComparator = new Comparator(){

            public int compare(Object a, Object b) {
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
                IProblem aProblem = (IProblem)a;
                IProblem bProblem = (IProblem)b;
                SyntaxColumnLabelProvider labelProvider = (SyntaxColumnLabelProvider)ProbekitEditor.this._syntaxErrors.getLabelProvider();
                String aDesc = labelProvider.getColumnText(aProblem, 1);
                String bDesc = labelProvider.getColumnText(bProblem, 1);
                return aDesc.compareTo(bDesc);
            }
        };
        private Comparator _descriptionDescendingComparator = new Comparator(){

            public int compare(Object a, Object b) {
                String bDesc;
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
                IProblem aProblem = (IProblem)a;
                IProblem bProblem = (IProblem)b;
                SyntaxColumnLabelProvider labelProvider = (SyntaxColumnLabelProvider)ProbekitEditor.this._syntaxErrors.getLabelProvider();
                String aDesc = labelProvider.getColumnText(aProblem, 1);
                int result = aDesc.compareTo(bDesc = labelProvider.getColumnText(bProblem, 1));
                if (result < 0) {
                    return 1;
                }
                if (result > 0) {
                    return -1;
                }
                return 0;
            }
        };
        private Comparator _resourceAscendingComparator = new Comparator(){

            public int compare(Object a, Object b) {
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
                IProblem aProblem = (IProblem)a;
                IProblem bProblem = (IProblem)b;
                SyntaxColumnLabelProvider labelProvider = (SyntaxColumnLabelProvider)ProbekitEditor.this._syntaxErrors.getLabelProvider();
                String aDesc = labelProvider.getColumnText(aProblem, 2);
                String bDesc = labelProvider.getColumnText(bProblem, 2);
                return aDesc.compareTo(bDesc);
            }
        };
        private Comparator _resourceDescendingComparator = new Comparator(){

            public int compare(Object a, Object b) {
                String bDesc;
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
                IProblem aProblem = (IProblem)a;
                IProblem bProblem = (IProblem)b;
                SyntaxColumnLabelProvider labelProvider = (SyntaxColumnLabelProvider)ProbekitEditor.this._syntaxErrors.getLabelProvider();
                String aDesc = labelProvider.getColumnText(aProblem, 2);
                int result = aDesc.compareTo(bDesc = labelProvider.getColumnText(bProblem, 2));
                if (result < 0) {
                    return 1;
                }
                if (result > 0) {
                    return -1;
                }
                return 0;
            }
        };
        private Comparator _currentComparator = this._resourceAscendingComparator;

        private SyntaxViewerSorter() {
        }

        public void setSortBy(String column) {
            if (ProbekitEditor.this.COLUMNS[0].equals(column)) {
                this._currentComparator = this._currentComparator.equals(this._iconAscendingComparator) ? this._iconDescendingComparator : this._iconAscendingComparator;
            } else if (ProbekitEditor.this.COLUMNS[1].equals(column)) {
                this._currentComparator = this._currentComparator.equals(this._descriptionAscendingComparator) ? this._descriptionDescendingComparator : this._descriptionAscendingComparator;
            } else if (ProbekitEditor.this.COLUMNS[2].equals(column)) {
                this._currentComparator = this._currentComparator.equals(this._resourceAscendingComparator) ? this._resourceDescendingComparator : this._resourceAscendingComparator;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this._currentComparator.compare(e1, e2);
        }
    }
}

