/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.models.internal.probekit.Target;
import org.eclipse.hyades.models.internal.probekit.impl.TargetImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.presentation.BaseDetails;
import org.eclipse.hyades.probekit.editor.internal.presentation.GridUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitWidgetFactory;
import org.eclipse.hyades.probekit.editor.internal.presentation.TargetTypeEnum;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.TargetItemProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TargetDetails
extends BaseDetails
implements ModifyListener {
    protected final EAttribute TYPE = ProbekitPackage.eINSTANCE.getTarget_Type();
    protected final EAttribute PACKAGE = ProbekitPackage.eINSTANCE.getTarget_Package();
    protected final EAttribute CLASSNAME = ProbekitPackage.eINSTANCE.getTarget_ClassName();
    protected final EAttribute METHOD = ProbekitPackage.eINSTANCE.getTarget_Method();
    protected final EAttribute SIGNATURE = ProbekitPackage.eINSTANCE.getTarget_Signature();
    protected CCombo typeCombo;
    protected Text packageText;
    protected Text classText;
    protected Text methodText;
    protected Text signatureText;
    protected boolean isDisplaying;
    protected Target currentSelection;
    protected TargetItemProvider itemProvider;
    protected ProbekitItemProviderAdapterFactory itemFactory;

    public TargetDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
        super(composite, style);
        this.itemFactory = itemFactory;
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 1;
        this.setLayout((Layout)detailLayout);
        GridData data = GridUtil.createFill();
        data.widthHint = 300;
        this.setLayoutData(data);
        Label typeLabel = factory.createLabel(this, ProbekitMessages._22, 0);
        typeLabel.setBackground(this.getBackground());
        this.typeCombo = factory.createCombo(this, 2048);
        this.typeCombo.setItems(new String[]{TargetTypeEnum.INCLUDE.getTranslatedType(), TargetTypeEnum.EXCLUDE.getTranslatedType()});
        this.typeCombo.setLayoutData((Object)new GridData(768));
        Label packageLabel = factory.createLabel(this, ProbekitMessages._25, 0);
        packageLabel.setBackground(this.getBackground());
        this.packageText = factory.createText(this, "", 2048);
        this.packageText.setLayoutData((Object)new GridData(768));
        Label classLabel = factory.createLabel(this, ProbekitMessages._26, 0);
        classLabel.setBackground(this.getBackground());
        this.classText = factory.createText(this, "", 2048);
        this.classText.setLayoutData((Object)new GridData(768));
        Label methodLabel = factory.createLabel(this, ProbekitMessages._27, 0);
        methodLabel.setBackground(this.getBackground());
        this.methodText = factory.createText(this, "", 2048);
        this.methodText.setLayoutData((Object)new GridData(768));
        Label signatureLabel = factory.createLabel(this, ProbekitMessages._28, 0);
        signatureLabel.setBackground(this.getBackground());
        this.signatureText = factory.createText(this, "", 2048);
        this.signatureText.setLayoutData((Object)new GridData(768));
        this.typeCombo.addModifyListener((ModifyListener)this);
        this.packageText.addModifyListener((ModifyListener)this);
        this.classText.addModifyListener((ModifyListener)this);
        this.methodText.addModifyListener((ModifyListener)this);
        this.signatureText.addModifyListener((ModifyListener)this);
        this.itemProvider = (TargetItemProvider)itemFactory.createTargetAdapter();
        this.addFocusListenerTo((Control)this.typeCombo);
        this.addFocusListenerTo((Control)this.packageText);
        this.addFocusListenerTo((Control)this.classText);
        this.addFocusListenerTo((Control)this.methodText);
        this.addFocusListenerTo((Control)this.signatureText);
    }

    public void display(Object object) {
        if (this.typeCombo.isFocusControl() || this.packageText.isFocusControl() || this.classText.isFocusControl() || this.methodText.isFocusControl() || this.signatureText.isFocusControl()) {
            return;
        }
        this.currentSelection = (Target)object;
        this.isDisplaying = true;
        this.typeCombo.setText(this.currentSelection.getType() == null ? "" : this.currentSelection.getType());
        this.packageText.setText(this.currentSelection.getPackage() == null ? "" : this.currentSelection.getPackage());
        this.classText.setText(this.currentSelection.getClassName() == null ? "" : this.currentSelection.getClassName());
        this.methodText.setText(this.currentSelection.getMethod() == null ? "" : this.currentSelection.getMethod());
        this.signatureText.setText(this.currentSelection.getSignature() == null ? "" : this.currentSelection.getSignature());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(Object currentSelection) {
        this.currentSelection = (Target)currentSelection;
        this.currentSelection.setType(this.typeCombo.getText().trim());
        this.currentSelection.setPackage(this.packageText.getText().trim());
        this.currentSelection.setClassName(this.classText.getText().trim());
        this.currentSelection.setMethod(this.methodText.getText().trim());
        this.currentSelection.setSignature(this.signatureText.getText().trim());
        return false;
    }

    public void setFocusToType() {
        this.typeCombo.setFocus();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.typeCombo) {
            String text2 = this.typeCombo.getText().trim();
            if (!text2.equals(this.currentSelection.getType())) {
                if (text2.length() == 0 && this.currentSelection.getType() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, this.TYPE);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text2);
                }
            }
        } else if (e.getSource() == this.packageText) {
            String text3 = this.packageText.getText().trim();
            if (!text3.equals(this.currentSelection.getPackage())) {
                if (text3.length() == 0 && this.currentSelection.getPackage() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, this.PACKAGE);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text3);
                }
            }
        } else if (e.getSource() == this.classText) {
            String text4 = this.classText.getText().trim();
            if (!text4.equals(this.currentSelection.getClassName())) {
                if (text4.length() == 0 && this.currentSelection.getClassName() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, this.CLASSNAME);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text4);
                }
            }
        } else if (e.getSource() == this.methodText) {
            String text5 = this.methodText.getText().trim();
            if (!text5.equals(this.currentSelection.getMethod())) {
                if (text5.length() == 0 && this.currentSelection.getMethod() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, this.METHOD);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text5);
                }
            }
        } else if (e.getSource() == this.signatureText && !(text = this.signatureText.getText().trim()).equals(this.currentSelection.getSignature())) {
            if (text.length() == 0 && this.currentSelection.getSignature() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, this.SIGNATURE);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
        this.typeCombo = null;
        this.packageText = null;
        this.classText = null;
        this.methodText = null;
        this.signatureText = null;
    }

    public boolean isDetailsFor(Object object) {
        return object instanceof Target || object instanceof TargetImpl;
    }

    public void setFocusTo() {
        this.setFocusToType();
    }

    public void refresh() {
    }
}

