/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.ui;

import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.DataType;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataDialog
extends Dialog {
    private DataItem _item = null;
    private String _title = null;
    private Text _name = null;
    private Combo _combo = null;
    private String[] _dataTypeNames = null;

    public DataDialog(Shell shell, String[] dataTypeNames, DataItem item) {
        super(shell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        this._dataTypeNames = dataTypeNames;
        this._item = item;
    }

    public DataItem getResult() {
        return this._item;
    }

    void update() {
        String typeName = this._combo.getText();
        String name = this._name.getText();
        DataType newType = DataType.get((String)typeName);
        this.getResult().setType(newType);
        this.getResult().setName(name);
    }

    private String[] getDataTypeNames() {
        return this._dataTypeNames;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        GridData data = new GridData(1808);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        return this.createDialogContents(composite);
    }

    protected Composite createDialogContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData data = new GridData(1808);
        data.widthHint = 300;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        Label comboLabel = new Label(composite, 0);
        comboLabel.setText(ProbekitMessages._40);
        DataModifyListener listener = new DataModifyListener();
        this._combo = new Combo(composite, 2060);
        GridData comboData = new GridData(768);
        this._combo.setItems(this.getDataTypeNames());
        this._combo.setText(ProbekitUtil.getDataTypeName(this.getResult()));
        this._combo.setLayoutData((Object)comboData);
        this._combo.addModifyListener((ModifyListener)listener);
        Label textLabel = new Label(composite, 0);
        textLabel.setText(ProbekitMessages._41);
        this._name = new Text(composite, 2052);
        this._name.setText(ProbekitUtil.getDataItemName(this.getResult()));
        GridData textData = new GridData(768);
        this._name.setLayoutData((Object)textData);
        this._name.addModifyListener((ModifyListener)listener);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.getTitle() != null) {
            shell.setText(this.getTitle());
        }
    }

    private String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    private class DataModifyListener
    implements ModifyListener {
        private DataModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            DataDialog.this.update();
        }
    }
}

