/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.ui;

import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.probekit.editor.internal.ui.CompoundLabelProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.CompoundTreeContentProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.CompoundViewerSorter;
import org.eclipse.hyades.probekit.editor.internal.ui.ResourceContentProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.ResourceLabelProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.WrappedCheckedTreeSelectionDialog;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public final class DialogUtil {
    public static final String PROBLEMS_VIEW_ID = "org.eclipse.ui.views.ProblemView";

    public static CheckedTreeSelectionDialog createResourceDialog(Shell shell, IResource[] input, List includedResources) {
        IResource[] res = includedResources.toArray(new IResource[0]);
        WrappedCheckedTreeSelectionDialog dialog = new WrappedCheckedTreeSelectionDialog(shell, (ILabelProvider)new ResourceLabelProvider(), new ResourceContentProvider(res));
        dialog.setInput(input);
        dialog.setSorter(new ViewerSorter());
        dialog.setBlockOnOpen(true);
        dialog.setContainerMode(true);
        return dialog;
    }

    public static CheckedTreeSelectionDialog createCompoundDialog(Shell shell, IJavaProject[] input, CompoundTreeContentProvider compoundTreeContentProvider, CompoundLabelProvider compoundLabelProvider) {
        WrappedCheckedTreeSelectionDialog dialog = new WrappedCheckedTreeSelectionDialog(shell, (ILabelProvider)compoundLabelProvider, compoundTreeContentProvider);
        dialog.setInput(input);
        dialog.setSorter(new CompoundViewerSorter());
        dialog.setBlockOnOpen(true);
        dialog.setContainerMode(true);
        return dialog;
    }

    private DialogUtil() {
    }

    public static void openProblemsView() {
        try {
            String viewId = PROBLEMS_VIEW_ID;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            if (page != null) {
                page.showView(viewId);
            }
        }
        catch (PartInitException exc) {
            ProbekitUIPlugin.getPlugin().log((Object)exc);
        }
    }

    public static Image getImage(URL url) {
        return ImageDescriptor.createFromURL((URL)url).createImage();
    }
}

