/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.ui.instrument;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.probekit.editor.internal.core.instrument.InstrumentOperation;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.ui.DialogUtil;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class InstrumentRunnableWithProgress
implements IRunnableWithProgress {
    private final IFile _probeFile;
    private final Shell _shell;
    private final Display _display;
    private final List _elementsToInstrument;

    public InstrumentRunnableWithProgress(Shell shell, Display display, IFile probeFile, List elements) {
        this._shell = shell;
        this._display = display;
        this._probeFile = probeFile;
        this._elementsToInstrument = elements;
    }

    Shell getShell() {
        return this._shell;
    }

    private Display getDisplay() {
        return this._display;
    }

    IFile getProbeFile() {
        return this._probeFile;
    }

    private List getElements() {
        return this._elementsToInstrument;
    }

    public void run(IProgressMonitor monitor) {
        try {
            InstrumentOperation op = new InstrumentOperation(this.getProbeFile(), this.getElements());
            op.run(monitor);
        }
        catch (CoreException exc) {
            ProbekitUIPlugin.getPlugin().log((Object)exc);
            int code = exc.getStatus().getCode();
            final String excMessage = exc.getMessage();
            switch (code) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)InstrumentRunnableWithProgress.this.getShell(), (String)NLS.bind((String)ProbekitMessages._90, (Object[])new Object[]{InstrumentRunnableWithProgress.this.getProbeFile().getName()}), (String)excMessage);
                            DialogUtil.openProblemsView();
                        }
                    });
                    break;
                }
                default: {
                    this.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)InstrumentRunnableWithProgress.this.getShell(), (String)NLS.bind((String)ProbekitMessages._90, (Object[])new Object[]{InstrumentRunnableWithProgress.this.getProbeFile().getName()}), (String)ProbekitMessages._91);
                        }
                    });
                }
            }
        }
    }

    public void open() {
        if (this.getElements().size() == 0) {
            return;
        }
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            dialog.run(true, true, (IRunnableWithProgress)this);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException exc) {
            ProbekitUIPlugin.getPlugin().log(exc);
            MessageDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)ProbekitMessages._90, (Object[])new Object[]{this.getProbeFile().getName()}), (String)ProbekitMessages._91);
        }
    }
}

