/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.editor.internal.ui.newFile;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.models.internal.probekit.FragmentType;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.AbstractProbeMetaData;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.CallsiteProbeMetaData;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.IProbeMetaData;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.MethodProbeMetaData;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.NoProbeMetaData;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.ProbeFileModel;
import org.eclipse.hyades.probekit.editor.internal.core.util.JavaUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.hyades.probekit.editor.internal.ui.DataItemLabelProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.DataItemTreeProvider;
import org.eclipse.hyades.probekit.editor.internal.ui.DialogUtil;
import org.eclipse.hyades.probekit.editor.internal.ui.SelectOneIncludedValidator;
import org.eclipse.hyades.probekit.editor.internal.ui.newFile.DiscardDataReadOnlyDialog;
import org.eclipse.hyades.probekit.ui.internal.ContextIds;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public final class NewProbekitProbePage
extends WizardPage {
    public static final String PAGE_ID = "New Probekit File (Probe)";
    private ProbeFileModel _model = null;
    private Button _methodProbeButton = null;
    private Button _callsiteProbeButton = null;
    private Button _noProbeButton = null;
    private Group _fragmentTypes = null;
    private Text _explanationText = null;
    private Text _fragmentExplanationText = null;
    private Text _fileNameField = null;
    Text _sourceContainerField = null;
    private CCombo _encodingField = null;

    public NewProbekitProbePage(ProbeFileModel model) {
        super(PAGE_ID);
        this._model = model;
        this.setTitle(ProbekitMessages._35);
        this.setMessage(ProbekitMessages._36);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.refreshProbeExplanation();
            this.refreshFragmentTypeExplanation();
        }
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setFont(parent.getFont());
        GridLayout pageLayout = new GridLayout();
        page.setLayout((Layout)pageLayout);
        this.createFile(page);
        this.createFolder(page);
        this.createXMLEncoding(page);
        Label line = new Label(page, 258);
        GridData lineData = new GridData(768);
        line.setLayoutData((Object)lineData);
        this.createProbeSection(page);
        Label line2 = new Label(page, 258);
        GridData line2Data = new GridData(768);
        line2.setLayoutData((Object)line2Data);
        this.createFragmentSection(page);
        this.setControl((Control)page);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)page, ContextIds.PROBEKIT_NEWWIZ_PROBE);
        this.checkPageComplete();
    }

    private void createFile(Composite page) {
        Font font = page.getFont();
        FileOrContainerModifiedListener listener = new FileOrContainerModifiedListener();
        Composite group = new Composite(page, 0);
        GridData groupData = new GridData(1808);
        group.setLayoutData((Object)groupData);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        groupLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)groupLayout);
        Label fileNameLabel = new Label(group, 16384);
        fileNameLabel.setText(ProbekitMessages._45);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        fileNameLabel.setLayoutData((Object)data);
        this._fileNameField = new Text(group, 2048);
        GridData fileNameFieldData = new GridData(768);
        this._fileNameField.setFont(font);
        this._fileNameField.setLayoutData((Object)fileNameFieldData);
        this._fileNameField.setText(this._model.getFileName());
        this._fileNameField.addModifyListener((ModifyListener)listener);
    }

    private void createFolder(Composite page) {
        Font font = page.getFont();
        FileOrContainerModifiedListener listener = new FileOrContainerModifiedListener();
        Composite group = new Composite(page, 0);
        GridData groupData = new GridData(1808);
        group.setLayoutData((Object)groupData);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 3;
        groupLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)groupLayout);
        Label sourceFolderLabel = new Label(group, 16384);
        sourceFolderLabel.setText(ProbekitMessages._46);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        sourceFolderLabel.setLayoutData((Object)data);
        this._sourceContainerField = new Text(group, 2048);
        GridData sourceFolderFieldData = new GridData(768);
        sourceFolderFieldData.grabExcessHorizontalSpace = true;
        this._sourceContainerField.setFont(font);
        this._sourceContainerField.setLayoutData((Object)sourceFolderFieldData);
        this._sourceContainerField.setText(this._model.getSourceContainerPath());
        Button button = new Button(group, 8);
        GridData buttonData = new GridData();
        button.setLayoutData((Object)buttonData);
        button.setFont(font);
        button.setText(ProbekitMessages._47);
        this._sourceContainerField.addModifyListener((ModifyListener)listener);
        button.addSelectionListener((SelectionListener)new BrowseListener());
    }

    private void createXMLEncoding(Composite page) {
        Composite encoding = new Composite(page, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        encoding.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        encoding.setLayoutData((Object)gd);
        Label encodingLabel = new Label(encoding, 16384);
        encodingLabel.setText(ProbekitMessages._8);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        encodingLabel.setLayoutData((Object)data);
        this._encodingField = new CCombo(encoding, 2048);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this._encodingField.setLayoutData((Object)data);
        String[] xmlEncodingChoices = this._model.getXMLEncodingChoices();
        int selectionIndex = 0;
        int i = 0;
        while (i < xmlEncodingChoices.length) {
            this._encodingField.add(xmlEncodingChoices[i]);
            if (this._model.getDefaultEncoding().equals(xmlEncodingChoices[i])) {
                selectionIndex = i;
            }
            ++i;
        }
        this._encodingField.select(selectionIndex);
        this._encodingField.addSelectionListener((SelectionListener)new XMLEncodingSelectionListener());
    }

    private void createProbeSection(Composite page) {
        Composite buttonComposite = new Composite(page, 0);
        GridData buttonCompositeData = new GridData(1808);
        buttonComposite.setLayoutData((Object)buttonCompositeData);
        GridLayout buttonCompositeLayout = new GridLayout();
        buttonCompositeLayout.numColumns = 2;
        buttonComposite.setLayout((Layout)buttonCompositeLayout);
        buttonComposite.setFont(page.getFont());
        this.createProbeButtons(buttonComposite);
        this.createProbeExplanation(buttonComposite);
    }

    private void createProbeButtons(Composite buttonComposite) {
        Font font = buttonComposite.getFont();
        ProbeButtonSelectionListener listener = new ProbeButtonSelectionListener();
        Group buttonGroup = new Group(buttonComposite, 32);
        GridData buttonData = new GridData();
        buttonGroup.setLayoutData((Object)buttonData);
        buttonGroup.setFont(font);
        buttonGroup.setText(ProbekitMessages._48);
        GridLayout buttonLayout = new GridLayout();
        buttonGroup.setLayout((Layout)buttonLayout);
        this._methodProbeButton = new Button((Composite)buttonGroup, 16);
        this._methodProbeButton.setText(ProbekitMessages._49);
        GridData mData = new GridData();
        this._methodProbeButton.setLayoutData((Object)mData);
        this._methodProbeButton.setSelection(this._model.getProbeMetaData().getProbeType() == 0);
        this._methodProbeButton.setFont(font);
        this._callsiteProbeButton = new Button((Composite)buttonGroup, 16);
        this._callsiteProbeButton.setText(ProbekitMessages._50);
        GridData cData = new GridData();
        this._callsiteProbeButton.setLayoutData((Object)cData);
        this._callsiteProbeButton.setSelection(this._model.getProbeMetaData().getProbeType() == 1);
        this._callsiteProbeButton.setFont(font);
        this._noProbeButton = new Button((Composite)buttonGroup, 16);
        this._noProbeButton.setText(ProbekitMessages._51);
        GridData bData = new GridData();
        this._noProbeButton.setLayoutData((Object)bData);
        this._noProbeButton.setSelection(this._model.getProbeMetaData().getProbeType() == 2);
        this._noProbeButton.setFont(font);
        this._methodProbeButton.addSelectionListener((SelectionListener)listener);
        this._callsiteProbeButton.addSelectionListener((SelectionListener)listener);
        this._noProbeButton.addSelectionListener((SelectionListener)listener);
    }

    private void createProbeExplanation(Composite buttonComposite) {
        this._explanationText = new Text(buttonComposite, 842);
        GridData explanationData = new GridData(1808);
        this._explanationText.setLayoutData((Object)explanationData);
        this._explanationText.setFont(buttonComposite.getFont());
        this._explanationText.setBackground(buttonComposite.getBackground());
    }

    private void createFragmentSection(Composite page) {
        Composite buttonComposite = new Composite(page, 0);
        GridData buttonCompositeData = new GridData(1808);
        buttonComposite.setLayoutData((Object)buttonCompositeData);
        GridLayout buttonCompositeLayout = new GridLayout();
        buttonCompositeLayout.numColumns = 2;
        buttonComposite.setLayout((Layout)buttonCompositeLayout);
        buttonComposite.setBackground(page.getBackground());
        this._fragmentTypes = new Group(buttonComposite, 0);
        GridData fragmentData = new GridData();
        this._fragmentTypes.setLayoutData((Object)fragmentData);
        this._fragmentTypes.setText(ProbekitMessages._52);
        GridLayout fragmentLayout = new GridLayout();
        this._fragmentTypes.setLayout((Layout)fragmentLayout);
        this.createFragmentExplanation(buttonComposite);
    }

    private void createFragmentExplanation(Composite buttonComposite) {
        this._fragmentExplanationText = new Text(buttonComposite, 842);
        GridData explanationData = new GridData(1808);
        this._fragmentExplanationText.setLayoutData((Object)explanationData);
        this._fragmentExplanationText.setBackground(buttonComposite.getBackground());
        this.refreshFragmentTypes();
    }

    private DiscardDataReadOnlyDialog createDialog(IProbeMetaData probe, FragmentType type) {
        Object[] items = this._model.getInvalidDataItems(probe, type);
        DiscardDataReadOnlyDialog dialog = new DiscardDataReadOnlyDialog(this.getContainer().getShell(), (ILabelProvider)new DataItemLabelProvider(), new DataItemTreeProvider());
        dialog.setInput(items);
        dialog.setSorter(new ViewerSorter());
        dialog.setBlockOnOpen(true);
        dialog.setTitle(ProbekitMessages._56);
        dialog.setMessage(ProbekitMessages._57);
        dialog.setInitialSelections(items);
        return dialog;
    }

    void updateProbe(SelectionEvent e) {
        Object source = e.getSource();
        int probeType = this._model.getProbeMetaData().getProbeType();
        IProbeMetaData oldProbe = this._model.getProbeMetaData();
        AbstractProbeMetaData newProbe = null;
        if (source.equals(this._methodProbeButton) && probeType != 0) {
            newProbe = new MethodProbeMetaData(oldProbe);
        } else if (source.equals(this._callsiteProbeButton) && probeType != 1) {
            newProbe = new CallsiteProbeMetaData(oldProbe);
        } else if (source.equals(this._noProbeButton) && probeType != 2) {
            newProbe = new NoProbeMetaData(oldProbe);
        }
        if (newProbe != null) {
            boolean doChange = this.confirmChange(newProbe, newProbe.getFragmentType());
            if (doChange) {
                oldProbe.release();
                newProbe.forceValid();
                this._model.setProbeMetaData(newProbe);
                this.refreshProbeExplanation();
                this.refreshFragmentTypes();
                this.refreshFragmentTypeExplanation();
            } else {
                this._methodProbeButton.setSelection(probeType == 0);
                this._callsiteProbeButton.setSelection(probeType == 1);
                this._noProbeButton.setSelection(probeType == 2);
            }
        }
        this.checkPageComplete();
    }

    void updateFragmentType(SelectionEvent e) {
        boolean doChange;
        FragmentType[] types = this._model.getProbeMetaData().getAvailableFragmentTypes();
        Button selectionEventButton = (Button)e.getSource();
        if (!selectionEventButton.getSelection()) {
            return;
        }
        Control[] allChildren = this._fragmentTypes.getChildren();
        String buttonText = null;
        int j = 0;
        while (j < allChildren.length) {
            Control control = allChildren[j];
            Button button = (Button)control;
            if (button.getSelection()) {
                buttonText = button.getText();
            }
            ++j;
        }
        FragmentType newType = null;
        if (buttonText == null) {
            if (types.length > 0) {
                newType = types[0];
            }
        } else {
            int i = 0;
            while (i < types.length) {
                FragmentType type = types[i];
                if (buttonText.equals(type.getName())) {
                    newType = type;
                    break;
                }
                ++i;
            }
        }
        if (doChange = this.confirmChange(this._model.getProbeMetaData(), newType)) {
            this._model.getProbeMetaData().setFragmentType(newType);
            this._model.getProbeMetaData().forceValid();
            this.refreshFragmentTypeExplanation();
        } else {
            int j2 = 0;
            while (j2 < allChildren.length) {
                Control control = allChildren[j2];
                Button button = (Button)control;
                button.setSelection(button.getText().equals(this._model.getProbeMetaData().getFragmentType().getName()));
                ++j2;
            }
        }
        this.checkPageComplete();
    }

    private void refreshProbeExplanation() {
        this._explanationText.setText(this._model.getProbeMetaData().getProbeTypeExplanation());
    }

    private void refreshFragmentTypeExplanation() {
        this._fragmentExplanationText.setText(this._model.getProbeMetaData().getFragmentTypeExplanation());
    }

    private void refreshFragmentTypes() {
        Button button;
        Control[] allChildren;
        FragmentType[] types = this._model.getProbeMetaData().getAvailableFragmentTypes();
        if (types.length > (allChildren = this._fragmentTypes.getChildren()).length) {
            FragmentButtonSelectionListener listener = new FragmentButtonSelectionListener();
            int missing = types.length - allChildren.length;
            int i = 0;
            while (i < missing) {
                button = new Button((Composite)this._fragmentTypes, 16);
                button.setFont(this._fragmentTypes.getFont());
                button.addSelectionListener((SelectionListener)listener);
                ++i;
            }
            allChildren = this._fragmentTypes.getChildren();
        }
        int j = 0;
        while (j < allChildren.length) {
            Control control = allChildren[j];
            control.setVisible(j < types.length);
            if (control.isVisible()) {
                FragmentType type = types[j];
                button = (Button)control;
                button.setText(type.getName());
                button.pack(true);
                button.setSelection(type.equals((Object)this._model.getProbeMetaData().getFragmentType()));
            }
            ++j;
        }
    }

    void checkPageComplete() {
        this._model.setFileName(this._fileNameField.getText());
        this._model.setSourceContainerPath(this._sourceContainerField.getText());
        String errorMessage = null;
        if (!this._model.isValidFileName()) {
            errorMessage = ProbekitMessages._53;
        }
        if (!this._model.isValidFile()) {
            errorMessage = ProbekitMessages._54;
        }
        if (!this._model.isValidSourceContainer()) {
            errorMessage = ProbekitMessages._55;
        }
        this.setErrorMessage(errorMessage);
        boolean isComplete = errorMessage == null;
        this.setPageComplete(isComplete);
    }

    private boolean confirmChange(IProbeMetaData probe, FragmentType type) {
        boolean arePagesConsistent = this._model.isValidCombination(probe, type);
        if (arePagesConsistent) {
            return true;
        }
        DiscardDataReadOnlyDialog dialog = this.createDialog(probe, type);
        dialog.open();
        int returnCode = dialog.getReturnCode();
        if (returnCode == 1) {
            return false;
        }
        if (returnCode == 0) {
            return true;
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        if (this._model.getProbeMetaData().getProbeType() == 2) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    private class BrowseListener
    implements SelectionListener {
        private BrowseListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                IJavaProject[] javaProjects = JavaUtil.getSourceJavaProjects();
                List sourceContainers = JavaUtil.getSourceContainers(javaProjects);
                CheckedTreeSelectionDialog dialog = DialogUtil.createResourceDialog(NewProbekitProbePage.this.getContainer().getShell(), (IResource[])JavaUtil.getProjects(javaProjects), sourceContainers);
                dialog.setTitle(ProbekitMessages._58);
                dialog.setValidator((ISelectionStatusValidator)new SelectOneIncludedValidator(sourceContainers, ProbekitMessages._59, ProbekitMessages._60));
                IContainer selectedContainer = JavaUtil.getSourceContainer(NewProbekitProbePage.this._sourceContainerField.getText());
                if (selectedContainer != null && selectedContainer.isAccessible()) {
                    dialog.setInitialSelection((Object)selectedContainer);
                }
                dialog.open();
                Object[] selected = dialog.getResult();
                if (selected != null) {
                    Object[] res = ResourceUtil.filter(selected, sourceContainers);
                    NewProbekitProbePage.this._sourceContainerField.setText(((IContainer)res[0]).getFullPath().toString());
                }
            }
            catch (JavaModelException exc) {
                ProbekitUIPlugin.getPlugin().log((Object)exc);
            }
        }
    }

    private class FileOrContainerModifiedListener
    implements ModifyListener {
        private FileOrContainerModifiedListener() {
        }

        public void modifyText(ModifyEvent e) {
            NewProbekitProbePage.this.checkPageComplete();
        }
    }

    private class FragmentButtonSelectionListener
    implements SelectionListener {
        private FragmentButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            NewProbekitProbePage.this.updateFragmentType(e);
        }
    }

    private class ProbeButtonSelectionListener
    implements SelectionListener {
        private ProbeButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            NewProbekitProbePage.this.updateProbe(e);
        }
    }

    private class XMLEncodingSelectionListener
    implements SelectionListener {
        private XMLEncodingSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            NewProbekitProbePage.this._model.setEncoding(NewProbekitProbePage.this._encodingField.getText());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

