/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor.action;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.core.common.util.TestCommonUtil;
import org.eclipse.hyades.test.tools.ui.common.TestCommonImages;
import org.eclipse.hyades.test.tools.ui.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.InsertBlockChildAction;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;

public abstract class InsertTestInvocation
extends InsertBlockChildAction {
    public InsertTestInvocation(IITestSuiteProvider testSuiteProvider, String baseName) {
        super(testSuiteProvider, ToolsUiPluginResourceBundle.LBL_INV, baseName);
        this.setImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor("invocation.gif"));
    }

    public void run() {
        this.setActionPerformed(false);
        InvokedTestSelectionDialog selectionDialog = this.createInvokedTestSelectionDialog(this.getTestSuite());
        if (selectionDialog.open() == 0) {
            IBlock parentBlock = null;
            EObject objectSelection = (EObject)this.getStructuredSelection().getFirstElement();
            EObject parent = objectSelection.eContainer();
            parentBlock = parent != null && parent instanceof IBlock ? (IBlock)parent : this.getTestSuite().getImplementor().getBlock();
            if (parentBlock != null) {
                for (ITest test : selectionDialog.getTests()) {
                    ResourceSet resourceSet = ((EObject)this.getTestSuite()).eResource().getResourceSet();
                    ITest resourcetest = (ITest)EMFUtil.getEObject((ResourceSet)resourceSet, (EObject)((EObject)test), (boolean)true);
                    if (resourcetest == null) {
                        resourcetest = test;
                        resourceSet.getResources().add((Object)((EObject)test).eResource());
                    }
                    ITestInvocation testInvocation = HyadesFactory.INSTANCE.createTestInvocation(resourcetest);
                    testInvocation.setName(this.calculateName(resourcetest));
                    parentBlock.getActions().add(testInvocation);
                }
            }
            this.setActionPerformed(true);
        }
    }

    protected abstract InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite var1);

    protected String calculateName(ITest test) {
        String testName = test.getName();
        if (testName == null) {
            return TestCommonUtil.getUniqueName((String)this.getBaseName(), (List)this.getBlock().getActions());
        }
        if (test instanceof ITestCase) {
            String testSuiteName;
            ITestSuite invokedTestSuite = ((ITestCase)test).getOwner();
            if (this.getTestSuite() != invokedTestSuite && (testSuiteName = invokedTestSuite.getName()) != null) {
                testName = String.valueOf(testSuiteName) + "." + testName;
            }
        }
        return testName.concat(" - ").concat(this.getBaseName());
    }
}

