/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.codegen;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.core.internal.changes.CreateFileChange;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.DelegateProjectDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Helper;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.IProjectDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.JavaGenerator;
import org.eclipse.hyades.test.tools.ui.http.internal.codegen.GenTestSuite;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class HttpGenerator
extends JavaGenerator {
    public static final String PLUGIN_ID_JUNIT = "org.junit";
    public static final String PLUGIN_ID_EXECUTION_CORE = "org.eclipse.hyades.execution.core";
    public static final String PLUGIN_ID_EXECUTION_REMOTE = "org.eclipse.hyades.execution.remote";

    public HttpGenerator(ITestSuite testSuite, IProjectDependencyUpdater updater) {
        super(testSuite, (IProjectDependencyUpdater)new HttpProjectDependencyUpdater(updater));
    }

    protected Change createGenerateCodeChange(IFile file, IProgressMonitor monitor) throws CoreException {
        Helper helper = new Helper();
        try {
            GenTestSuite genTestSuite = new GenTestSuite();
            this.computeTestMethodNames(this.getTestSuite(), false, helper);
            String generatedCode = Helper.formatContent((String)genTestSuite.generate(this.getTestSuite(), helper));
            CreateFileChange fileChange = new CreateFileChange(file, generatedCode, "UTF-8");
            Change methodNameChange = helper.getMethodNamesChange();
            if (methodNameChange != null) {
                CompositeChange compositeChange = new CompositeChange("Composite source refactoring");
                compositeChange.add((Change)fileChange);
                compositeChange.add(methodNameChange);
                compositeChange.markAsSynthetic();
                CompositeChange compositeChange2 = compositeChange;
                return compositeChange2;
            }
            CreateFileChange createFileChange = fileChange;
            return createFileChange;
        }
        finally {
            helper.dispose();
        }
    }

    static class HttpProjectDependencyUpdater
    extends DelegateProjectDependencyUpdater {
        public HttpProjectDependencyUpdater(IProjectDependencyUpdater delegate) {
            super(delegate);
            this.addRequiredPlugin(HttpGenerator.PLUGIN_ID_JUNIT, null);
            this.addRequiredPlugin(CorePlugin.getID(), "common.runner.jar");
            this.addRequiredPlugin(CorePlugin.getID(), "http.runner.jar");
            this.addRequiredPlugin("org.eclipse.hyades.logging.core", null);
            this.addRequiredPlugin("org.eclipse.tptp.platform.logging.events", "tlcore.jar");
            this.addRequiredPlugin("org.eclipse.tptp.platform.logging.events", "hlcbe101.jar");
            this.addRequiredPlugin("org.eclipse.emf.ecore", null);
            this.addRequiredPlugin("org.eclipse.emf.common", null);
        }
    }
}

